/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.aggregators;

import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.CountValueAggregator;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.DocCountAggregator;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.MaxValueAggregator;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.MinValueAggregator;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.SumValueAggregator;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.ValueAggregator;
import org.opensearch.index.mapper.FieldValueConverter;

public class ValueAggregatorFactory {
    private ValueAggregatorFactory() {
    }

    public static ValueAggregator getValueAggregator(MetricStat aggregationType, FieldValueConverter fieldValueConverter) {
        switch (aggregationType) {
            case SUM: {
                return new SumValueAggregator(fieldValueConverter);
            }
            case VALUE_COUNT: {
                return new CountValueAggregator();
            }
            case MIN: {
                return new MinValueAggregator(fieldValueConverter);
            }
            case MAX: {
                return new MaxValueAggregator(fieldValueConverter);
            }
            case DOC_COUNT: {
                return new DocCountAggregator();
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }
}

