/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.mapper.BinaryFieldMapper;
import org.opensearch.index.mapper.BooleanFieldMapper;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.DocumentMapperParser;
import org.opensearch.index.mapper.DynamicTemplate;
import org.opensearch.index.mapper.FieldAliasMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.IdFieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.Mapping;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.NestedPathFieldMapper;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.mapper.StrictDynamicMappingException;
import org.opensearch.index.mapper.TextFieldMapper;

final class DocumentParser {
    private final IndexSettings indexSettings;
    private final DocumentMapperParser docMapperParser;
    private final DocumentMapper docMapper;

    DocumentParser(IndexSettings indexSettings, DocumentMapperParser docMapperParser, DocumentMapper docMapper) {
        this.indexSettings = indexSettings;
        this.docMapperParser = docMapperParser;
        this.docMapper = docMapper;
    }

    ParsedDocument parseDocument(SourceToParse source, MetadataFieldMapper[] metadataFieldsMappers) throws MapperParsingException {
        ParseContext.InternalParseContext context;
        Mapping mapping = this.docMapper.mapping();
        MediaType mediaType = source.getMediaType();
        try (XContentParser parser = XContentHelper.createParser(this.docMapperParser.getXContentRegistry(), LoggingDeprecationHandler.INSTANCE, source.source(), mediaType);){
            context = new ParseContext.InternalParseContext(this.indexSettings, this.docMapperParser, this.docMapper, source, parser);
            DocumentParser.validateStart(parser);
            DocumentParser.internalParseDocument(mapping, metadataFieldsMappers, context, parser);
            DocumentParser.validateEnd(parser);
        }
        catch (Exception e) {
            throw DocumentParser.wrapInMapperParsingException(source, e);
        }
        String remainingPath = context.path().pathAsText("");
        if (!remainingPath.isEmpty()) {
            throw new IllegalStateException("found leftover path elements: " + remainingPath);
        }
        context.postParse();
        return DocumentParser.parsedDocument(source, context, DocumentParser.createDynamicUpdate(mapping, this.docMapper, context.getDynamicMappers()));
    }

    private static boolean containsDisabledObjectMapper(ObjectMapper objectMapper, String[] subfields) {
        Mapper mapper;
        for (int i = 0; i < subfields.length - 1 && (mapper = objectMapper.getMapper(subfields[i])) instanceof ObjectMapper; ++i) {
            objectMapper = (ObjectMapper)mapper;
            if (objectMapper.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static void internalParseDocument(Mapping mapping, MetadataFieldMapper[] metadataFieldsMappers, ParseContext.InternalParseContext context, XContentParser parser) throws IOException {
        boolean emptyDoc = DocumentParser.isEmptyDoc(mapping, parser);
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.preParse(context);
        }
        if (!mapping.root.isEnabled()) {
            parser.skipChildren();
        } else if (!emptyDoc) {
            DocumentParser.parseObjectOrNested(context, mapping.root);
        }
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.postParse(context);
        }
    }

    private static void validateStart(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new MapperParsingException("Malformed content, must start with an object");
        }
    }

    private static void validateEnd(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != null) {
            throw new IllegalArgumentException("Malformed content, found extra data after parsing: " + token);
        }
    }

    private static boolean isEmptyDoc(Mapping mapping, XContentParser parser) throws IOException {
        if (mapping.root.isEnabled()) {
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.END_OBJECT) {
                return true;
            }
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
            }
        }
        return false;
    }

    private static ParsedDocument parsedDocument(SourceToParse source, ParseContext.InternalParseContext context, Mapping update) {
        return new ParsedDocument(context.version(), context.seqID(), context.sourceToParse().id(), source.routing(), context.docs(), context.sourceToParse().source(), context.sourceToParse().getMediaType(), update);
    }

    private static MapperParsingException wrapInMapperParsingException(SourceToParse source, Exception e) {
        if (e instanceof MapperParsingException) {
            return (MapperParsingException)((Object)e);
        }
        if (source.source() != null && source.source().length() == 0) {
            return new MapperParsingException("failed to parse, document is empty");
        }
        return new MapperParsingException("failed to parse", e);
    }

    private static String[] splitAndValidatePath(String fullFieldPath) {
        if (fullFieldPath.contains(".")) {
            String[] parts = fullFieldPath.split("\\.");
            if (parts.length == 0) {
                throw new IllegalArgumentException("field name cannot contain only the character [.]");
            }
            for (String part : parts) {
                if (Strings.hasText((String)part)) continue;
                if (!Strings.isEmpty((CharSequence)part)) {
                    throw new IllegalArgumentException("object field cannot contain only whitespace: ['" + fullFieldPath + "']");
                }
                throw new IllegalArgumentException("object field starting or ending with a [.] makes object resolution ambiguous: [" + fullFieldPath + "]");
            }
            return parts;
        }
        if (Strings.isEmpty((CharSequence)fullFieldPath)) {
            throw new IllegalArgumentException("field name cannot be an empty string");
        }
        return new String[]{fullFieldPath};
    }

    static Mapping createDynamicUpdate(Mapping mapping, DocumentMapper docMapper, List<Mapper> dynamicMappers) {
        if (dynamicMappers.isEmpty()) {
            return null;
        }
        Collections.sort(dynamicMappers, (o1, o2) -> o1.name().compareTo(o2.name()));
        Iterator<Mapper> dynamicMapperItr = dynamicMappers.iterator();
        ArrayList<ObjectMapper> parentMappers = new ArrayList<ObjectMapper>();
        Mapper firstUpdate = dynamicMapperItr.next();
        parentMappers.add(DocumentParser.createUpdate(mapping.root(), DocumentParser.splitAndValidatePath(firstUpdate.name()), 0, firstUpdate));
        Mapper previousMapper = null;
        while (dynamicMapperItr.hasNext()) {
            Mapper newMapper = dynamicMapperItr.next();
            if (previousMapper != null && newMapper.name().equals(previousMapper.name())) {
                newMapper.merge(previousMapper);
                continue;
            }
            previousMapper = newMapper;
            String[] nameParts = DocumentParser.splitAndValidatePath(newMapper.name());
            int i = DocumentParser.removeUncommonMappers(parentMappers, nameParts);
            if ((i = DocumentParser.expandCommonMappers(parentMappers, nameParts, i)) < nameParts.length - 1) {
                newMapper = DocumentParser.createExistingMapperUpdate(parentMappers, nameParts, i, docMapper, newMapper);
            }
            if (newMapper instanceof ObjectMapper) {
                parentMappers.add((ObjectMapper)newMapper);
                continue;
            }
            DocumentParser.addToLastMapper(parentMappers, newMapper, true);
        }
        DocumentParser.popMappers(parentMappers, 1, true);
        assert (parentMappers.size() == 1);
        return mapping.mappingUpdate((Mapper)parentMappers.get(0));
    }

    private static void popMappers(List<ObjectMapper> parentMappers, int keepBefore, boolean merge) {
        assert (keepBefore >= 1);
        for (int i = parentMappers.size() - 1; i >= keepBefore; --i) {
            DocumentParser.addToLastMapper(parentMappers, parentMappers.remove(i), merge);
        }
    }

    private static void addToLastMapper(List<ObjectMapper> parentMappers, Mapper mapper, boolean merge) {
        assert (parentMappers.size() >= 1);
        int lastIndex = parentMappers.size() - 1;
        ObjectMapper withNewMapper = parentMappers.get(lastIndex).mappingUpdate(mapper);
        if (merge) {
            withNewMapper = parentMappers.get(lastIndex).merge(withNewMapper);
        }
        parentMappers.set(lastIndex, withNewMapper);
    }

    private static int removeUncommonMappers(List<ObjectMapper> parentMappers, String[] nameParts) {
        int keepBefore;
        for (keepBefore = 1; keepBefore < parentMappers.size() && parentMappers.get(keepBefore).simpleName().equals(nameParts[keepBefore - 1]); ++keepBefore) {
        }
        DocumentParser.popMappers(parentMappers, keepBefore, true);
        return keepBefore - 1;
    }

    private static int expandCommonMappers(List<ObjectMapper> parentMappers, String[] nameParts, int i) {
        ObjectMapper last = parentMappers.get(parentMappers.size() - 1);
        while (i < nameParts.length - 1 && last.getMapper(nameParts[i]) != null) {
            Mapper newLast = last.getMapper(nameParts[i]);
            assert (newLast instanceof ObjectMapper);
            last = (ObjectMapper)newLast;
            parentMappers.add(last);
            ++i;
        }
        return i;
    }

    private static ObjectMapper createExistingMapperUpdate(List<ObjectMapper> parentMappers, String[] nameParts, int i, DocumentMapper docMapper, Mapper newMapper) {
        Object updateParentName = nameParts[i];
        ObjectMapper lastParent = parentMappers.get(parentMappers.size() - 1);
        if (parentMappers.size() > 1) {
            updateParentName = lastParent.name() + "." + nameParts[i];
        }
        ObjectMapper updateParent = docMapper.objectMappers().get(updateParentName);
        assert (updateParent != null) : (String)updateParentName + " doesn't exist";
        return DocumentParser.createUpdate(updateParent, nameParts, i + 1, newMapper);
    }

    private static ObjectMapper createUpdate(ObjectMapper parent, String[] nameParts, int i, Mapper mapper) {
        ArrayList<ObjectMapper> parentMappers = new ArrayList<ObjectMapper>();
        ObjectMapper previousIntermediate = parent;
        while (i < nameParts.length - 1) {
            Mapper intermediate = previousIntermediate.getMapper(nameParts[i]);
            assert (intermediate != null) : "Field " + previousIntermediate.name() + " does not have a subfield " + nameParts[i];
            assert (intermediate instanceof ObjectMapper);
            parentMappers.add((ObjectMapper)intermediate);
            previousIntermediate = (ObjectMapper)intermediate;
            ++i;
        }
        if (!parentMappers.isEmpty()) {
            DocumentParser.addToLastMapper(parentMappers, mapper, false);
            DocumentParser.popMappers(parentMappers, 1, false);
            mapper = (Mapper)parentMappers.get(0);
        }
        return parent.mappingUpdate(mapper);
    }

    static void parseObjectOrNested(ParseContext context, ObjectMapper mapper) throws IOException {
        if (!mapper.isEnabled()) {
            context.parser().skipChildren();
            return;
        }
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return;
        }
        String currentFieldName = parser.currentName();
        if (token.isValue()) {
            throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but found a concrete value");
        }
        ObjectMapper.Nested nested = mapper.nested();
        if (nested.isNested()) {
            context = DocumentParser.nestedContext(context, mapper);
        }
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        DocumentParser.innerParseObject(context, mapper, parser, currentFieldName, token);
        if (nested.isNested()) {
            DocumentParser.nested(context, nested);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerParseObject(ParseContext context, ObjectMapper mapper, XContentParser parser, String currentFieldName, XContentParser.Token token) throws IOException {
        try {
            assert (token == XContentParser.Token.FIELD_NAME || token == XContentParser.Token.END_OBJECT);
            String[] paths = null;
            context.incrementFieldCurrentDepth();
            context.checkFieldDepthLimit();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    paths = DocumentParser.splitAndValidatePath(currentFieldName);
                    if (DocumentParser.containsDisabledObjectMapper(mapper, paths)) {
                        parser.nextToken();
                        parser.skipChildren();
                    }
                } else if (token == XContentParser.Token.START_OBJECT) {
                    DocumentParser.parseObject(context, mapper, currentFieldName, paths);
                } else if (token == XContentParser.Token.START_ARRAY) {
                    DocumentParser.parseArray(context, mapper, currentFieldName, paths);
                } else if (token == XContentParser.Token.VALUE_NULL) {
                    DocumentParser.parseNullValue(context, mapper, currentFieldName, paths);
                } else {
                    if (token == null) {
                        throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but got EOF, has a concrete value been provided to it?");
                    }
                    if (token.isValue()) {
                        DocumentParser.parseValue(context, mapper, currentFieldName, token, paths);
                    }
                }
                token = parser.nextToken();
            }
        }
        finally {
            context.decrementFieldCurrentDepth();
        }
    }

    private static void nested(ParseContext context, ObjectMapper.Nested nested) {
        ParseContext.Document nestedDoc = context.doc();
        ParseContext.Document parentDoc = nestedDoc.getParent();
        Version indexVersion = context.indexSettings().getIndexVersionCreated();
        if (nested.isIncludeInParent()) {
            DocumentParser.addFields(indexVersion, nestedDoc, parentDoc);
        }
        if (nested.isIncludeInRoot()) {
            ParseContext.Document rootDoc = context.rootDoc();
            if (!nested.isIncludeInParent() || parentDoc != rootDoc) {
                DocumentParser.addFields(indexVersion, nestedDoc, rootDoc);
            }
        }
    }

    private static void addFields(Version indexVersion, ParseContext.Document nestedDoc, ParseContext.Document rootDoc) {
        String nestedPathFieldName = NestedPathFieldMapper.name(indexVersion);
        for (IndexableField field : nestedDoc.getFields()) {
            if (field.name().equals(nestedPathFieldName)) continue;
            rootDoc.add(field);
        }
    }

    private static ParseContext nestedContext(ParseContext context, ObjectMapper mapper) {
        ParseContext.Document nestedDoc = (context = context.createNestedContext(mapper.fullPath())).doc();
        ParseContext.Document parentDoc = nestedDoc.getParent();
        IndexableField idField = parentDoc.getField("_id");
        if (idField == null) {
            throw new IllegalStateException("The root document of a nested document should have an _id field");
        }
        nestedDoc.add((IndexableField)new Field("_id", idField.binaryValue(), (IndexableFieldType)IdFieldMapper.Defaults.NESTED_FIELD_TYPE));
        nestedDoc.add((IndexableField)NestedPathFieldMapper.field(context.indexSettings().getIndexVersionCreated(), mapper.nestedTypePath()));
        return context;
    }

    private static void parseObjectOrField(ParseContext context, Mapper mapper) throws IOException {
        if (mapper instanceof ObjectMapper) {
            DocumentParser.parseObjectOrNested(context, (ObjectMapper)mapper);
        } else if (mapper instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)mapper;
            fieldMapper.parse(context);
            DocumentParser.parseCopyFields(context, fieldMapper.copyTo().copyToFields());
        } else {
            if (mapper instanceof FieldAliasMapper) {
                throw new IllegalArgumentException("Cannot write to a field alias [" + mapper.name() + "].");
            }
            throw new IllegalStateException("The provided mapper [" + mapper.name() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
        }
    }

    private static void parseObject(ParseContext context, ObjectMapper mapper, String currentFieldName, String[] paths) throws IOException {
        assert (currentFieldName != null);
        Mapper objectMapper = DocumentParser.getMapper(context, mapper, currentFieldName, paths);
        if (objectMapper != null) {
            context.path().add(currentFieldName);
            DocumentParser.parseObjectOrField(context, objectMapper);
            context.path().remove();
        } else {
            currentFieldName = paths[paths.length - 1];
            Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, mapper);
            ObjectMapper parentMapper = (ObjectMapper)parentMapperTuple.v2();
            ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
            switch (dynamic) {
                case STRICT: {
                    throw new StrictDynamicMappingException(dynamic.name().toLowerCase(Locale.ROOT), mapper.fullPath(), currentFieldName);
                }
                case TRUE: 
                case STRICT_ALLOW_TEMPLATES: {
                    Mapper.Builder builder = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.OBJECT, dynamic, mapper.fullPath());
                    if (builder == null) {
                        builder = new ObjectMapper.Builder(currentFieldName).enabled(true);
                    }
                    Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path());
                    objectMapper = builder.build(builderContext);
                    context.addDynamicMapper(objectMapper);
                    context.path().add(currentFieldName);
                    DocumentParser.parseObjectOrField(context, objectMapper);
                    context.path().remove();
                    break;
                }
                case FALSE: {
                    context.parser().skipChildren();
                }
            }
            for (int i = 0; i < (Integer)parentMapperTuple.v1(); ++i) {
                context.path().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseArray(ParseContext context, ObjectMapper parentMapper, String lastFieldName, String[] paths) throws IOException {
        try {
            String arrayFieldName = lastFieldName;
            context.incrementFieldArrayDepth();
            context.checkFieldArrayDepthLimit();
            Mapper mapper = DocumentParser.getMapper(context, parentMapper, lastFieldName, paths);
            if (mapper != null) {
                if (DocumentParser.parsesArrayValue(mapper)) {
                    DocumentParser.parseObjectOrField(context, mapper);
                } else {
                    DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                }
            } else {
                lastFieldName = arrayFieldName = paths[paths.length - 1];
                Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, parentMapper);
                parentMapper = (ObjectMapper)parentMapperTuple.v2();
                ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
                switch (dynamic) {
                    case STRICT: {
                        throw new StrictDynamicMappingException(dynamic.name().toLowerCase(Locale.ROOT), parentMapper.fullPath(), arrayFieldName);
                    }
                    case TRUE: 
                    case STRICT_ALLOW_TEMPLATES: {
                        Mapper.Builder builder = DocumentParser.findTemplateBuilder(context, arrayFieldName, DynamicTemplate.XContentFieldType.OBJECT, dynamic, parentMapper.fullPath());
                        if (builder == null) {
                            DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                            break;
                        }
                        Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path());
                        mapper = builder.build(builderContext);
                        assert (mapper != null);
                        if (DocumentParser.parsesArrayValue(mapper)) {
                            context.addDynamicMapper(mapper);
                            context.path().add(arrayFieldName);
                            DocumentParser.parseObjectOrField(context, mapper);
                            context.path().remove();
                            break;
                        }
                        DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                        break;
                    }
                    case FALSE: {
                        DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                    }
                }
                for (int i = 0; i < (Integer)parentMapperTuple.v1(); ++i) {
                    context.path().remove();
                }
            }
        }
        finally {
            context.decrementFieldArrayDepth();
        }
    }

    private static boolean parsesArrayValue(Mapper mapper) {
        return mapper instanceof FieldMapper && ((FieldMapper)mapper).parsesArrayValue();
    }

    private static void parseNonDynamicArray(ParseContext context, ObjectMapper mapper, String lastFieldName, String arrayFieldName) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        if (context.indexSettings().isCompositeIndex() && context.mapperService().isFieldPartOfCompositeIndex(arrayFieldName)) {
            throw new MapperParsingException(String.format(Locale.ROOT, "object mapping for [%s] with array for [%s] cannot be accepted as field is also part of composite index mapping which does not accept arrays", mapper.name(), arrayFieldName));
        }
        String[] paths = DocumentParser.splitAndValidatePath(lastFieldName);
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                DocumentParser.parseObject(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                DocumentParser.parseArray(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == null) {
                throw new MapperParsingException("object mapping for [" + mapper.name() + "] with array for [" + arrayFieldName + "] tried to parse as array, but got EOF, is there a mismatch in types for the same field?");
            }
            assert (token.isValue());
            DocumentParser.parseValue(context, mapper, lastFieldName, token, paths);
        }
    }

    private static void parseValue(ParseContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token, String[] paths) throws IOException {
        if (currentFieldName == null) {
            throw new MapperParsingException("object mapping [" + parentMapper.name() + "] trying to serialize a value with no field associated with it, current value [" + context.parser().textOrNull() + "]");
        }
        Mapper mapper = DocumentParser.getMapper(context, parentMapper, currentFieldName, paths);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else {
            currentFieldName = paths[paths.length - 1];
            Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, parentMapper);
            parentMapper = (ObjectMapper)parentMapperTuple.v2();
            DocumentParser.parseDynamicValue(context, parentMapper, currentFieldName, token);
            for (int i = 0; i < (Integer)parentMapperTuple.v1(); ++i) {
                context.path().remove();
            }
        }
    }

    private static void parseNullValue(ParseContext context, ObjectMapper parentMapper, String lastFieldName, String[] paths) throws IOException {
        Mapper mapper = DocumentParser.getMapper(context, parentMapper, lastFieldName, paths);
        ObjectMapper.Dynamic dynamic = parentMapper.dynamic();
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else if (dynamic == ObjectMapper.Dynamic.STRICT || dynamic == ObjectMapper.Dynamic.STRICT_ALLOW_TEMPLATES) {
            throw new StrictDynamicMappingException(dynamic.name().toLowerCase(Locale.ROOT), parentMapper.fullPath(), lastFieldName);
        }
    }

    private static Mapper.Builder<?> newLongBuilder(String name, Settings settings) {
        return new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.LONG, settings);
    }

    private static Mapper.Builder<?> newFloatBuilder(String name, Settings settings) {
        return new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.FLOAT, settings);
    }

    private static Mapper.Builder<?> createBuilderFromDynamicValue(ParseContext context, XContentParser.Token token, String currentFieldName, ObjectMapper.Dynamic dynamic, String fullPath) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            Object builder;
            String text = context.parser().text();
            boolean parseableAsLong = false;
            try {
                Long.parseLong(text);
                parseableAsLong = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean parseableAsDouble = false;
            try {
                Double.parseDouble(text);
                parseableAsDouble = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (parseableAsLong && context.root().numericDetection()) {
                Mapper.Builder<?> builder2 = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.LONG, dynamic, fullPath);
                if (builder2 == null) {
                    builder2 = DocumentParser.newLongBuilder(currentFieldName, context.indexSettings().getSettings());
                }
                return builder2;
            }
            if (parseableAsDouble && context.root().numericDetection()) {
                Mapper.Builder<?> builder3 = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.DOUBLE, dynamic, fullPath);
                if (builder3 == null) {
                    builder3 = DocumentParser.newFloatBuilder(currentFieldName, context.indexSettings().getSettings());
                }
                return builder3;
            }
            if (!parseableAsLong && !parseableAsDouble && context.root().dateDetection()) {
                builder = context.root().dynamicDateTimeFormatters();
                int n = ((DateFormatter[])builder).length;
                for (int i = 0; i < n; ++i) {
                    DateFormatter dateTimeFormatter = builder[i];
                    try {
                        dateTimeFormatter.parse(text);
                    }
                    catch (IllegalArgumentException | DateTimeParseException | OpenSearchParseException e) {
                        continue;
                    }
                    Mapper.Builder builder4 = DocumentParser.findTemplateBuilder(context, currentFieldName, dateTimeFormatter, dynamic, fullPath);
                    if (builder4 == null) {
                        boolean ignoreMalformed = FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings().getSettings());
                        builder4 = new DateFieldMapper.Builder(currentFieldName, DateFieldMapper.Resolution.MILLISECONDS, dateTimeFormatter, ignoreMalformed, IndexMetadata.indexCreated(context.indexSettings().getSettings()));
                    }
                    return builder4;
                }
            }
            if ((builder = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.STRING, dynamic, fullPath)) == null) {
                builder = new TextFieldMapper.Builder(currentFieldName, context.mapperService().getIndexAnalyzers()).addMultiField(new KeywordFieldMapper.Builder("keyword").ignoreAbove(256));
            }
            return builder;
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = context.parser().numberType();
            if (numberType == XContentParser.NumberType.INT || numberType == XContentParser.NumberType.LONG || numberType == XContentParser.NumberType.BIG_INTEGER) {
                Mapper.Builder<?> builder = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.LONG, dynamic, fullPath);
                if (builder == null) {
                    builder = DocumentParser.newLongBuilder(currentFieldName, context.indexSettings().getSettings());
                }
                return builder;
            }
            if (numberType == XContentParser.NumberType.FLOAT || numberType == XContentParser.NumberType.DOUBLE || numberType == XContentParser.NumberType.BIG_DECIMAL) {
                Mapper.Builder<?> builder = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.DOUBLE, dynamic, fullPath);
                if (builder == null) {
                    builder = DocumentParser.newFloatBuilder(currentFieldName, context.indexSettings().getSettings());
                }
                return builder;
            }
        } else {
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                Mapper.Builder builder = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.BOOLEAN, dynamic, fullPath);
                if (builder == null) {
                    builder = new BooleanFieldMapper.Builder(currentFieldName);
                }
                return builder;
            }
            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                Mapper.Builder builder = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.BINARY, dynamic, fullPath);
                if (builder == null) {
                    builder = new BinaryFieldMapper.Builder(currentFieldName);
                }
                return builder;
            }
            Mapper.Builder builder = DocumentParser.findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.STRING, dynamic, fullPath);
            if (builder != null) {
                return builder;
            }
        }
        throw new IllegalStateException("Can't handle serializing a dynamic type with content token [" + token + "] and field name [" + currentFieldName + "]");
    }

    private static void parseDynamicValue(ParseContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token) throws IOException {
        ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
        if (dynamic == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(dynamic.name().toLowerCase(Locale.ROOT), parentMapper.fullPath(), currentFieldName);
        }
        if (dynamic == ObjectMapper.Dynamic.FALSE) {
            return;
        }
        Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path());
        Mapper.Builder<?> builder = DocumentParser.createBuilderFromDynamicValue(context, token, currentFieldName, dynamic, parentMapper.fullPath());
        Mapper mapper = builder.build(builderContext);
        context.addDynamicMapper(mapper);
        DocumentParser.parseObjectOrField(context, mapper);
    }

    private static void parseCopyFields(ParseContext context, List<String> copyToFields) throws IOException {
        if (!context.isWithinCopyTo() && !copyToFields.isEmpty()) {
            context = context.createCopyToContext();
            for (String field : copyToFields) {
                ParseContext.Document targetDoc = null;
                for (ParseContext.Document doc = context.doc(); doc != null; doc = doc.getParent()) {
                    if (!field.startsWith(doc.getPrefix())) continue;
                    targetDoc = doc;
                    break;
                }
                assert (targetDoc != null);
                ParseContext copyToContext = targetDoc == context.doc() ? context : context.switchDoc(targetDoc);
                DocumentParser.parseCopy(field, copyToContext);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseCopy(String field, ParseContext context) throws IOException {
        Mapper mapper = context.docMapper().mappers().getMapper(field);
        if (mapper != null) {
            if (mapper instanceof FieldMapper) {
                ((FieldMapper)mapper).parse(context);
                return;
            }
            if (!(mapper instanceof FieldAliasMapper)) throw new IllegalStateException("The provided mapper [" + mapper.name() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
            throw new IllegalArgumentException("Cannot copy to a field alias [" + mapper.name() + "].");
        }
        context = context.overridePath(new ContentPath(0));
        String[] paths = DocumentParser.splitAndValidatePath(field);
        String fieldName = paths[paths.length - 1];
        Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, null);
        ObjectMapper objectMapper = (ObjectMapper)parentMapperTuple.v2();
        DocumentParser.parseDynamicValue(context, objectMapper, fieldName, context.parser().currentToken());
        int i = 0;
        while (i < (Integer)parentMapperTuple.v1()) {
            context.path().remove();
            ++i;
        }
    }

    private static Tuple<Integer, ObjectMapper> getDynamicParentMapper(ParseContext context, String[] paths, ObjectMapper currentParent) {
        ObjectMapper mapper = currentParent == null ? context.root() : currentParent;
        int pathsAdded = 0;
        ObjectMapper parent = mapper;
        for (int i = 0; i < paths.length - 1; ++i) {
            String currentPath = context.path().pathAsText(paths[i]);
            Mapper existingFieldMapper = context.docMapper().mappers().getMapper(currentPath);
            if (existingFieldMapper != null) {
                throw new MapperParsingException("Could not dynamically add mapping for field [{}]. Existing mapping for [{}] must be of type object but found [{}].", null, String.join((CharSequence)".", paths), currentPath, existingFieldMapper.typeName());
            }
            mapper = context.docMapper().objectMappers().get(currentPath);
            if (mapper == null) {
                ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parent, context);
                switch (dynamic) {
                    case STRICT: {
                        throw new StrictDynamicMappingException(dynamic.name().toLowerCase(Locale.ROOT), parent.fullPath(), paths[i]);
                    }
                    case TRUE: 
                    case STRICT_ALLOW_TEMPLATES: {
                        Mapper.BuilderContext builderContext;
                        Mapper.Builder builder = DocumentParser.findTemplateBuilder(context, paths[i], DynamicTemplate.XContentFieldType.OBJECT, dynamic, parent.fullPath());
                        if (builder == null) {
                            builder = new ObjectMapper.Builder(paths[i]).enabled(true);
                        }
                        if ((mapper = (ObjectMapper)builder.build(builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path()))).nested() != ObjectMapper.Nested.NO) {
                            throw new MapperParsingException("It is forbidden to create dynamic nested objects ([" + context.path().pathAsText(paths[i]) + "]) through `copy_to` or dots in field names");
                        }
                        context.addDynamicMapper(mapper);
                        break;
                    }
                    case FALSE: {
                        return new Tuple((Object)pathsAdded, (Object)parent);
                    }
                }
            }
            context.path().add(paths[i]);
            ++pathsAdded;
            parent = mapper;
        }
        return new Tuple((Object)pathsAdded, (Object)mapper);
    }

    private static ObjectMapper.Dynamic dynamicOrDefault(ObjectMapper parentMapper, ParseContext context) {
        int lastDotNdx;
        ObjectMapper.Dynamic dynamic = parentMapper.dynamic();
        while (dynamic == null && (lastDotNdx = parentMapper.name().lastIndexOf(46)) != -1) {
            String parentName = parentMapper.name().substring(0, lastDotNdx);
            parentMapper = context.docMapper().objectMappers().get(parentName);
            if (parentMapper == null) {
                return ObjectMapper.Dynamic.TRUE;
            }
            dynamic = parentMapper.dynamic();
        }
        if (dynamic == null) {
            return context.root().dynamic() == null ? ObjectMapper.Dynamic.TRUE : context.root().dynamic();
        }
        return dynamic;
    }

    private static Mapper getMapper(ParseContext context, ObjectMapper objectMapper, String fieldName, String[] subfields) {
        String fieldPath = context.path().pathAsText(fieldName);
        Mapper mapper = context.docMapper().mapping().getMetadataMapper(fieldPath);
        if (mapper != null) {
            return mapper;
        }
        for (int i = 0; i < subfields.length - 1; ++i) {
            mapper = objectMapper.getMapper(subfields[i]);
            if (mapper == null || !(mapper instanceof ObjectMapper)) {
                return null;
            }
            objectMapper = (ObjectMapper)mapper;
            if (!objectMapper.nested().isNested()) continue;
            throw new MapperParsingException("Cannot add a value for field [" + fieldName + "] since one of the intermediate objects is mapped as a nested object: [" + mapper.name() + "]");
        }
        return objectMapper.getMapper(subfields[subfields.length - 1]);
    }

    private static Mapper.Builder findTemplateBuilder(ParseContext context, String name, DynamicTemplate.XContentFieldType matchType, ObjectMapper.Dynamic dynamic, String fieldFullPath) {
        Mapper.Builder builder = context.root().findTemplateBuilder(context, name, matchType);
        if (builder == null && dynamic == ObjectMapper.Dynamic.STRICT_ALLOW_TEMPLATES) {
            throw new StrictDynamicMappingException(dynamic.name().toLowerCase(Locale.ROOT), fieldFullPath, name);
        }
        return builder;
    }

    private static Mapper.Builder findTemplateBuilder(ParseContext context, String name, DateFormatter dateFormat, ObjectMapper.Dynamic dynamic, String fieldFullPath) {
        Mapper.Builder builder = context.root().findTemplateBuilder(context, name, dateFormat);
        if (builder == null && dynamic == ObjectMapper.Dynamic.STRICT_ALLOW_TEMPLATES) {
            throw new StrictDynamicMappingException(dynamic.name().toLowerCase(Locale.ROOT), fieldFullPath, name);
        }
        return builder;
    }
}

