/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.FieldNamesFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.WithFieldName;

public class ExistsQueryBuilder
extends AbstractQueryBuilder<ExistsQueryBuilder>
implements WithFieldName {
    public static final String NAME = "exists";
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private final String fieldName;

    public ExistsQueryBuilder(String fieldName) {
        if (Strings.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.fieldName = fieldName;
    }

    public ExistsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        Collection<String> fields;
        QueryShardContext context = queryShardContext.convertToShardContext();
        if (context != null && (fields = ExistsQueryBuilder.getMappedField(context, this.fieldName)).isEmpty()) {
            return new MatchNoneQueryBuilder();
        }
        return super.doRewrite(queryShardContext);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(FIELD_FIELD.getPreferredName(), this.fieldName);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static ExistsQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldPattern = null;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (FIELD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fieldPattern = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[exists] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[exists] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldPattern == null) {
            throw new ParsingException(parser.getTokenLocation(), "[exists] must be provided with a [field]", new Object[0]);
        }
        ExistsQueryBuilder builder = new ExistsQueryBuilder(fieldPattern);
        builder.queryName(queryName);
        builder.boost(boost);
        return builder;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        return ExistsQueryBuilder.newFilter(context, this.fieldName, true);
    }

    public static Query newFilter(QueryShardContext context, String fieldPattern, boolean checkRewrite) {
        Collection<String> fields = ExistsQueryBuilder.getMappedField(context, fieldPattern);
        if (fields.isEmpty()) {
            if (checkRewrite) {
                throw new IllegalStateException("Rewrite first");
            }
            return new MatchNoDocsQuery("unmapped field:" + fieldPattern);
        }
        if (fields.size() == 1) {
            String field = fields.iterator().next();
            return ExistsQueryBuilder.newFieldExistsQuery(context, field);
        }
        BooleanQuery.Builder boolFilterBuilder = new BooleanQuery.Builder();
        for (String field : fields) {
            boolFilterBuilder.add(ExistsQueryBuilder.newFieldExistsQuery(context, field), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)boolFilterBuilder.build());
    }

    private static Query newFieldExistsQuery(QueryShardContext context, String field) {
        MappedFieldType fieldType = context.getMapperService().fieldType(field);
        if (fieldType == null) {
            if (context.getObjectMapper(field) != null) {
                return ExistsQueryBuilder.newObjectFieldExistsQuery(context, field);
            }
            return Queries.newMatchNoDocsQuery("User requested \"match_none\" query.");
        }
        Query filter = fieldType.existsQuery(context);
        return new ConstantScoreQuery(filter);
    }

    private static Query newObjectFieldExistsQuery(QueryShardContext context, String objField) {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        Set<String> fields = context.simpleMatchToIndexNames(objField + ".*");
        for (String field : fields) {
            int dotPos = field.lastIndexOf(46);
            if (dotPos > 0 && field.charAt(dotPos + 1) == '_') continue;
            Query existsQuery = context.getMapperService().fieldType(field).existsQuery(context);
            booleanQuery.add(existsQuery, BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)booleanQuery.build());
    }

    private static Collection<String> getMappedField(QueryShardContext context, String fieldPattern) {
        String field;
        MappedFieldType fieldType;
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)context.getMapperService().fieldType("_field_names");
        if (fieldNamesFieldType == null) {
            return Collections.emptySet();
        }
        if (context.getObjectMapper(fieldPattern) != null) {
            return Collections.singleton(fieldPattern);
        }
        Set<String> fields = context.simpleMatchToIndexNames(fieldPattern);
        if (fields.size() == 1 && (fieldType = context.fieldMapper(field = (String)fields.iterator().next())) == null) {
            return Collections.emptySet();
        }
        return fields;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName);
    }

    @Override
    protected boolean doEquals(ExistsQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName);
    }

    public String getWriteableName() {
        return NAME;
    }
}

