/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster.dangling;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.indices.dangling.delete.DeleteDanglingIndexRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDeleteDanglingIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestDeleteDanglingIndexAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_dangling/{index_uuid}"));
    }

    @Override
    public String getName() {
        return "delete_dangling_index";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeleteDanglingIndexRequest deleteRequest = new DeleteDanglingIndexRequest(request.param("index_uuid"), request.paramAsBoolean("accept_data_loss", false));
        deleteRequest.timeout(request.paramAsTime("timeout", deleteRequest.timeout()));
        deleteRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", deleteRequest.clusterManagerNodeTimeout()));
        RestDeleteDanglingIndexAction.parseDeprecatedMasterTimeoutParameter(deleteRequest, request);
        return channel -> client.admin().cluster().deleteDanglingIndex(deleteRequest, (ActionListener<AcknowledgedResponse>)new RestToXContentListener<AcknowledgedResponse>(channel){

            @Override
            protected RestStatus getStatus(AcknowledgedResponse acknowledgedResponse) {
                return RestStatus.ACCEPTED;
            }
        });
    }
}

