/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.tracker;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskResourceTrackingService;
import org.opensearch.wlm.QueryGroupLevelResourceUsageView;
import org.opensearch.wlm.QueryGroupTask;
import org.opensearch.wlm.ResourceType;

public class QueryGroupResourceUsageTrackerService {
    public static final EnumSet<ResourceType> TRACKED_RESOURCES = EnumSet.allOf(ResourceType.class);
    private final TaskResourceTrackingService taskResourceTrackingService;

    public QueryGroupResourceUsageTrackerService(TaskResourceTrackingService taskResourceTrackingService) {
        this.taskResourceTrackingService = taskResourceTrackingService;
    }

    public Map<String, QueryGroupLevelResourceUsageView> constructQueryGroupLevelUsageViews() {
        Map<String, List<Task>> tasksByQueryGroup = this.getTasksGroupedByQueryGroup();
        HashMap<String, QueryGroupLevelResourceUsageView> queryGroupViews = new HashMap<String, QueryGroupLevelResourceUsageView>();
        for (Map.Entry<String, List<Task>> queryGroupEntry : tasksByQueryGroup.entrySet()) {
            EnumMap<ResourceType, Long> queryGroupUsage = new EnumMap<ResourceType, Long>(ResourceType.class);
            for (ResourceType resourceType : TRACKED_RESOURCES) {
                long queryGroupResourceUsage = 0L;
                for (Task task : queryGroupEntry.getValue()) {
                    queryGroupResourceUsage += resourceType.getResourceUsage(task);
                }
                queryGroupUsage.put(resourceType, queryGroupResourceUsage);
            }
            queryGroupViews.put(queryGroupEntry.getKey(), new QueryGroupLevelResourceUsageView(queryGroupUsage, queryGroupEntry.getValue()));
        }
        return queryGroupViews;
    }

    private Map<String, List<Task>> getTasksGroupedByQueryGroup() {
        return this.taskResourceTrackingService.getResourceAwareTasks().values().stream().filter(QueryGroupTask.class::isInstance).map(QueryGroupTask.class::cast).collect(Collectors.groupingBy(QueryGroupTask::getQueryGroupId, Collectors.mapping(task -> task, Collectors.toList())));
    }
}

