/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import com.yahoo.sketches.theta.DirectCompactUnorderedSketch;
import com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import com.yahoo.sketches.theta.HeapCompactUnorderedSketch;
import com.yahoo.sketches.theta.IntersectionImpl;
import com.yahoo.sketches.theta.IntersectionImplR;
import com.yahoo.sketches.theta.SetOperationBuilder;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.UnionImpl;

public abstract class SetOperation {
    static final int CONST_PREAMBLE_LONGS = 3;

    SetOperation() {
    }

    public static final SetOperationBuilder builder() {
        return new SetOperationBuilder();
    }

    public static SetOperation heapify(Memory srcMem) {
        return SetOperation.heapify(srcMem, 9001L);
    }

    public static SetOperation heapify(Memory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        switch (family) {
            case UNION: {
                return UnionImpl.heapifyInstance(srcMem, seed);
            }
            case INTERSECTION: {
                return IntersectionImpl.heapifyInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("SetOperation cannot heapify family: " + family.toString());
    }

    public static SetOperation wrap(Memory srcMem) {
        return SetOperation.wrap(srcMem, 9001L);
    }

    public static SetOperation wrap(Memory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        switch (family) {
            case UNION: {
                return UnionImpl.wrapInstance(srcMem, seed);
            }
            case INTERSECTION: {
                return IntersectionImplR.wrapInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("SetOperation cannot wrap family: " + family.toString());
    }

    public static SetOperation wrap(WritableMemory srcMem) {
        return SetOperation.wrap(srcMem, 9001L);
    }

    public static SetOperation wrap(WritableMemory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        switch (family) {
            case UNION: {
                return UnionImpl.wrapInstance(srcMem, seed);
            }
            case INTERSECTION: {
                return IntersectionImpl.wrapInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("SetOperation cannot wrap family: " + family.toString());
    }

    public static int getMaxUnionBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.UNION.getMaxPreLongs() << 3);
    }

    public static int getMaxIntersectionBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        int bytes = (nomEnt << 4) + (Family.INTERSECTION.getMaxPreLongs() << 3);
        return bytes;
    }

    public abstract Family getFamily();

    public abstract boolean isSameResource(Memory var1);

    abstract long[] getCache();

    abstract int getRetainedEntries(boolean var1);

    abstract short getSeedHash();

    abstract long getThetaLong();

    static short computeSeedHash(long seed) {
        return Util.computeSeedHash(seed);
    }

    abstract boolean isEmpty();

    static final CompactSketch createCompactSketch(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, boolean dstOrdered, WritableMemory dstMem) {
        thetaLong = Sketch.thetaOnCompact(empty, curCount, thetaLong);
        empty = Sketch.emptyOnCompact(curCount, thetaLong);
        CompactSketch sketchOut = null;
        int sw = (dstOrdered ? 2 : 0) | (dstMem != null ? 1 : 0);
        switch (sw) {
            case 0: {
                sketchOut = HeapCompactUnorderedSketch.compact(compactCache, empty, seedHash, curCount, thetaLong);
                break;
            }
            case 1: {
                sketchOut = DirectCompactUnorderedSketch.compact(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
                break;
            }
            case 2: {
                sketchOut = HeapCompactOrderedSketch.compact(compactCache, empty, seedHash, curCount, thetaLong);
                break;
            }
            case 3: {
                sketchOut = DirectCompactOrderedSketch.compact(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
            }
        }
        return sketchOut;
    }

    static final int computeMinLgArrLongsFromCount(int count) {
        int upperCount = (int)Math.ceil((double)count / 0.9375);
        int arrLongs = Math.max(Util.ceilingPowerOf2(upperCount), 32);
        int newLgArrLongs = Integer.numberOfTrailingZeros(arrLongs);
        return newLgArrLongs;
    }

    static boolean isValidSetOpID(int id) {
        Family family = Family.idToFamily(id);
        boolean ret = family == Family.UNION || family == Family.INTERSECTION || family == Family.A_NOT_B;
        return ret;
    }
}

