"use strict";

var _react = require("@testing-library/react");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// import '@testing-library/jest-dom/extend-expect';

(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
window.URL.createObjectURL = () => '';
window.scrollTo = jest.fn();
HTMLCanvasElement.prototype.getContext = jest.fn();
jest.mock('../../../src/plugins/data/common', () => ({
  buildOpenSearchQuery: jest.fn(() => ({
    bool: {
      must: []
    }
  })),
  Filter: jest.fn(),
  Query: jest.fn(),
  TimeRange: jest.fn(),
  getTime: jest.fn(() => ({
    range: 'test-range'
  }))
}));
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'random-id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'random_html_id';
  }
}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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