/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Excuse;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.provenance.ModelProvenance;

public abstract class Model<T extends Output<T>>
implements Provenancable<ModelProvenance>,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final String ALL_OUTPUTS = "ALL_OUTPUTS";
    public static final String BIAS_FEATURE = "BIAS";
    protected String name;
    protected final ModelProvenance provenance;
    protected final String provenanceOutput;
    protected final ImmutableFeatureMap featureIDMap;
    protected final ImmutableOutputInfo<T> outputIDInfo;
    protected final boolean generatesProbabilities;

    protected Model(String name, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, boolean generatesProbabilities) {
        this.name = name;
        this.provenance = provenance;
        this.provenanceOutput = provenance.toString();
        this.featureIDMap = featureIDMap;
        this.outputIDInfo = outputIDInfo;
        this.generatesProbabilities = generatesProbabilities;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelProvenance getProvenance() {
        return this.provenance;
    }

    public ImmutableFeatureMap getFeatureIDMap() {
        return this.featureIDMap;
    }

    public ImmutableOutputInfo<T> getOutputIDInfo() {
        return this.outputIDInfo;
    }

    public boolean generatesProbabilities() {
        return this.generatesProbabilities;
    }

    public boolean validate(Class<? extends Output<?>> clazz) {
        Set domain = this.outputIDInfo.getDomain();
        boolean output = true;
        for (Output type : domain) {
            output &= clazz.isInstance(type);
        }
        return output;
    }

    public abstract Prediction<T> predict(Example<T> var1);

    public List<Prediction<T>> predict(Iterable<Example<T>> examples) {
        return this.innerPredict(examples);
    }

    public List<Prediction<T>> predict(Dataset<T> examples) {
        return this.innerPredict(examples);
    }

    protected List<Prediction<T>> innerPredict(Iterable<Example<T>> examples) {
        ArrayList<Prediction<T>> predictions = new ArrayList<Prediction<T>>();
        for (Example<T> example : examples) {
            predictions.add(this.predict(example));
        }
        return predictions;
    }

    public abstract Map<String, List<Pair<String, Double>>> getTopFeatures(int var1);

    public abstract Optional<Excuse<T>> getExcuse(Example<T> var1);

    public Optional<List<Excuse<T>>> getExcuses(Iterable<Example<T>> examples) {
        ArrayList<Excuse<T>> excuses = new ArrayList<Excuse<T>>();
        for (Example<T> e : examples) {
            Optional<Excuse<T>> excuse = this.getExcuse(e);
            if (excuse.isPresent()) {
                excuses.add(excuse.get());
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(excuses);
    }

    public Model<T> copy() {
        List omp = ProvenanceUtil.marshalProvenance((ObjectProvenance)this.provenance);
        ModelProvenance provenanceCopy = (ModelProvenance)ProvenanceUtil.unmarshalProvenance((List)omp);
        return this.copy(this.name, provenanceCopy);
    }

    protected abstract Model<T> copy(String var1, ModelProvenance var2);

    public String toString() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name + " - " + this.provenanceOutput;
        }
        return this.provenanceOutput;
    }

    public <U extends Output<U>> Model<U> castModel(Class<U> outputType) {
        if (this.validate(outputType)) {
            Model castedModel = this;
            return castedModel;
        }
        throw new ClassCastException("Attempted to cast model to " + outputType.getName() + " which is not valid for model " + this.toString());
    }
}

