/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.hwnet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.commons.collectors.NetInterfaceSummary;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics_generator.linux.LinuxIPMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;

public class NetworkInterface {
    private static final Logger LOG = LogManager.getLogger(NetworkInterface.class);
    private static NetInterfaceMetrics currentMetrics = new NetInterfaceMetrics();
    private static NetInterfaceMetrics oldMetrics = new NetInterfaceMetrics();
    private static Map<String, Long> currentMetrics6 = new HashMap<String, Long>();
    private static Map<String, Long> oldMetrics6 = new HashMap<String, Long>();
    private static long kvTimestamp = 0L;
    private static long oldkvTimestamp = 0L;
    private static StringBuilder ret = new StringBuilder();
    private static String[] IPkeys = null;
    private static LinuxIPMetricsGenerator linuxIPMetricsGenerator = new LinuxIPMetricsGenerator();
    private static final Splitter STRING_PATTERN_SPLITTER = Splitter.on((Pattern)Pattern.compile("[ \\t]+"));

    public static LinuxIPMetricsGenerator getLinuxIPMetricsGenerator() {
        return linuxIPMetricsGenerator;
    }

    protected static void calculateNetworkMetrics() {
        if (kvTimestamp <= oldkvTimestamp) {
            linuxIPMetricsGenerator.setInNetworkInterfaceSummary(null);
            linuxIPMetricsGenerator.setOutNetworkInterfaceSummary(null);
            return;
        }
        Map<String, Long> curphy = NetworkInterface.currentMetrics.PHYmetrics;
        Map<String, Long> curipv4 = NetworkInterface.currentMetrics.IPmetrics;
        Map<String, Long> oldphy = NetworkInterface.oldMetrics.PHYmetrics;
        Map<String, Long> oldipv4 = NetworkInterface.oldMetrics.IPmetrics;
        long nin = curipv4.get("InReceives") - oldipv4.get("InReceives");
        long nout = curipv4.get("OutRequests") - oldipv4.get("OutRequests");
        long delivin = curipv4.get("InDelivers") - oldipv4.get("InDelivers");
        long dropout = curipv4.get("OutDiscards") + curipv4.get("OutNoRoutes") - oldipv4.get("OutDiscards") - oldipv4.get("OutNoRoutes");
        long nin6 = currentMetrics6.get("Ip6InReceives") - oldMetrics6.get("Ip6InReceives");
        long nout6 = currentMetrics6.get("Ip6OutRequests") - oldMetrics6.get("Ip6OutRequests");
        long delivin6 = currentMetrics6.get("Ip6InDelivers") - oldMetrics6.get("Ip6InDelivers");
        long dropout6 = currentMetrics6.get("Ip6OutDiscards") + currentMetrics6.get("Ip6OutNoRoutes") - oldMetrics6.get("Ip6OutDiscards") - oldMetrics6.get("Ip6OutNoRoutes");
        long timeDelta = kvTimestamp - oldkvTimestamp;
        double inbps = 8000.0 * (double)(curphy.get("inbytes") - oldphy.get("inbytes")) / (double)timeDelta;
        double outbps = 8000.0 * (double)(curphy.get("outbytes") - oldphy.get("outbytes")) / (double)timeDelta;
        double inPacketRate4 = 1000.0 * (double)nin / (double)timeDelta;
        double outPacketRate4 = 1000.0 * (double)nout / (double)timeDelta;
        double inDropRate4 = 1000.0 * (double)(nin - delivin) / (double)timeDelta;
        double outDropRate4 = 1000.0 * (double)dropout / (double)timeDelta;
        double inPacketRate6 = 1000.0 * (double)nin6 / (double)timeDelta;
        double outPacketRate6 = 1000.0 * (double)nout6 / (double)timeDelta;
        double inDropRate6 = 1000.0 * (double)(nin6 - delivin6) / (double)timeDelta;
        double outDropRate6 = 1000.0 * (double)dropout6 / (double)timeDelta;
        NetInterfaceSummary inNetwork = new NetInterfaceSummary(NetInterfaceSummary.Direction.in, inPacketRate4, inDropRate4, inPacketRate6, inDropRate6, inbps);
        NetInterfaceSummary outNetwork = new NetInterfaceSummary(NetInterfaceSummary.Direction.out, outPacketRate4, outDropRate4, outPacketRate6, outDropRate6, outbps);
        linuxIPMetricsGenerator.setInNetworkInterfaceSummary(inNetwork);
        linuxIPMetricsGenerator.setOutNetworkInterfaceSummary(outNetwork);
    }

    private static void getKeys(String line) {
        if (IPkeys != null) {
            return;
        }
        if (line.startsWith("Ip:")) {
            IPkeys = line.split("\\s+");
        }
    }

    private static void generateMap(String line) {
        Map<String, Long> map = null;
        String[] keys = null;
        if (line.startsWith("Ip:")) {
            map = NetworkInterface.currentMetrics.IPmetrics;
            keys = IPkeys;
        }
        if (keys != null) {
            NetworkInterface.generateMap(line, keys, map);
        }
    }

    private static void generateMap(String line, String[] keys, Map<String, Long> map) {
        String[] values = line.split("\\s+");
        int count = values.length;
        map.put(keys[0], 0L);
        for (int i = 1; i < count; ++i) {
            map.put(keys[i], Long.parseLong(values[i]));
        }
    }

    private static void addSample4() {
        int ln = 0;
        oldMetrics.clearAll();
        oldMetrics.putAll(currentMetrics);
        currentMetrics.clearAll();
        oldkvTimestamp = kvTimestamp;
        kvTimestamp = System.currentTimeMillis();
        try (FileReader fileReader = new FileReader(new File("/proc/net/snmp"));
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (ln % 2 == 0) {
                    NetworkInterface.getKeys(line);
                } else {
                    NetworkInterface.generateMap(line);
                }
                ++ln;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception in calling addSample4 with details: {} with ExceptionCode: {}", new Supplier[]{() -> e.toString(), () -> StatExceptionCode.NETWORK_COLLECTION_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.NETWORK_COLLECTION_ERROR);
        }
    }

    private static void addSample6() {
        oldMetrics6.clear();
        oldMetrics6.putAll(currentMetrics6);
        currentMetrics6.clear();
        try (FileReader fileReader = new FileReader(new File("/proc/net/snmp6"));
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                List toks = STRING_PATTERN_SPLITTER.splitToList((CharSequence)line);
                if (toks.size() <= 1) continue;
                currentMetrics6.put((String)toks.get(0), Long.parseLong((String)toks.get(1)));
            }
        }
        catch (Exception e) {
            LOG.debug("Exception in calling addSample6 with details: {} with ExceptionCode: {}", new Supplier[]{() -> e.toString(), () -> StatExceptionCode.NETWORK_COLLECTION_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.NETWORK_COLLECTION_ERROR);
        }
    }

    private static void addDeviceStats() {
        try (FileReader fileReader = new FileReader(new File("/proc/net/dev"));
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = null;
            long intotbytes = 0L;
            long outtotbytes = 0L;
            long intotpackets = 0L;
            long outtotpackets = 0L;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains("Receive") || line.contains("packets")) continue;
                String[] toks = line.trim().split(" +");
                intotbytes += Long.parseLong(toks[1]);
                intotpackets += Long.parseLong(toks[2]);
                outtotbytes += Long.parseLong(toks[9]);
                outtotpackets += Long.parseLong(toks[10]);
            }
            NetworkInterface.currentMetrics.PHYmetrics.put("inbytes", intotbytes);
            NetworkInterface.currentMetrics.PHYmetrics.put("inpackets", intotpackets);
            NetworkInterface.currentMetrics.PHYmetrics.put("outbytes", outtotbytes);
            NetworkInterface.currentMetrics.PHYmetrics.put("outpackets", outtotpackets);
        }
        catch (Exception e) {
            LOG.debug("Exception in calling addDeviceStats with details: {} with ExceptionCode: {}", new Supplier[]{() -> e.toString(), () -> StatExceptionCode.NETWORK_COLLECTION_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.NETWORK_COLLECTION_ERROR);
        }
    }

    public static void addSample() {
        NetworkInterface.addSampleHelper();
        NetworkInterface.calculateNetworkMetrics();
    }

    private static synchronized void addSampleHelper() {
        NetworkInterface.addSample4();
        NetworkInterface.addSample6();
        NetworkInterface.addDeviceStats();
    }

    public static void runOnce() {
        NetworkInterface.addSample();
    }

    @VisibleForTesting
    Map<String, Long> getCurrentPhyMetric() {
        return NetworkInterface.currentMetrics.PHYmetrics;
    }

    @VisibleForTesting
    Map<String, Long> getCurrentIpMetric() {
        return NetworkInterface.currentMetrics.IPmetrics;
    }

    @VisibleForTesting
    Map<String, Long> getOldPhyMetric() {
        return NetworkInterface.oldMetrics.PHYmetrics;
    }

    @VisibleForTesting
    Map<String, Long> getOldIpMetric() {
        return NetworkInterface.oldMetrics.IPmetrics;
    }

    @VisibleForTesting
    Map<String, Long> getCurrentMetrics6() {
        return currentMetrics6;
    }

    @VisibleForTesting
    Map<String, Long> getOldMetrics6() {
        return oldMetrics6;
    }

    @VisibleForTesting
    void putCurrentPhyMetric(String key, Long value) {
        NetworkInterface.currentMetrics.PHYmetrics.put(key, value);
    }

    @VisibleForTesting
    void putCurrentIpMetric(String key, Long value) {
        NetworkInterface.currentMetrics.IPmetrics.put(key, value);
    }

    @VisibleForTesting
    void putOldPhyMetric(String key, Long value) {
        NetworkInterface.oldMetrics.PHYmetrics.put(key, value);
    }

    @VisibleForTesting
    void putOldIpMetric(String key, Long value) {
        NetworkInterface.oldMetrics.IPmetrics.put(key, value);
    }

    @VisibleForTesting
    void putCurrentMetrics6(String key, Long value) {
        currentMetrics6.put(key, value);
    }

    @VisibleForTesting
    void putOldMetrics6(String key, Long value) {
        oldMetrics6.put(key, value);
    }

    @VisibleForTesting
    static void setKvTimestamp(long value) {
        kvTimestamp = value;
    }

    @VisibleForTesting
    static void setOldkvTimestamp(long oldkvTimestamp) {
        NetworkInterface.oldkvTimestamp = oldkvTimestamp;
    }

    @VisibleForTesting
    static long getKvTimestamp() {
        return kvTimestamp;
    }

    @VisibleForTesting
    static long getOldkvTimestamp() {
        return oldkvTimestamp;
    }

    static {
        NetworkInterface.addSampleHelper();
    }

    static class NetInterfaceMetrics {
        Map<String, Long> PHYmetrics = new HashMap<String, Long>();
        Map<String, Long> IPmetrics = new HashMap<String, Long>();

        NetInterfaceMetrics() {
        }

        public void clearAll() {
            this.PHYmetrics.clear();
            this.IPmetrics.clear();
        }

        public void putAll(NetInterfaceMetrics m) {
            this.PHYmetrics.putAll(m.PHYmetrics);
            this.IPmetrics.putAll(m.IPmetrics);
        }
    }
}

