/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.net.tasks;

import com.google.common.collect.ImmutableSet;
import io.grpc.stub.StreamObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.grpc.PublishResponse;
import org.opensearch.performanceanalyzer.net.NetClient;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.messages.DataMsg;
import org.opensearch.performanceanalyzer.rca.net.SubscriptionManager;

public class FlowUnitTxTask
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(FlowUnitTxTask.class);
    private final NetClient client;
    private final SubscriptionManager subscriptionManager;
    private final DataMsg dataMsg;
    private final AppContext appContext;

    public FlowUnitTxTask(NetClient client, SubscriptionManager subscriptionManager, DataMsg dataMsg, AppContext appContext) {
        this.client = client;
        this.subscriptionManager = subscriptionManager;
        this.dataMsg = dataMsg;
        this.appContext = appContext;
    }

    @Override
    public void run() {
        final String sourceGraphNode = this.dataMsg.getSourceGraphNode();
        InstanceDetails openSearchInstanceDetails = this.appContext.getMyInstanceDetails();
        if (this.subscriptionManager.isNodeSubscribed(sourceGraphNode)) {
            ImmutableSet<InstanceDetails.Id> downstreamHostIds = this.subscriptionManager.getSubscribersFor(sourceGraphNode);
            LOG.debug("{} has downstream subscribers: {}", (Object)sourceGraphNode, downstreamHostIds);
            for (final InstanceDetails.Id downstreamHostId : downstreamHostIds) {
                for (GenericFlowUnit flowUnit : this.dataMsg.getFlowUnits()) {
                    LOG.debug("rca: [pub-tx]: {} -> {}", (Object)sourceGraphNode, (Object)downstreamHostId);
                    this.client.publish(this.appContext.getInstanceById(downstreamHostId), flowUnit.buildFlowUnitMessage(sourceGraphNode, openSearchInstanceDetails.getInstanceId()), new StreamObserver<PublishResponse>(){

                        public void onNext(PublishResponse value) {
                            LOG.debug("rca: Received acknowledgement from the server. status: {}", (Object)value.getDataStatus());
                            if (value.getDataStatus() == PublishResponse.PublishResponseStatus.NODE_SHUTDOWN) {
                                FlowUnitTxTask.this.subscriptionManager.unsubscribeAndTerminateConnection(sourceGraphNode, downstreamHostId);
                                FlowUnitTxTask.this.client.flushStream(downstreamHostId);
                            }
                        }

                        public void onError(Throwable t) {
                            ServiceMetrics.RCA_GRAPH_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaGraphMetrics.RCA_NETWORK_ERROR, sourceGraphNode, (Number)1);
                            LOG.error("rca: Encountered an exception at the server: ", t);
                            FlowUnitTxTask.this.subscriptionManager.unsubscribeAndTerminateConnection(sourceGraphNode, downstreamHostId);
                            FlowUnitTxTask.this.client.flushStream(downstreamHostId);
                        }

                        public void onCompleted() {
                            LOG.debug("rca: Server closed the data channel!");
                        }
                    });
                    ServiceMetrics.RCA_GRAPH_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaGraphMetrics.RCA_NODES_FU_PUBLISH_COUNT, sourceGraphNode, (Number)1);
                }
            }
        } else {
            LOG.debug("No subscribers for {}.", (Object)sourceGraphNode);
        }
    }
}

