/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.exception.DataAccessException;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.Node;
import org.opensearch.performanceanalyzer.rca.persistence.FileGC;
import org.opensearch.performanceanalyzer.rca.persistence.FileRotate;
import org.opensearch.performanceanalyzer.rca.persistence.Persistable;

public abstract class PersistorBase
implements Persistable {
    private static final Logger LOG = LogManager.getLogger(PersistorBase.class);
    protected final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    protected String dir;
    protected String filename;
    protected Connection conn;
    protected Set<String> tableNames;
    protected Date fileCreateTime;
    protected String filenameParam;
    protected String dbProtocol;
    private final int STORAGE_FILE_RETENTION_COUNT;
    private static final int STORAGE_FILE_RETENTION_COUNT_DEFAULT_VALUE = 5;
    private final File dirDB;
    private final FileRotate fileRotate;
    private final FileGC fileGC;

    PersistorBase(String dir, String filename, String dbProtocolString, String storageFileRetentionCount, TimeUnit fileRotationTimeUnit, long fileRotationPeriod) throws SQLException, IOException {
        int parsedStorageFileRetentionCount;
        this.dir = dir;
        this.filenameParam = filename;
        this.dbProtocol = dbProtocolString;
        this.dirDB = new File(this.dir);
        try {
            parsedStorageFileRetentionCount = Integer.parseInt(storageFileRetentionCount);
        }
        catch (NumberFormatException exp) {
            parsedStorageFileRetentionCount = 5;
            LOG.error(String.format("Unable to parse '%s' as integer", storageFileRetentionCount));
        }
        this.STORAGE_FILE_RETENTION_COUNT = parsedStorageFileRetentionCount;
        Path path = Paths.get(dir, this.filenameParam);
        this.fileRotate = new FileRotate(path, fileRotationTimeUnit, fileRotationPeriod, this.dateFormat);
        this.fileRotate.forceRotate(System.currentTimeMillis());
        this.fileGC = new FileGC(Paths.get(dir, new String[0]), this.filenameParam, fileRotationTimeUnit, fileRotationPeriod, this.STORAGE_FILE_RETENTION_COUNT);
        this.openNewDBFile();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    abstract void createTable(String var1, List<Field<?>> var2) throws SQLException;

    abstract void createTable(String var1, List<Field<?>> var2, String var3, String var4) throws SQLException;

    abstract int insertRow(String var1, List<Object> var2) throws SQLException;

    abstract String readTables();

    abstract JsonElement readRca(String var1);

    abstract void createNewDSLContext();

    @Override
    @VisibleForTesting
    public abstract Map<String, Result<Record>> getRecordsForAllTables();

    @Override
    public synchronized List<ResourceFlowUnit> read(Node<?> node) {
        return null;
    }

    @Override
    public synchronized String read() {
        return this.readTables();
    }

    @Override
    public synchronized JsonElement read(String rca) {
        JsonArray rcaJson = new JsonArray();
        JsonElement response = this.readRca(rca);
        if (response != null) {
            rcaJson.add(response);
        }
        return rcaJson;
    }

    private synchronized void openNewDBFile() throws SQLException {
        this.fileCreateTime = new Date(System.currentTimeMillis());
        this.filename = Paths.get(this.dir, this.filenameParam).toString();
        this.tableNames = new HashSet<String>();
        String url = String.format("%s%s", this.dbProtocol, this.filename);
        this.close();
        this.conn = DriverManager.getConnection(url);
        this.createNewDSLContext();
    }

    @Override
    public synchronized <T extends ResourceFlowUnit> void write(Node<?> node, T flowUnit) throws SQLException, IOException {
        if (flowUnit.isEmpty()) {
            LOG.debug("RCA: Flow unit isEmpty");
            return;
        }
        this.rotateRegisterGarbageThenCreateNewDB(RotationType.TRY_ROTATE);
        try {
            this.writeFlowUnit(flowUnit, node.name());
        }
        catch (SQLException e) {
            LOG.error("RCA: Multiple attempts to write the data for table '{}' failed", (Object)node.name(), (Object)e);
            throw e;
        }
    }

    @Override
    public synchronized <T> void write(T obj) throws SQLException, IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Objects.requireNonNull(obj);
        this.rotateRegisterGarbageThenCreateNewDB(RotationType.TRY_ROTATE);
        try {
            this.writeImpl(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | IllegalStateException | NoSuchMethodException | InvocationTargetException illegalEx) {
            throw illegalEx;
        }
        catch (SQLException e) {
            LOG.info("RCA: Fail to write.", (Throwable)e);
            this.rotateRegisterGarbageThenCreateNewDB(RotationType.FORCE_ROTATE);
            try {
                this.writeImpl(obj);
            }
            catch (SQLException ex) {
                LOG.error("Failed to write multiple times. Giving up.");
                throw e;
            }
        }
    }

    abstract <T> void writeImpl(T var1) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException;

    private synchronized void rotateRegisterGarbageThenCreateNewDB(RotationType type) throws IOException, SQLException {
        Path rotatedFile = null;
        long currTime = System.currentTimeMillis();
        switch (type) {
            case FORCE_ROTATE: {
                rotatedFile = this.fileRotate.forceRotate(currTime);
                break;
            }
            case TRY_ROTATE: {
                rotatedFile = this.fileRotate.tryRotate(currTime);
            }
        }
        if (rotatedFile != null) {
            this.fileGC.eligibleForGc(rotatedFile.toFile().getName());
        }
        if (this.fileRotate.getLastRotatedMillis() == currTime) {
            this.openNewDBFile();
            LOG.info("Created a new DB file.");
        }
    }

    private synchronized <T extends ResourceFlowUnit> void writeFlowUnit(T flowUnit, String tableName) throws SQLException, IOException {
        try {
            this.tryWriteFlowUnit(flowUnit, tableName);
        }
        catch (SQLException | DataAccessException e) {
            LOG.info("RCA: Fail to write to table '{}', creating a new DB file and retrying write/create operation", (Object)tableName, (Object)e);
            this.rotateRegisterGarbageThenCreateNewDB(RotationType.FORCE_ROTATE);
            this.tryWriteFlowUnit(flowUnit, tableName);
        }
    }

    private synchronized <T extends ResourceFlowUnit> void tryWriteFlowUnit(T flowUnit, String nodeName) throws SQLException, DataAccessException {
        String tableName = "RCA";
        if (!this.tableNames.contains(tableName)) {
            LOG.info("RCA: Table '{}' does not exist. Creating one with columns: {}", (Object)tableName, flowUnit.getSqlSchema());
            this.createTable(tableName, flowUnit.getSqlSchema());
        }
        int lastPrimaryKey = this.insertRow(tableName, flowUnit.getSqlValue(nodeName));
        if (flowUnit.hasResourceSummary() && flowUnit.isSummaryPersistable()) {
            this.writeSummary(flowUnit.getPersistableSummary(), tableName, this.getPrimaryKeyColumnName(tableName), lastPrimaryKey);
        }
    }

    private synchronized void writeSummary(GenericSummary summary, String referenceTable, String referenceTablePrimaryKeyFieldName, int referenceTablePrimaryKeyFieldValue) throws SQLException {
        String tableName = summary.getClass().getSimpleName();
        if (!this.tableNames.contains(tableName)) {
            LOG.info("RCA: Summary table '{}' does not exist. Creating one with columns: {}", (Object)tableName, summary.getSqlSchema());
            this.createTable(tableName, summary.getSqlSchema(), referenceTable, referenceTablePrimaryKeyFieldName);
        }
        List<Object> values = summary.getSqlValue();
        values.add(referenceTablePrimaryKeyFieldValue);
        int lastPrimaryKey = this.insertRow(tableName, values);
        for (GenericSummary nestedSummary : summary.getNestedSummaryList()) {
            this.writeSummary(nestedSummary, tableName, this.getPrimaryKeyColumnName(tableName), lastPrimaryKey);
        }
    }

    protected String getPrimaryKeyColumnName(String tableName) {
        return tableName + "_ID";
    }

    static enum RotationType {
        TRY_ROTATE,
        FORCE_ROTATE;

    }
}

