/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import tim.prune.cmd.Command;
import tim.prune.cmd.InsertPhotoCmd;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;

public class RemovePhotoCmd
extends Command {
    private final int _photoIndex;

    public RemovePhotoCmd(int n) {
        this(null, n);
    }

    protected RemovePhotoCmd(Command command, int n) {
        super(command);
        this._photoIndex = n;
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        try {
            trackInfo.getPhotoList().delete(this._photoIndex);
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        Photo photo = trackInfo.getPhotoList().get(this._photoIndex);
        return new InsertPhotoCmd(this, photo, this._photoIndex);
    }
}

