/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bugreport;

import java.awt.Dimension;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class DebugTextDisplay
extends JScrollPane {
    private static final String CODE_PATTERN = "{{{%n%s%n}}}";
    private String text;
    private final JosmTextArea textArea = new JosmTextArea();

    private DebugTextDisplay() {
        this.textArea.setCaretPosition(0);
        this.textArea.setEditable(false);
        this.setViewportView(this.textArea);
        this.setPreferredSize(new Dimension(600, 270));
    }

    public DebugTextDisplay(String textToDisplay) {
        this();
        this.setCodeText(textToDisplay);
    }

    public DebugTextDisplay(BugReport report) {
        this();
        this.setCodeText(report.getReportText(ShowStatusReportAction.getReportHeader()));
        report.addChangeListener(e -> this.setCodeText(report.getReportText(ShowStatusReportAction.getReportHeader())));
    }

    private void setCodeText(String textToDisplay) {
        this.text = Utils.strip(textToDisplay).replaceAll("\r", "");
        this.textArea.setText(String.format(CODE_PATTERN, this.text));
        this.textArea.setCaretPosition(0);
    }

    public boolean copyToClipboard() {
        return ClipboardUtils.copyString(String.format(CODE_PATTERN, this.text));
    }

    public String getCodeText() {
        return this.text;
    }
}

