/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.HeaderProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.Map;

public class LinkProcessor {
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    private final HeaderProcessor headerProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public LinkProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.headerProcessor = new HeaderProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processLink(Link link) {
        if (link.get$ref() != null) {
            String newRef;
            RefFormat refFormat = RefUtils.computeRefFormat(link.get$ref());
            String $ref = link.get$ref();
            if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalLink($ref, refFormat)) != null) {
                link.set$ref(newRef);
            }
        } else if (link.getHeaders() != null) {
            Map<String, Header> headers = link.getHeaders();
            for (String headerName : headers.keySet()) {
                Header header = headers.get(headerName);
                this.headerProcessor.processHeader(header);
            }
        }
    }
}

