/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.sdedit.diagram.AbstractPaintDevice;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.GraphicDevice;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Fragment;
import net.sf.sdedit.drawable.Line;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.util.Direction;

public class SDPaintDevice
extends AbstractPaintDevice {
    private int height = 0;
    private final ArrayList<Set<SequenceElement>> leftOf = new ArrayList();
    private final List<Drawable> other = new LinkedList<Drawable>();
    private SequenceDiagram diagram;
    private final Line rightBound = new Line(1, null);

    public SDPaintDevice(GraphicDevice graphic) {
        super(graphic);
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagram = (SequenceDiagram)diagram;
        this.getGraphicDevice().initialize(diagram);
    }

    @Override
    public void reinitialize() {
        this.leftOf.clear();
        this.other.clear();
        this.rightBound.setLeft(0);
        this.height = 0;
        for (int i = 0; i < this.diagram.getNumberOfLifelines(); ++i) {
            this.addLifelineSlot();
        }
    }

    private void addLifelineSlot() {
        this.leftOf.add(new HashSet());
    }

    private Line getRightBound() {
        return this.rightBound;
    }

    @Override
    public void addExtraordinary(Drawable drawable) {
        this.other.add(drawable);
        if (drawable.getRight() > this.rightBound.getLeft()) {
            this.rightBound.setLeft(drawable.getRight());
        }
        if (drawable.getBottom() > this.height) {
            this.height = drawable.getBottom();
        }
    }

    @Override
    public void append(Drawable drawable) {
        ExtensibleDrawable right;
        ExtensibleDrawable left;
        int index;
        SequenceElement elem = (SequenceElement)drawable;
        if (elem.getAlign() == Direction.RIGHT) {
            index = elem.getLeftEndpoint().getLifeline().getPosition();
            left = elem.getLeftEndpoint().getLifeline().getRightmost().getView();
            right = index == this.diagram.getNumberOfLifelines() - 1 ? this.rightBound : this.diagram.getLifelineAt(index + 1).getLeftmost().getView();
        } else {
            index = elem.getRightEndpoint().getLifeline().getPosition() - 1;
            right = elem.getRightEndpoint().getLifeline().getLeftmost().getView();
            left = this.diagram.getLifelineAt(index).getRightmost().getView();
        }
        this.leftOf.get(index).add(elem);
        elem.setLeftLimit(left);
        elem.setRightLimit(right);
        this.diagram.getFragmentManager().addSequenceElement(elem);
    }

    @Override
    public boolean isEmpty() {
        return this.diagram == null || this.diagram.getNumberOfLifelines() == 0;
    }

    private int getMaxHeadWidthAt(int position) {
        int maxHeadWidth = 0;
        List<Lifeline> list = this.diagram.getLifelinesAt(position);
        for (Lifeline line : list) {
            if (line.getHead().getWidth() <= maxHeadWidth) continue;
            maxHeadWidth = line.getHead().getWidth();
        }
        return maxHeadWidth;
    }

    private void computeAxes(int leftAxis) {
        int n = this.diagram.getNumberOfLifelines();
        int axis = leftAxis;
        int mainWidth = this.diagram.getConfiguration().getMainLifelineWidth();
        int subWidth = this.diagram.getConfiguration().getSubLifelineWidth();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                axis += this.diagram.getConfiguration().getGlue();
            }
            int j = 0;
            List<Lifeline> list = this.diagram.getLifelinesAt(i);
            int maxHeadWidth = this.getMaxHeadWidthAt(i);
            for (Lifeline lifeline : list) {
                for (ExtensibleDrawable view : lifeline.getAllViews()) {
                    if (view instanceof Line) {
                        view.setLeft(axis + mainWidth / 2);
                        continue;
                    }
                    switch (view.getLifeline().getDirection()) {
                        case CENTER: {
                            view.setLeft(axis);
                            break;
                        }
                        case LEFT: {
                            view.setLeft(axis - view.getLifeline().getSideLevel() * subWidth);
                            break;
                        }
                        case RIGHT: {
                            view.setLeft(axis + mainWidth + (view.getLifeline().getSideLevel() - 1) * subWidth);
                        }
                    }
                }
                Drawable head = lifeline.getHead();
                int offset = mainWidth / 2;
                head.setLeft(axis - head.getWidth() / 2 + offset);
                if (lifeline.getCross() != null) {
                    lifeline.getCross().setLeft(axis - this.diagram.getConfiguration().getDestructorWidth() / 2 + mainWidth / 2);
                }
                if (j == list.size() - 1) {
                    axis = i < this.diagram.getNumberOfLifelines() - 1 ? (axis += maxHeadWidth / 2 + this.getMaxHeadWidthAt(i + 1) / 2) : (axis += maxHeadWidth / 2 + mainWidth / 2);
                }
                ++j;
            }
            for (SequenceElement arrow : this.leftOf.get(i)) {
                int left = arrow.getLeftLimit().getRight();
                int level = arrow.getRightLimit() == this.rightBound ? 0 : arrow.getRightLimit().getLifeline().getSideLevel();
                axis = Math.max(axis, left + arrow.getSpace() + arrow.getWidth() + level * subWidth);
            }
        }
        this.rightBound.setLeft(axis);
    }

    @Override
    public int getWidth() {
        return this.diagram == null ? 0 : this.rightBound.getLeft() + 6 + this.diagram.getConfiguration().getRightMargin();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void clear() {
        this.diagram = null;
    }

    @Override
    public void computeBounds() {
        int i;
        for (i = 0; i < this.diagram.getNumberOfLifelines(); ++i) {
            for (Drawable drawable : this.getAllViewsAt(i)) {
                this.processDrawable(drawable);
            }
        }
        for (i = 0; i < this.leftOf.size(); ++i) {
            for (SequenceElement sequenceElement : this.leftOf.get(i)) {
                this.processDrawable(sequenceElement);
            }
        }
        for (Drawable d : this.other) {
            this.processDrawable(d);
        }
        this.height += this.diagram.getConfiguration().getLowerMargin();
    }

    private void processDrawable(Drawable drawable) {
        this.height = Math.max(this.height, drawable.getTop() + drawable.getHeight());
        drawable.computeLayoutInformation();
        if (drawable instanceof Fragment) {
            int r = this.rightBound.getLeft();
            this.rightBound.setLeft(Math.max(r, drawable.getLeft() + drawable.getWidth()));
        }
    }

    @Override
    public void announce(int height) {
    }

    @Override
    public SequenceDiagram getDiagram() {
        return this.diagram;
    }

    @Override
    public Iterator<Drawable> iterator() {
        return new Iter();
    }

    private List<ExtensibleDrawable> getAllViewsAt(int position) {
        ArrayList<ExtensibleDrawable> allViews = new ArrayList<ExtensibleDrawable>();
        for (Lifeline line : this.diagram.getLifelinesAt(position)) {
            allViews.addAll(line.getAllViews());
        }
        return allViews;
    }

    @Override
    public Object callSpecial(String method, Object argument) {
        if ("addLifelineSlot".equals(method)) {
            this.addLifelineSlot();
            return null;
        }
        if ("computeAxes".equals(method)) {
            int leftAxis = (Integer)argument;
            this.computeAxes(leftAxis);
            return null;
        }
        if ("getRightBound".equals(method)) {
            return this.getRightBound();
        }
        throw new IllegalArgumentException("special method not supported: " + method);
    }

    private class Iter
    implements Iterator<Drawable> {
        private int counter;
        private Iterator<? extends Drawable> iterator;
        private Drawable next;
        private final SequenceDiagram diagram;

        private void nextIterator() {
            if (this.diagram == null || !this.diagram.isFinished()) {
                this.iterator = null;
                return;
            }
            ++this.counter;
            this.iterator = this.counter < this.diagram.getNumberOfLifelines() ? SDPaintDevice.this.getAllViewsAt(this.counter).iterator() : (this.counter < 2 * this.diagram.getNumberOfLifelines() ? ((Set)SDPaintDevice.this.leftOf.get(this.counter - this.diagram.getNumberOfLifelines())).iterator() : (this.counter == 2 * this.diagram.getNumberOfLifelines() ? SDPaintDevice.this.other.iterator() : null));
        }

        Iter() {
            this.diagram = SDPaintDevice.this.diagram;
            this.counter = -1;
            this.nextIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.diagram != null && this.diagram != SDPaintDevice.this.diagram) {
                return false;
            }
            if (this.next == null) {
                this.findNext();
            }
            return this.next != null;
        }

        private void findNext() {
            while (this.iterator != null) {
                while (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (!this.next.isVisible()) continue;
                    return;
                }
                this.nextIterator();
            }
            if (this.next != null && !this.next.isVisible()) {
                this.next = null;
            }
        }

        @Override
        public Drawable next() {
            if (this.next == null) {
                this.findNext();
            }
            if (this.next != null) {
                Drawable ret = this.next;
                this.next = null;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

