/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMESupport;

public class FileEvent
extends EventObject {
    private static final long serialVersionUID = 1028087432345400108L;
    private static final Logger LOG = Logger.getLogger(FileEvent.class.getName());
    private FileObject file;
    private long time;
    private boolean expected;
    private EventControl.AtomicActionLink atomActionID;
    private transient Collection<Runnable> postNotify;

    public FileEvent(FileObject fileObject) {
        this(fileObject, fileObject, false, -1L);
    }

    public FileEvent(FileObject fileObject, FileObject fileObject2) {
        this(fileObject, fileObject2, false, -1L);
    }

    FileEvent(FileObject fileObject, FileObject fileObject2, long l) {
        this(fileObject, fileObject2, false, l);
    }

    public FileEvent(FileObject fileObject, FileObject fileObject2, boolean bl) {
        this(fileObject, fileObject2, bl, -1L);
    }

    public FileEvent(FileObject fileObject, FileObject fileObject2, boolean bl, long l) {
        super(fileObject);
        this.file = fileObject2;
        this.time = l <= 0L ? System.currentTimeMillis() : l;
        this.expected = bl;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "FileEvent({0}, {1}, {2}, {3})", new Object[]{fileObject, fileObject2, bl, this.time});
        }
        MIMESupport.freeCaches();
        FileUtil.freeCaches();
    }

    public final FileObject getFile() {
        return this.file;
    }

    public final long getTime() {
        return this.time;
    }

    public final boolean isExpected() {
        return this.expected;
    }

    public final void runWhenDeliveryOver(Runnable runnable) {
        Collection<Runnable> collection = this.postNotify;
        if (collection != null) {
            collection.add(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName().replaceFirst(".+\\.", ""));
        stringBuilder.append('[');
        FileObject fileObject = (FileObject)this.getSource();
        if (fileObject != this.file) {
            stringBuilder.append("src=");
            stringBuilder.append(FileUtil.getFileDisplayName(fileObject));
            stringBuilder.append(',');
        }
        stringBuilder.append("file=");
        stringBuilder.append(FileUtil.getFileDisplayName(this.file));
        stringBuilder.append(",time=");
        stringBuilder.append(new Date(this.time));
        stringBuilder.append(",expected=");
        stringBuilder.append(this.expected);
        this.insertIntoToString(stringBuilder);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    void insertIntoToString(StringBuilder stringBuilder) {
    }

    void setAtomicActionLink(EventControl.AtomicActionLink atomicActionLink) {
        this.atomActionID = atomicActionLink;
    }

    public boolean firedFrom(FileSystem.AtomicAction atomicAction) {
        if (atomicAction == null) {
            return false;
        }
        for (EventControl.AtomicActionLink atomicActionLink = this.atomActionID; atomicActionLink != null; atomicActionLink = atomicActionLink.getPreviousLink()) {
            Object object = atomicActionLink.getAtomicAction();
            if (object == null || !object.equals(atomicAction)) continue;
            return true;
        }
        return false;
    }

    final boolean isAsynchronous() {
        for (EventControl.AtomicActionLink atomicActionLink = this.atomActionID; atomicActionLink != null; atomicActionLink = atomicActionLink.getPreviousLink()) {
            Object object = atomicActionLink.getAtomicAction();
            if (object != null && object.getClass().getName().indexOf("AsyncRefreshAtomicAction") != -1) {
                return true;
            }
            if (!(object instanceof FileSystem.AsyncAtomicAction) || !((FileSystem.AsyncAtomicAction)object).isAsynchronous()) continue;
            return true;
        }
        return false;
    }

    void setPostNotify(Collection<Runnable> collection) {
        assert (this.postNotify == null || collection == null);
        this.postNotify = collection;
    }

    void inheritPostNotify(FileEvent fileEvent) {
        assert (this.postNotify == null);
        this.postNotify = fileEvent.postNotify;
    }
}

