/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Command;

public class ClassLoadedCommand
extends Command {
    private String className;
    private byte[] classFileBytes;
    private int[] thisAndParentLoaderData;
    private boolean threadInCallGraph;

    public ClassLoadedCommand(String className, int[] thisAndParentLoaderData, byte[] classFileBytes, boolean threadInCallGraph) {
        super(3);
        this.className = className;
        this.thisAndParentLoaderData = thisAndParentLoaderData;
        this.classFileBytes = classFileBytes;
        this.threadInCallGraph = threadInCallGraph;
    }

    ClassLoadedCommand() {
        super(3);
    }

    public byte[] getClassFileBytes() {
        return this.classFileBytes;
    }

    public String getClassName() {
        return this.className;
    }

    public int[] getThisAndParentLoaderData() {
        return this.thisAndParentLoaderData;
    }

    public boolean getThreadInCallGraph() {
        return this.threadInCallGraph;
    }

    public String toString() {
        return super.toString() + ", className: " + this.className + ", threadInCallGraph: " + this.threadInCallGraph + ", thisAndParentLoaderData: " + this.thisAndParentLoaderData[0] + ", " + this.thisAndParentLoaderData[1] + ", " + this.thisAndParentLoaderData[2] + ", classFileBytes: " + (this.classFileBytes == null ? "null" : "" + this.classFileBytes.length);
    }

    void readObject(ObjectInputStream in) throws IOException {
        this.className = in.readUTF();
        this.thisAndParentLoaderData = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.thisAndParentLoaderData[i] = in.readInt();
        }
        int len = in.readInt();
        if (len == 0) {
            this.classFileBytes = null;
        } else {
            this.classFileBytes = new byte[len];
            in.readFully(this.classFileBytes);
        }
        this.threadInCallGraph = in.readBoolean();
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.className);
        for (int i = 0; i < 3; ++i) {
            out.writeInt(this.thisAndParentLoaderData[i]);
        }
        if (this.classFileBytes != null) {
            out.writeInt(this.classFileBytes.length);
            out.write(this.classFileBytes);
            this.classFileBytes = null;
        } else {
            out.writeInt(0);
        }
        out.writeBoolean(this.threadInCallGraph);
    }
}

