/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.actions.StopAction;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.utilities.ProfilerUtils;

public final class ProfilingSupport {
    public static boolean checkProfilingInProgress() {
        final Profiler profiler = Profiler.getDefault();
        int state = profiler.getProfilingState();
        int mode = profiler.getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilingSupport_StopStartProfileSessionMessage(), (String)Bundle.CAPTION_Question())) {
                    return true;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    StopAction.getInstance().setEnabled(false);
                    ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            profiler.stopApp();
                        }
                    });
                } else {
                    profiler.stopApp();
                }
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilingSupport_StopStartAttachSessionMessage(), (String)Bundle.CAPTION_Question())) {
                    return true;
                }
                profiler.detachFromApp();
            }
        }
        return false;
    }
}

