/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.syntax;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.AbstractClassesTransformer;
import com.tngtech.archunit.lang.ClassesTransformer;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;

class Transformers {
    Transformers() {
    }

    static ClassesTransformer<JavaClass> classes() {
        return new AbstractClassesTransformer<JavaClass>("classes"){

            @Override
            public Iterable<JavaClass> doTransform(JavaClasses collection) {
                return collection;
            }
        };
    }

    static ClassesTransformer<JavaMember> members() {
        return new AbstractClassesTransformer<JavaMember>("members"){

            @Override
            public Iterable<JavaMember> doTransform(JavaClasses collection) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : collection) {
                    result.addAll(javaClass.getMembers());
                }
                return result.build();
            }
        };
    }

    static ClassesTransformer<JavaField> fields() {
        return new AbstractClassesTransformer<JavaField>("fields"){

            @Override
            public Iterable<JavaField> doTransform(JavaClasses collection) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : collection) {
                    result.addAll(javaClass.getFields());
                }
                return result.build();
            }
        };
    }

    static ClassesTransformer<JavaCodeUnit> codeUnits() {
        return new AbstractClassesTransformer<JavaCodeUnit>("code units"){

            @Override
            public Iterable<JavaCodeUnit> doTransform(JavaClasses collection) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : collection) {
                    result.addAll(javaClass.getCodeUnits());
                }
                return result.build();
            }
        };
    }

    static ClassesTransformer<JavaConstructor> constructors() {
        return new AbstractClassesTransformer<JavaConstructor>("constructors"){

            @Override
            public Iterable<JavaConstructor> doTransform(JavaClasses collection) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : collection) {
                    result.addAll(javaClass.getConstructors());
                }
                return result.build();
            }
        };
    }

    static ClassesTransformer<JavaMethod> methods() {
        return new AbstractClassesTransformer<JavaMethod>("methods"){

            @Override
            public Iterable<JavaMethod> doTransform(JavaClasses collection) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : collection) {
                    result.addAll(javaClass.getMethods());
                }
                return result.build();
            }
        };
    }
}

