/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.graph.GraphNodeSort;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.DeletedContentNode;
import org.freeplane.plugin.codeexplorer.map.DistinctTargetDependencyFilter;
import org.freeplane.plugin.codeexplorer.map.GroupFinder;
import org.freeplane.plugin.codeexplorer.map.PackageNode;
import org.freeplane.plugin.codeexplorer.map.SubgroupComparator;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;
import org.freeplane.plugin.codeexplorer.task.UserDefinedCodeExplorerConfiguration;

class ProjectRootNode
extends CodeNode
implements GroupFinder {
    static final String UI_ICON_NAME = "code_project";
    private static final Map.Entry<Integer, String> UNKNOWN;
    private final JavaPackage rootPackage;
    private final Map<String, Map.Entry<Integer, String>> groupsById;
    private final String[] idBySubrojectIndex;
    private final Set<String> badLocations;
    private final JavaClasses classes;
    private final long classCount;
    private final GroupMatcher groupMatcher;

    static ProjectRootNode asMapRoot(String projectName, CodeMap map, JavaClasses classes, GroupMatcher groupMatcher) {
        ProjectRootNode projectRootNode = new ProjectRootNode(projectName, map, classes, groupMatcher);
        map.setRoot(projectRootNode);
        if (projectRootNode.getChildCount() > 20) {
            projectRootNode.getChildren().forEach(node -> ((CodeNode)((Object)node)).memoizeCodeDependencies());
        }
        return projectRootNode;
    }

    private ProjectRootNode(String projectName, CodeMap map, JavaClasses classes, GroupMatcher groupMatcher) {
        super(map, 0);
        this.classes = classes;
        this.groupMatcher = groupMatcher;
        this.rootPackage = classes.getDefaultPackage();
        this.setID("projectRoot");
        this.groupsById = new LinkedHashMap<String, Map.Entry<Integer, String>>();
        classes.stream().map(groupMatcher::groupIdentifier).filter(Optional::isPresent).map(Optional::get).forEach(this::addLocation);
        this.badLocations = new HashSet<String>();
        map.setGroupFinder(this);
        this.initializeChildNodes();
        this.classCount = super.getChildrenInternal().stream().map(PackageNode.class::cast).mapToLong(PackageNode::getClassCount).sum();
        this.setText(projectName + ProjectRootNode.formatClassCount(this.classCount));
        CodeExplorerConfiguration configuration = map.getConfiguration();
        if (configuration instanceof UserDefinedCodeExplorerConfiguration) {
            ((UserDefinedCodeExplorerConfiguration)configuration).getUserContent().keySet().forEach(this::addDeletedLocation);
        }
        this.idBySubrojectIndex = new String[this.groupsById.size()];
        this.groupsById.entrySet().forEach(e -> {
            this.idBySubrojectIndex[((Integer)((Map.Entry)e.getValue()).getKey()).intValue()] = (String)e.getKey();
        });
    }

    private void addDeletedLocation(String location) {
        Map.Entry<Integer, String> locationEntry = this.addLocation(new GroupIdentifier(location, location));
        int childIndex = locationEntry.getKey();
        if (childIndex == this.getChildCount()) {
            this.insert(new DeletedContentNode(this.getMap(), "", childIndex, locationEntry.getValue()));
        }
    }

    private Map.Entry<Integer, String> addLocation(GroupIdentifier identifier) {
        return this.groupsById.computeIfAbsent(identifier.getId(), key -> new AbstractMap.SimpleEntry<Integer, String>(this.groupsById.size(), identifier.getName()));
    }

    private void initializeChildNodes() {
        List children = super.getChildrenInternal();
        List nodes = ((Stream)this.groupsById.values().stream().parallel()).map(e -> new PackageNode(this.rootPackage, this.getMap(), (String)e.getValue(), (Integer)e.getKey(), true)).collect(Collectors.toList());
        GraphNodeSort<Integer> childNodes = new GraphNodeSort<Integer>();
        Integer[] subrojectIndices = (Integer[])IntStream.range(0, this.groupsById.size()).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        nodes.stream().filter(node -> node.getClassCount() > 0L).forEach(node -> {
            childNodes.addNode(subrojectIndices[node.groupIndex]);
            DistinctTargetDependencyFilter filter = new DistinctTargetDependencyFilter();
            Map<Integer, Long> referencedGroups = node.getOutgoingDependenciesWithKnownTargets().map(filter::knownDependency).map(Dependency::getTargetClass).collect(Collectors.groupingBy(t -> subrojectIndices[this.groupIndexOf((JavaClass)t)], Collectors.counting()));
            referencedGroups.entrySet().forEach(e -> childNodes.addEdge(subrojectIndices[node.groupIndex], (Integer)e.getKey(), ((Long)e.getValue()).longValue()));
        });
        Comparator<Set> comparingByReversedClassCount = Comparator.comparing(indices -> -indices.stream().map(nodes::get).mapToLong(PackageNode::getClassCount).sum());
        List<List<Integer>> orderedPackages = childNodes.sortNodes(Comparator.comparing(i -> ((PackageNode)((Object)((Object)nodes.get((int)i)))).getText()), comparingByReversedClassCount.thenComparing(SubgroupComparator.comparingByName(i -> ((PackageNode)((Object)((Object)nodes.get((int)i)))).getText())));
        for (int subgroupIndex = 0; subgroupIndex < orderedPackages.size(); ++subgroupIndex) {
            for (Integer groupIndex : orderedPackages.get(subgroupIndex)) {
                CodeNode node2 = (CodeNode)((Object)nodes.get(groupIndex));
                children.add(node2);
                node2.setParent(this);
            }
        }
        for (NodeModel child : children) {
            ((CodeNode)child).setInitialFoldingState();
        }
    }

    @Override
    HasName getCodeElement() {
        return () -> "root";
    }

    @Override
    Stream<Dependency> getOutgoingDependencies() {
        return Stream.empty();
    }

    @Override
    Stream<Dependency> getIncomingDependencies() {
        return Stream.empty();
    }

    @Override
    String getUIIconName() {
        return UI_ICON_NAME;
    }

    @Override
    public boolean isKnown(JavaClass javaClass) {
        return this.groupMatcher.belongsToGroup(javaClass);
    }

    @Override
    public int groupIndexOf(JavaClass javaClass) {
        Optional<String> classSourceLocation = this.groupMatcher.groupIdentifier(javaClass).map(GroupIdentifier::getId);
        Optional<Map.Entry> groupEntry = classSourceLocation.map(s -> this.groupsById.getOrDefault(s, UNKNOWN));
        if (groupEntry.filter(UNKNOWN::equals).isPresent() && this.badLocations.add(classSourceLocation.get())) {
            LogUtils.info((String)("Unknown class source location " + ((Source)javaClass.getSource().get()).getUri()));
        }
        return groupEntry.orElse(UNKNOWN).getKey();
    }

    @Override
    public int groupIndexOf(String location) {
        return this.groupsById.getOrDefault(location, UNKNOWN).getKey();
    }

    @Override
    public Stream<JavaClass> allClasses() {
        return this.classes.stream();
    }

    @Override
    public Stream<JavaClass> getClasses() {
        return this.allClasses();
    }

    JavaClasses getImportedClasses() {
        return this.classes;
    }

    @Override
    public String getIdByIndex(int index) {
        if (index >= 0 && index < this.idBySubrojectIndex.length) {
            return this.idBySubrojectIndex[index];
        }
        throw new IllegalArgumentException("Bad index " + index);
    }

    static {
        IconStoreFactory.INSTANCE.createStateIcon(UI_ICON_NAME, "code/homeFolder.svg");
        UNKNOWN = new AbstractMap.SimpleEntry<Integer, String>(-1, ":unknown:");
    }
}

