/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.formula.dependencies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.HighlightedElements;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.Pair;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeSelection;
import org.freeplane.features.attribute.NodeAttribute;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.Connectors;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.script.dependencies.DependencySearchStrategy;
import org.freeplane.plugin.script.dependencies.RelatedElements;

class FormulaDependencyTracer
implements IExtension {
    private DependencySearchStrategy searchStrategy;
    private static final long serialVersionUID = 1L;
    private final Configurable configurable;
    private final LinkController linkController;
    private Collection<Object> tracedValues;
    private HighlightedElements highlighedElements;
    private Connectors connectors;

    public static void clear(Configurable configurable) {
        configurable.removeExtension(HighlightedElements.class);
        configurable.removeExtension(Connectors.class);
        configurable.removeExtension(FormulaDependencyTracer.class);
        configurable.refresh();
    }

    public FormulaDependencyTracer(Configurable configurable, LinkController linkController) {
        this.configurable = configurable;
        this.linkController = linkController;
    }

    public void findPrecedents() {
        this.findDependencies(DependencySearchStrategy.PRECEDENTS);
    }

    public void findDependents() {
        this.findDependencies(DependencySearchStrategy.DEPENDENTS);
    }

    private void findDependencies(DependencySearchStrategy strategy) {
        boolean dependenciesFoundInFirstSearchIteration;
        Collection accessedValues;
        boolean isFirstSearchIteration;
        this.highlighedElements = HighlightedElements.of((Configurable)this.configurable);
        if (this.tracedValues != null && this.searchStrategy != strategy) {
            this.tracedValues = this.highlighedElements.getElements();
        }
        this.searchStrategy = strategy;
        this.connectors = Connectors.of((Configurable)this.configurable);
        boolean bl = isFirstSearchIteration = this.tracedValues == null;
        if (isFirstSearchIteration) {
            this.highlighedElements.clear();
            ((Connectors)this.configurable.computeIfAbsent(Connectors.class, Connectors::new)).clear();
            AttributeSelection attributeSelection = AttributeController.getAttributeSelection();
            if (!attributeSelection.isEmpty()) {
                attributeSelection.nodeAttributeStream().map(NodeAttribute::attribute).forEach(arg_0 -> ((HighlightedElements)this.highlighedElements).add(arg_0));
                accessedValues = attributeSelection.nodeAttributeStream().map(this::findDependencies).flatMap(Collection::stream).collect(Collectors.toSet());
            } else {
                NodeModel node = Controller.getCurrentController().getSelection().getSelected();
                this.highlighedElements.add((Object)node);
                accessedValues = this.findDependencies(node);
            }
            dependenciesFoundInFirstSearchIteration = !accessedValues.isEmpty();
        } else {
            accessedValues = this.tracedValues.stream().map(this::findDependencies).flatMap(Collection::stream).collect(Collectors.toSet());
            dependenciesFoundInFirstSearchIteration = true;
        }
        this.saveAccessedValuesForNextIteration(accessedValues);
        this.highlightAttributes(accessedValues);
        this.showConnectors(accessedValues);
        this.configurable.refresh();
        if (!dependenciesFoundInFirstSearchIteration) {
            this.tracedValues = null;
        }
        this.highlighedElements = null;
        this.connectors = null;
    }

    private void highlightAttributes(Collection<Pair<NodeModel, RelatedElements>> accessedValues) {
        accessedValues.forEach(this::highlightAttributes);
    }

    private void saveAccessedValuesForNextIteration(Collection<Pair<NodeModel, RelatedElements>> accessedValues) {
        this.tracedValues = new HashSet<Object>();
        accessedValues.forEach(v -> this.tracedValues.addAll(((RelatedElements)v.second).getElements()));
    }

    private Collection<Pair<NodeModel, RelatedElements>> findDependencies(Object value) {
        if (value instanceof NodeAttribute) {
            return this.findDependencies((NodeAttribute)value);
        }
        if (value instanceof NodeModel) {
            return this.findDependencies((NodeModel)value);
        }
        return Collections.emptySet();
    }

    private Collection<Pair<NodeModel, RelatedElements>> findDependencies(NodeModel node) {
        RelatedElements relatedElements = this.searchStrategy.find(node);
        return this.toCollection(node, relatedElements);
    }

    private Collection<Pair<NodeModel, RelatedElements>> findDependencies(NodeAttribute nodeAttribute) {
        RelatedElements relatedElements = this.searchStrategy.find(nodeAttribute.node, nodeAttribute.attribute);
        return this.toCollection(nodeAttribute.node, relatedElements);
    }

    private Collection<Pair<NodeModel, RelatedElements>> toCollection(NodeModel node, RelatedElements relatedElements) {
        if (!relatedElements.isEmpty()) {
            return Collections.singleton(new Pair((Object)node, (Object)relatedElements));
        }
        return Collections.emptySet();
    }

    private void showConnectors(Collection<Pair<NodeModel, RelatedElements>> accessedValues) {
        Stream<Pair> connectedNodes = accessedValues.stream().flatMap(pair -> ((RelatedElements)pair.second).getRelatedNodes().stream().distinct().map(node -> new Pair((Object)((NodeModel)pair.first), node))).distinct().map(arg_0 -> ((DependencySearchStrategy)this.searchStrategy).inConnectionOrder(arg_0));
        connectedNodes.forEach(this::showConnectors);
    }

    private void showConnectors(Pair<NodeModel, NodeModel> v) {
        this.connectors.add(this.createConnector((NodeModel)v.first, ((NodeModel)v.second).createID()));
    }

    private ConnectorModel createConnector(NodeModel source, String id) {
        return new ConnectorModel(source, id, ConnectorArrows.FORWARD, null, FilterController.HIGHLIGHT_COLOR, this.linkController.getStandardConnectorOpacity(), this.linkController.getStandardConnectorShape(), this.linkController.getStandardConnectorWidth(), this.linkController.getStandardLabelFontFamily(), this.linkController.getStandardLabelFontSize());
    }

    private void highlightAttributes(Pair<NodeModel, RelatedElements> v) {
        ((RelatedElements)v.second).getElements().stream().map(a -> a instanceof NodeAttribute ? ((NodeAttribute)a).attribute : a).forEach(arg_0 -> ((HighlightedElements)this.highlighedElements).add(arg_0));
    }
}

