/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.resources.components.FormatterFactoryWithPredefinedNames;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;

public class QuantityProperty<U extends Enum<U>>
extends PropertyBean
implements IPropertyControl {
    private final JSpinner numberSpinner;
    private final JComboBox unitBox;
    private final U defaultUnit;
    private U currentUnit;

    public QuantityProperty(String name, double min, double max, double step, U defaultUnit) {
        super(name);
        this.defaultUnit = defaultUnit;
        this.numberSpinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
        ((JSpinner.NumberEditor)this.numberSpinner.getEditor()).getTextField().setColumns(3);
        TranslatedObject[] units = TranslatedObject.fromEnum(((Enum)defaultUnit).getDeclaringClass());
        JComboBox<TranslatedObject> c = new JComboBox<TranslatedObject>(units){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        c.setMaximumRowCount(10);
        this.unitBox = c;
        this.addChangeListeners();
    }

    public void configureMinimumName(String name) {
        FormatterFactoryWithPredefinedNames.installFactory(this.numberSpinner, Collections.singletonMap(name, ((SpinnerNumberModel)this.numberSpinner.getModel()).getMinimum()));
    }

    private void addChangeListeners() {
        this.numberSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent pE) {
                QuantityProperty.this.firePropertyChangeEvent();
            }
        });
        this.unitBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object newUnit = QuantityProperty.this.getCurrentUnit();
                    double value = (Double)QuantityProperty.this.numberSpinner.getValue();
                    Quantity newQuantity = new Quantity(value, QuantityProperty.this.currentUnit).in(newUnit);
                    QuantityProperty.this.currentUnit = newUnit;
                    if (value != newQuantity.value) {
                        QuantityProperty.this.numberSpinner.setValue(newQuantity.value);
                    } else {
                        QuantityProperty.this.firePropertyChangeEvent();
                    }
                }
            }
        });
    }

    @Override
    public String getValue() {
        return this.getQuantifiedValue().toString();
    }

    @Override
    public JComponent getValueComponent() {
        return this.numberSpinner;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        Box box = new Box(0){

            @Override
            public void setEnabled(boolean enabled) {
                QuantityProperty.this.setEnabled(enabled);
            }
        };
        box.add(this.numberSpinner);
        box.add(this.unitBox);
        this.appendToForm(builder, box);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.numberSpinner.setEnabled(pEnabled);
        this.unitBox.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    public void setQuantifiedValue(Quantity<U> quantity) {
        this.currentUnit = quantity.unit;
        this.numberSpinner.setValue(quantity.value);
        this.unitBox.setSelectedIndex(quantity.unit.ordinal());
    }

    public Quantity<U> getQuantifiedValue() {
        double value = (Double)this.numberSpinner.getValue();
        U unit = this.getCurrentUnit();
        return new Quantity(value, unit);
    }

    public U getCurrentUnit() {
        return (U)((Enum[])((Enum)this.defaultUnit).getDeclaringClass().getEnumConstants())[this.unitBox.getSelectedIndex()];
    }

    @Override
    public void setValue(String value) {
        Quantity quantity = Quantity.fromString((String)value, this.defaultUnit);
        this.setQuantifiedValue(quantity);
    }
}

