/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.DetachedNodeList;
import org.freeplane.features.map.MultipleNodeList;
import org.freeplane.features.map.NodeModel;

public class SingleNodeList
implements Clones {
    private final NodeModel nodeModel;
    private final NodeModel.CloneType cloneType;

    SingleNodeList(NodeModel nodeModel, NodeModel.CloneType cloneType) {
        this.nodeModel = nodeModel;
        this.cloneType = cloneType;
    }

    @Override
    public Clones add(NodeModel nodeModel) {
        MultipleNodeList multipleNodeList = new MultipleNodeList(this.cloneType);
        multipleNodeList.add(this.nodeModel);
        multipleNodeList.add(nodeModel);
        return multipleNodeList;
    }

    public Clones remove(NodeModel nodeModel) {
        return null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Iterator<NodeModel> iterator() {
        return Arrays.asList(this.nodeModel).iterator();
    }

    @Override
    public void attach() {
        throw new IllegalStateException();
    }

    @Override
    public void detach(NodeModel nodeModel) {
        nodeModel.setClones(new DetachedNodeList(nodeModel, this.cloneType));
    }

    @Override
    public Collection<NodeModel> toCollection() {
        return Arrays.asList(this.nodeModel);
    }

    @Override
    public boolean contains(NodeModel node) {
        return this.nodeModel.equals(node);
    }

    @Override
    public NodeModel head() {
        return this.nodeModel;
    }

    @Override
    public NodeModel.CloneType getCloneType() {
        return this.cloneType;
    }
}

