/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg.drew;

import tim.prune.jpeg.drew.ExifException;

public class ByteArrayReader {
    private final byte[] _buffer;
    private boolean _isMotorolaByteOrder = true;

    public ByteArrayReader(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this._buffer = byArray;
    }

    public void setMotorolaByteOrder(boolean bl) {
        this._isMotorolaByteOrder = bl;
    }

    public long getLength() {
        return this._buffer.length;
    }

    protected byte getByte(int n) {
        return this._buffer[n];
    }

    protected void validateIndex(int n, int n2) throws ExifException {
        if (!this.isValidIndex(n, n2)) {
            throw new ExifException("Invalid index " + n);
        }
    }

    private boolean isValidIndex(int n, int n2) {
        return n2 >= 0 && n >= 0 && (long)n + (long)n2 <= (long)this._buffer.length;
    }

    public byte[] getBytes(int n, int n2) throws ExifException {
        this.validateIndex(n, n2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this._buffer, n, byArray, 0, n2);
        return byArray;
    }

    public short getUInt8(int n) throws ExifException {
        this.validateIndex(n, 1);
        return (short)(this.getByte(n) & 0xFF);
    }

    public byte getInt8(int n) throws ExifException {
        this.validateIndex(n, 1);
        return this.getByte(n);
    }

    public int getUInt16(int n) throws ExifException {
        this.validateIndex(n, 2);
        if (this._isMotorolaByteOrder) {
            return this.getByte(n) << 8 & 0xFF00 | this.getByte(n + 1) & 0xFF;
        }
        return this.getByte(n + 1) << 8 & 0xFF00 | this.getByte(n) & 0xFF;
    }

    public short getInt16(int n) throws ExifException {
        this.validateIndex(n, 2);
        if (this._isMotorolaByteOrder) {
            return (short)((short)this.getByte(n) << 8 & 0xFFFFFF00 | (short)this.getByte(n + 1) & 0xFF);
        }
        return (short)((short)this.getByte(n + 1) << 8 & 0xFFFFFF00 | (short)this.getByte(n) & 0xFF);
    }

    public long getUInt32(int n) throws ExifException {
        this.validateIndex(n, 4);
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte(n) << 24 & 0xFF000000L | (long)this.getByte(n + 1) << 16 & 0xFF0000L | (long)this.getByte(n + 2) << 8 & 0xFF00L | (long)this.getByte(n + 3) & 0xFFL;
        }
        return (long)this.getByte(n + 3) << 24 & 0xFF000000L | (long)this.getByte(n + 2) << 16 & 0xFF0000L | (long)this.getByte(n + 1) << 8 & 0xFF00L | (long)this.getByte(n) & 0xFFL;
    }

    public int getInt32(int n) throws ExifException {
        this.validateIndex(n, 4);
        if (this._isMotorolaByteOrder) {
            return this.getByte(n) << 24 & 0xFF000000 | this.getByte(n + 1) << 16 & 0xFF0000 | this.getByte(n + 2) << 8 & 0xFF00 | this.getByte(n + 3) & 0xFF;
        }
        return this.getByte(n + 3) << 24 & 0xFF000000 | this.getByte(n + 2) << 16 & 0xFF0000 | this.getByte(n + 1) << 8 & 0xFF00 | this.getByte(n) & 0xFF;
    }

    public String getNullTerminatedString(int n, int n2) throws ExifException {
        byte[] byArray = this.getBytes(n, n2);
        int n3 = 0;
        while (n3 < byArray.length && byArray[n3] != 0) {
            ++n3;
        }
        return new String(byArray, 0, n3);
    }

    public String getString(int n, int n2) throws ExifException {
        return new String(this.getBytes(n, n2));
    }
}

