/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.BaseNameClassPairEnumeration;
import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.NameNode;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

final class NameClassPairEnumeration
extends BaseNameClassPairEnumeration<NameClassPair>
implements NamingEnumeration<NameClassPair> {
    NameClassPairEnumeration(DnsContext ctx, Hashtable<String, NameNode> nodes) {
        super(ctx, nodes);
    }

    @Override
    public NameClassPair next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        NameNode nnode = (NameNode)this.nodes.nextElement();
        String className = nnode.isZoneCut() || nnode.getChildren() != null ? "javax.naming.directory.DirContext" : "java.lang.Object";
        String label = nnode.getLabel();
        Name compName = new DnsName().add(label);
        Name cname = new CompositeName().add(compName.toString());
        NameClassPair ncp = new NameClassPair(cname.toString(), className);
        ncp.setNameInNamespace(this.ctx.fullyQualify(cname).toString());
        return ncp;
    }
}

