/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.registry;

import com.install4j.api.context.Context;
import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.registry.RegistryInterface;
import java.util.prefs.Preferences;

public class PreferencesRegistry
implements RegistryInterface {
    private static final String PATH_NAME = "/com/install4j/installations";

    @Override
    public void setValue(String name, String value) {
        PreferencesRegistry.setValueInt(name, value);
    }

    private static void setValueInt(final String name, final String value) {
        if (!PreferencesUtil.isDisableSystemRoot()) {
            Preferences node = Preferences.systemRoot().node(PATH_NAME);
            try {
                node.put(name, value);
                node.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                Preferences node = Preferences.userRoot().node(PreferencesRegistry.PATH_NAME);
                try {
                    node.put(name, value);
                    node.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public String getValue(String name) {
        Preferences node = Preferences.userRoot().node(PATH_NAME);
        String ret = node.get(name, null);
        if (ret != null) {
            return ret;
        }
        if (!PreferencesUtil.isDisableSystemRoot()) {
            node = Preferences.systemRoot().node(PATH_NAME);
            return node.get(name, null);
        }
        return null;
    }

    @Override
    public String getOtherBitnessValue(String valueName) {
        return null;
    }

    @Override
    public void deleteValue(String name) {
        PreferencesRegistry.deleteValueInt(name);
    }

    private static void deleteValueInt(final String name) {
        if (!PreferencesUtil.isDisableSystemRoot()) {
            Preferences node = Preferences.systemRoot().node(PATH_NAME);
            node.remove(name);
            try {
                node.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                Preferences node = Preferences.userRoot().node(PreferencesRegistry.PATH_NAME);
                node.remove(name);
                try {
                    node.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }
}

