/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.percolator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.Version;
import org.opensearch.action.get.GetRequest;
import org.opensearch.common.SetOnce;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.analysis.FieldNameAnalyzer;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.percolator.PercolateQuery;
import org.opensearch.percolator.PercolatorFieldMapperExt;
import org.opensearch.search.SearchService;

public class PercolateQueryBuilderExt
extends AbstractQueryBuilder<PercolateQueryBuilderExt> {
    public static final String NAME = "percolate_ext";
    static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
    static final ParseField DOCUMENTS_FIELD = new ParseField("documents", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("field", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_INDEX = new ParseField("index", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ID = new ParseField("id", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_PREFERENCE = new ParseField("preference", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_VERSION = new ParseField("version", new String[0]);
    private final String field;
    private String name;
    private final List<BytesReference> documents;
    private final MediaType documentXContentType;
    private final String indexedDocumentIndex;
    private final String indexedDocumentId;
    private final String indexedDocumentRouting;
    private final String indexedDocumentPreference;
    private final Long indexedDocumentVersion;
    private final Supplier<BytesReference> documentSupplier;
    private static final ConstructingObjectParser<PercolateQueryBuilderExt, Void> PARSER = new ConstructingObjectParser("percolate_ext", args -> {
        String field = (String)args[0];
        BytesReference document = (BytesReference)args[1];
        List documents = (List)args[2];
        String indexedDocId = (String)args[3];
        String indexedDocIndex = (String)args[4];
        String indexDocRouting = (String)args[5];
        String indexDocPreference = (String)args[6];
        Long indexedDocVersion = (Long)args[7];
        if (indexedDocId != null) {
            return new PercolateQueryBuilderExt(field, indexedDocIndex, indexedDocId, indexDocRouting, indexDocPreference, indexedDocVersion);
        }
        if (document != null) {
            return new PercolateQueryBuilderExt(field, Collections.singletonList(document), (MediaType)XContentType.JSON);
        }
        return new PercolateQueryBuilderExt(field, documents, (MediaType)XContentType.JSON);
    });

    public PercolateQueryBuilderExt(String field, BytesReference document, XContentType documentXContentType) {
        this(field, Collections.singletonList(document), (MediaType)documentXContentType);
    }

    public PercolateQueryBuilderExt(String field, List<BytesReference> documents, MediaType documentXContentType) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (documents == null) {
            throw new IllegalArgumentException("[document] is a required argument");
        }
        this.field = field;
        this.documents = documents;
        this.documentXContentType = Objects.requireNonNull(documentXContentType);
        this.indexedDocumentIndex = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
        this.documentSupplier = null;
    }

    public PercolateQueryBuilderExt(String field, String indexedDocumentIndex, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (indexedDocumentIndex == null) {
            throw new IllegalArgumentException("[index] is a required argument");
        }
        if (indexedDocumentId == null) {
            throw new IllegalArgumentException("[id] is a required argument");
        }
        this.field = field;
        this.indexedDocumentIndex = indexedDocumentIndex;
        this.indexedDocumentId = indexedDocumentId;
        this.indexedDocumentRouting = indexedDocumentRouting;
        this.indexedDocumentPreference = indexedDocumentPreference;
        this.indexedDocumentVersion = indexedDocumentVersion;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = null;
    }

    protected PercolateQueryBuilderExt(String field, Supplier<BytesReference> documentSupplier) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        this.field = field;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = documentSupplier;
        this.indexedDocumentIndex = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
    }

    PercolateQueryBuilderExt(StreamInput in) throws IOException {
        super(in);
        String indexedDocumentType;
        String documentType;
        this.field = in.readString();
        this.name = in.readOptionalString();
        if (in.getVersion().before(Version.V_2_0_0) && (documentType = in.readOptionalString()) != null) {
            throw new IllegalStateException("documentType must be null");
        }
        this.indexedDocumentIndex = in.readOptionalString();
        if (in.getVersion().before(Version.V_2_0_0) && (indexedDocumentType = in.readOptionalString()) != null) {
            throw new IllegalStateException("indexedDocumentType must be null");
        }
        this.indexedDocumentId = in.readOptionalString();
        this.indexedDocumentRouting = in.readOptionalString();
        this.indexedDocumentPreference = in.readOptionalString();
        this.indexedDocumentVersion = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        this.documents = in.readList(StreamInput::readBytesReference);
        this.documentXContentType = !this.documents.isEmpty() ? (in.getVersion().onOrAfter(Version.V_2_0_0) ? in.readMediaType() : (MediaType)in.readEnum(XContentType.class)) : null;
        this.documentSupplier = null;
    }

    public PercolateQueryBuilderExt setName(String name) {
        this.name = name;
        return this;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.documentSupplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.field);
        out.writeOptionalString(this.name);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeOptionalString(this.indexedDocumentIndex);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeOptionalString(this.indexedDocumentId);
        out.writeOptionalString(this.indexedDocumentRouting);
        out.writeOptionalString(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            out.writeBoolean(true);
            out.writeVLong(this.indexedDocumentVersion.longValue());
        } else {
            out.writeBoolean(false);
        }
        out.writeVInt(this.documents.size());
        for (BytesReference document : this.documents) {
            out.writeBytesReference(document);
        }
        if (!this.documents.isEmpty()) {
            if (out.getVersion().onOrAfter(Version.V_2_0_0)) {
                this.documentXContentType.writeTo(out);
            } else {
                out.writeEnum((Enum)((XContentType)this.documentXContentType));
            }
        }
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.field);
        if (this.name != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.name);
        }
        if (!this.documents.isEmpty()) {
            builder.startArray(DOCUMENTS_FIELD.getPreferredName());
            for (BytesReference document : this.documents) {
                XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)document);
                try {
                    parser.nextToken();
                    builder.generator().copyCurrentStructure(parser);
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            builder.endArray();
        }
        if (this.indexedDocumentIndex != null || this.indexedDocumentId != null) {
            if (this.indexedDocumentIndex != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_INDEX.getPreferredName(), this.indexedDocumentIndex);
            }
            if (this.indexedDocumentId != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ID.getPreferredName(), this.indexedDocumentId);
            }
            if (this.indexedDocumentRouting != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ROUTING.getPreferredName(), this.indexedDocumentRouting);
            }
            if (this.indexedDocumentPreference != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_PREFERENCE.getPreferredName(), this.indexedDocumentPreference);
            }
            if (this.indexedDocumentVersion != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_VERSION.getPreferredName(), this.indexedDocumentVersion);
            }
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    private static BytesReference parseDocument(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.copyCurrentStructure(parser);
            builder.flush();
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    public static PercolateQueryBuilderExt fromXContent(XContentParser parser) throws IOException {
        return (PercolateQueryBuilderExt)((Object)PARSER.parse(parser, null));
    }

    protected boolean doEquals(PercolateQueryBuilderExt other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.documents, other.documents) && Objects.equals(this.indexedDocumentIndex, other.indexedDocumentIndex) && Objects.equals(this.documentSupplier, other.documentSupplier) && Objects.equals(this.indexedDocumentId, other.indexedDocumentId);
    }

    protected int doHashCode() {
        return Objects.hash(this.field, this.documents, this.indexedDocumentIndex, this.indexedDocumentId, this.documentSupplier);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) {
        if (!this.documents.isEmpty()) {
            return this;
        }
        if (this.documentSupplier != null) {
            BytesReference source = this.documentSupplier.get();
            if (source == null) {
                return this;
            }
            PercolateQueryBuilderExt rewritten = new PercolateQueryBuilderExt(this.field, Collections.singletonList(source), MediaTypeRegistry.xContentType((BytesReference)source));
            if (this.name != null) {
                rewritten.setName(this.name);
            }
            return rewritten;
        }
        GetRequest getRequest = new GetRequest(this.indexedDocumentIndex, this.indexedDocumentId);
        getRequest.preference("_local");
        getRequest.routing(this.indexedDocumentRouting);
        getRequest.preference(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            getRequest.version(this.indexedDocumentVersion.longValue());
        }
        SetOnce documentSupplier = new SetOnce();
        queryShardContext.registerAsyncAction((client, listener2) -> client.get(getRequest, ActionListener.wrap(getResponse2 -> {
            if (!getResponse2.isExists()) {
                throw new ResourceNotFoundException("indexed document [{}/{}] couldn't be found", new Object[]{this.indexedDocumentIndex, this.indexedDocumentId});
            }
            if (getResponse2.isSourceEmpty()) {
                throw new IllegalArgumentException("indexed document [" + this.indexedDocumentIndex + "/" + this.indexedDocumentId + "] source disabled");
            }
            documentSupplier.set((Object)getResponse2.getSourceAsBytesRef());
            listener2.onResponse(null);
        }, arg_0 -> ((ActionListener)listener2).onFailure(arg_0))));
        PercolateQueryBuilderExt rewritten = new PercolateQueryBuilderExt(this.field, () -> ((SetOnce)documentSupplier).get());
        if (this.name != null) {
            rewritten.setName(this.name);
        }
        return rewritten;
    }

    protected Query doToQuery(final QueryShardContext context) throws IOException {
        boolean excludeNestedDocuments;
        IndexSearcher docSearcher;
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[percolate] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        context.nowInMillis();
        if (this.documents.isEmpty()) {
            throw new IllegalStateException("no document to percolate");
        }
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            throw new QueryShardException(context, "field [" + this.field + "] does not exist", new Object[0]);
        }
        if (!(fieldType instanceof PercolatorFieldMapperExt.PercolatorFieldType)) {
            throw new QueryShardException(context, "expected field [" + this.field + "] to be of type [percolator], but is of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        ArrayList<ParsedDocument> docs = new ArrayList<ParsedDocument>();
        MapperService mapperService = context.getMapperService();
        String type = mapperService.documentMapper().type();
        DocumentMapper docMapper = mapperService.documentMapper();
        for (BytesReference document : this.documents) {
            docs.add(docMapper.parse(new SourceToParse(context.index().getName(), "_temp_id", document, this.documentXContentType)));
        }
        final FieldNameAnalyzer fieldNameAnalyzer = (FieldNameAnalyzer)docMapper.mappers().indexAnalyzer();
        DelegatingAnalyzerWrapper analyzer = new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                Analyzer analyzer = (Analyzer)fieldNameAnalyzer.analyzers().get(fieldName);
                if (analyzer != null) {
                    return analyzer;
                }
                return context.getIndexAnalyzers().getDefaultIndexAnalyzer();
            }
        };
        if (docs.size() > 1 || ((ParsedDocument)docs.get(0)).docs().size() > 1) {
            assert (docs.size() != 1 || docMapper.hasNestedObjects());
            docSearcher = PercolateQueryBuilderExt.createMultiDocumentSearcher((Analyzer)analyzer, docs);
            excludeNestedDocuments = docMapper.hasNestedObjects() && docs.stream().map(ParsedDocument::docs).mapToInt(List::size).anyMatch(size -> size > 1);
        } else {
            MemoryIndex memoryIndex = MemoryIndex.fromDocument((Iterable)((ParsedDocument)docs.get(0)).rootDoc(), (Analyzer)analyzer, (boolean)true, (boolean)false);
            docSearcher = memoryIndex.createSearcher();
            docSearcher.setQueryCache(null);
            excludeNestedDocuments = false;
        }
        PercolatorFieldMapperExt.PercolatorFieldType pft = (PercolatorFieldMapperExt.PercolatorFieldType)fieldType;
        String name = pft.name();
        QueryShardContext percolateShardContext = PercolateQueryBuilderExt.wrap(context);
        PercolatorFieldMapperExt.configureContext(percolateShardContext, pft.mapUnmappedFieldsAsText);
        PercolateQuery.QueryStore queryStore = PercolateQueryBuilderExt.createStore(pft.queryBuilderField, percolateShardContext);
        return pft.percolateQuery(name, queryStore, this.documents, docSearcher, excludeNestedDocuments, context.indexVersionCreated());
    }

    public String getField() {
        return this.field;
    }

    public List<BytesReference> getDocuments() {
        return this.documents;
    }

    MediaType getXContentType() {
        return this.documentXContentType;
    }

    public String getQueryName() {
        return this.name;
    }

    static IndexSearcher createMultiDocumentSearcher(Analyzer analyzer, Collection<ParsedDocument> docs) {
        IndexSearcher indexSearcher;
        ByteBuffersDirectory directory = new ByteBuffersDirectory();
        IndexWriter indexWriter = new IndexWriter((Directory)directory, new IndexWriterConfig(analyzer));
        try {
            Iterable iterable = () -> docs.stream().map(ParsedDocument::docs).flatMap(Collection::stream).iterator();
            indexWriter.addDocuments(iterable);
            DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)indexWriter);
            assert (directoryReader.leaves().size() == 1) : "Expected single leaf, but got [" + directoryReader.leaves().size() + "]";
            IndexSearcher slowSearcher = new IndexSearcher((IndexReader)directoryReader);
            slowSearcher.setQueryCache(null);
            indexSearcher = slowSearcher;
        }
        catch (Throwable throwable) {
            try {
                try {
                    indexWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OpenSearchException("Failed to create index for percolator with nested document ", (Throwable)e, new Object[0]);
            }
        }
        indexWriter.close();
        return indexSearcher;
    }

    static PercolateQuery.QueryStore createStore(MappedFieldType queryBuilderFieldType, QueryShardContext context) {
        Version indexVersion = context.indexVersionCreated();
        NamedWriteableRegistry registry = context.getWriteableRegistry();
        return ctx -> {
            LeafReader leafReader = ctx.reader();
            BinaryDocValues binaryDocValues = leafReader.getBinaryDocValues(queryBuilderFieldType.name());
            if (binaryDocValues == null) {
                return docId -> null;
            }
            return docId -> {
                if (binaryDocValues.advanceExact(docId.intValue())) {
                    BytesRef qbSource = binaryDocValues.binaryValue();
                    try (ByteArrayInputStream in = new ByteArrayInputStream(qbSource.bytes, qbSource.offset, qbSource.length);){
                        Query query;
                        try (NamedWriteableAwareStreamInput input = new NamedWriteableAwareStreamInput((StreamInput)new InputStreamStreamInput((InputStream)in, (long)qbSource.length), registry);){
                            input.setVersion(indexVersion);
                            int numValues = input.readVInt();
                            assert (numValues == 1);
                            int valueLength = input.readVInt();
                            assert (valueLength > 0);
                            QueryBuilder queryBuilder = (QueryBuilder)input.readNamedWriteable(QueryBuilder.class);
                            assert (((InputStream)in).read() == -1);
                            queryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)context);
                            query = queryBuilder.toQuery(context);
                        }
                        return query;
                    }
                }
                return null;
            };
        };
    }

    static QueryShardContext wrap(final QueryShardContext shardContext) {
        return new QueryShardContext(shardContext){

            public IndexReader getIndexReader() {
                return null;
            }

            public BitSetProducer bitsetFilter(Query query) {
                return context -> {
                    IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                    IndexSearcher searcher = new IndexSearcher(topLevelContext);
                    searcher.setQueryCache(null);
                    Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                    Scorer s = weight.scorer(context);
                    if (s != null) {
                        return new BitDocIdSet(BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc())).bits();
                    }
                    return null;
                };
            }

            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
                IndexFieldData.Builder builder = fieldType.fielddataBuilder(shardContext.getFullyQualifiedIndex().getName(), () -> ((QueryShardContext)shardContext).lookup());
                IndexFieldDataCache.None cache = new IndexFieldDataCache.None();
                NoneCircuitBreakerService circuitBreaker = new NoneCircuitBreakerService();
                return (IFD)builder.build((IndexFieldDataCache)cache, (CircuitBreakerService)circuitBreaker);
            }
        };
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), QUERY_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PercolateQueryBuilderExt.parseDocument(p), DOCUMENT_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PercolateQueryBuilderExt.parseDocument(p), DOCUMENTS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_INDEX);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_ROUTING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_PREFERENCE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_VERSION);
        PARSER.declareString(PercolateQueryBuilderExt::setName, NAME_FIELD);
        PARSER.declareString(AbstractQueryBuilder::queryName, AbstractQueryBuilder.NAME_FIELD);
        PARSER.declareFloat(AbstractQueryBuilder::boost, BOOST_FIELD);
        PARSER.declareRequiredFieldSet(new String[]{DOCUMENT_FIELD.getPreferredName(), DOCUMENTS_FIELD.getPreferredName(), INDEXED_DOCUMENT_FIELD_ID.getPreferredName()});
        PARSER.declareExclusiveFieldSet(new String[]{DOCUMENT_FIELD.getPreferredName(), DOCUMENTS_FIELD.getPreferredName(), INDEXED_DOCUMENT_FIELD_ID.getPreferredName()});
    }
}

