"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateTenantIndices = migrateTenantIndices;
exports.setupIndexTemplate = setupIndexTemplate;
var _core = require("../../../../src/core/server/saved_objects/migrations/core");
var _build_index_map = require("../../../../src/core/server/saved_objects/migrations/core/build_index_map");
var _opensearch_dashboards_migrator = require("../../../../src/core/server/saved_objects/migrations/opensearch_dashboards/opensearch_dashboards_migrator");
var _common = require("../../common");
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

async function setupIndexTemplate(esClient, opensearchDashboardsIndex, typeRegistry, logger) {
  const mappings = (0, _core.buildActiveMappings)((0, _opensearch_dashboards_migrator.mergeTypes)(typeRegistry.getAllTypes()));
  try {
    await esClient.indices.putIndexTemplate({
      name: 'tenant_template',
      body: {
        // Setting priority to the max value to avoid being overridden by custom index templates.
        priority: _common.MAX_INTEGER,
        index_patterns: [opensearchDashboardsIndex + '_-*_*', opensearchDashboardsIndex + '_0*_*', opensearchDashboardsIndex + '_1*_*', opensearchDashboardsIndex + '_2*_*', opensearchDashboardsIndex + '_3*_*', opensearchDashboardsIndex + '_4*_*', opensearchDashboardsIndex + '_5*_*', opensearchDashboardsIndex + '_6*_*', opensearchDashboardsIndex + '_7*_*', opensearchDashboardsIndex + '_8*_*', opensearchDashboardsIndex + '_9*_*'],
        template: {
          settings: {
            number_of_shards: 1
          },
          mappings
        }
      }
    });
  } catch (error) {
    logger.error(error);
    throw error;
  }
}
async function migrateTenantIndices(opensearchDashboardsVersion, migrationClient, securityClient, typeRegistry, serializer, logger) {
  let tenantInfo;
  try {
    tenantInfo = await securityClient.getTenantInfoWithInternalUser();
  } catch (error) {
    logger.error(error);
    throw error;
  }

  // follows the same approach in opensearch_dashboards_migrator.ts to initiate DocumentMigrator here
  const documentMigrator = new _core.DocumentMigrator({
    opensearchDashboardsVersion,
    typeRegistry,
    log: logger
  });
  for (const indexName of Object.keys(tenantInfo)) {
    const indexMap = (0, _build_index_map.createIndexMap)({
      opensearchDashboardsIndexName: indexName,
      indexMap: (0, _opensearch_dashboards_migrator.mergeTypes)(typeRegistry.getAllTypes()),
      registry: typeRegistry
    });

    // follows the same aporach in opensearch_dashboards_mirator.ts to construct IndexMigrator
    //
    // FIXME: hard code batchSize, pollInterval, and scrollDuration for now
    //        they are used to fetched from `migration.xxx` config, which is not accessible from new playform
    const indexMigrator = new _core.IndexMigrator({
      batchSize: 100,
      client: migrationClient,
      documentMigrator,
      index: indexName,
      log: logger,
      mappingProperties: indexMap[indexName].typeMappings,
      pollInterval: 1500,
      // millisec
      scrollDuration: '15m',
      serializer,
      obsoleteIndexTemplatePattern: undefined,
      convertToAliasScript: indexMap[indexName].script
    });
    try {
      await indexMigrator.migrate();
    } catch (error) {
      logger.error(error);
      // fail early, exit the kibana process
      // NOTE: according to https://github.com/elastic/kibana/issues/41983 ,
      //       PR https://github.com/elastic/kibana/pull/75819 , API to allow plugins
      //       to set status will be available in 7.10, for now, we fail OpenSearchDashboards
      //       process to indicate index migration error. Customer can fix their
      //       tenant indices in ES then restart OpenSearchDashboards.
      process.exit(1);
    }
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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