/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfo;

public class DescribeInstanceTypesPublisher
implements SdkPublisher<DescribeInstanceTypesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstanceTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceTypesPublisher(Ec2AsyncClient client, DescribeInstanceTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceTypesPublisher(Ec2AsyncClient client, DescribeInstanceTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceTypeInfo> instanceTypes() {
        Function<DescribeInstanceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypes() != null) {
                return response.instanceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstanceTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstanceTypesResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceTypesResponse> {
        private DescribeInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceTypesResponse> nextPage(DescribeInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceTypesPublisher.this.client.describeInstanceTypes(DescribeInstanceTypesPublisher.this.firstRequest);
            }
            return DescribeInstanceTypesPublisher.this.client.describeInstanceTypes((DescribeInstanceTypesRequest)((Object)DescribeInstanceTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

