/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.net.tasks;

import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.grpc.SubscribeMessage;
import org.opensearch.performanceanalyzer.grpc.SubscribeResponse;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.net.SubscriptionManager;
import org.opensearch.performanceanalyzer.rca.net.requests.CompositeSubscribeRequest;

public class SubscriptionRxTask
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(SubscriptionRxTask.class);
    private final SubscriptionManager subscriptionManager;
    private final CompositeSubscribeRequest compositeSubscribeRequest;

    public SubscriptionRxTask(SubscriptionManager subscriptionManager, CompositeSubscribeRequest compositeSubscribeRequest) {
        this.subscriptionManager = subscriptionManager;
        this.compositeSubscribeRequest = compositeSubscribeRequest;
    }

    @Override
    public void run() {
        SubscribeMessage request = this.compositeSubscribeRequest.getSubscribeMessage();
        Map<String, String> tags = request.getTagsMap();
        InstanceDetails.Id requesterHostId = new InstanceDetails.Id(tags.getOrDefault("requester", ""));
        String locus = tags.getOrDefault("locus", "");
        SubscribeResponse.SubscriptionStatus subscriptionStatus = this.subscriptionManager.addSubscriber(request.getDestinationGraphNode(), requesterHostId, locus);
        LOG.debug("rca: [sub-rx]: {} <- {} from {} Result: {}", (Object)request.getDestinationGraphNode(), (Object)request.getRequesterGraphNode(), (Object)requesterHostId, (Object)subscriptionStatus);
        StreamObserver<SubscribeResponse> responseStream = this.compositeSubscribeRequest.getSubscribeResponseStream();
        responseStream.onNext((Object)SubscribeResponse.newBuilder().setSubscriptionStatus(subscriptionStatus).build());
        responseStream.onCompleted();
        ServiceMetrics.RCA_GRAPH_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaGraphMetrics.RCA_NODES_SUB_ACK_COUNT, request.getRequesterGraphNode() + ":" + request.getDestinationGraphNode(), (Number)1);
    }
}

