/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.CollectionFactory;

public abstract class OWLEntityCollectingOntologyChangeListener
implements OWLOntologyChangeListener {
    private final Set<OWLEntity> entities = new HashSet<OWLEntity>();

    @Override
    public void ontologiesChanged(@Nonnull List<? extends OWLOntologyChange> changes) throws OWLException {
        this.entities.clear();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            OWLAxiomChange axiomChange = (OWLAxiomChange)oWLOntologyChange;
            this.entities.addAll(axiomChange.getSignature());
        }
        this.ontologiesChanged();
    }

    public abstract void ontologiesChanged() throws OWLException;

    public Set<OWLEntity> getEntities() {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(this.entities);
    }
}

