/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.ListenerThread;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public class ListenerThreadImpl
implements ListenerThread,
Work {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private ORB orb;
    private Acceptor acceptor;
    private boolean keepRunning;
    private long enqueueTime;

    public ListenerThreadImpl(ORB orb, Acceptor acceptor) {
        this.orb = orb;
        this.acceptor = acceptor;
        this.keepRunning = true;
    }

    @Override
    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    @Transport
    public synchronized void close() {
        this.keepRunning = false;
        this.acceptor.close();
    }

    private synchronized boolean isRunning() {
        return this.keepRunning;
    }

    @InfoMethod
    private void display(String msg) {
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    @Transport
    public void doWork() {
        while (this.isRunning()) {
            this.display("acceptor", this.acceptor);
            try {
                this.display("Before Accept cycle");
                this.acceptor.processSocket(this.acceptor.getAcceptedSocket());
                this.display("After Accept cycle");
            }
            catch (Throwable t) {
                wrapper.exceptionInListenerThread(t);
                this.display("Exception in accept", t);
                this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getAcceptor().getEventHandler());
                try {
                    if (!this.isRunning()) continue;
                    this.getAcceptor().close();
                }
                catch (Exception exc) {
                    wrapper.ioExceptionOnClose(exc);
                }
            }
        }
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return "ListenerThread";
    }
}

