/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.git;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.git.GitRepositoryManager;
import org.protege.editor.owl.model.git.GitStatusView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepoStatusPresenter {
    private static final Logger logger = LoggerFactory.getLogger(GitRepoStatusPresenter.class);
    @Nonnull
    private final OWLModelManager modelManager;
    @Nonnull
    private final GitStatusView view;
    @Nonnull
    private final OWLModelManagerListener listener = this::handleModelManagerEvent;

    public GitRepoStatusPresenter(@Nonnull OWLModelManager modelManager, @Nonnull GitStatusView view) {
        this.modelManager = (OWLModelManager)Preconditions.checkNotNull((Object)modelManager);
        this.view = (GitStatusView)Preconditions.checkNotNull((Object)view);
    }

    @Nonnull
    public GitStatusView getView() {
        return this.view;
    }

    public void start() {
        this.modelManager.addListener(this.listener);
    }

    public void dispose() {
        this.modelManager.removeListener(this.listener);
    }

    private void handleModelManagerEvent(OWLModelManagerChangeEvent event) {
        switch (event.getType()) {
            case ACTIVE_ONTOLOGY_CHANGED: 
            case ONTOLOGY_LOADED: 
            case ONTOLOGY_RELOADED: 
            case ONTOLOGY_SAVED: {
                this.updateStatusView();
            }
        }
    }

    public void update() {
        this.updateStatusView();
    }

    private void updateStatusView() {
        try {
            GitRepositoryManager repository = GitRepositoryManager.get(this.modelManager);
            if (repository.isGitRepositoryPresent()) {
                Optional<String> branch = repository.getBranchName();
                branch.ifPresent(b -> {
                    logger.info("[GitRepo] On branch: {}", b);
                    this.view.setBranch((String)b);
                });
                this.view.setModified(repository.isAnyOntologyDocumentModified());
                repository.dispose();
            } else {
                this.view.clear();
            }
        }
        catch (Exception e) {
            logger.error("[GitRepo] An error occurred: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

