/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.ui.wizard.WizardController;
import org.protege.editor.core.ui.wizard.WizardModel;
import org.protege.editor.core.ui.wizard.WizardPanel;

public class Wizard
extends WindowAdapter
implements PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    public static final int MARGIN = 100;
    static String BACK_TEXT = "Go Back";
    static String NEXT_TEXT = "Continue";
    static String FINISH_TEXT;
    static String CANCEL_TEXT;
    private WizardModel wizardModel = new WizardModel();
    private WizardController wizardController;
    private JDialog wizardDialog;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private int returnCode;

    public Wizard() {
        this((Frame)null);
    }

    public Wizard(Dialog owner) {
        this.wizardDialog = new JDialog(owner);
        this.initComponents();
    }

    public Wizard(Frame owner) {
        this.wizardDialog = new JDialog(owner);
        this.initComponents();
    }

    public JDialog getDialog() {
        return this.wizardDialog;
    }

    public Component getOwner() {
        return this.wizardDialog.getOwner();
    }

    public void setTitle(String s) {
        this.wizardDialog.setTitle(s);
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    public void setModal(boolean b) {
        this.wizardDialog.setModal(b);
    }

    public boolean isModal() {
        return this.wizardDialog.isModal();
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.pack();
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wizardDimension = this.wizardDialog.getSize();
        if (wizardDimension.width > screenDimension.width - 100) {
            wizardDimension.width = screenDimension.width - 100;
        }
        if (wizardDimension.height > screenDimension.height - 100) {
            wizardDimension.height = screenDimension.height - 100;
        }
        this.wizardDialog.setLocation((screenDimension.width - wizardDimension.width) / 2, (screenDimension.height - wizardDimension.height) / 2);
        this.wizardDialog.setVisible(true);
        return this.returnCode;
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPanel(Object id, WizardPanel panel) {
        this.cardPanel.add((Component)panel, id);
        panel.setWizard(this);
        this.wizardModel.registerPanel(id, panel);
    }

    public void setCurrentPanel(Object id) {
        WizardPanel oldPanelDescriptor;
        if (id == null) {
            this.close(2);
        }
        if ((oldPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null) {
            oldPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(id);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.cardLayout.show(this.cardPanel, id.toString());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (evt.getPropertyName().equals("nextButtonTextProperty")) {
            this.nextButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("backButtonTextProperty")) {
            this.backButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("cancelButtonTextProperty")) {
            this.cancelButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("nextButtonEnabledProperty")) {
            this.nextButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("backButtonEnabledProperty")) {
            this.backButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("cancelButtonEnabledProperty")) {
            this.cancelButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("nextButtonIconProperty")) {
            this.nextButton.setIcon((Icon)evt.getNewValue());
        } else if (evt.getPropertyName().equals("backButtonIconProperty")) {
            this.backButton.setIcon((Icon)evt.getNewValue());
        } else if (evt.getPropertyName().equals("cancelButtonIconProperty")) {
            this.cancelButton.setIcon((Icon)evt.getNewValue());
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public boolean getBackButtonEnabled() {
        return this.wizardModel.getBackButtonEnabled();
    }

    public void setBackButtonEnabled(boolean newValue) {
        this.wizardModel.setBackButtonEnabled(newValue);
    }

    public boolean getNextFinishButtonEnabled() {
        return this.wizardModel.getNextFinishButtonEnabled();
    }

    public void setNextFinishButtonEnabled(boolean newValue) {
        this.wizardModel.setNextFinishButtonEnabled(newValue);
    }

    public boolean getCancelButtonEnabled() {
        return this.wizardModel.getCancelButtonEnabled();
    }

    public void setCancelButtonEnabled(boolean newValue) {
        this.wizardModel.setCancelButtonEnabled(newValue);
    }

    public void resetButtonStates() {
        this.wizardController.resetButtonsToPanelRules();
        this.wizardDialog.repaint();
    }

    void close(int code) {
        this.returnCode = code;
        this.wizardDialog.dispose();
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        this.wizardDialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        Box buttonBox = new Box(0);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        InputMap im = this.cardPanel.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 128), "NEXT");
        im.put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        ActionMap am = this.cardPanel.getActionMap();
        am.put("NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Wizard.this.nextButton.isEnabled()) {
                    Wizard.this.wizardController.next();
                }
            }
        });
        am.put("CANCEL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.wizardController.cancel();
            }
        });
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        buttonPanel.setLayout(new BorderLayout());
        buttonBox.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(20));
        buttonBox.add(this.cancelButton);
        buttonPanel.add((Component)buttonBox, "East");
        this.wizardDialog.getContentPane().add((Component)buttonPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.returnCode = 1;
    }

    public void dispose() {
    }

    static {
        CANCEL_TEXT = "Cancel";
        FINISH_TEXT = "Finish";
    }
}

