/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final byte[] EMPTY_BUFFER = new byte[0];

    public static void symlink(File file, File file2, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        try {
            if (file2.exists()) {
                if (!file2.isFile()) {
                    throw new IOException("impossible to copy: destination is not a file: " + file2);
                }
                if (!bl) {
                    Message.verbose(file2 + " already exists, nothing done");
                    return;
                }
            }
            if (file2.getParentFile() != null) {
                file2.getParentFile().mkdirs();
            }
            Object object = Runtime.getRuntime();
            Message.verbose("executing 'ln -s -f " + file.getAbsolutePath() + " " + file2.getPath() + "'");
            Object object2 = ((Runtime)object).exec(new String[]{"ln", "-s", "-f", file.getAbsolutePath(), file2.getPath()});
            if (((Process)object2).waitFor() != 0) {
                String string;
                object = ((Process)object2).getErrorStream();
                object = new InputStreamReader((InputStream)object);
                object = new BufferedReader((Reader)object);
                object2 = new StringBuffer();
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    ((StringBuffer)object2).append(string);
                    ((StringBuffer)object2).append('\n');
                }
                throw new IOException("error symlinking " + file + " to " + file2 + ":\n" + object2);
            }
            if (!file2.exists()) {
                throw new IOException("error symlinking: " + file2 + " doesn't exists");
            }
            if (file2.getAbsolutePath().equals(file2.getCanonicalPath())) {
                file2.delete();
                throw new IOException("error symlinking: " + file2 + " isn't a symlink");
            }
            return;
        }
        catch (IOException iOException) {
            Message.verbose("symlink failed; falling back to copy");
            StringWriter stringWriter = new StringWriter();
            iOException.printStackTrace(new PrintWriter(stringWriter));
            Message.debug(stringWriter.toString());
            FileUtil.copy(file, file2, copyProgressListener, bl);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public static boolean copy(File file, File file2, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        if (file2.exists()) {
            if (!file2.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + file2);
            }
            if (bl) {
                if (!file2.canWrite()) {
                    file2.delete();
                }
            } else {
                Message.verbose(file2 + " already exists, nothing done");
                return false;
            }
        }
        FileUtil.copy((InputStream)new FileInputStream(file), file2, copyProgressListener);
        long l = file.length();
        long l2 = file2.length();
        if (l != l2) {
            file2.delete();
            throw new IOException("size of source file " + file.toString() + "(" + l + ") differs from size of dest file " + file2.toString() + "(" + l2 + ") - please retry");
        }
        file2.setLastModified(file.lastModified());
        return true;
    }

    public static void copy(URL uRL, File file, CopyProgressListener copyProgressListener) throws IOException {
        URLHandlerRegistry.getDefault().download(uRL, file, copyProgressListener);
    }

    public static void copy(InputStream inputStream, File file, CopyProgressListener copyProgressListener) throws IOException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileUtil.copy(inputStream, new FileOutputStream(file), copyProgressListener);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener) throws IOException {
        FileUtil.copy(inputStream, outputStream, copyProgressListener, true);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        CopyProgressEvent copyProgressEvent;
        block20: {
            copyProgressEvent = null;
            if (copyProgressListener != null) {
                copyProgressEvent = new CopyProgressEvent();
            }
            try {
                int n;
                byte[] byArray = new byte[65536];
                long l = 0L;
                if (copyProgressListener != null) {
                    copyProgressListener.start(copyProgressEvent);
                }
                while ((n = inputStream.read(byArray)) != -1) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new IOException("transfer interrupted");
                    }
                    outputStream.write(byArray, 0, n);
                    l += (long)n;
                    if (copyProgressListener == null) continue;
                    copyProgressListener.progress(copyProgressEvent.update(byArray, n, l));
                }
                if (copyProgressListener != null) {
                    copyProgressEvent.update(EMPTY_BUFFER, 0, l);
                }
                try {
                    outputStream.flush();
                }
                catch (IOException iOException) {}
                if (bl) {
                    inputStream.close();
                    outputStream.close();
                }
                if (!bl) break block20;
            }
            catch (Throwable throwable) {
                if (bl) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (copyProgressListener != null) {
            copyProgressListener.end(copyProgressEvent);
        }
    }

    public static String readEntirely(BufferedReader bufferedReader) throws IOException {
        try {
            CharSequence charSequence = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                charSequence.append(string + "\n");
                string = bufferedReader.readLine();
            }
            charSequence = charSequence.toString();
            return charSequence;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static boolean forceDelete(File file) {
        File[] fileArray;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (FileUtil.forceDelete(fileArray[i])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static List getPathFiles(File file, File file2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        while (file2 != null && !file2.getAbsolutePath().equals(file.getAbsolutePath())) {
            arrayList.add(file2);
            file2 = file2.getParentFile();
        }
        if (file != null) {
            arrayList.add(file);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static Collection listAll(File file, Collection collection) {
        return FileUtil.listAll(file, new ArrayList(), collection);
    }

    private static Collection listAll(File fileArray, Collection collection, Collection collection2) {
        if (collection2.contains(fileArray.getName())) {
            return collection;
        }
        if (fileArray.exists()) {
            collection.add(fileArray);
        }
        if (fileArray.isDirectory()) {
            fileArray = fileArray.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.listAll(fileArray[i], collection, collection2);
            }
        }
        return collection;
    }

    public static File resolveFile(File file, String string) {
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            file2 = new File(file, string);
        }
        return FileUtil.normalize(file2.getPath());
    }

    public static File normalize(String string) {
        CharSequence charSequence;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        Object object = FileUtil.dissect(string);
        stack.push(object[0]);
        object = new StringTokenizer(object[1], File.separator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            charSequence = ((StringTokenizer)object).nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (stack.size() < 2) {
                    return new File(string);
                }
                stack.pop();
                continue;
            }
            stack.push(charSequence);
        }
        charSequence = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            if (i > 1) {
                ((StringBuffer)charSequence).append(File.separatorChar);
            }
            ((StringBuffer)charSequence).append(stack.elementAt(i));
        }
        return new File(((StringBuffer)charSequence).toString());
    }

    private static String[] dissect(String object) {
        Object object2;
        char c = File.separatorChar;
        int n = ((String)(object = ((String)object).replace('/', c).replace('\\', c))).indexOf(58);
        if (n > 0) {
            int n2 = n + 1;
            object2 = ((String)object).substring(0, n2);
            object = ((String)object).toCharArray();
            object2 = (String)object2 + c;
            n2 = object[n2] == c ? n2 + 1 : n2;
            StringBuffer stringBuffer = new StringBuffer();
            while (n2 < ((Object)object).length) {
                if (object[n2] != c || object[n2 - 1] != c) {
                    stringBuffer.append((char)object[n2]);
                }
                ++n2;
            }
            object = stringBuffer.toString();
        } else if (((String)object).length() > 1 && ((String)object).charAt(1) == c) {
            int n3 = ((String)object).indexOf(c, 2);
            object2 = (n3 = ((String)object).indexOf(c, n3 + 1)) > 2 ? ((String)object).substring(0, n3 + 1) : object;
            object = ((String)object).substring(((String)object2).length());
        } else {
            object2 = File.separator;
            object = ((String)object).substring(1);
        }
        return new String[]{object2, object};
    }
}

