/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.vectorvalues.KNNBinaryVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNByteVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;

public final class KNNVectorValuesFactory {
    public static <T> KNNVectorValues<T> getVectorValues(VectorDataType vectorDataType, DocIdSetIterator docIdSetIterator) {
        return KNNVectorValuesFactory.getVectorValues(vectorDataType, new KNNVectorValuesIterator.DocIdsIteratorValues(docIdSetIterator));
    }

    public static <T> KNNVectorValues<T> getVectorValues(VectorDataType vectorDataType, DocsWithFieldSet docIdWithFieldSet, Map<Integer, T> vectors) {
        return KNNVectorValuesFactory.getVectorValues(vectorDataType, new KNNVectorValuesIterator.FieldWriterIteratorValues<T>(docIdWithFieldSet, vectors));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> KNNVectorValues<T> getVectorValues(FieldInfo fieldInfo, LeafReader leafReader) throws IOException {
        BinaryDocValues docIdSetIterator;
        if (fieldInfo.hasVectorValues()) {
            if (fieldInfo.getVectorEncoding() == VectorEncoding.BYTE) {
                docIdSetIterator = leafReader.getByteVectorValues(fieldInfo.getName());
            } else {
                if (fieldInfo.getVectorEncoding() != VectorEncoding.FLOAT32) throw new IllegalArgumentException("Invalid Vector encoding provided, hence cannot return VectorValues");
                docIdSetIterator = leafReader.getFloatVectorValues(fieldInfo.getName());
            }
        } else {
            docIdSetIterator = DocValues.getBinary((LeafReader)leafReader, (String)fieldInfo.getName());
        }
        KNNVectorValuesIterator.DocIdsIteratorValues vectorValuesIterator = new KNNVectorValuesIterator.DocIdsIteratorValues((DocIdSetIterator)docIdSetIterator);
        return KNNVectorValuesFactory.getVectorValues(FieldInfoExtractor.extractVectorDataType(fieldInfo), vectorValuesIterator);
    }

    private static <T> KNNVectorValues<T> getVectorValues(VectorDataType vectorDataType, KNNVectorValuesIterator knnVectorValuesIterator) {
        switch (vectorDataType) {
            case FLOAT: {
                return new KNNFloatVectorValues(knnVectorValuesIterator);
            }
            case BYTE: {
                return new KNNByteVectorValues(knnVectorValuesIterator);
            }
            case BINARY: {
                return new KNNBinaryVectorValues(knnVectorValuesIterator);
            }
        }
        throw new IllegalArgumentException("Invalid Vector data type provided, hence cannot return VectorValues");
    }
}

