/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SizeButton
extends JComponent
implements Accessible {
    private final ImageIcon enlargeImage;
    private final ImageIcon shrinkImage;
    private boolean isEnlarged;
    private final SlippyMapBBoxChooser slippyMapBBoxChooser;
    private final transient MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                SizeButton.this.toggle();
            }
        }
    };

    public SizeButton(SlippyMapBBoxChooser slippyMapBBoxChooser) {
        this.slippyMapBBoxChooser = slippyMapBBoxChooser;
        this.enlargeImage = ImageProvider.get("view-fullscreen");
        this.shrinkImage = ImageProvider.get("view-fullscreen-revert");
        this.setPreferredSize(new Dimension(this.enlargeImage.getIconWidth(), this.enlargeImage.getIconHeight()));
        this.addMouseListener(this.mouseAdapter);
        this.setToolTipText(I18n.tr("Enlarge", new Object[0]));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEnlarged) {
            if (this.shrinkImage != null) {
                g.drawImage(this.shrinkImage.getImage(), 0, 0, null);
            }
        } else if (this.enlargeImage != null) {
            g.drawImage(this.enlargeImage.getImage(), 0, 0, null);
        }
    }

    public void toggle() {
        this.isEnlarged = !this.isEnlarged;
        this.setToolTipText(this.isEnlarged ? I18n.tr("Shrink", new Object[0]) : I18n.tr("Enlarge", new Object[0]));
        this.slippyMapBBoxChooser.resizeSlippyMap();
    }

    public boolean isEnlarged() {
        return this.isEnlarged;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSizeButton();
        }
        return this.accessibleContext;
    }

    class AccessibleSizeButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        AccessibleSizeButton() {
            super(SizeButton.this);
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            return "toggle";
        }

        @Override
        public boolean doAccessibleAction(int i) {
            SizeButton.this.toggle();
            return true;
        }
    }
}

