/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import net.osmand.util.MapUtils;

@XmlRootElement
public class LatLon
implements Serializable {
    private double longitude;
    private double latitude;

    public void setLongitude(double pLongitude) {
        this.longitude = pLongitude;
    }

    public void setLatitude(double pLatitude) {
        this.latitude = pLatitude;
    }

    public LatLon() {
    }

    public LatLon(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int temp = (int)Math.floor(this.latitude * 10000.0);
        result = 31 * result + temp;
        temp = (int)Math.floor(this.longitude * 10000.0);
        result = 31 * result + temp;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatLon other = (LatLon)obj;
        return Math.abs(this.latitude - other.latitude) < 1.0E-5 && Math.abs(this.longitude - other.longitude) < 1.0E-5;
    }

    public String toString() {
        return "Lat " + (float)this.latitude + " Lon " + (float)this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int get31TileNumberX() {
        return MapUtils.get31TileNumberX(this.longitude);
    }

    public int get31TileNumberY() {
        return MapUtils.get31TileNumberY(this.latitude);
    }
}

