/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompoundTypeDefinition;
import com.strobel.assembler.metadata.ICompoundType;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.Accumulator;
import com.strobel.core.Comparer;
import com.strobel.core.VerifyArgument;
import java.util.ArrayList;
import java.util.List;

public final class CompoundTypeReference
extends TypeReference
implements ICompoundType {
    private final TypeReference _baseType;
    private final List<TypeReference> _interfaces;
    private final IMetadataResolver _resolver;

    public CompoundTypeReference(TypeReference baseType, List<TypeReference> interfaces) {
        this(baseType, interfaces, IMetadataResolver.EMPTY);
    }

    public CompoundTypeReference(TypeReference baseType, List<TypeReference> interfaces, IMetadataResolver resolver) {
        VerifyArgument.noNullElementsAndNotEmpty(interfaces, "interfaces");
        this._baseType = baseType != BuiltinTypes.Null ? baseType : null;
        this._interfaces = interfaces;
        this._resolver = Comparer.coalesce(resolver, IMetadataResolver.EMPTY);
    }

    private TypeReference underlyingType0() {
        return this._baseType != null ? this._baseType : this._interfaces.get(0);
    }

    @Override
    public final TypeReference getBaseType() {
        return this._baseType;
    }

    @Override
    public final List<TypeReference> getInterfaces() {
        return this._interfaces;
    }

    @Override
    public IMetadataResolver getResolver() {
        return Comparer.coalesce(this._resolver, IMetadataResolver.EMPTY);
    }

    @Override
    public TypeReference getDeclaringType() {
        return null;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    @Override
    public String getSimpleName() {
        return this.underlyingType0().getSimpleName();
    }

    @Override
    public boolean containsGenericParameters() {
        TypeReference baseType = this.getBaseType();
        if (baseType != null && baseType.containsGenericParameters()) {
            return true;
        }
        for (TypeReference t : this._interfaces) {
            if (!t.containsGenericParameters()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.underlyingType0().getName();
    }

    @Override
    public String getFullName() {
        return this.underlyingType0().getFullName();
    }

    @Override
    public String getInternalName() {
        return this.underlyingType0().getInternalName();
    }

    @Override
    public TypeReference getUnderlyingType() {
        return this.underlyingType0();
    }

    @Override
    public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitCompoundType(this, parameter);
    }

    @Override
    protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        return this.underlyingType0().appendName(sb, fullName, dottedName);
    }

    static StringBuilder append0(ICompoundType t, StringBuilder sb, String delimiter, Accumulator<TypeReference, StringBuilder> appender) {
        TypeReference baseType = t.getBaseType();
        List<TypeReference> interfaces = t.getInterfaces();
        StringBuilder s = sb;
        if (baseType != null) {
            s = appender.accumulate(s, baseType);
            if (!interfaces.isEmpty()) {
                s.append(delimiter);
            }
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s.append(delimiter);
            }
            s = appender.accumulate(s, interfaces.get(i));
        }
        return s;
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        return CompoundTypeReference.append0(this, sb, " & ", TypeReference.TypeFunctions.APPEND_BRIEF_DESCRIPTION);
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        return CompoundTypeReference.append0(this, sb, " & ", TypeReference.TypeFunctions.APPEND_SIMPLE_DESCRIPTION);
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return CompoundTypeReference.append0(this, sb, " & ", TypeReference.TypeFunctions.APPEND_ERASED_DESCRIPTION);
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return CompoundTypeReference.append0(this, sb, " & ", TypeReference.TypeFunctions.APPEND_DESCRIPTION);
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        int position = sb.length();
        StringBuilder s = CompoundTypeReference.append0(this, sb, ":", TypeReference.TypeFunctions.APPEND_SIGNATURE);
        if (this._baseType == null) {
            s.insert(position, ':');
        }
        return s;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this.underlyingType0().appendErasedSignature(sb);
    }

    @Override
    protected StringBuilder appendErasedClassSignature(StringBuilder sb) {
        return this.underlyingType0().appendErasedClassSignature(sb);
    }

    @Override
    public TypeDefinition resolve() {
        boolean hasResolver;
        IMetadataResolver resolver = this._resolver;
        boolean bl = hasResolver = resolver != IMetadataResolver.EMPTY;
        TypeDefinition baseResolved = this._baseType != null ? (hasResolver ? resolver.resolve(this._baseType) : this._baseType.resolve()) : null;
        ArrayList<TypeReference> ifsResolved = new ArrayList<TypeReference>();
        for (TypeReference ifType : this._interfaces) {
            TypeDefinition ifTypeResolved = ifType != null ? (hasResolver ? resolver.resolve(ifType) : ifType.resolve()) : null;
            ifsResolved.add(Comparer.coalesce(ifTypeResolved, ifType));
        }
        return new CompoundTypeDefinition(Comparer.coalesce(baseResolved, this._baseType), ifsResolved, resolver);
    }
}

