// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAME70J21B.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsame70j21b

// Microchip ATSAME70J21B Microcontroller
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAME70J21B"
	CPU          = "CM7"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Supply Controller
	IRQ_SUPC = 0

	// Reset Controller
	IRQ_RSTC = 1

	// Real-time Clock
	IRQ_RTC = 2

	// Real-time Timer
	IRQ_RTT = 3

	// Watchdog Timer
	IRQ_WDT = 4

	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller
	IRQ_EFC = 6

	// Universal Asynchronous Receiver Transmitter
	IRQ_UART0 = 7

	IRQ_UART1 = 8

	// Parallel Input/Output Controller
	IRQ_PIOA = 10

	IRQ_PIOB = 11

	// Universal Synchronous Asynchronous Receiver Transmitter
	IRQ_USART0 = 13

	IRQ_USART1 = 14

	IRQ_PIOD = 16

	// Two-wire Interface High Speed
	IRQ_TWIHS0 = 19

	IRQ_TWIHS1 = 20

	// Synchronous Serial Controller
	IRQ_SSC = 22

	// Timer Counter
	IRQ_TC0 = 23

	// Timer Counter
	IRQ_TC1 = 24

	// Timer Counter
	IRQ_TC2 = 25

	IRQ_TC3 = 26

	IRQ_TC4 = 27

	IRQ_TC5 = 28

	// Analog Front-End Controller
	IRQ_AFEC0 = 29

	// Digital-to-Analog Converter Controller
	IRQ_DACC = 30

	// Pulse Width Modulation Controller
	IRQ_PWM0 = 31

	// Integrity Check Monitor
	IRQ_ICM = 32

	// Analog Comparator Controller
	IRQ_ACC = 33

	// USB High-Speed Interface
	IRQ_USBHS = 34

	// Controller Area Network
	IRQ_MCAN0_INT0 = 35

	// Controller Area Network
	IRQ_MCAN0_INT1 = 36

	// Gigabit Ethernet MAC
	IRQ_GMAC = 39

	IRQ_AFEC1 = 40

	// Quad Serial Peripheral Interface
	IRQ_QSPI = 43

	IRQ_UART2 = 44

	IRQ_TC6 = 47

	IRQ_TC7 = 48

	IRQ_TC8 = 49

	IRQ_TC9 = 50

	IRQ_TC10 = 51

	IRQ_TC11 = 52

	// Advanced Encryption Standard
	IRQ_AES = 56

	// True Random Number Generator
	IRQ_TRNG = 57

	// Extensible DMA Controller
	IRQ_XDMAC = 58

	// Image Sensor Interface
	IRQ_ISI = 59

	IRQ_PWM1 = 60

	// Floating Point Unit
	IRQ_FPU = 61

	// Reinforced Safety Watchdog Timer
	IRQ_RSWDT = 63

	// System Control Block
	IRQ_CCW = 64

	// System Control Block
	IRQ_CCF = 65

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q1 = 66

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q2 = 67

	// Floating Point Unit
	IRQ_IXC = 68

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q3 = 71

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q4 = 72

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q5 = 73

	// Highest interrupt number on this device.
	IRQ_max = 73
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export SUPC_IRQHandler
func interruptSUPC() {
	callHandlers(IRQ_SUPC)
}

//export RSTC_IRQHandler
func interruptRSTC() {
	callHandlers(IRQ_RSTC)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RTT_IRQHandler
func interruptRTT() {
	callHandlers(IRQ_RTT)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export EFC_IRQHandler
func interruptEFC() {
	callHandlers(IRQ_EFC)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export PIOD_IRQHandler
func interruptPIOD() {
	callHandlers(IRQ_PIOD)
}

//export TWIHS0_IRQHandler
func interruptTWIHS0() {
	callHandlers(IRQ_TWIHS0)
}

//export TWIHS1_IRQHandler
func interruptTWIHS1() {
	callHandlers(IRQ_TWIHS1)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export TC3_IRQHandler
func interruptTC3() {
	callHandlers(IRQ_TC3)
}

//export TC4_IRQHandler
func interruptTC4() {
	callHandlers(IRQ_TC4)
}

//export TC5_IRQHandler
func interruptTC5() {
	callHandlers(IRQ_TC5)
}

//export AFEC0_IRQHandler
func interruptAFEC0() {
	callHandlers(IRQ_AFEC0)
}

//export DACC_IRQHandler
func interruptDACC() {
	callHandlers(IRQ_DACC)
}

//export PWM0_IRQHandler
func interruptPWM0() {
	callHandlers(IRQ_PWM0)
}

//export ICM_IRQHandler
func interruptICM() {
	callHandlers(IRQ_ICM)
}

//export ACC_IRQHandler
func interruptACC() {
	callHandlers(IRQ_ACC)
}

//export USBHS_IRQHandler
func interruptUSBHS() {
	callHandlers(IRQ_USBHS)
}

//export MCAN0_INT0_IRQHandler
func interruptMCAN0_INT0() {
	callHandlers(IRQ_MCAN0_INT0)
}

//export MCAN0_INT1_IRQHandler
func interruptMCAN0_INT1() {
	callHandlers(IRQ_MCAN0_INT1)
}

//export GMAC_IRQHandler
func interruptGMAC() {
	callHandlers(IRQ_GMAC)
}

//export AFEC1_IRQHandler
func interruptAFEC1() {
	callHandlers(IRQ_AFEC1)
}

//export QSPI_IRQHandler
func interruptQSPI() {
	callHandlers(IRQ_QSPI)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export TC6_IRQHandler
func interruptTC6() {
	callHandlers(IRQ_TC6)
}

//export TC7_IRQHandler
func interruptTC7() {
	callHandlers(IRQ_TC7)
}

//export TC8_IRQHandler
func interruptTC8() {
	callHandlers(IRQ_TC8)
}

//export TC9_IRQHandler
func interruptTC9() {
	callHandlers(IRQ_TC9)
}

//export TC10_IRQHandler
func interruptTC10() {
	callHandlers(IRQ_TC10)
}

//export TC11_IRQHandler
func interruptTC11() {
	callHandlers(IRQ_TC11)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

//export XDMAC_IRQHandler
func interruptXDMAC() {
	callHandlers(IRQ_XDMAC)
}

//export ISI_IRQHandler
func interruptISI() {
	callHandlers(IRQ_ISI)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export RSWDT_IRQHandler
func interruptRSWDT() {
	callHandlers(IRQ_RSWDT)
}

//export CCW_IRQHandler
func interruptCCW() {
	callHandlers(IRQ_CCW)
}

//export CCF_IRQHandler
func interruptCCF() {
	callHandlers(IRQ_CCF)
}

//export GMAC_Q1_IRQHandler
func interruptGMAC_Q1() {
	callHandlers(IRQ_GMAC_Q1)
}

//export GMAC_Q2_IRQHandler
func interruptGMAC_Q2() {
	callHandlers(IRQ_GMAC_Q2)
}

//export IXC_IRQHandler
func interruptIXC() {
	callHandlers(IRQ_IXC)
}

//export GMAC_Q3_IRQHandler
func interruptGMAC_Q3() {
	callHandlers(IRQ_GMAC_Q3)
}

//export GMAC_Q4_IRQHandler
func interruptGMAC_Q4() {
	callHandlers(IRQ_GMAC_Q4)
}

//export GMAC_Q5_IRQHandler
func interruptGMAC_Q5() {
	callHandlers(IRQ_GMAC_Q5)
}

// Peripherals.
var (
	// Analog Comparator Controller
	ACC = (*ACC_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// Advanced Encryption Standard
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// Analog Front-End Controller
	AFEC0 = (*AFEC_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0940)))

	// Digital-to-Analog Converter Controller
	DACC = (*DACC_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Embedded Flash Controller
	EFC = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0c00)))

	// Gigabit Ethernet MAC
	GMAC = (*GMAC_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// General Purpose Backup Registers
	GPBR = (*GPBR_Type)(unsafe.Pointer(uintptr(0x400e1890)))

	// Integrity Check Monitor
	ICM = (*ICM_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// Image Sensor Interface
	ISI = (*ISI_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Controller Area Network
	MCAN0 = (*MCAN_Type)(unsafe.Pointer(uintptr(0x40030000)))

	// Parallel Input/Output Controller
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Pulse Width Modulation Controller
	PWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Quad Serial Peripheral Interface
	QSPI = (*QSPI_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Reset Controller
	RSTC = (*RSTC_Type)(unsafe.Pointer(uintptr(0x400e1800)))

	// Reinforced Safety Watchdog Timer
	RSWDT = (*RSWDT_Type)(unsafe.Pointer(uintptr(0x400e1900)))

	// Real-time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x400e1860)))

	// Real-time Timer
	RTT = (*RTT_Type)(unsafe.Pointer(uintptr(0x400e1830)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Supply Controller
	SUPC = (*SUPC_Type)(unsafe.Pointer(uintptr(0x400e1810)))

	// Timer Counter
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0x40070000)))

	// Two-wire Interface High Speed
	TWIHS0 = (*TWIHS_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Universal Asynchronous Receiver Transmitter
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Universal Synchronous Asynchronous Receiver Transmitter
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// USB High-Speed Interface
	USBHS = (*USBHS_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// USB Transmitter Interface Macrocell
	UTMI = (*UTMI_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x400e1850)))

	// Extensible DMA Controller
	XDMAC = (*XDMAC_Type)(unsafe.Pointer(uintptr(0x40078000)))

	LOCKBIT = (*LOCKBIT_Type)(unsafe.Pointer(uintptr(0x0)))

	// System control not in SCB
	SCnSCB = (*SCnSCB_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// System Control Block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// System timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory Protection Unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Floating Point Unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef30)))

	// Analog Front-End Controller
	AFEC1 = (*AFEC_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Parallel Input/Output Controller
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// Parallel Input/Output Controller
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1400)))

	// Pulse Width Modulation Controller
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// Timer Counter
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Timer Counter
	TC2 = (*TC_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Timer Counter
	TC3 = (*TC_Type)(unsafe.Pointer(uintptr(0x40054000)))

	// Two-wire Interface High Speed
	TWIHS1 = (*TWIHS_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Universal Asynchronous Receiver Transmitter
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Universal Asynchronous Receiver Transmitter
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e1a00)))

	// Universal Synchronous Asynchronous Receiver Transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40028000)))
)

// Analog Comparator Controller
type ACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [28]byte
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	ISR  volatile.Register32 // 0x30
	_    [96]byte
	ACR  volatile.Register32 // 0x94
	_    [76]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// ACC.CR: Control Register
func (o *ACC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ACC.MR: Mode Register
func (o *ACC_Type) SetMR_SELMINUS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7)|value)
}
func (o *ACC_Type) GetMR_SELMINUS() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x7
}
func (o *ACC_Type) SetMR_SELPLUS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x70)|value<<4)
}
func (o *ACC_Type) GetMR_SELPLUS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x70) >> 4
}
func (o *ACC_Type) SetMR_ACEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *ACC_Type) GetMR_ACEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *ACC_Type) SetMR_EDGETYP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x600)|value<<9)
}
func (o *ACC_Type) GetMR_EDGETYP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x600) >> 9
}
func (o *ACC_Type) SetMR_INV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *ACC_Type) GetMR_INV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *ACC_Type) SetMR_SELFS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *ACC_Type) GetMR_SELFS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *ACC_Type) SetMR_FE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *ACC_Type) GetMR_FE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}

// ACC.IER: Interrupt Enable Register
func (o *ACC_Type) SetIER_CE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIER_CE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ACC.IDR: Interrupt Disable Register
func (o *ACC_Type) SetIDR_CE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIDR_CE() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// ACC.IMR: Interrupt Mask Register
func (o *ACC_Type) SetIMR_CE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIMR_CE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// ACC.ISR: Interrupt Status Register
func (o *ACC_Type) SetISR_CE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetISR_CE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ACC_Type) SetISR_SCO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ACC_Type) GetISR_SCO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ACC_Type) SetISR_MASK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *ACC_Type) GetISR_MASK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// ACC.ACR: Analog Control Register
func (o *ACC_Type) SetACR_ISEL(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACR_ISEL() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *ACC_Type) SetACR_HYST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x6)|value<<1)
}
func (o *ACC_Type) GetACR_HYST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x6) >> 1
}

// ACC.WPMR: Write Protection Mode Register
func (o *ACC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ACC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ACC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ACC.WPSR: Write Protection Status Register
func (o *ACC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}

// Advanced Encryption Standard
type AES_Type struct {
	CR      volatile.Register32 // 0x0
	MR      volatile.Register32 // 0x4
	_       [8]byte
	IER     volatile.Register32    // 0x10
	IDR     volatile.Register32    // 0x14
	IMR     volatile.Register32    // 0x18
	ISR     volatile.Register32    // 0x1C
	KEYWR   [8]volatile.Register32 // 0x20
	IDATAR  [4]volatile.Register32 // 0x40
	ODATAR  [4]volatile.Register32 // 0x50
	IVR     [4]volatile.Register32 // 0x60
	AADLENR volatile.Register32    // 0x70
	CLENR   volatile.Register32    // 0x74
	GHASHR  [4]volatile.Register32 // 0x78
	TAGR    [4]volatile.Register32 // 0x88
	CTRR    volatile.Register32    // 0x98
	GCMHR   [4]volatile.Register32 // 0x9C
}

// AES.CR: Control Register
func (o *AES_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *AES_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetCR_LOADSEED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetCR_LOADSEED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}

// AES.MR: Mode Register
func (o *AES_Type) SetMR_CIPHER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetMR_CIPHER() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *AES_Type) SetMR_GTAGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetMR_GTAGEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetMR_DUALBUFF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8)|value<<3)
}
func (o *AES_Type) GetMR_DUALBUFF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8) >> 3
}
func (o *AES_Type) SetMR_PROCDLY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0)|value<<4)
}
func (o *AES_Type) GetMR_PROCDLY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0) >> 4
}
func (o *AES_Type) SetMR_SMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x300)|value<<8)
}
func (o *AES_Type) GetMR_SMOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x300) >> 8
}
func (o *AES_Type) SetMR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc00)|value<<10)
}
func (o *AES_Type) GetMR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc00) >> 10
}
func (o *AES_Type) SetMR_OPMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000)|value<<12)
}
func (o *AES_Type) GetMR_OPMOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000) >> 12
}
func (o *AES_Type) SetMR_LOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *AES_Type) GetMR_LOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}
func (o *AES_Type) SetMR_CFBS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x70000)|value<<16)
}
func (o *AES_Type) GetMR_CFBS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x70000) >> 16
}
func (o *AES_Type) SetMR_CKEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00000)|value<<20)
}
func (o *AES_Type) GetMR_CKEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00000) >> 20
}

// AES.IER: Interrupt Enable Register
func (o *AES_Type) SetIER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *AES_Type) SetIER_URAD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIER_URAD() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetIER_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetIER_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}

// AES.IDR: Interrupt Disable Register
func (o *AES_Type) SetIDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *AES_Type) SetIDR_URAD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIDR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetIDR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetIDR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}

// AES.IMR: Interrupt Mask Register
func (o *AES_Type) SetIMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AES_Type) SetIMR_URAD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIMR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetIMR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetIMR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}

// AES.ISR: Interrupt Status Register
func (o *AES_Type) SetISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *AES_Type) SetISR_URAD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetISR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetISR_URAT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf000)|value<<12)
}
func (o *AES_Type) GetISR_URAT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf000) >> 12
}
func (o *AES_Type) SetISR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetISR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// AES.KEYWR: Key Word Register
func (o *AES_Type) SetKEYWR(idx int, value uint32) {
	volatile.StoreUint32(&o.KEYWR[idx].Reg, value)
}
func (o *AES_Type) GetKEYWR(idx int) uint32 {
	return volatile.LoadUint32(&o.KEYWR[idx].Reg)
}

// AES.IDATAR: Input Data Register
func (o *AES_Type) SetIDATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.IDATAR[idx].Reg, value)
}
func (o *AES_Type) GetIDATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.IDATAR[idx].Reg)
}

// AES.ODATAR: Output Data Register
func (o *AES_Type) SetODATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.ODATAR[idx].Reg, value)
}
func (o *AES_Type) GetODATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.ODATAR[idx].Reg)
}

// AES.IVR: Initialization Vector Register
func (o *AES_Type) SetIVR(idx int, value uint32) {
	volatile.StoreUint32(&o.IVR[idx].Reg, value)
}
func (o *AES_Type) GetIVR(idx int) uint32 {
	return volatile.LoadUint32(&o.IVR[idx].Reg)
}

// AES.AADLENR: Additional Authenticated Data Length Register
func (o *AES_Type) SetAADLENR(value uint32) {
	volatile.StoreUint32(&o.AADLENR.Reg, value)
}
func (o *AES_Type) GetAADLENR() uint32 {
	return volatile.LoadUint32(&o.AADLENR.Reg)
}

// AES.CLENR: Plaintext/Ciphertext Length Register
func (o *AES_Type) SetCLENR(value uint32) {
	volatile.StoreUint32(&o.CLENR.Reg, value)
}
func (o *AES_Type) GetCLENR() uint32 {
	return volatile.LoadUint32(&o.CLENR.Reg)
}

// AES.GHASHR: GCM Intermediate Hash Word Register
func (o *AES_Type) SetGHASHR(idx int, value uint32) {
	volatile.StoreUint32(&o.GHASHR[idx].Reg, value)
}
func (o *AES_Type) GetGHASHR(idx int) uint32 {
	return volatile.LoadUint32(&o.GHASHR[idx].Reg)
}

// AES.TAGR: GCM Authentication Tag Word Register
func (o *AES_Type) SetTAGR(idx int, value uint32) {
	volatile.StoreUint32(&o.TAGR[idx].Reg, value)
}
func (o *AES_Type) GetTAGR(idx int) uint32 {
	return volatile.LoadUint32(&o.TAGR[idx].Reg)
}

// AES.CTRR: GCM Encryption Counter Value Register
func (o *AES_Type) SetCTRR(value uint32) {
	volatile.StoreUint32(&o.CTRR.Reg, value)
}
func (o *AES_Type) GetCTRR() uint32 {
	return volatile.LoadUint32(&o.CTRR.Reg)
}

// AES.GCMHR: GCM H Word Register
func (o *AES_Type) SetGCMHR(idx int, value uint32) {
	volatile.StoreUint32(&o.GCMHR[idx].Reg, value)
}
func (o *AES_Type) GetGCMHR(idx int) uint32 {
	return volatile.LoadUint32(&o.GCMHR[idx].Reg)
}

// Analog Front-End Controller
type AFEC_Type struct {
	CR      volatile.Register32 // 0x0
	MR      volatile.Register32 // 0x4
	EMR     volatile.Register32 // 0x8
	SEQ1R   volatile.Register32 // 0xC
	SEQ2R   volatile.Register32 // 0x10
	CHER    volatile.Register32 // 0x14
	CHDR    volatile.Register32 // 0x18
	CHSR    volatile.Register32 // 0x1C
	LCDR    volatile.Register32 // 0x20
	IER     volatile.Register32 // 0x24
	IDR     volatile.Register32 // 0x28
	IMR     volatile.Register32 // 0x2C
	ISR     volatile.Register32 // 0x30
	_       [24]byte
	OVER    volatile.Register32 // 0x4C
	CWR     volatile.Register32 // 0x50
	CGR     volatile.Register32 // 0x54
	_       [8]byte
	DIFFR   volatile.Register32 // 0x60
	CSELR   volatile.Register32 // 0x64
	CDR     volatile.Register32 // 0x68
	COCR    volatile.Register32 // 0x6C
	TEMPMR  volatile.Register32 // 0x70
	TEMPCWR volatile.Register32 // 0x74
	_       [28]byte
	ACR     volatile.Register32 // 0x94
	_       [8]byte
	SHMR    volatile.Register32 // 0xA0
	_       [44]byte
	COSR    volatile.Register32 // 0xD0
	CVR     volatile.Register32 // 0xD4
	CECR    volatile.Register32 // 0xD8
	_       [8]byte
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
}

// AFEC.CR: AFEC Control Register
func (o *AFEC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *AFEC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// AFEC.MR: AFEC Mode Register
func (o *AFEC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *AFEC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *AFEC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *AFEC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetMR_FWUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetMR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetMR_FREERUN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetMR_FREERUN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *AFEC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *AFEC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *AFEC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *AFEC_Type) SetMR_ONE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *AFEC_Type) GetMR_ONE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *AFEC_Type) SetMR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetMR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *AFEC_Type) SetMR_TRANSFER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30000000)|value<<28)
}
func (o *AFEC_Type) GetMR_TRANSFER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30000000) >> 28
}
func (o *AFEC_Type) SetMR_USEQ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *AFEC_Type) GetMR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// AFEC.EMR: AFEC Extended Mode Register
func (o *AFEC_Type) SetEMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *AFEC_Type) GetEMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *AFEC_Type) SetEMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xf8)|value<<3)
}
func (o *AFEC_Type) GetEMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xf8) >> 3
}
func (o *AFEC_Type) SetEMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetEMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetEMR_CMPFILTER(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3000)|value<<12)
}
func (o *AFEC_Type) GetEMR_CMPFILTER() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x3000) >> 12
}
func (o *AFEC_Type) SetEMR_RES(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x70000)|value<<16)
}
func (o *AFEC_Type) GetEMR_RES() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x70000) >> 16
}
func (o *AFEC_Type) SetEMR_TAG(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetEMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetEMR_STM(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetEMR_STM() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetEMR_SIGNMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30000000)|value<<28)
}
func (o *AFEC_Type) GetEMR_SIGNMODE() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30000000) >> 28
}

// AFEC.SEQ1R: AFEC Channel Sequence 1 Register
func (o *AFEC_Type) SetSEQ1R_USCH0(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetSEQ1R_USCH0() uint32 {
	return volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf
}
func (o *AFEC_Type) SetSEQ1R_USCH1(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf0)|value<<4)
}
func (o *AFEC_Type) GetSEQ1R_USCH1() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf0) >> 4
}
func (o *AFEC_Type) SetSEQ1R_USCH2(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf00)|value<<8)
}
func (o *AFEC_Type) GetSEQ1R_USCH2() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf00) >> 8
}
func (o *AFEC_Type) SetSEQ1R_USCH3(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf000)|value<<12)
}
func (o *AFEC_Type) GetSEQ1R_USCH3() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf000) >> 12
}
func (o *AFEC_Type) SetSEQ1R_USCH4(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf0000)|value<<16)
}
func (o *AFEC_Type) GetSEQ1R_USCH4() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf0000) >> 16
}
func (o *AFEC_Type) SetSEQ1R_USCH5(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf00000)|value<<20)
}
func (o *AFEC_Type) GetSEQ1R_USCH5() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf00000) >> 20
}
func (o *AFEC_Type) SetSEQ1R_USCH6(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetSEQ1R_USCH6() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf000000) >> 24
}
func (o *AFEC_Type) SetSEQ1R_USCH7(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf0000000)|value<<28)
}
func (o *AFEC_Type) GetSEQ1R_USCH7() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf0000000) >> 28
}

// AFEC.SEQ2R: AFEC Channel Sequence 2 Register
func (o *AFEC_Type) SetSEQ2R_USCH8(value uint32) {
	volatile.StoreUint32(&o.SEQ2R.Reg, volatile.LoadUint32(&o.SEQ2R.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetSEQ2R_USCH8() uint32 {
	return volatile.LoadUint32(&o.SEQ2R.Reg) & 0xf
}
func (o *AFEC_Type) SetSEQ2R_USCH9(value uint32) {
	volatile.StoreUint32(&o.SEQ2R.Reg, volatile.LoadUint32(&o.SEQ2R.Reg)&^(0xf0)|value<<4)
}
func (o *AFEC_Type) GetSEQ2R_USCH9() uint32 {
	return (volatile.LoadUint32(&o.SEQ2R.Reg) & 0xf0) >> 4
}
func (o *AFEC_Type) SetSEQ2R_USCH10(value uint32) {
	volatile.StoreUint32(&o.SEQ2R.Reg, volatile.LoadUint32(&o.SEQ2R.Reg)&^(0xf00)|value<<8)
}
func (o *AFEC_Type) GetSEQ2R_USCH10() uint32 {
	return (volatile.LoadUint32(&o.SEQ2R.Reg) & 0xf00) >> 8
}
func (o *AFEC_Type) SetSEQ2R_USCH11(value uint32) {
	volatile.StoreUint32(&o.SEQ2R.Reg, volatile.LoadUint32(&o.SEQ2R.Reg)&^(0xf000)|value<<12)
}
func (o *AFEC_Type) GetSEQ2R_USCH11() uint32 {
	return (volatile.LoadUint32(&o.SEQ2R.Reg) & 0xf000) >> 12
}

// AFEC.CHER: AFEC Channel Enable Register
func (o *AFEC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *AFEC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetCHER_CH8(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetCHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetCHER_CH9(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetCHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetCHER_CH10(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetCHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetCHER_CH11(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetCHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}

// AFEC.CHDR: AFEC Channel Disable Register
func (o *AFEC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *AFEC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetCHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetCHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetCHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetCHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetCHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetCHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetCHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetCHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}

// AFEC.CHSR: AFEC Channel Status Register
func (o *AFEC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *AFEC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetCHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetCHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetCHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetCHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetCHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetCHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetCHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetCHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}

// AFEC.LCDR: AFEC Last Converted Data Register
func (o *AFEC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xffff
}
func (o *AFEC_Type) SetLCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetLCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.LCDR.Reg) & 0xf000000) >> 24
}

// AFEC.IER: AFEC Interrupt Enable Register
func (o *AFEC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *AFEC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetIER_EOC8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetIER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetIER_EOC9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetIER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetIER_EOC10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetIER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetIER_EOC11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetIER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetIER_COMPE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetIER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetIER_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetIER_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}

// AFEC.IDR: AFEC Interrupt Disable Register
func (o *AFEC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *AFEC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetIDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetIDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetIDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetIDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetIDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetIDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetIDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetIDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetIDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetIDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetIDR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetIDR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}

// AFEC.IMR: AFEC Interrupt Mask Register
func (o *AFEC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AFEC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetIMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetIMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetIMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetIMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetIMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetIMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetIMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetIMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetIMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetIMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetIMR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetIMR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}

// AFEC.ISR: AFEC Interrupt Status Register
func (o *AFEC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *AFEC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetISR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetISR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}

// AFEC.OVER: AFEC Overrun Status Register
func (o *AFEC_Type) SetOVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetOVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.OVER.Reg) & 0x1
}
func (o *AFEC_Type) SetOVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetOVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetOVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetOVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetOVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetOVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetOVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetOVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetOVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetOVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetOVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetOVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetOVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetOVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetOVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetOVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetOVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetOVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetOVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetOVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetOVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetOVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x800) >> 11
}

// AFEC.CWR: AFEC Compare Window Register
func (o *AFEC_Type) SetCWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetCWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.CWR.Reg) & 0xffff
}
func (o *AFEC_Type) SetCWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetCWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.CWR.Reg) & 0xffff0000) >> 16
}

// AFEC.CGR: AFEC Channel Gain Register
func (o *AFEC_Type) SetCGR_GAIN0(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3)|value)
}
func (o *AFEC_Type) GetCGR_GAIN0() uint32 {
	return volatile.LoadUint32(&o.CGR.Reg) & 0x3
}
func (o *AFEC_Type) SetCGR_GAIN1(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc)|value<<2)
}
func (o *AFEC_Type) GetCGR_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc) >> 2
}
func (o *AFEC_Type) SetCGR_GAIN2(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30)|value<<4)
}
func (o *AFEC_Type) GetCGR_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30) >> 4
}
func (o *AFEC_Type) SetCGR_GAIN3(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0)|value<<6)
}
func (o *AFEC_Type) GetCGR_GAIN3() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0) >> 6
}
func (o *AFEC_Type) SetCGR_GAIN4(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300)|value<<8)
}
func (o *AFEC_Type) GetCGR_GAIN4() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300) >> 8
}
func (o *AFEC_Type) SetCGR_GAIN5(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00)|value<<10)
}
func (o *AFEC_Type) GetCGR_GAIN5() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00) >> 10
}
func (o *AFEC_Type) SetCGR_GAIN6(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3000)|value<<12)
}
func (o *AFEC_Type) GetCGR_GAIN6() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x3000) >> 12
}
func (o *AFEC_Type) SetCGR_GAIN7(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc000)|value<<14)
}
func (o *AFEC_Type) GetCGR_GAIN7() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc000) >> 14
}
func (o *AFEC_Type) SetCGR_GAIN8(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30000)|value<<16)
}
func (o *AFEC_Type) GetCGR_GAIN8() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30000) >> 16
}
func (o *AFEC_Type) SetCGR_GAIN9(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0000)|value<<18)
}
func (o *AFEC_Type) GetCGR_GAIN9() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0000) >> 18
}
func (o *AFEC_Type) SetCGR_GAIN10(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300000)|value<<20)
}
func (o *AFEC_Type) GetCGR_GAIN10() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300000) >> 20
}
func (o *AFEC_Type) SetCGR_GAIN11(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00000)|value<<22)
}
func (o *AFEC_Type) GetCGR_GAIN11() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00000) >> 22
}

// AFEC.DIFFR: AFEC Channel Differential Register
func (o *AFEC_Type) SetDIFFR_DIFF0(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetDIFFR_DIFF0() uint32 {
	return volatile.LoadUint32(&o.DIFFR.Reg) & 0x1
}
func (o *AFEC_Type) SetDIFFR_DIFF1(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetDIFFR_DIFF1() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetDIFFR_DIFF2(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetDIFFR_DIFF2() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetDIFFR_DIFF3(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetDIFFR_DIFF3() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetDIFFR_DIFF4(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetDIFFR_DIFF4() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetDIFFR_DIFF5(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetDIFFR_DIFF5() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetDIFFR_DIFF6(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetDIFFR_DIFF6() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetDIFFR_DIFF7(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetDIFFR_DIFF7() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetDIFFR_DIFF8(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetDIFFR_DIFF8() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetDIFFR_DIFF9(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetDIFFR_DIFF9() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetDIFFR_DIFF10(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetDIFFR_DIFF10() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetDIFFR_DIFF11(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetDIFFR_DIFF11() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x800) >> 11
}

// AFEC.CSELR: AFEC Channel Selection Register
func (o *AFEC_Type) SetCSELR_CSEL(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetCSELR_CSEL() uint32 {
	return volatile.LoadUint32(&o.CSELR.Reg) & 0xf
}

// AFEC.CDR: AFEC Channel Data Register
func (o *AFEC_Type) SetCDR_DATA(value uint32) {
	volatile.StoreUint32(&o.CDR.Reg, volatile.LoadUint32(&o.CDR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetCDR_DATA() uint32 {
	return volatile.LoadUint32(&o.CDR.Reg) & 0xffff
}

// AFEC.COCR: AFEC Channel Offset Compensation Register
func (o *AFEC_Type) SetCOCR_AOFF(value uint32) {
	volatile.StoreUint32(&o.COCR.Reg, volatile.LoadUint32(&o.COCR.Reg)&^(0x3ff)|value)
}
func (o *AFEC_Type) GetCOCR_AOFF() uint32 {
	return volatile.LoadUint32(&o.COCR.Reg) & 0x3ff
}

// AFEC.TEMPMR: AFEC Temperature Sensor Mode Register
func (o *AFEC_Type) SetTEMPMR_RTCT(value uint32) {
	volatile.StoreUint32(&o.TEMPMR.Reg, volatile.LoadUint32(&o.TEMPMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetTEMPMR_RTCT() uint32 {
	return volatile.LoadUint32(&o.TEMPMR.Reg) & 0x1
}
func (o *AFEC_Type) SetTEMPMR_TEMPCMPMOD(value uint32) {
	volatile.StoreUint32(&o.TEMPMR.Reg, volatile.LoadUint32(&o.TEMPMR.Reg)&^(0x30)|value<<4)
}
func (o *AFEC_Type) GetTEMPMR_TEMPCMPMOD() uint32 {
	return (volatile.LoadUint32(&o.TEMPMR.Reg) & 0x30) >> 4
}

// AFEC.TEMPCWR: AFEC Temperature Compare Window Register
func (o *AFEC_Type) SetTEMPCWR_TLOWTHRES(value uint32) {
	volatile.StoreUint32(&o.TEMPCWR.Reg, volatile.LoadUint32(&o.TEMPCWR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetTEMPCWR_TLOWTHRES() uint32 {
	return volatile.LoadUint32(&o.TEMPCWR.Reg) & 0xffff
}
func (o *AFEC_Type) SetTEMPCWR_THIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.TEMPCWR.Reg, volatile.LoadUint32(&o.TEMPCWR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetTEMPCWR_THIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.TEMPCWR.Reg) & 0xffff0000) >> 16
}

// AFEC.ACR: AFEC Analog Control Register
func (o *AFEC_Type) SetACR_PGA0EN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetACR_PGA0EN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetACR_PGA1EN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetACR_PGA1EN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetACR_IBCTL(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x300)|value<<8)
}
func (o *AFEC_Type) GetACR_IBCTL() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x300) >> 8
}

// AFEC.SHMR: AFEC Sample & Hold Mode Register
func (o *AFEC_Type) SetSHMR_DUAL0(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetSHMR_DUAL0() uint32 {
	return volatile.LoadUint32(&o.SHMR.Reg) & 0x1
}
func (o *AFEC_Type) SetSHMR_DUAL1(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetSHMR_DUAL1() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetSHMR_DUAL2(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetSHMR_DUAL2() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetSHMR_DUAL3(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetSHMR_DUAL3() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetSHMR_DUAL4(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetSHMR_DUAL4() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetSHMR_DUAL5(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetSHMR_DUAL5() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetSHMR_DUAL6(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetSHMR_DUAL6() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetSHMR_DUAL7(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetSHMR_DUAL7() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetSHMR_DUAL8(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetSHMR_DUAL8() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetSHMR_DUAL9(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetSHMR_DUAL9() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetSHMR_DUAL10(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetSHMR_DUAL10() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetSHMR_DUAL11(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetSHMR_DUAL11() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x800) >> 11
}

// AFEC.COSR: AFEC Correction Select Register
func (o *AFEC_Type) SetCOSR_CSEL(value uint32) {
	volatile.StoreUint32(&o.COSR.Reg, volatile.LoadUint32(&o.COSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCOSR_CSEL() uint32 {
	return volatile.LoadUint32(&o.COSR.Reg) & 0x1
}

// AFEC.CVR: AFEC Correction Values Register
func (o *AFEC_Type) SetCVR_OFFSETCORR(value uint32) {
	volatile.StoreUint32(&o.CVR.Reg, volatile.LoadUint32(&o.CVR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetCVR_OFFSETCORR() uint32 {
	return volatile.LoadUint32(&o.CVR.Reg) & 0xffff
}
func (o *AFEC_Type) SetCVR_GAINCORR(value uint32) {
	volatile.StoreUint32(&o.CVR.Reg, volatile.LoadUint32(&o.CVR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetCVR_GAINCORR() uint32 {
	return (volatile.LoadUint32(&o.CVR.Reg) & 0xffff0000) >> 16
}

// AFEC.CECR: AFEC Channel Error Correction Register
func (o *AFEC_Type) SetCECR_ECORR0(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCECR_ECORR0() uint32 {
	return volatile.LoadUint32(&o.CECR.Reg) & 0x1
}
func (o *AFEC_Type) SetCECR_ECORR1(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCECR_ECORR1() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetCECR_ECORR2(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetCECR_ECORR2() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetCECR_ECORR3(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetCECR_ECORR3() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetCECR_ECORR4(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetCECR_ECORR4() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetCECR_ECORR5(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetCECR_ECORR5() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetCECR_ECORR6(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetCECR_ECORR6() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetCECR_ECORR7(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetCECR_ECORR7() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetCECR_ECORR8(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetCECR_ECORR8() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetCECR_ECORR9(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetCECR_ECORR9() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetCECR_ECORR10(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetCECR_ECORR10() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetCECR_ECORR11(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetCECR_ECORR11() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x800) >> 11
}

// AFEC.WPMR: AFEC Write Protection Mode Register
func (o *AFEC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *AFEC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *AFEC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// AFEC.WPSR: AFEC Write Protection Status Register
func (o *AFEC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *AFEC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *AFEC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// CHIPID.CIDR: Chip ID Register
func (o *CHIPID_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *CHIPID_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *CHIPID_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *CHIPID_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *CHIPID_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *CHIPID_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *CHIPID_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *CHIPID_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *CHIPID_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *CHIPID_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *CHIPID_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *CHIPID_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// CHIPID.EXID: Chip ID Extension Register
func (o *CHIPID_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *CHIPID_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	TRIGR volatile.Register32 // 0x8
	_     [4]byte
	CHER  volatile.Register32    // 0x10
	CHDR  volatile.Register32    // 0x14
	CHSR  volatile.Register32    // 0x18
	CDR   [2]volatile.Register32 // 0x1C
	IER   volatile.Register32    // 0x24
	IDR   volatile.Register32    // 0x28
	IMR   volatile.Register32    // 0x2C
	ISR   volatile.Register32    // 0x30
	_     [96]byte
	ACR   volatile.Register32 // 0x94
	_     [76]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// DACC.CR: Control Register
func (o *DACC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DACC.MR: Mode Register
func (o *DACC_Type) SetMR_MAXS0(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetMR_MAXS0() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *DACC_Type) SetMR_MAXS1(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetMR_MAXS1() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetMR_WORD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetMR_WORD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetMR_ZERO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetMR_ZERO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *DACC_Type) SetMR_DIFF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *DACC_Type) GetMR_DIFF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *DACC_Type) SetMR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *DACC_Type) GetMR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}

// DACC.TRIGR: Trigger Register
func (o *DACC_Type) SetTRIGR_TRGEN0(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetTRIGR_TRGEN0() uint32 {
	return volatile.LoadUint32(&o.TRIGR.Reg) & 0x1
}
func (o *DACC_Type) SetTRIGR_TRGEN1(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetTRIGR_TRGEN1() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetTRIGR_TRGSEL0(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x70)|value<<4)
}
func (o *DACC_Type) GetTRIGR_TRGSEL0() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x70) >> 4
}
func (o *DACC_Type) SetTRIGR_TRGSEL1(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x700)|value<<8)
}
func (o *DACC_Type) GetTRIGR_TRGSEL1() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x700) >> 8
}
func (o *DACC_Type) SetTRIGR_OSR0(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x70000)|value<<16)
}
func (o *DACC_Type) GetTRIGR_OSR0() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x70000) >> 16
}
func (o *DACC_Type) SetTRIGR_OSR1(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x700000)|value<<20)
}
func (o *DACC_Type) GetTRIGR_OSR1() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x700000) >> 20
}

// DACC.CHER: Channel Enable Register
func (o *DACC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DACC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}

// DACC.CHDR: Channel Disable Register
func (o *DACC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DACC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}

// DACC.CHSR: Channel Status Register
func (o *DACC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DACC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetCHSR_DACRDY0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetCHSR_DACRDY0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *DACC_Type) SetCHSR_DACRDY1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *DACC_Type) GetCHSR_DACRDY1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}

// DACC.CDR: Conversion Data Register 0
func (o *DACC_Type) SetCDR_DATA0(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetCDR_DATA0(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xffff
}
func (o *DACC_Type) SetCDR_DATA1(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *DACC_Type) GetCDR_DATA1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CDR[idx].Reg) & 0xffff0000) >> 16
}

// DACC.IER: Interrupt Enable Register
func (o *DACC_Type) SetIER_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIER_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DACC_Type) SetIER_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIER_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetIER_EOC0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}

// DACC.IDR: Interrupt Disable Register
func (o *DACC_Type) SetIDR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIDR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DACC_Type) SetIDR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIDR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetIDR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}

// DACC.IMR: Interrupt Mask Register
func (o *DACC_Type) SetIMR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIMR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DACC_Type) SetIMR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIMR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetIMR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}

// DACC.ISR: Interrupt Status Register
func (o *DACC_Type) SetISR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetISR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DACC_Type) SetISR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetISR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetISR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}

// DACC.ACR: Analog Current Register
func (o *DACC_Type) SetACR_IBCTLCH0(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x3)|value)
}
func (o *DACC_Type) GetACR_IBCTLCH0() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x3
}
func (o *DACC_Type) SetACR_IBCTLCH1(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xc)|value<<2)
}
func (o *DACC_Type) GetACR_IBCTLCH1() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xc) >> 2
}

// DACC.WPMR: Write Protection Mode Register
func (o *DACC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DACC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DACC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DACC.WPSR: Write Protection Status Register
func (o *DACC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DACC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *DACC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// Embedded Flash Controller
type EFC_Type struct {
	EEFC_FMR  volatile.Register32 // 0x0
	EEFC_FCR  volatile.Register32 // 0x4
	EEFC_FSR  volatile.Register32 // 0x8
	EEFC_FRR  volatile.Register32 // 0xC
	_         [212]byte
	EEFC_WPMR volatile.Register32 // 0xE4
}

// EFC.EEFC_FMR: EEFC Flash Mode Register
func (o *EFC_Type) SetEEFC_FMR_FRDY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_FMR_FRDY() uint32 {
	return volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_FMR_FWS(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0xf00)|value<<8)
}
func (o *EFC_Type) GetEEFC_FMR_FWS() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0xf00) >> 8
}
func (o *EFC_Type) SetEEFC_FMR_SCOD(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetEEFC_FMR_SCOD() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetEEFC_FMR_CLOE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x4000000)|value<<26)
}
func (o *EFC_Type) GetEEFC_FMR_CLOE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x4000000) >> 26
}

// EFC.EEFC_FCR: EEFC Flash Command Register
func (o *EFC_Type) SetEEFC_FCR_FCMD(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xff)|value)
}
func (o *EFC_Type) GetEEFC_FCR_FCMD() uint32 {
	return volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xff
}
func (o *EFC_Type) SetEEFC_FCR_FARG(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xffff00)|value<<8)
}
func (o *EFC_Type) GetEEFC_FCR_FARG() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xffff00) >> 8
}
func (o *EFC_Type) SetEEFC_FCR_FKEY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xff000000)|value<<24)
}
func (o *EFC_Type) GetEEFC_FCR_FKEY() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xff000000) >> 24
}

// EFC.EEFC_FSR: EEFC Flash Status Register
func (o *EFC_Type) SetEEFC_FSR_FRDY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_FSR_FRDY() uint32 {
	return volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_FSR_FCMDE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x2)|value<<1)
}
func (o *EFC_Type) GetEEFC_FSR_FCMDE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x2) >> 1
}
func (o *EFC_Type) SetEEFC_FSR_FLOCKE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x4)|value<<2)
}
func (o *EFC_Type) GetEEFC_FSR_FLOCKE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x4) >> 2
}
func (o *EFC_Type) SetEEFC_FSR_FLERR(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x8)|value<<3)
}
func (o *EFC_Type) GetEEFC_FSR_FLERR() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x8) >> 3
}
func (o *EFC_Type) SetEEFC_FSR_UECCELSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetEEFC_FSR_UECCELSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetEEFC_FSR_MECCELSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x20000)|value<<17)
}
func (o *EFC_Type) GetEEFC_FSR_MECCELSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x20000) >> 17
}
func (o *EFC_Type) SetEEFC_FSR_UECCEMSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x40000)|value<<18)
}
func (o *EFC_Type) GetEEFC_FSR_UECCEMSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x40000) >> 18
}
func (o *EFC_Type) SetEEFC_FSR_MECCEMSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x80000)|value<<19)
}
func (o *EFC_Type) GetEEFC_FSR_MECCEMSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x80000) >> 19
}

// EFC.EEFC_FRR: EEFC Flash Result Register
func (o *EFC_Type) SetEEFC_FRR(value uint32) {
	volatile.StoreUint32(&o.EEFC_FRR.Reg, value)
}
func (o *EFC_Type) GetEEFC_FRR() uint32 {
	return volatile.LoadUint32(&o.EEFC_FRR.Reg)
}

// EFC.EEFC_WPMR: Write Protection Mode Register
func (o *EFC_Type) SetEEFC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.EEFC_WPMR.Reg, volatile.LoadUint32(&o.EEFC_WPMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.EEFC_WPMR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.EEFC_WPMR.Reg, volatile.LoadUint32(&o.EEFC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *EFC_Type) GetEEFC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.EEFC_WPMR.Reg) & 0xffffff00) >> 8
}

// Gigabit Ethernet MAC
type GMAC_Type struct {
	NCR        volatile.Register32 // 0x0
	NCFGR      volatile.Register32 // 0x4
	NSR        volatile.Register32 // 0x8
	UR         volatile.Register32 // 0xC
	DCFGR      volatile.Register32 // 0x10
	TSR        volatile.Register32 // 0x14
	RBQB       volatile.Register32 // 0x18
	TBQB       volatile.Register32 // 0x1C
	RSR        volatile.Register32 // 0x20
	ISR        volatile.Register32 // 0x24
	IER        volatile.Register32 // 0x28
	IDR        volatile.Register32 // 0x2C
	IMR        volatile.Register32 // 0x30
	MAN        volatile.Register32 // 0x34
	RPQ        volatile.Register32 // 0x38
	TPQ        volatile.Register32 // 0x3C
	TPSF       volatile.Register32 // 0x40
	RPSF       volatile.Register32 // 0x44
	RJFML      volatile.Register32 // 0x48
	_          [52]byte
	HRB        volatile.Register32  // 0x80
	HRT        volatile.Register32  // 0x84
	GMAC_SA    [4]GMAC_GMAC_SA_Type // 0x88
	TIDM1      volatile.Register32  // 0xA8
	TIDM2      volatile.Register32  // 0xAC
	TIDM3      volatile.Register32  // 0xB0
	TIDM4      volatile.Register32  // 0xB4
	WOL        volatile.Register32  // 0xB8
	IPGS       volatile.Register32  // 0xBC
	SVLAN      volatile.Register32  // 0xC0
	TPFCP      volatile.Register32  // 0xC4
	SAMB1      volatile.Register32  // 0xC8
	SAMT1      volatile.Register32  // 0xCC
	_          [12]byte
	NSC        volatile.Register32 // 0xDC
	SCL        volatile.Register32 // 0xE0
	SCH        volatile.Register32 // 0xE4
	EFTSH      volatile.Register32 // 0xE8
	EFRSH      volatile.Register32 // 0xEC
	PEFTSH     volatile.Register32 // 0xF0
	PEFRSH     volatile.Register32 // 0xF4
	_          [8]byte
	OTLO       volatile.Register32 // 0x100
	OTHI       volatile.Register32 // 0x104
	FT         volatile.Register32 // 0x108
	BCFT       volatile.Register32 // 0x10C
	MFT        volatile.Register32 // 0x110
	PFT        volatile.Register32 // 0x114
	BFT64      volatile.Register32 // 0x118
	TBFT127    volatile.Register32 // 0x11C
	TBFT255    volatile.Register32 // 0x120
	TBFT511    volatile.Register32 // 0x124
	TBFT1023   volatile.Register32 // 0x128
	TBFT1518   volatile.Register32 // 0x12C
	GTBFT1518  volatile.Register32 // 0x130
	TUR        volatile.Register32 // 0x134
	SCF        volatile.Register32 // 0x138
	MCF        volatile.Register32 // 0x13C
	EC         volatile.Register32 // 0x140
	LC         volatile.Register32 // 0x144
	DTF        volatile.Register32 // 0x148
	CSE        volatile.Register32 // 0x14C
	ORLO       volatile.Register32 // 0x150
	ORHI       volatile.Register32 // 0x154
	FR         volatile.Register32 // 0x158
	BCFR       volatile.Register32 // 0x15C
	MFR        volatile.Register32 // 0x160
	PFR        volatile.Register32 // 0x164
	BFR64      volatile.Register32 // 0x168
	TBFR127    volatile.Register32 // 0x16C
	TBFR255    volatile.Register32 // 0x170
	TBFR511    volatile.Register32 // 0x174
	TBFR1023   volatile.Register32 // 0x178
	TBFR1518   volatile.Register32 // 0x17C
	TMXBFR     volatile.Register32 // 0x180
	UFR        volatile.Register32 // 0x184
	OFR        volatile.Register32 // 0x188
	JR         volatile.Register32 // 0x18C
	FCSE       volatile.Register32 // 0x190
	LFFE       volatile.Register32 // 0x194
	RSE        volatile.Register32 // 0x198
	AE         volatile.Register32 // 0x19C
	RRE        volatile.Register32 // 0x1A0
	ROE        volatile.Register32 // 0x1A4
	IHCE       volatile.Register32 // 0x1A8
	TCE        volatile.Register32 // 0x1AC
	UCE        volatile.Register32 // 0x1B0
	_          [8]byte
	TISUBN     volatile.Register32 // 0x1BC
	TSH        volatile.Register32 // 0x1C0
	_          [12]byte
	TSL        volatile.Register32 // 0x1D0
	TN         volatile.Register32 // 0x1D4
	TA         volatile.Register32 // 0x1D8
	TI         volatile.Register32 // 0x1DC
	EFTSL      volatile.Register32 // 0x1E0
	EFTN       volatile.Register32 // 0x1E4
	EFRSL      volatile.Register32 // 0x1E8
	EFRN       volatile.Register32 // 0x1EC
	PEFTSL     volatile.Register32 // 0x1F0
	PEFTN      volatile.Register32 // 0x1F4
	PEFRSL     volatile.Register32 // 0x1F8
	PEFRN      volatile.Register32 // 0x1FC
	_          [112]byte
	RXLPI      volatile.Register32 // 0x270
	RXLPITIME  volatile.Register32 // 0x274
	TXLPI      volatile.Register32 // 0x278
	TXLPITIME  volatile.Register32 // 0x27C
	_          [384]byte
	ISRPQ      [5]volatile.Register32 // 0x400
	_          [44]byte
	TBQBAPQ    [5]volatile.Register32 // 0x440
	_          [44]byte
	RBQBAPQ    [5]volatile.Register32 // 0x480
	_          [12]byte
	RBSRPQ     [5]volatile.Register32 // 0x4A0
	_          [8]byte
	CBSCR      volatile.Register32 // 0x4BC
	CBSISQA    volatile.Register32 // 0x4C0
	CBSISQB    volatile.Register32 // 0x4C4
	_          [56]byte
	ST1RPQ     [4]volatile.Register32 // 0x500
	_          [48]byte
	ST2RPQ     [8]volatile.Register32 // 0x540
	_          [160]byte
	IERPQ      [5]volatile.Register32 // 0x600
	_          [12]byte
	IDRPQ      [5]volatile.Register32 // 0x620
	_          [12]byte
	IMRPQ      [5]volatile.Register32 // 0x640
	_          [140]byte
	ST2ER      [4]volatile.Register32 // 0x6E0
	_          [16]byte
	GMAC_ST2CW [24]GMAC_GMAC_ST2CW_Type // 0x700
}

// GMAC.NCR: Network Control Register
func (o *GMAC_Type) SetNCR_LBL(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetNCR_LBL() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetNCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetNCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetNCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetNCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetNCR_MPE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetNCR_MPE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetNCR_CLRSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetNCR_CLRSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetNCR_INCSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetNCR_INCSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetNCR_WESTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetNCR_WESTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetNCR_BP(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x100)|value<<8)
}
func (o *GMAC_Type) GetNCR_BP() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x100) >> 8
}
func (o *GMAC_Type) SetNCR_TSTART(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x200)|value<<9)
}
func (o *GMAC_Type) GetNCR_TSTART() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x200) >> 9
}
func (o *GMAC_Type) SetNCR_THALT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetNCR_THALT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetNCR_TXPF(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetNCR_TXPF() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetNCR_TXZQPF(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetNCR_TXZQPF() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetNCR_SRTSM(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x8000)|value<<15)
}
func (o *GMAC_Type) GetNCR_SRTSM() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x8000) >> 15
}
func (o *GMAC_Type) SetNCR_ENPBPR(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x10000)|value<<16)
}
func (o *GMAC_Type) GetNCR_ENPBPR() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x10000) >> 16
}
func (o *GMAC_Type) SetNCR_TXPBPF(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x20000)|value<<17)
}
func (o *GMAC_Type) GetNCR_TXPBPF() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x20000) >> 17
}
func (o *GMAC_Type) SetNCR_FNP(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetNCR_FNP() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetNCR_TXLPIEN(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetNCR_TXLPIEN() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x80000) >> 19
}

// GMAC.NCFGR: Network Configuration Register
func (o *GMAC_Type) SetNCFGR_SPD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetNCFGR_SPD() uint32 {
	return volatile.LoadUint32(&o.NCFGR.Reg) & 0x1
}
func (o *GMAC_Type) SetNCFGR_FD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetNCFGR_FD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetNCFGR_DNVLAN(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetNCFGR_DNVLAN() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetNCFGR_JFRAME(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetNCFGR_JFRAME() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetNCFGR_CAF(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetNCFGR_CAF() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetNCFGR_NBC(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetNCFGR_NBC() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetNCFGR_MTIHEN(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetNCFGR_MTIHEN() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetNCFGR_UNIHEN(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetNCFGR_UNIHEN() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetNCFGR_MAXFS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x100)|value<<8)
}
func (o *GMAC_Type) GetNCFGR_MAXFS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x100) >> 8
}
func (o *GMAC_Type) SetNCFGR_RTY(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetNCFGR_RTY() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetNCFGR_PEN(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetNCFGR_PEN() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetNCFGR_RXBUFO(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0xc000)|value<<14)
}
func (o *GMAC_Type) GetNCFGR_RXBUFO() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0xc000) >> 14
}
func (o *GMAC_Type) SetNCFGR_LFERD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *GMAC_Type) GetNCFGR_LFERD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10000) >> 16
}
func (o *GMAC_Type) SetNCFGR_RFCS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *GMAC_Type) GetNCFGR_RFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20000) >> 17
}
func (o *GMAC_Type) SetNCFGR_CLK(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1c0000)|value<<18)
}
func (o *GMAC_Type) GetNCFGR_CLK() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x1c0000) >> 18
}
func (o *GMAC_Type) SetNCFGR_DBW(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x600000)|value<<21)
}
func (o *GMAC_Type) GetNCFGR_DBW() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x600000) >> 21
}
func (o *GMAC_Type) SetNCFGR_DCPF(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetNCFGR_DCPF() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetNCFGR_RXCOEN(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetNCFGR_RXCOEN() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetNCFGR_EFRHD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetNCFGR_EFRHD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetNCFGR_IRXFCS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetNCFGR_IRXFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetNCFGR_IPGSEN(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetNCFGR_IPGSEN() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetNCFGR_RXBP(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetNCFGR_RXBP() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20000000) >> 29
}
func (o *GMAC_Type) SetNCFGR_IRXER(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x40000000)|value<<30)
}
func (o *GMAC_Type) GetNCFGR_IRXER() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x40000000) >> 30
}

// GMAC.NSR: Network Status Register
func (o *GMAC_Type) SetNSR_MDIO(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetNSR_MDIO() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetNSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetNSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetNSR_RXLPIS(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetNSR_RXLPIS() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x80) >> 7
}

// GMAC.UR: User Register
func (o *GMAC_Type) SetUR_RMII(value uint32) {
	volatile.StoreUint32(&o.UR.Reg, volatile.LoadUint32(&o.UR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetUR_RMII() uint32 {
	return volatile.LoadUint32(&o.UR.Reg) & 0x1
}

// GMAC.DCFGR: DMA Configuration Register
func (o *GMAC_Type) SetDCFGR_FBLDO(value uint32) {
	volatile.StoreUint32(&o.DCFGR.Reg, volatile.LoadUint32(&o.DCFGR.Reg)&^(0x1f)|value)
}
func (o *GMAC_Type) GetDCFGR_FBLDO() uint32 {
	return volatile.LoadUint32(&o.DCFGR.Reg) & 0x1f
}
func (o *GMAC_Type) SetDCFGR_ESMA(value uint32) {
	volatile.StoreUint32(&o.DCFGR.Reg, volatile.LoadUint32(&o.DCFGR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetDCFGR_ESMA() uint32 {
	return (volatile.LoadUint32(&o.DCFGR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetDCFGR_ESPA(value uint32) {
	volatile.StoreUint32(&o.DCFGR.Reg, volatile.LoadUint32(&o.DCFGR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetDCFGR_ESPA() uint32 {
	return (volatile.LoadUint32(&o.DCFGR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetDCFGR_RXBMS(value uint32) {
	volatile.StoreUint32(&o.DCFGR.Reg, volatile.LoadUint32(&o.DCFGR.Reg)&^(0x300)|value<<8)
}
func (o *GMAC_Type) GetDCFGR_RXBMS() uint32 {
	return (volatile.LoadUint32(&o.DCFGR.Reg) & 0x300) >> 8
}
func (o *GMAC_Type) SetDCFGR_TXPBMS(value uint32) {
	volatile.StoreUint32(&o.DCFGR.Reg, volatile.LoadUint32(&o.DCFGR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetDCFGR_TXPBMS() uint32 {
	return (volatile.LoadUint32(&o.DCFGR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetDCFGR_TXCOEN(value uint32) {
	volatile.StoreUint32(&o.DCFGR.Reg, volatile.LoadUint32(&o.DCFGR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetDCFGR_TXCOEN() uint32 {
	return (volatile.LoadUint32(&o.DCFGR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetDCFGR_DRBS(value uint32) {
	volatile.StoreUint32(&o.DCFGR.Reg, volatile.LoadUint32(&o.DCFGR.Reg)&^(0xff0000)|value<<16)
}
func (o *GMAC_Type) GetDCFGR_DRBS() uint32 {
	return (volatile.LoadUint32(&o.DCFGR.Reg) & 0xff0000) >> 16
}
func (o *GMAC_Type) SetDCFGR_DDRP(value uint32) {
	volatile.StoreUint32(&o.DCFGR.Reg, volatile.LoadUint32(&o.DCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetDCFGR_DDRP() uint32 {
	return (volatile.LoadUint32(&o.DCFGR.Reg) & 0x1000000) >> 24
}

// GMAC.TSR: Transmit Status Register
func (o *GMAC_Type) SetTSR_UBR(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetTSR_UBR() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}
func (o *GMAC_Type) SetTSR_COL(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetTSR_COL() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetTSR_RLE(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetTSR_RLE() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetTSR_TXGO(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetTSR_TXGO() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetTSR_TFC(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetTSR_TFC() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetTSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetTSR_TXCOMP() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetTSR_HRESP(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x100)|value<<8)
}
func (o *GMAC_Type) GetTSR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x100) >> 8
}

// GMAC.RBQB: Receive Buffer Queue Base Address Register
func (o *GMAC_Type) SetRBQB_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBQB.Reg, volatile.LoadUint32(&o.RBQB.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GMAC_Type) GetRBQB_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBQB.Reg) & 0xfffffffc) >> 2
}

// GMAC.TBQB: Transmit Buffer Queue Base Address Register
func (o *GMAC_Type) SetTBQB_ADDR(value uint32) {
	volatile.StoreUint32(&o.TBQB.Reg, volatile.LoadUint32(&o.TBQB.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GMAC_Type) GetTBQB_ADDR() uint32 {
	return (volatile.LoadUint32(&o.TBQB.Reg) & 0xfffffffc) >> 2
}

// GMAC.RSR: Receive Status Register
func (o *GMAC_Type) SetRSR_BNA(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetRSR_BNA() uint32 {
	return volatile.LoadUint32(&o.RSR.Reg) & 0x1
}
func (o *GMAC_Type) SetRSR_REC(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetRSR_REC() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetRSR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetRSR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetRSR_HNO(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetRSR_HNO() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x8) >> 3
}

// GMAC.ISR: Interrupt Status Register
func (o *GMAC_Type) SetISR_MFS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetISR_MFS() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *GMAC_Type) SetISR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetISR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetISR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetISR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetISR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetISR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetISR_TUR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetISR_TUR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetISR_RLEX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetISR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetISR_TFC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetISR_TFC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetISR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetISR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetISR_ROVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetISR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetISR_HRESP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetISR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetISR_PFNZ(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetISR_PFNZ() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetISR_PTZ(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetISR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetISR_PFTR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *GMAC_Type) GetISR_PFTR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *GMAC_Type) SetISR_DRQFR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetISR_DRQFR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetISR_SFR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetISR_SFR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *GMAC_Type) SetISR_DRQFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *GMAC_Type) GetISR_DRQFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *GMAC_Type) SetISR_SFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *GMAC_Type) GetISR_SFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *GMAC_Type) SetISR_PDRQFR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *GMAC_Type) GetISR_PDRQFR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *GMAC_Type) SetISR_PDRSFR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetISR_PDRSFR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetISR_PDRQFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetISR_PDRQFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetISR_PDRSFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetISR_PDRSFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetISR_SRI(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetISR_SRI() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetISR_RXLPISBC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *GMAC_Type) GetISR_RXLPISBC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *GMAC_Type) SetISR_WOL(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetISR_WOL() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetISR_TSUTIMCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetISR_TSUTIMCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}

// GMAC.IER: Interrupt Enable Register
func (o *GMAC_Type) SetIER_MFS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetIER_MFS() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *GMAC_Type) SetIER_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetIER_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetIER_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetIER_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetIER_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetIER_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetIER_TUR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetIER_TUR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetIER_RLEX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetIER_RLEX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetIER_TFC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetIER_TFC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetIER_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetIER_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetIER_ROVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetIER_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetIER_HRESP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetIER_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetIER_PFNZ(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetIER_PFNZ() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetIER_PTZ(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetIER_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetIER_PFTR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *GMAC_Type) GetIER_PFTR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *GMAC_Type) SetIER_EXINT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *GMAC_Type) GetIER_EXINT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *GMAC_Type) SetIER_DRQFR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetIER_DRQFR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetIER_SFR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetIER_SFR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *GMAC_Type) SetIER_DRQFT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *GMAC_Type) GetIER_DRQFT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *GMAC_Type) SetIER_SFT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *GMAC_Type) GetIER_SFT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *GMAC_Type) SetIER_PDRQFR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *GMAC_Type) GetIER_PDRQFR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *GMAC_Type) SetIER_PDRSFR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetIER_PDRSFR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetIER_PDRQFT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetIER_PDRQFT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetIER_PDRSFT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetIER_PDRSFT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetIER_SRI(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetIER_SRI() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetIER_RXLPISBC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *GMAC_Type) GetIER_RXLPISBC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *GMAC_Type) SetIER_WOL(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetIER_WOL() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetIER_TSUTIMCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetIER_TSUTIMCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}

// GMAC.IDR: Interrupt Disable Register
func (o *GMAC_Type) SetIDR_MFS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetIDR_MFS() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *GMAC_Type) SetIDR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetIDR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetIDR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetIDR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetIDR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetIDR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetIDR_TUR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetIDR_TUR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetIDR_RLEX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetIDR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetIDR_TFC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetIDR_TFC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetIDR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetIDR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetIDR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetIDR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetIDR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetIDR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetIDR_PFNZ(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetIDR_PFNZ() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetIDR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetIDR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetIDR_PFTR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GMAC_Type) GetIDR_PFTR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GMAC_Type) SetIDR_EXINT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GMAC_Type) GetIDR_EXINT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GMAC_Type) SetIDR_DRQFR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetIDR_DRQFR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetIDR_SFR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetIDR_SFR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *GMAC_Type) SetIDR_DRQFT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *GMAC_Type) GetIDR_DRQFT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *GMAC_Type) SetIDR_SFT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *GMAC_Type) GetIDR_SFT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *GMAC_Type) SetIDR_PDRQFR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *GMAC_Type) GetIDR_PDRQFR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *GMAC_Type) SetIDR_PDRSFR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetIDR_PDRSFR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetIDR_PDRQFT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetIDR_PDRQFT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetIDR_PDRSFT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetIDR_PDRSFT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetIDR_SRI(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetIDR_SRI() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetIDR_RXLPISBC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *GMAC_Type) GetIDR_RXLPISBC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *GMAC_Type) SetIDR_WOL(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetIDR_WOL() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetIDR_TSUTIMCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetIDR_TSUTIMCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}

// GMAC.IMR: Interrupt Mask Register
func (o *GMAC_Type) SetIMR_MFS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetIMR_MFS() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *GMAC_Type) SetIMR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetIMR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetIMR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetIMR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetIMR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetIMR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetIMR_TUR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetIMR_TUR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetIMR_RLEX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetIMR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetIMR_TFC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetIMR_TFC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetIMR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetIMR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetIMR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetIMR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetIMR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetIMR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetIMR_PFNZ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetIMR_PFNZ() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetIMR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetIMR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetIMR_PFTR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *GMAC_Type) GetIMR_PFTR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *GMAC_Type) SetIMR_EXINT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *GMAC_Type) GetIMR_EXINT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *GMAC_Type) SetIMR_DRQFR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetIMR_DRQFR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetIMR_SFR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetIMR_SFR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *GMAC_Type) SetIMR_DRQFT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *GMAC_Type) GetIMR_DRQFT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *GMAC_Type) SetIMR_SFT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *GMAC_Type) GetIMR_SFT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *GMAC_Type) SetIMR_PDRQFR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *GMAC_Type) GetIMR_PDRQFR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *GMAC_Type) SetIMR_PDRSFR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetIMR_PDRSFR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetIMR_PDRQFT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetIMR_PDRQFT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetIMR_PDRSFT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetIMR_PDRSFT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetIMR_SRI(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetIMR_SRI() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetIMR_RXLPISBC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *GMAC_Type) GetIMR_RXLPISBC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *GMAC_Type) SetIMR_WOL(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetIMR_WOL() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetIMR_TSUTIMCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetIMR_TSUTIMCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}

// GMAC.MAN: PHY Maintenance Register
func (o *GMAC_Type) SetMAN_DATA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetMAN_DATA() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xffff
}
func (o *GMAC_Type) SetMAN_WTN(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000)|value<<16)
}
func (o *GMAC_Type) GetMAN_WTN() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000) >> 16
}
func (o *GMAC_Type) SetMAN_REGA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x7c0000)|value<<18)
}
func (o *GMAC_Type) GetMAN_REGA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x7c0000) >> 18
}
func (o *GMAC_Type) SetMAN_PHYA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf800000)|value<<23)
}
func (o *GMAC_Type) GetMAN_PHYA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf800000) >> 23
}
func (o *GMAC_Type) SetMAN_OP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000000)|value<<28)
}
func (o *GMAC_Type) GetMAN_OP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000000) >> 28
}
func (o *GMAC_Type) SetMAN_CLTTO(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *GMAC_Type) GetMAN_CLTTO() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}
func (o *GMAC_Type) SetMAN_WZO(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetMAN_WZO() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x80000000) >> 31
}

// GMAC.RPQ: Received Pause Quantum Register
func (o *GMAC_Type) SetRPQ(value uint32) {
	volatile.StoreUint32(&o.RPQ.Reg, volatile.LoadUint32(&o.RPQ.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetRPQ() uint32 {
	return volatile.LoadUint32(&o.RPQ.Reg) & 0xffff
}

// GMAC.TPQ: Transmit Pause Quantum Register
func (o *GMAC_Type) SetTPQ(value uint32) {
	volatile.StoreUint32(&o.TPQ.Reg, volatile.LoadUint32(&o.TPQ.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetTPQ() uint32 {
	return volatile.LoadUint32(&o.TPQ.Reg) & 0xffff
}

// GMAC.TPSF: TX Partial Store and Forward Register
func (o *GMAC_Type) SetTPSF_TPB1ADR(value uint32) {
	volatile.StoreUint32(&o.TPSF.Reg, volatile.LoadUint32(&o.TPSF.Reg)&^(0xfff)|value)
}
func (o *GMAC_Type) GetTPSF_TPB1ADR() uint32 {
	return volatile.LoadUint32(&o.TPSF.Reg) & 0xfff
}
func (o *GMAC_Type) SetTPSF_ENTXP(value uint32) {
	volatile.StoreUint32(&o.TPSF.Reg, volatile.LoadUint32(&o.TPSF.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetTPSF_ENTXP() uint32 {
	return (volatile.LoadUint32(&o.TPSF.Reg) & 0x80000000) >> 31
}

// GMAC.RPSF: RX Partial Store and Forward Register
func (o *GMAC_Type) SetRPSF_RPB1ADR(value uint32) {
	volatile.StoreUint32(&o.RPSF.Reg, volatile.LoadUint32(&o.RPSF.Reg)&^(0xfff)|value)
}
func (o *GMAC_Type) GetRPSF_RPB1ADR() uint32 {
	return volatile.LoadUint32(&o.RPSF.Reg) & 0xfff
}
func (o *GMAC_Type) SetRPSF_ENRXP(value uint32) {
	volatile.StoreUint32(&o.RPSF.Reg, volatile.LoadUint32(&o.RPSF.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetRPSF_ENRXP() uint32 {
	return (volatile.LoadUint32(&o.RPSF.Reg) & 0x80000000) >> 31
}

// GMAC.RJFML: RX Jumbo Frame Max Length Register
func (o *GMAC_Type) SetRJFML_FML(value uint32) {
	volatile.StoreUint32(&o.RJFML.Reg, volatile.LoadUint32(&o.RJFML.Reg)&^(0x3fff)|value)
}
func (o *GMAC_Type) GetRJFML_FML() uint32 {
	return volatile.LoadUint32(&o.RJFML.Reg) & 0x3fff
}

// GMAC.HRB: Hash Register Bottom
func (o *GMAC_Type) SetHRB(value uint32) {
	volatile.StoreUint32(&o.HRB.Reg, value)
}
func (o *GMAC_Type) GetHRB() uint32 {
	return volatile.LoadUint32(&o.HRB.Reg)
}

// GMAC.HRT: Hash Register Top
func (o *GMAC_Type) SetHRT(value uint32) {
	volatile.StoreUint32(&o.HRT.Reg, value)
}
func (o *GMAC_Type) GetHRT() uint32 {
	return volatile.LoadUint32(&o.HRT.Reg)
}

// GMAC.TIDM1: Type ID Match 1 Register
func (o *GMAC_Type) SetTIDM1_TID(value uint32) {
	volatile.StoreUint32(&o.TIDM1.Reg, volatile.LoadUint32(&o.TIDM1.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetTIDM1_TID() uint32 {
	return volatile.LoadUint32(&o.TIDM1.Reg) & 0xffff
}
func (o *GMAC_Type) SetTIDM1_ENID1(value uint32) {
	volatile.StoreUint32(&o.TIDM1.Reg, volatile.LoadUint32(&o.TIDM1.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetTIDM1_ENID1() uint32 {
	return (volatile.LoadUint32(&o.TIDM1.Reg) & 0x80000000) >> 31
}

// GMAC.TIDM2: Type ID Match 2 Register
func (o *GMAC_Type) SetTIDM2_TID(value uint32) {
	volatile.StoreUint32(&o.TIDM2.Reg, volatile.LoadUint32(&o.TIDM2.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetTIDM2_TID() uint32 {
	return volatile.LoadUint32(&o.TIDM2.Reg) & 0xffff
}
func (o *GMAC_Type) SetTIDM2_ENID2(value uint32) {
	volatile.StoreUint32(&o.TIDM2.Reg, volatile.LoadUint32(&o.TIDM2.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetTIDM2_ENID2() uint32 {
	return (volatile.LoadUint32(&o.TIDM2.Reg) & 0x80000000) >> 31
}

// GMAC.TIDM3: Type ID Match 3 Register
func (o *GMAC_Type) SetTIDM3_TID(value uint32) {
	volatile.StoreUint32(&o.TIDM3.Reg, volatile.LoadUint32(&o.TIDM3.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetTIDM3_TID() uint32 {
	return volatile.LoadUint32(&o.TIDM3.Reg) & 0xffff
}
func (o *GMAC_Type) SetTIDM3_ENID3(value uint32) {
	volatile.StoreUint32(&o.TIDM3.Reg, volatile.LoadUint32(&o.TIDM3.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetTIDM3_ENID3() uint32 {
	return (volatile.LoadUint32(&o.TIDM3.Reg) & 0x80000000) >> 31
}

// GMAC.TIDM4: Type ID Match 4 Register
func (o *GMAC_Type) SetTIDM4_TID(value uint32) {
	volatile.StoreUint32(&o.TIDM4.Reg, volatile.LoadUint32(&o.TIDM4.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetTIDM4_TID() uint32 {
	return volatile.LoadUint32(&o.TIDM4.Reg) & 0xffff
}
func (o *GMAC_Type) SetTIDM4_ENID4(value uint32) {
	volatile.StoreUint32(&o.TIDM4.Reg, volatile.LoadUint32(&o.TIDM4.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetTIDM4_ENID4() uint32 {
	return (volatile.LoadUint32(&o.TIDM4.Reg) & 0x80000000) >> 31
}

// GMAC.WOL: Wake on LAN Register
func (o *GMAC_Type) SetWOL_IP(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetWOL_IP() uint32 {
	return volatile.LoadUint32(&o.WOL.Reg) & 0xffff
}
func (o *GMAC_Type) SetWOL_MAG(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0x10000)|value<<16)
}
func (o *GMAC_Type) GetWOL_MAG() uint32 {
	return (volatile.LoadUint32(&o.WOL.Reg) & 0x10000) >> 16
}
func (o *GMAC_Type) SetWOL_ARP(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0x20000)|value<<17)
}
func (o *GMAC_Type) GetWOL_ARP() uint32 {
	return (volatile.LoadUint32(&o.WOL.Reg) & 0x20000) >> 17
}
func (o *GMAC_Type) SetWOL_SA1(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetWOL_SA1() uint32 {
	return (volatile.LoadUint32(&o.WOL.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetWOL_MTI(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetWOL_MTI() uint32 {
	return (volatile.LoadUint32(&o.WOL.Reg) & 0x80000) >> 19
}

// GMAC.IPGS: IPG Stretch Register
func (o *GMAC_Type) SetIPGS_FL(value uint32) {
	volatile.StoreUint32(&o.IPGS.Reg, volatile.LoadUint32(&o.IPGS.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetIPGS_FL() uint32 {
	return volatile.LoadUint32(&o.IPGS.Reg) & 0xffff
}

// GMAC.SVLAN: Stacked VLAN Register
func (o *GMAC_Type) SetSVLAN_VLAN_TYPE(value uint32) {
	volatile.StoreUint32(&o.SVLAN.Reg, volatile.LoadUint32(&o.SVLAN.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetSVLAN_VLAN_TYPE() uint32 {
	return volatile.LoadUint32(&o.SVLAN.Reg) & 0xffff
}
func (o *GMAC_Type) SetSVLAN_ESVLAN(value uint32) {
	volatile.StoreUint32(&o.SVLAN.Reg, volatile.LoadUint32(&o.SVLAN.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetSVLAN_ESVLAN() uint32 {
	return (volatile.LoadUint32(&o.SVLAN.Reg) & 0x80000000) >> 31
}

// GMAC.TPFCP: Transmit PFC Pause Register
func (o *GMAC_Type) SetTPFCP_PEV(value uint32) {
	volatile.StoreUint32(&o.TPFCP.Reg, volatile.LoadUint32(&o.TPFCP.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetTPFCP_PEV() uint32 {
	return volatile.LoadUint32(&o.TPFCP.Reg) & 0xff
}
func (o *GMAC_Type) SetTPFCP_PQ(value uint32) {
	volatile.StoreUint32(&o.TPFCP.Reg, volatile.LoadUint32(&o.TPFCP.Reg)&^(0xff00)|value<<8)
}
func (o *GMAC_Type) GetTPFCP_PQ() uint32 {
	return (volatile.LoadUint32(&o.TPFCP.Reg) & 0xff00) >> 8
}

// GMAC.SAMB1: Specific Address 1 Mask Bottom Register
func (o *GMAC_Type) SetSAMB1(value uint32) {
	volatile.StoreUint32(&o.SAMB1.Reg, value)
}
func (o *GMAC_Type) GetSAMB1() uint32 {
	return volatile.LoadUint32(&o.SAMB1.Reg)
}

// GMAC.SAMT1: Specific Address 1 Mask Top Register
func (o *GMAC_Type) SetSAMT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.SAMT1.Reg, volatile.LoadUint32(&o.SAMT1.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetSAMT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.SAMT1.Reg) & 0xffff
}

// GMAC.NSC: 1588 Timer Nanosecond Comparison Register
func (o *GMAC_Type) SetNSC_NANOSEC(value uint32) {
	volatile.StoreUint32(&o.NSC.Reg, volatile.LoadUint32(&o.NSC.Reg)&^(0x3fffff)|value)
}
func (o *GMAC_Type) GetNSC_NANOSEC() uint32 {
	return volatile.LoadUint32(&o.NSC.Reg) & 0x3fffff
}

// GMAC.SCL: 1588 Timer Second Comparison Low Register
func (o *GMAC_Type) SetSCL(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, value)
}
func (o *GMAC_Type) GetSCL() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg)
}

// GMAC.SCH: 1588 Timer Second Comparison High Register
func (o *GMAC_Type) SetSCH_SEC(value uint32) {
	volatile.StoreUint32(&o.SCH.Reg, volatile.LoadUint32(&o.SCH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetSCH_SEC() uint32 {
	return volatile.LoadUint32(&o.SCH.Reg) & 0xffff
}

// GMAC.EFTSH: PTP Event Frame Transmitted Seconds High Register
func (o *GMAC_Type) SetEFTSH_RUD(value uint32) {
	volatile.StoreUint32(&o.EFTSH.Reg, volatile.LoadUint32(&o.EFTSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetEFTSH_RUD() uint32 {
	return volatile.LoadUint32(&o.EFTSH.Reg) & 0xffff
}

// GMAC.EFRSH: PTP Event Frame Received Seconds High Register
func (o *GMAC_Type) SetEFRSH_RUD(value uint32) {
	volatile.StoreUint32(&o.EFRSH.Reg, volatile.LoadUint32(&o.EFRSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetEFRSH_RUD() uint32 {
	return volatile.LoadUint32(&o.EFRSH.Reg) & 0xffff
}

// GMAC.PEFTSH: PTP Peer Event Frame Transmitted Seconds High Register
func (o *GMAC_Type) SetPEFTSH_RUD(value uint32) {
	volatile.StoreUint32(&o.PEFTSH.Reg, volatile.LoadUint32(&o.PEFTSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetPEFTSH_RUD() uint32 {
	return volatile.LoadUint32(&o.PEFTSH.Reg) & 0xffff
}

// GMAC.PEFRSH: PTP Peer Event Frame Received Seconds High Register
func (o *GMAC_Type) SetPEFRSH_RUD(value uint32) {
	volatile.StoreUint32(&o.PEFRSH.Reg, volatile.LoadUint32(&o.PEFRSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetPEFRSH_RUD() uint32 {
	return volatile.LoadUint32(&o.PEFRSH.Reg) & 0xffff
}

// GMAC.OTLO: Octets Transmitted Low Register
func (o *GMAC_Type) SetOTLO(value uint32) {
	volatile.StoreUint32(&o.OTLO.Reg, value)
}
func (o *GMAC_Type) GetOTLO() uint32 {
	return volatile.LoadUint32(&o.OTLO.Reg)
}

// GMAC.OTHI: Octets Transmitted High Register
func (o *GMAC_Type) SetOTHI_TXO(value uint32) {
	volatile.StoreUint32(&o.OTHI.Reg, volatile.LoadUint32(&o.OTHI.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetOTHI_TXO() uint32 {
	return volatile.LoadUint32(&o.OTHI.Reg) & 0xffff
}

// GMAC.FT: Frames Transmitted Register
func (o *GMAC_Type) SetFT(value uint32) {
	volatile.StoreUint32(&o.FT.Reg, value)
}
func (o *GMAC_Type) GetFT() uint32 {
	return volatile.LoadUint32(&o.FT.Reg)
}

// GMAC.BCFT: Broadcast Frames Transmitted Register
func (o *GMAC_Type) SetBCFT(value uint32) {
	volatile.StoreUint32(&o.BCFT.Reg, value)
}
func (o *GMAC_Type) GetBCFT() uint32 {
	return volatile.LoadUint32(&o.BCFT.Reg)
}

// GMAC.MFT: Multicast Frames Transmitted Register
func (o *GMAC_Type) SetMFT(value uint32) {
	volatile.StoreUint32(&o.MFT.Reg, value)
}
func (o *GMAC_Type) GetMFT() uint32 {
	return volatile.LoadUint32(&o.MFT.Reg)
}

// GMAC.PFT: Pause Frames Transmitted Register
func (o *GMAC_Type) SetPFT_PFTX(value uint32) {
	volatile.StoreUint32(&o.PFT.Reg, volatile.LoadUint32(&o.PFT.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetPFT_PFTX() uint32 {
	return volatile.LoadUint32(&o.PFT.Reg) & 0xffff
}

// GMAC.BFT64: 64 Byte Frames Transmitted Register
func (o *GMAC_Type) SetBFT64(value uint32) {
	volatile.StoreUint32(&o.BFT64.Reg, value)
}
func (o *GMAC_Type) GetBFT64() uint32 {
	return volatile.LoadUint32(&o.BFT64.Reg)
}

// GMAC.TBFT127: 65 to 127 Byte Frames Transmitted Register
func (o *GMAC_Type) SetTBFT127(value uint32) {
	volatile.StoreUint32(&o.TBFT127.Reg, value)
}
func (o *GMAC_Type) GetTBFT127() uint32 {
	return volatile.LoadUint32(&o.TBFT127.Reg)
}

// GMAC.TBFT255: 128 to 255 Byte Frames Transmitted Register
func (o *GMAC_Type) SetTBFT255(value uint32) {
	volatile.StoreUint32(&o.TBFT255.Reg, value)
}
func (o *GMAC_Type) GetTBFT255() uint32 {
	return volatile.LoadUint32(&o.TBFT255.Reg)
}

// GMAC.TBFT511: 256 to 511 Byte Frames Transmitted Register
func (o *GMAC_Type) SetTBFT511(value uint32) {
	volatile.StoreUint32(&o.TBFT511.Reg, value)
}
func (o *GMAC_Type) GetTBFT511() uint32 {
	return volatile.LoadUint32(&o.TBFT511.Reg)
}

// GMAC.TBFT1023: 512 to 1023 Byte Frames Transmitted Register
func (o *GMAC_Type) SetTBFT1023(value uint32) {
	volatile.StoreUint32(&o.TBFT1023.Reg, value)
}
func (o *GMAC_Type) GetTBFT1023() uint32 {
	return volatile.LoadUint32(&o.TBFT1023.Reg)
}

// GMAC.TBFT1518: 1024 to 1518 Byte Frames Transmitted Register
func (o *GMAC_Type) SetTBFT1518(value uint32) {
	volatile.StoreUint32(&o.TBFT1518.Reg, value)
}
func (o *GMAC_Type) GetTBFT1518() uint32 {
	return volatile.LoadUint32(&o.TBFT1518.Reg)
}

// GMAC.GTBFT1518: Greater Than 1518 Byte Frames Transmitted Register
func (o *GMAC_Type) SetGTBFT1518(value uint32) {
	volatile.StoreUint32(&o.GTBFT1518.Reg, value)
}
func (o *GMAC_Type) GetGTBFT1518() uint32 {
	return volatile.LoadUint32(&o.GTBFT1518.Reg)
}

// GMAC.TUR: Transmit Underruns Register
func (o *GMAC_Type) SetTUR_TXUNR(value uint32) {
	volatile.StoreUint32(&o.TUR.Reg, volatile.LoadUint32(&o.TUR.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetTUR_TXUNR() uint32 {
	return volatile.LoadUint32(&o.TUR.Reg) & 0x3ff
}

// GMAC.SCF: Single Collision Frames Register
func (o *GMAC_Type) SetSCF_SCOL(value uint32) {
	volatile.StoreUint32(&o.SCF.Reg, volatile.LoadUint32(&o.SCF.Reg)&^(0x3ffff)|value)
}
func (o *GMAC_Type) GetSCF_SCOL() uint32 {
	return volatile.LoadUint32(&o.SCF.Reg) & 0x3ffff
}

// GMAC.MCF: Multiple Collision Frames Register
func (o *GMAC_Type) SetMCF_MCOL(value uint32) {
	volatile.StoreUint32(&o.MCF.Reg, volatile.LoadUint32(&o.MCF.Reg)&^(0x3ffff)|value)
}
func (o *GMAC_Type) GetMCF_MCOL() uint32 {
	return volatile.LoadUint32(&o.MCF.Reg) & 0x3ffff
}

// GMAC.EC: Excessive Collisions Register
func (o *GMAC_Type) SetEC_XCOL(value uint32) {
	volatile.StoreUint32(&o.EC.Reg, volatile.LoadUint32(&o.EC.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetEC_XCOL() uint32 {
	return volatile.LoadUint32(&o.EC.Reg) & 0x3ff
}

// GMAC.LC: Late Collisions Register
func (o *GMAC_Type) SetLC_LCOL(value uint32) {
	volatile.StoreUint32(&o.LC.Reg, volatile.LoadUint32(&o.LC.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetLC_LCOL() uint32 {
	return volatile.LoadUint32(&o.LC.Reg) & 0x3ff
}

// GMAC.DTF: Deferred Transmission Frames Register
func (o *GMAC_Type) SetDTF_DEFT(value uint32) {
	volatile.StoreUint32(&o.DTF.Reg, volatile.LoadUint32(&o.DTF.Reg)&^(0x3ffff)|value)
}
func (o *GMAC_Type) GetDTF_DEFT() uint32 {
	return volatile.LoadUint32(&o.DTF.Reg) & 0x3ffff
}

// GMAC.CSE: Carrier Sense Errors Register
func (o *GMAC_Type) SetCSE_CSR(value uint32) {
	volatile.StoreUint32(&o.CSE.Reg, volatile.LoadUint32(&o.CSE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetCSE_CSR() uint32 {
	return volatile.LoadUint32(&o.CSE.Reg) & 0x3ff
}

// GMAC.ORLO: Octets Received Low Received Register
func (o *GMAC_Type) SetORLO(value uint32) {
	volatile.StoreUint32(&o.ORLO.Reg, value)
}
func (o *GMAC_Type) GetORLO() uint32 {
	return volatile.LoadUint32(&o.ORLO.Reg)
}

// GMAC.ORHI: Octets Received High Received Register
func (o *GMAC_Type) SetORHI_RXO(value uint32) {
	volatile.StoreUint32(&o.ORHI.Reg, volatile.LoadUint32(&o.ORHI.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetORHI_RXO() uint32 {
	return volatile.LoadUint32(&o.ORHI.Reg) & 0xffff
}

// GMAC.FR: Frames Received Register
func (o *GMAC_Type) SetFR(value uint32) {
	volatile.StoreUint32(&o.FR.Reg, value)
}
func (o *GMAC_Type) GetFR() uint32 {
	return volatile.LoadUint32(&o.FR.Reg)
}

// GMAC.BCFR: Broadcast Frames Received Register
func (o *GMAC_Type) SetBCFR(value uint32) {
	volatile.StoreUint32(&o.BCFR.Reg, value)
}
func (o *GMAC_Type) GetBCFR() uint32 {
	return volatile.LoadUint32(&o.BCFR.Reg)
}

// GMAC.MFR: Multicast Frames Received Register
func (o *GMAC_Type) SetMFR(value uint32) {
	volatile.StoreUint32(&o.MFR.Reg, value)
}
func (o *GMAC_Type) GetMFR() uint32 {
	return volatile.LoadUint32(&o.MFR.Reg)
}

// GMAC.PFR: Pause Frames Received Register
func (o *GMAC_Type) SetPFR_PFRX(value uint32) {
	volatile.StoreUint32(&o.PFR.Reg, volatile.LoadUint32(&o.PFR.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetPFR_PFRX() uint32 {
	return volatile.LoadUint32(&o.PFR.Reg) & 0xffff
}

// GMAC.BFR64: 64 Byte Frames Received Register
func (o *GMAC_Type) SetBFR64(value uint32) {
	volatile.StoreUint32(&o.BFR64.Reg, value)
}
func (o *GMAC_Type) GetBFR64() uint32 {
	return volatile.LoadUint32(&o.BFR64.Reg)
}

// GMAC.TBFR127: 65 to 127 Byte Frames Received Register
func (o *GMAC_Type) SetTBFR127(value uint32) {
	volatile.StoreUint32(&o.TBFR127.Reg, value)
}
func (o *GMAC_Type) GetTBFR127() uint32 {
	return volatile.LoadUint32(&o.TBFR127.Reg)
}

// GMAC.TBFR255: 128 to 255 Byte Frames Received Register
func (o *GMAC_Type) SetTBFR255(value uint32) {
	volatile.StoreUint32(&o.TBFR255.Reg, value)
}
func (o *GMAC_Type) GetTBFR255() uint32 {
	return volatile.LoadUint32(&o.TBFR255.Reg)
}

// GMAC.TBFR511: 256 to 511 Byte Frames Received Register
func (o *GMAC_Type) SetTBFR511(value uint32) {
	volatile.StoreUint32(&o.TBFR511.Reg, value)
}
func (o *GMAC_Type) GetTBFR511() uint32 {
	return volatile.LoadUint32(&o.TBFR511.Reg)
}

// GMAC.TBFR1023: 512 to 1023 Byte Frames Received Register
func (o *GMAC_Type) SetTBFR1023(value uint32) {
	volatile.StoreUint32(&o.TBFR1023.Reg, value)
}
func (o *GMAC_Type) GetTBFR1023() uint32 {
	return volatile.LoadUint32(&o.TBFR1023.Reg)
}

// GMAC.TBFR1518: 1024 to 1518 Byte Frames Received Register
func (o *GMAC_Type) SetTBFR1518(value uint32) {
	volatile.StoreUint32(&o.TBFR1518.Reg, value)
}
func (o *GMAC_Type) GetTBFR1518() uint32 {
	return volatile.LoadUint32(&o.TBFR1518.Reg)
}

// GMAC.TMXBFR: 1519 to Maximum Byte Frames Received Register
func (o *GMAC_Type) SetTMXBFR(value uint32) {
	volatile.StoreUint32(&o.TMXBFR.Reg, value)
}
func (o *GMAC_Type) GetTMXBFR() uint32 {
	return volatile.LoadUint32(&o.TMXBFR.Reg)
}

// GMAC.UFR: Undersize Frames Received Register
func (o *GMAC_Type) SetUFR_UFRX(value uint32) {
	volatile.StoreUint32(&o.UFR.Reg, volatile.LoadUint32(&o.UFR.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetUFR_UFRX() uint32 {
	return volatile.LoadUint32(&o.UFR.Reg) & 0x3ff
}

// GMAC.OFR: Oversize Frames Received Register
func (o *GMAC_Type) SetOFR_OFRX(value uint32) {
	volatile.StoreUint32(&o.OFR.Reg, volatile.LoadUint32(&o.OFR.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetOFR_OFRX() uint32 {
	return volatile.LoadUint32(&o.OFR.Reg) & 0x3ff
}

// GMAC.JR: Jabbers Received Register
func (o *GMAC_Type) SetJR_JRX(value uint32) {
	volatile.StoreUint32(&o.JR.Reg, volatile.LoadUint32(&o.JR.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetJR_JRX() uint32 {
	return volatile.LoadUint32(&o.JR.Reg) & 0x3ff
}

// GMAC.FCSE: Frame Check Sequence Errors Register
func (o *GMAC_Type) SetFCSE_FCKR(value uint32) {
	volatile.StoreUint32(&o.FCSE.Reg, volatile.LoadUint32(&o.FCSE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetFCSE_FCKR() uint32 {
	return volatile.LoadUint32(&o.FCSE.Reg) & 0x3ff
}

// GMAC.LFFE: Length Field Frame Errors Register
func (o *GMAC_Type) SetLFFE_LFER(value uint32) {
	volatile.StoreUint32(&o.LFFE.Reg, volatile.LoadUint32(&o.LFFE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetLFFE_LFER() uint32 {
	return volatile.LoadUint32(&o.LFFE.Reg) & 0x3ff
}

// GMAC.RSE: Receive Symbol Errors Register
func (o *GMAC_Type) SetRSE_RXSE(value uint32) {
	volatile.StoreUint32(&o.RSE.Reg, volatile.LoadUint32(&o.RSE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetRSE_RXSE() uint32 {
	return volatile.LoadUint32(&o.RSE.Reg) & 0x3ff
}

// GMAC.AE: Alignment Errors Register
func (o *GMAC_Type) SetAE_AER(value uint32) {
	volatile.StoreUint32(&o.AE.Reg, volatile.LoadUint32(&o.AE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetAE_AER() uint32 {
	return volatile.LoadUint32(&o.AE.Reg) & 0x3ff
}

// GMAC.RRE: Receive Resource Errors Register
func (o *GMAC_Type) SetRRE_RXRER(value uint32) {
	volatile.StoreUint32(&o.RRE.Reg, volatile.LoadUint32(&o.RRE.Reg)&^(0x3ffff)|value)
}
func (o *GMAC_Type) GetRRE_RXRER() uint32 {
	return volatile.LoadUint32(&o.RRE.Reg) & 0x3ffff
}

// GMAC.ROE: Receive Overrun Register
func (o *GMAC_Type) SetROE_RXOVR(value uint32) {
	volatile.StoreUint32(&o.ROE.Reg, volatile.LoadUint32(&o.ROE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetROE_RXOVR() uint32 {
	return volatile.LoadUint32(&o.ROE.Reg) & 0x3ff
}

// GMAC.IHCE: IP Header Checksum Errors Register
func (o *GMAC_Type) SetIHCE_HCKER(value uint32) {
	volatile.StoreUint32(&o.IHCE.Reg, volatile.LoadUint32(&o.IHCE.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetIHCE_HCKER() uint32 {
	return volatile.LoadUint32(&o.IHCE.Reg) & 0xff
}

// GMAC.TCE: TCP Checksum Errors Register
func (o *GMAC_Type) SetTCE_TCKER(value uint32) {
	volatile.StoreUint32(&o.TCE.Reg, volatile.LoadUint32(&o.TCE.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetTCE_TCKER() uint32 {
	return volatile.LoadUint32(&o.TCE.Reg) & 0xff
}

// GMAC.UCE: UDP Checksum Errors Register
func (o *GMAC_Type) SetUCE_UCKER(value uint32) {
	volatile.StoreUint32(&o.UCE.Reg, volatile.LoadUint32(&o.UCE.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetUCE_UCKER() uint32 {
	return volatile.LoadUint32(&o.UCE.Reg) & 0xff
}

// GMAC.TISUBN: 1588 Timer Increment Sub-nanoseconds Register
func (o *GMAC_Type) SetTISUBN_LSBTIR(value uint32) {
	volatile.StoreUint32(&o.TISUBN.Reg, volatile.LoadUint32(&o.TISUBN.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetTISUBN_LSBTIR() uint32 {
	return volatile.LoadUint32(&o.TISUBN.Reg) & 0xffff
}

// GMAC.TSH: 1588 Timer Seconds High Register
func (o *GMAC_Type) SetTSH_TCS(value uint32) {
	volatile.StoreUint32(&o.TSH.Reg, volatile.LoadUint32(&o.TSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetTSH_TCS() uint32 {
	return volatile.LoadUint32(&o.TSH.Reg) & 0xffff
}

// GMAC.TSL: 1588 Timer Seconds Low Register
func (o *GMAC_Type) SetTSL(value uint32) {
	volatile.StoreUint32(&o.TSL.Reg, value)
}
func (o *GMAC_Type) GetTSL() uint32 {
	return volatile.LoadUint32(&o.TSL.Reg)
}

// GMAC.TN: 1588 Timer Nanoseconds Register
func (o *GMAC_Type) SetTN_TNS(value uint32) {
	volatile.StoreUint32(&o.TN.Reg, volatile.LoadUint32(&o.TN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetTN_TNS() uint32 {
	return volatile.LoadUint32(&o.TN.Reg) & 0x3fffffff
}

// GMAC.TA: 1588 Timer Adjust Register
func (o *GMAC_Type) SetTA_ITDT(value uint32) {
	volatile.StoreUint32(&o.TA.Reg, volatile.LoadUint32(&o.TA.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetTA_ITDT() uint32 {
	return volatile.LoadUint32(&o.TA.Reg) & 0x3fffffff
}
func (o *GMAC_Type) SetTA_ADJ(value uint32) {
	volatile.StoreUint32(&o.TA.Reg, volatile.LoadUint32(&o.TA.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetTA_ADJ() uint32 {
	return (volatile.LoadUint32(&o.TA.Reg) & 0x80000000) >> 31
}

// GMAC.TI: 1588 Timer Increment Register
func (o *GMAC_Type) SetTI_CNS(value uint32) {
	volatile.StoreUint32(&o.TI.Reg, volatile.LoadUint32(&o.TI.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetTI_CNS() uint32 {
	return volatile.LoadUint32(&o.TI.Reg) & 0xff
}
func (o *GMAC_Type) SetTI_ACNS(value uint32) {
	volatile.StoreUint32(&o.TI.Reg, volatile.LoadUint32(&o.TI.Reg)&^(0xff00)|value<<8)
}
func (o *GMAC_Type) GetTI_ACNS() uint32 {
	return (volatile.LoadUint32(&o.TI.Reg) & 0xff00) >> 8
}
func (o *GMAC_Type) SetTI_NIT(value uint32) {
	volatile.StoreUint32(&o.TI.Reg, volatile.LoadUint32(&o.TI.Reg)&^(0xff0000)|value<<16)
}
func (o *GMAC_Type) GetTI_NIT() uint32 {
	return (volatile.LoadUint32(&o.TI.Reg) & 0xff0000) >> 16
}

// GMAC.EFTSL: PTP Event Frame Transmitted Seconds Low Register
func (o *GMAC_Type) SetEFTSL(value uint32) {
	volatile.StoreUint32(&o.EFTSL.Reg, value)
}
func (o *GMAC_Type) GetEFTSL() uint32 {
	return volatile.LoadUint32(&o.EFTSL.Reg)
}

// GMAC.EFTN: PTP Event Frame Transmitted Nanoseconds Register
func (o *GMAC_Type) SetEFTN_RUD(value uint32) {
	volatile.StoreUint32(&o.EFTN.Reg, volatile.LoadUint32(&o.EFTN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetEFTN_RUD() uint32 {
	return volatile.LoadUint32(&o.EFTN.Reg) & 0x3fffffff
}

// GMAC.EFRSL: PTP Event Frame Received Seconds Low Register
func (o *GMAC_Type) SetEFRSL(value uint32) {
	volatile.StoreUint32(&o.EFRSL.Reg, value)
}
func (o *GMAC_Type) GetEFRSL() uint32 {
	return volatile.LoadUint32(&o.EFRSL.Reg)
}

// GMAC.EFRN: PTP Event Frame Received Nanoseconds Register
func (o *GMAC_Type) SetEFRN_RUD(value uint32) {
	volatile.StoreUint32(&o.EFRN.Reg, volatile.LoadUint32(&o.EFRN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetEFRN_RUD() uint32 {
	return volatile.LoadUint32(&o.EFRN.Reg) & 0x3fffffff
}

// GMAC.PEFTSL: PTP Peer Event Frame Transmitted Seconds Low Register
func (o *GMAC_Type) SetPEFTSL(value uint32) {
	volatile.StoreUint32(&o.PEFTSL.Reg, value)
}
func (o *GMAC_Type) GetPEFTSL() uint32 {
	return volatile.LoadUint32(&o.PEFTSL.Reg)
}

// GMAC.PEFTN: PTP Peer Event Frame Transmitted Nanoseconds Register
func (o *GMAC_Type) SetPEFTN_RUD(value uint32) {
	volatile.StoreUint32(&o.PEFTN.Reg, volatile.LoadUint32(&o.PEFTN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetPEFTN_RUD() uint32 {
	return volatile.LoadUint32(&o.PEFTN.Reg) & 0x3fffffff
}

// GMAC.PEFRSL: PTP Peer Event Frame Received Seconds Low Register
func (o *GMAC_Type) SetPEFRSL(value uint32) {
	volatile.StoreUint32(&o.PEFRSL.Reg, value)
}
func (o *GMAC_Type) GetPEFRSL() uint32 {
	return volatile.LoadUint32(&o.PEFRSL.Reg)
}

// GMAC.PEFRN: PTP Peer Event Frame Received Nanoseconds Register
func (o *GMAC_Type) SetPEFRN_RUD(value uint32) {
	volatile.StoreUint32(&o.PEFRN.Reg, volatile.LoadUint32(&o.PEFRN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetPEFRN_RUD() uint32 {
	return volatile.LoadUint32(&o.PEFRN.Reg) & 0x3fffffff
}

// GMAC.RXLPI: Received LPI Transitions
func (o *GMAC_Type) SetRXLPI_COUNT(value uint32) {
	volatile.StoreUint32(&o.RXLPI.Reg, volatile.LoadUint32(&o.RXLPI.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetRXLPI_COUNT() uint32 {
	return volatile.LoadUint32(&o.RXLPI.Reg) & 0xffff
}

// GMAC.RXLPITIME: Received LPI Time
func (o *GMAC_Type) SetRXLPITIME_LPITIME(value uint32) {
	volatile.StoreUint32(&o.RXLPITIME.Reg, volatile.LoadUint32(&o.RXLPITIME.Reg)&^(0xffffff)|value)
}
func (o *GMAC_Type) GetRXLPITIME_LPITIME() uint32 {
	return volatile.LoadUint32(&o.RXLPITIME.Reg) & 0xffffff
}

// GMAC.TXLPI: Transmit LPI Transitions
func (o *GMAC_Type) SetTXLPI_COUNT(value uint32) {
	volatile.StoreUint32(&o.TXLPI.Reg, volatile.LoadUint32(&o.TXLPI.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetTXLPI_COUNT() uint32 {
	return volatile.LoadUint32(&o.TXLPI.Reg) & 0xffff
}

// GMAC.TXLPITIME: Transmit LPI Time
func (o *GMAC_Type) SetTXLPITIME_LPITIME(value uint32) {
	volatile.StoreUint32(&o.TXLPITIME.Reg, volatile.LoadUint32(&o.TXLPITIME.Reg)&^(0xffffff)|value)
}
func (o *GMAC_Type) GetTXLPITIME_LPITIME() uint32 {
	return volatile.LoadUint32(&o.TXLPITIME.Reg) & 0xffffff
}

// GMAC.ISRPQ: Interrupt Status Register Priority Queue (1..5)
func (o *GMAC_Type) SetISRPQ_RCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.ISRPQ[idx].Reg, volatile.LoadUint32(&o.ISRPQ[idx].Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetISRPQ_RCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.ISRPQ[idx].Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetISRPQ_RXUBR(idx int, value uint32) {
	volatile.StoreUint32(&o.ISRPQ[idx].Reg, volatile.LoadUint32(&o.ISRPQ[idx].Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetISRPQ_RXUBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.ISRPQ[idx].Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetISRPQ_RLEX(idx int, value uint32) {
	volatile.StoreUint32(&o.ISRPQ[idx].Reg, volatile.LoadUint32(&o.ISRPQ[idx].Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetISRPQ_RLEX(idx int) uint32 {
	return (volatile.LoadUint32(&o.ISRPQ[idx].Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetISRPQ_TFC(idx int, value uint32) {
	volatile.StoreUint32(&o.ISRPQ[idx].Reg, volatile.LoadUint32(&o.ISRPQ[idx].Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetISRPQ_TFC(idx int) uint32 {
	return (volatile.LoadUint32(&o.ISRPQ[idx].Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetISRPQ_TCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.ISRPQ[idx].Reg, volatile.LoadUint32(&o.ISRPQ[idx].Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetISRPQ_TCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.ISRPQ[idx].Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetISRPQ_ROVR(idx int, value uint32) {
	volatile.StoreUint32(&o.ISRPQ[idx].Reg, volatile.LoadUint32(&o.ISRPQ[idx].Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetISRPQ_ROVR(idx int) uint32 {
	return (volatile.LoadUint32(&o.ISRPQ[idx].Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetISRPQ_HRESP(idx int, value uint32) {
	volatile.StoreUint32(&o.ISRPQ[idx].Reg, volatile.LoadUint32(&o.ISRPQ[idx].Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetISRPQ_HRESP(idx int) uint32 {
	return (volatile.LoadUint32(&o.ISRPQ[idx].Reg) & 0x800) >> 11
}

// GMAC.TBQBAPQ: Transmit Buffer Queue Base Address Register Priority Queue (1..5)
func (o *GMAC_Type) SetTBQBAPQ_TXBQBA(idx int, value uint32) {
	volatile.StoreUint32(&o.TBQBAPQ[idx].Reg, volatile.LoadUint32(&o.TBQBAPQ[idx].Reg)&^(0xfffffffc)|value<<2)
}
func (o *GMAC_Type) GetTBQBAPQ_TXBQBA(idx int) uint32 {
	return (volatile.LoadUint32(&o.TBQBAPQ[idx].Reg) & 0xfffffffc) >> 2
}

// GMAC.RBQBAPQ: Receive Buffer Queue Base Address Register Priority Queue (1..5)
func (o *GMAC_Type) SetRBQBAPQ_RXBQBA(idx int, value uint32) {
	volatile.StoreUint32(&o.RBQBAPQ[idx].Reg, volatile.LoadUint32(&o.RBQBAPQ[idx].Reg)&^(0xfffffffc)|value<<2)
}
func (o *GMAC_Type) GetRBQBAPQ_RXBQBA(idx int) uint32 {
	return (volatile.LoadUint32(&o.RBQBAPQ[idx].Reg) & 0xfffffffc) >> 2
}

// GMAC.RBSRPQ: Receive Buffer Size Register Priority Queue (1..5)
func (o *GMAC_Type) SetRBSRPQ_RBS(idx int, value uint32) {
	volatile.StoreUint32(&o.RBSRPQ[idx].Reg, volatile.LoadUint32(&o.RBSRPQ[idx].Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetRBSRPQ_RBS(idx int) uint32 {
	return volatile.LoadUint32(&o.RBSRPQ[idx].Reg) & 0xffff
}

// GMAC.CBSCR: Credit-Based Shaping Control Register
func (o *GMAC_Type) SetCBSCR_QBE(value uint32) {
	volatile.StoreUint32(&o.CBSCR.Reg, volatile.LoadUint32(&o.CBSCR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetCBSCR_QBE() uint32 {
	return volatile.LoadUint32(&o.CBSCR.Reg) & 0x1
}
func (o *GMAC_Type) SetCBSCR_QAE(value uint32) {
	volatile.StoreUint32(&o.CBSCR.Reg, volatile.LoadUint32(&o.CBSCR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetCBSCR_QAE() uint32 {
	return (volatile.LoadUint32(&o.CBSCR.Reg) & 0x2) >> 1
}

// GMAC.CBSISQA: Credit-Based Shaping IdleSlope Register for Queue A
func (o *GMAC_Type) SetCBSISQA(value uint32) {
	volatile.StoreUint32(&o.CBSISQA.Reg, value)
}
func (o *GMAC_Type) GetCBSISQA() uint32 {
	return volatile.LoadUint32(&o.CBSISQA.Reg)
}

// GMAC.CBSISQB: Credit-Based Shaping IdleSlope Register for Queue B
func (o *GMAC_Type) SetCBSISQB(value uint32) {
	volatile.StoreUint32(&o.CBSISQB.Reg, value)
}
func (o *GMAC_Type) GetCBSISQB() uint32 {
	return volatile.LoadUint32(&o.CBSISQB.Reg)
}

// GMAC.ST1RPQ: Screening Type 1 Register Priority Queue
func (o *GMAC_Type) SetST1RPQ_QNB(idx int, value uint32) {
	volatile.StoreUint32(&o.ST1RPQ[idx].Reg, volatile.LoadUint32(&o.ST1RPQ[idx].Reg)&^(0x7)|value)
}
func (o *GMAC_Type) GetST1RPQ_QNB(idx int) uint32 {
	return volatile.LoadUint32(&o.ST1RPQ[idx].Reg) & 0x7
}
func (o *GMAC_Type) SetST1RPQ_DSTCM(idx int, value uint32) {
	volatile.StoreUint32(&o.ST1RPQ[idx].Reg, volatile.LoadUint32(&o.ST1RPQ[idx].Reg)&^(0xff0)|value<<4)
}
func (o *GMAC_Type) GetST1RPQ_DSTCM(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST1RPQ[idx].Reg) & 0xff0) >> 4
}
func (o *GMAC_Type) SetST1RPQ_UDPM(idx int, value uint32) {
	volatile.StoreUint32(&o.ST1RPQ[idx].Reg, volatile.LoadUint32(&o.ST1RPQ[idx].Reg)&^(0xffff000)|value<<12)
}
func (o *GMAC_Type) GetST1RPQ_UDPM(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST1RPQ[idx].Reg) & 0xffff000) >> 12
}
func (o *GMAC_Type) SetST1RPQ_DSTCE(idx int, value uint32) {
	volatile.StoreUint32(&o.ST1RPQ[idx].Reg, volatile.LoadUint32(&o.ST1RPQ[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetST1RPQ_DSTCE(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST1RPQ[idx].Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetST1RPQ_UDPE(idx int, value uint32) {
	volatile.StoreUint32(&o.ST1RPQ[idx].Reg, volatile.LoadUint32(&o.ST1RPQ[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetST1RPQ_UDPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST1RPQ[idx].Reg) & 0x20000000) >> 29
}

// GMAC.ST2RPQ: Screening Type 2 Register Priority Queue
func (o *GMAC_Type) SetST2RPQ_QNB(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x7)|value)
}
func (o *GMAC_Type) GetST2RPQ_QNB(idx int) uint32 {
	return volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x7
}
func (o *GMAC_Type) SetST2RPQ_VLANP(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x70)|value<<4)
}
func (o *GMAC_Type) GetST2RPQ_VLANP(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x70) >> 4
}
func (o *GMAC_Type) SetST2RPQ_VLANE(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x100)|value<<8)
}
func (o *GMAC_Type) GetST2RPQ_VLANE(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x100) >> 8
}
func (o *GMAC_Type) SetST2RPQ_I2ETH(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0xe00)|value<<9)
}
func (o *GMAC_Type) GetST2RPQ_I2ETH(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0xe00) >> 9
}
func (o *GMAC_Type) SetST2RPQ_ETHE(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetST2RPQ_ETHE(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetST2RPQ_COMPA(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x3e000)|value<<13)
}
func (o *GMAC_Type) GetST2RPQ_COMPA(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x3e000) >> 13
}
func (o *GMAC_Type) SetST2RPQ_COMPAE(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetST2RPQ_COMPAE(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetST2RPQ_COMPB(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0xf80000)|value<<19)
}
func (o *GMAC_Type) GetST2RPQ_COMPB(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0xf80000) >> 19
}
func (o *GMAC_Type) SetST2RPQ_COMPBE(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetST2RPQ_COMPBE(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetST2RPQ_COMPC(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x3e000000)|value<<25)
}
func (o *GMAC_Type) GetST2RPQ_COMPC(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x3e000000) >> 25
}
func (o *GMAC_Type) SetST2RPQ_COMPCE(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2RPQ[idx].Reg, volatile.LoadUint32(&o.ST2RPQ[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GMAC_Type) GetST2RPQ_COMPCE(idx int) uint32 {
	return (volatile.LoadUint32(&o.ST2RPQ[idx].Reg) & 0x40000000) >> 30
}

// GMAC.IERPQ: Interrupt Enable Register Priority Queue (1..5)
func (o *GMAC_Type) SetIERPQ_RCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.IERPQ[idx].Reg, volatile.LoadUint32(&o.IERPQ[idx].Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetIERPQ_RCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IERPQ[idx].Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetIERPQ_RXUBR(idx int, value uint32) {
	volatile.StoreUint32(&o.IERPQ[idx].Reg, volatile.LoadUint32(&o.IERPQ[idx].Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetIERPQ_RXUBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.IERPQ[idx].Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetIERPQ_RLEX(idx int, value uint32) {
	volatile.StoreUint32(&o.IERPQ[idx].Reg, volatile.LoadUint32(&o.IERPQ[idx].Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetIERPQ_RLEX(idx int) uint32 {
	return (volatile.LoadUint32(&o.IERPQ[idx].Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetIERPQ_TFC(idx int, value uint32) {
	volatile.StoreUint32(&o.IERPQ[idx].Reg, volatile.LoadUint32(&o.IERPQ[idx].Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetIERPQ_TFC(idx int) uint32 {
	return (volatile.LoadUint32(&o.IERPQ[idx].Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetIERPQ_TCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.IERPQ[idx].Reg, volatile.LoadUint32(&o.IERPQ[idx].Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetIERPQ_TCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IERPQ[idx].Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetIERPQ_ROVR(idx int, value uint32) {
	volatile.StoreUint32(&o.IERPQ[idx].Reg, volatile.LoadUint32(&o.IERPQ[idx].Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetIERPQ_ROVR(idx int) uint32 {
	return (volatile.LoadUint32(&o.IERPQ[idx].Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetIERPQ_HRESP(idx int, value uint32) {
	volatile.StoreUint32(&o.IERPQ[idx].Reg, volatile.LoadUint32(&o.IERPQ[idx].Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetIERPQ_HRESP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IERPQ[idx].Reg) & 0x800) >> 11
}

// GMAC.IDRPQ: Interrupt Disable Register Priority Queue (1..5)
func (o *GMAC_Type) SetIDRPQ_RCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.IDRPQ[idx].Reg, volatile.LoadUint32(&o.IDRPQ[idx].Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetIDRPQ_RCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IDRPQ[idx].Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetIDRPQ_RXUBR(idx int, value uint32) {
	volatile.StoreUint32(&o.IDRPQ[idx].Reg, volatile.LoadUint32(&o.IDRPQ[idx].Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetIDRPQ_RXUBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.IDRPQ[idx].Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetIDRPQ_RLEX(idx int, value uint32) {
	volatile.StoreUint32(&o.IDRPQ[idx].Reg, volatile.LoadUint32(&o.IDRPQ[idx].Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetIDRPQ_RLEX(idx int) uint32 {
	return (volatile.LoadUint32(&o.IDRPQ[idx].Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetIDRPQ_TFC(idx int, value uint32) {
	volatile.StoreUint32(&o.IDRPQ[idx].Reg, volatile.LoadUint32(&o.IDRPQ[idx].Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetIDRPQ_TFC(idx int) uint32 {
	return (volatile.LoadUint32(&o.IDRPQ[idx].Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetIDRPQ_TCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.IDRPQ[idx].Reg, volatile.LoadUint32(&o.IDRPQ[idx].Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetIDRPQ_TCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IDRPQ[idx].Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetIDRPQ_ROVR(idx int, value uint32) {
	volatile.StoreUint32(&o.IDRPQ[idx].Reg, volatile.LoadUint32(&o.IDRPQ[idx].Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetIDRPQ_ROVR(idx int) uint32 {
	return (volatile.LoadUint32(&o.IDRPQ[idx].Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetIDRPQ_HRESP(idx int, value uint32) {
	volatile.StoreUint32(&o.IDRPQ[idx].Reg, volatile.LoadUint32(&o.IDRPQ[idx].Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetIDRPQ_HRESP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IDRPQ[idx].Reg) & 0x800) >> 11
}

// GMAC.IMRPQ: Interrupt Mask Register Priority Queue (1..5)
func (o *GMAC_Type) SetIMRPQ_RCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.IMRPQ[idx].Reg, volatile.LoadUint32(&o.IMRPQ[idx].Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetIMRPQ_RCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IMRPQ[idx].Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetIMRPQ_RXUBR(idx int, value uint32) {
	volatile.StoreUint32(&o.IMRPQ[idx].Reg, volatile.LoadUint32(&o.IMRPQ[idx].Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetIMRPQ_RXUBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.IMRPQ[idx].Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetIMRPQ_RLEX(idx int, value uint32) {
	volatile.StoreUint32(&o.IMRPQ[idx].Reg, volatile.LoadUint32(&o.IMRPQ[idx].Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetIMRPQ_RLEX(idx int) uint32 {
	return (volatile.LoadUint32(&o.IMRPQ[idx].Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetIMRPQ_AHB(idx int, value uint32) {
	volatile.StoreUint32(&o.IMRPQ[idx].Reg, volatile.LoadUint32(&o.IMRPQ[idx].Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetIMRPQ_AHB(idx int) uint32 {
	return (volatile.LoadUint32(&o.IMRPQ[idx].Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetIMRPQ_TCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.IMRPQ[idx].Reg, volatile.LoadUint32(&o.IMRPQ[idx].Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetIMRPQ_TCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IMRPQ[idx].Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetIMRPQ_ROVR(idx int, value uint32) {
	volatile.StoreUint32(&o.IMRPQ[idx].Reg, volatile.LoadUint32(&o.IMRPQ[idx].Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetIMRPQ_ROVR(idx int) uint32 {
	return (volatile.LoadUint32(&o.IMRPQ[idx].Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetIMRPQ_HRESP(idx int, value uint32) {
	volatile.StoreUint32(&o.IMRPQ[idx].Reg, volatile.LoadUint32(&o.IMRPQ[idx].Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetIMRPQ_HRESP(idx int) uint32 {
	return (volatile.LoadUint32(&o.IMRPQ[idx].Reg) & 0x800) >> 11
}

// GMAC.ST2ER: Screening Type 2 Ethertype Register
func (o *GMAC_Type) SetST2ER_COMPVAL(idx int, value uint32) {
	volatile.StoreUint32(&o.ST2ER[idx].Reg, volatile.LoadUint32(&o.ST2ER[idx].Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetST2ER_COMPVAL(idx int) uint32 {
	return volatile.LoadUint32(&o.ST2ER[idx].Reg) & 0xffff
}

// Specific Address 1 Bottom Register
type GMAC_GMAC_SA_Type struct {
	SAB volatile.Register32 // 0x88
	SAT volatile.Register32 // 0x8C
}

// GMAC_GMAC_SA.SAB: Specific Address 1 Bottom Register
func (o *GMAC_GMAC_SA_Type) SetSAB(value uint32) {
	volatile.StoreUint32(&o.SAB.Reg, value)
}
func (o *GMAC_GMAC_SA_Type) GetSAB() uint32 {
	return volatile.LoadUint32(&o.SAB.Reg)
}

// GMAC_GMAC_SA.SAT: Specific Address 1 Top Register
func (o *GMAC_GMAC_SA_Type) SetSAT_ADDR(value uint32) {
	volatile.StoreUint32(&o.SAT.Reg, volatile.LoadUint32(&o.SAT.Reg)&^(0xffff)|value)
}
func (o *GMAC_GMAC_SA_Type) GetSAT_ADDR() uint32 {
	return volatile.LoadUint32(&o.SAT.Reg) & 0xffff
}

// Screening Type 2 Compare Word 0 Register
type GMAC_GMAC_ST2CW_Type struct {
	ST2CW0 volatile.Register32 // 0x700
	ST2CW1 volatile.Register32 // 0x704
}

// GMAC_GMAC_ST2CW.ST2CW0: Screening Type 2 Compare Word 0 Register
func (o *GMAC_GMAC_ST2CW_Type) SetST2CW0_MASKVAL(value uint32) {
	volatile.StoreUint32(&o.ST2CW0.Reg, volatile.LoadUint32(&o.ST2CW0.Reg)&^(0xffff)|value)
}
func (o *GMAC_GMAC_ST2CW_Type) GetST2CW0_MASKVAL() uint32 {
	return volatile.LoadUint32(&o.ST2CW0.Reg) & 0xffff
}
func (o *GMAC_GMAC_ST2CW_Type) SetST2CW0_COMPVAL(value uint32) {
	volatile.StoreUint32(&o.ST2CW0.Reg, volatile.LoadUint32(&o.ST2CW0.Reg)&^(0xffff0000)|value<<16)
}
func (o *GMAC_GMAC_ST2CW_Type) GetST2CW0_COMPVAL() uint32 {
	return (volatile.LoadUint32(&o.ST2CW0.Reg) & 0xffff0000) >> 16
}

// GMAC_GMAC_ST2CW.ST2CW1: Screening Type 2 Compare Word 1 Register
func (o *GMAC_GMAC_ST2CW_Type) SetST2CW1_OFFSVAL(value uint32) {
	volatile.StoreUint32(&o.ST2CW1.Reg, volatile.LoadUint32(&o.ST2CW1.Reg)&^(0x7f)|value)
}
func (o *GMAC_GMAC_ST2CW_Type) GetST2CW1_OFFSVAL() uint32 {
	return volatile.LoadUint32(&o.ST2CW1.Reg) & 0x7f
}
func (o *GMAC_GMAC_ST2CW_Type) SetST2CW1_OFFSSTRT(value uint32) {
	volatile.StoreUint32(&o.ST2CW1.Reg, volatile.LoadUint32(&o.ST2CW1.Reg)&^(0x180)|value<<7)
}
func (o *GMAC_GMAC_ST2CW_Type) GetST2CW1_OFFSSTRT() uint32 {
	return (volatile.LoadUint32(&o.ST2CW1.Reg) & 0x180) >> 7
}

// General Purpose Backup Registers
type GPBR_Type struct {
	SYS_GPBR [8]volatile.Register32 // 0x0
}

// GPBR.SYS_GPBR: General Purpose Backup Register 0
func (o *GPBR_Type) SetSYS_GPBR(idx int, value uint32) {
	volatile.StoreUint32(&o.SYS_GPBR[idx].Reg, value)
}
func (o *GPBR_Type) GetSYS_GPBR(idx int) uint32 {
	return volatile.LoadUint32(&o.SYS_GPBR[idx].Reg)
}

// Integrity Check Monitor
type ICM_Type struct {
	CFG    volatile.Register32 // 0x0
	CTRL   volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	_      [4]byte
	IER    volatile.Register32 // 0x10
	IDR    volatile.Register32 // 0x14
	IMR    volatile.Register32 // 0x18
	ISR    volatile.Register32 // 0x1C
	UASR   volatile.Register32 // 0x20
	_      [12]byte
	DSCR   volatile.Register32    // 0x30
	HASH   volatile.Register32    // 0x34
	UIHVAL [8]volatile.Register32 // 0x38
}

// ICM.CFG: Configuration Register
func (o *ICM_Type) SetCFG_WBDIS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetCFG_WBDIS() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *ICM_Type) SetCFG_EOMDIS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *ICM_Type) GetCFG_EOMDIS() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *ICM_Type) SetCFG_SLBDIS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4)|value<<2)
}
func (o *ICM_Type) GetCFG_SLBDIS() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4) >> 2
}
func (o *ICM_Type) SetCFG_BBC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetCFG_BBC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetCFG_ASCD(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *ICM_Type) GetCFG_ASCD() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *ICM_Type) SetCFG_DUALBUFF(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200)|value<<9)
}
func (o *ICM_Type) GetCFG_DUALBUFF() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200) >> 9
}
func (o *ICM_Type) SetCFG_UIHASH(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *ICM_Type) GetCFG_UIHASH() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *ICM_Type) SetCFG_UALGO(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xe000)|value<<13)
}
func (o *ICM_Type) GetCFG_UALGO() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xe000) >> 13
}

// ICM.CTRL: Control Register
func (o *ICM_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *ICM_Type) SetCTRL_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ICM_Type) GetCTRL_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *ICM_Type) SetCTRL_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ICM_Type) GetCTRL_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *ICM_Type) SetCTRL_REHASH(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetCTRL_REHASH() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetCTRL_RMDIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetCTRL_RMDIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetCTRL_RMEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetCTRL_RMEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf000) >> 12
}

// ICM.SR: Status Register
func (o *ICM_Type) SetSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *ICM_Type) SetSR_RAWRMDIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetSR_RAWRMDIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetSR_RMDIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetSR_RMDIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf000) >> 12
}

// ICM.IER: Interrupt Enable Register
func (o *ICM_Type) SetIER_RHC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetIER_RHC() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0xf
}
func (o *ICM_Type) SetIER_RDM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetIER_RDM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetIER_RBE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetIER_RBE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetIER_RWC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetIER_RWC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetIER_REC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetIER_REC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetIER_RSU(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetIER_RSU() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetIER_URAD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetIER_URAD() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// ICM.IDR: Interrupt Disable Register
func (o *ICM_Type) SetIDR_RHC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetIDR_RHC() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xf
}
func (o *ICM_Type) SetIDR_RDM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetIDR_RDM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetIDR_RBE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetIDR_RBE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetIDR_RWC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetIDR_RWC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetIDR_REC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetIDR_REC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetIDR_RSU(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetIDR_RSU() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetIDR_URAD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetIDR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// ICM.IMR: Interrupt Mask Register
func (o *ICM_Type) SetIMR_RHC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetIMR_RHC() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0xf
}
func (o *ICM_Type) SetIMR_RDM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetIMR_RDM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetIMR_RBE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetIMR_RBE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetIMR_RWC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetIMR_RWC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetIMR_REC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetIMR_REC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetIMR_RSU(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetIMR_RSU() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetIMR_URAD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetIMR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// ICM.ISR: Interrupt Status Register
func (o *ICM_Type) SetISR_RHC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetISR_RHC() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0xf
}
func (o *ICM_Type) SetISR_RDM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetISR_RDM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetISR_RBE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetISR_RBE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetISR_RWC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetISR_RWC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetISR_REC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetISR_REC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetISR_RSU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetISR_RSU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetISR_URAD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetISR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}

// ICM.UASR: Undefined Access Status Register
func (o *ICM_Type) SetUASR_URAT(value uint32) {
	volatile.StoreUint32(&o.UASR.Reg, volatile.LoadUint32(&o.UASR.Reg)&^(0x7)|value)
}
func (o *ICM_Type) GetUASR_URAT() uint32 {
	return volatile.LoadUint32(&o.UASR.Reg) & 0x7
}

// ICM.DSCR: Region Descriptor Area Start Address Register
func (o *ICM_Type) SetDSCR_DASA(value uint32) {
	volatile.StoreUint32(&o.DSCR.Reg, volatile.LoadUint32(&o.DSCR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *ICM_Type) GetDSCR_DASA() uint32 {
	return (volatile.LoadUint32(&o.DSCR.Reg) & 0xffffffc0) >> 6
}

// ICM.HASH: Region Hash Area Start Address Register
func (o *ICM_Type) SetHASH_HASA(value uint32) {
	volatile.StoreUint32(&o.HASH.Reg, volatile.LoadUint32(&o.HASH.Reg)&^(0xffffff80)|value<<7)
}
func (o *ICM_Type) GetHASH_HASA() uint32 {
	return (volatile.LoadUint32(&o.HASH.Reg) & 0xffffff80) >> 7
}

// ICM.UIHVAL: User Initial Hash Value 0 Register 0
func (o *ICM_Type) SetUIHVAL(idx int, value uint32) {
	volatile.StoreUint32(&o.UIHVAL[idx].Reg, value)
}
func (o *ICM_Type) GetUIHVAL(idx int) uint32 {
	return volatile.LoadUint32(&o.UIHVAL[idx].Reg)
}

// Image Sensor Interface
type ISI_Type struct {
	CFG1       volatile.Register32 // 0x0
	CFG2       volatile.Register32 // 0x4
	PSIZE      volatile.Register32 // 0x8
	PDECF      volatile.Register32 // 0xC
	Y2R_SET0   volatile.Register32 // 0x10
	Y2R_SET1   volatile.Register32 // 0x14
	R2Y_SET0   volatile.Register32 // 0x18
	R2Y_SET1   volatile.Register32 // 0x1C
	R2Y_SET2   volatile.Register32 // 0x20
	CR         volatile.Register32 // 0x24
	SR         volatile.Register32 // 0x28
	IER        volatile.Register32 // 0x2C
	IDR        volatile.Register32 // 0x30
	IMR        volatile.Register32 // 0x34
	DMA_CHER   volatile.Register32 // 0x38
	DMA_CHDR   volatile.Register32 // 0x3C
	DMA_CHSR   volatile.Register32 // 0x40
	DMA_P_ADDR volatile.Register32 // 0x44
	DMA_P_CTRL volatile.Register32 // 0x48
	DMA_P_DSCR volatile.Register32 // 0x4C
	DMA_C_ADDR volatile.Register32 // 0x50
	DMA_C_CTRL volatile.Register32 // 0x54
	DMA_C_DSCR volatile.Register32 // 0x58
	_          [136]byte
	WPMR       volatile.Register32 // 0xE4
	WPSR       volatile.Register32 // 0xE8
}

// ISI.CFG1: ISI Configuration 1 Register
func (o *ISI_Type) SetCFG1_HSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetCFG1_HSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetCFG1_VSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetCFG1_VSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x8) >> 3
}
func (o *ISI_Type) SetCFG1_PIXCLK_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ISI_Type) GetCFG1_PIXCLK_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *ISI_Type) SetCFG1_GRAYLE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x20)|value<<5)
}
func (o *ISI_Type) GetCFG1_GRAYLE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x20) >> 5
}
func (o *ISI_Type) SetCFG1_EMB_SYNC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x40)|value<<6)
}
func (o *ISI_Type) GetCFG1_EMB_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x40) >> 6
}
func (o *ISI_Type) SetCFG1_CRC_SYNC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ISI_Type) GetCFG1_CRC_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}
func (o *ISI_Type) SetCFG1_FRATE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x700)|value<<8)
}
func (o *ISI_Type) GetCFG1_FRATE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x700) >> 8
}
func (o *ISI_Type) SetCFG1_DISCR(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetCFG1_DISCR() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetCFG1_FULL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetCFG1_FULL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetCFG1_THMASK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x6000)|value<<13)
}
func (o *ISI_Type) GetCFG1_THMASK() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x6000) >> 13
}
func (o *ISI_Type) SetCFG1_SLD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetCFG1_SLD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetCFG1_SFD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetCFG1_SFD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xff000000) >> 24
}

// ISI.CFG2: ISI Configuration 2 Register
func (o *ISI_Type) SetCFG2_IM_VSIZE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7ff)|value)
}
func (o *ISI_Type) GetCFG2_IM_VSIZE() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x7ff
}
func (o *ISI_Type) SetCFG2_GS_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetCFG2_GS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetCFG2_RGB_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetCFG2_RGB_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetCFG2_GRAYSCALE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetCFG2_GRAYSCALE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetCFG2_RGB_SWAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetCFG2_RGB_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4000) >> 14
}
func (o *ISI_Type) SetCFG2_COL_SPACE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8000)|value<<15)
}
func (o *ISI_Type) GetCFG2_COL_SPACE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8000) >> 15
}
func (o *ISI_Type) SetCFG2_IM_HSIZE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ISI_Type) GetCFG2_IM_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x7ff0000) >> 16
}
func (o *ISI_Type) SetCFG2_YCC_SWAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *ISI_Type) GetCFG2_YCC_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000000) >> 28
}
func (o *ISI_Type) SetCFG2_RGB_CFG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xc0000000)|value<<30)
}
func (o *ISI_Type) GetCFG2_RGB_CFG() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xc0000000) >> 30
}

// ISI.PSIZE: ISI Preview Size Register
func (o *ISI_Type) SetPSIZE_PREV_VSIZE(value uint32) {
	volatile.StoreUint32(&o.PSIZE.Reg, volatile.LoadUint32(&o.PSIZE.Reg)&^(0x3ff)|value)
}
func (o *ISI_Type) GetPSIZE_PREV_VSIZE() uint32 {
	return volatile.LoadUint32(&o.PSIZE.Reg) & 0x3ff
}
func (o *ISI_Type) SetPSIZE_PREV_HSIZE(value uint32) {
	volatile.StoreUint32(&o.PSIZE.Reg, volatile.LoadUint32(&o.PSIZE.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ISI_Type) GetPSIZE_PREV_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.PSIZE.Reg) & 0x3ff0000) >> 16
}

// ISI.PDECF: ISI Preview Decimation Factor Register
func (o *ISI_Type) SetPDECF_DEC_FACTOR(value uint32) {
	volatile.StoreUint32(&o.PDECF.Reg, volatile.LoadUint32(&o.PDECF.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetPDECF_DEC_FACTOR() uint32 {
	return volatile.LoadUint32(&o.PDECF.Reg) & 0xff
}

// ISI.Y2R_SET0: ISI Color Space Conversion YCrCb To RGB Set 0 Register
func (o *ISI_Type) SetY2R_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetY2R_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff
}
func (o *ISI_Type) SetY2R_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff00)|value<<8)
}
func (o *ISI_Type) GetY2R_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff00) >> 8
}
func (o *ISI_Type) SetY2R_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetY2R_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetY2R_SET0_C3(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetY2R_SET0_C3() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff000000) >> 24
}

// ISI.Y2R_SET1: ISI Color Space Conversion YCrCb To RGB Set 1 Register
func (o *ISI_Type) SetY2R_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x1ff)|value)
}
func (o *ISI_Type) GetY2R_SET1_C4() uint32 {
	return volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x1ff
}
func (o *ISI_Type) SetY2R_SET1_Yoff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetY2R_SET1_Yoff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetY2R_SET1_Croff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetY2R_SET1_Croff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetY2R_SET1_Cboff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetY2R_SET1_Cboff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x4000) >> 14
}

// ISI.R2Y_SET0: ISI Color Space Conversion RGB To YCrCb Set 0 Register
func (o *ISI_Type) SetR2Y_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET0_Roff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET0_Roff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x1000000) >> 24
}

// ISI.R2Y_SET1: ISI Color Space Conversion RGB To YCrCb Set 1 Register
func (o *ISI_Type) SetR2Y_SET1_C3(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET1_C3() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET1_C4() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET1_C5(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET1_C5() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET1_Goff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET1_Goff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x1000000) >> 24
}

// ISI.R2Y_SET2: ISI Color Space Conversion RGB To YCrCb Set 2 Register
func (o *ISI_Type) SetR2Y_SET2_C6(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET2_C6() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET2_C7(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET2_C7() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET2_C8(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET2_C8() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET2_Boff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET2_Boff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x1000000) >> 24
}

// ISI.CR: ISI Control Register
func (o *ISI_Type) SetCR_ISI_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetCR_ISI_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ISI_Type) SetCR_ISI_DIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetCR_ISI_DIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetCR_ISI_SRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetCR_ISI_SRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetCR_ISI_CDC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetCR_ISI_CDC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// ISI.SR: ISI Status Register
func (o *ISI_Type) SetSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *ISI_Type) SetSR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetSR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetSR_SRST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetSR_SRST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetSR_CDC_PND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetSR_CDC_PND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *ISI_Type) SetSR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetSR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetSR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetSR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetSR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetSR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetSR_SIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *ISI_Type) GetSR_SIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *ISI_Type) SetSR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetSR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetSR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetSR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetSR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetSR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetSR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetSR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}

// ISI.IER: ISI Interrupt Enable Register
func (o *ISI_Type) SetIER_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIER_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIER_SRST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIER_SRST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIER_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIER_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIER_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIER_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIER_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIER_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIER_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIER_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIER_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIER_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIER_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIER_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIER_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIER_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}

// ISI.IDR: ISI Interrupt Disable Register
func (o *ISI_Type) SetIDR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIDR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIDR_SRST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIDR_SRST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIDR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIDR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIDR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIDR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIDR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIDR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIDR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIDR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIDR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIDR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIDR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIDR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIDR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIDR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}

// ISI.IMR: ISI Interrupt Mask Register
func (o *ISI_Type) SetIMR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIMR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIMR_SRST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIMR_SRST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIMR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIMR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIMR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIMR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIMR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIMR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIMR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIMR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIMR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIMR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIMR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIMR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIMR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIMR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}

// ISI.DMA_CHER: DMA Channel Enable Register
func (o *ISI_Type) SetDMA_CHER_P_CH_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CHER.Reg, volatile.LoadUint32(&o.DMA_CHER.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHER_P_CH_EN() uint32 {
	return volatile.LoadUint32(&o.DMA_CHER.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHER_C_CH_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CHER.Reg, volatile.LoadUint32(&o.DMA_CHER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHER_C_CH_EN() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHER.Reg) & 0x2) >> 1
}

// ISI.DMA_CHDR: DMA Channel Disable Register
func (o *ISI_Type) SetDMA_CHDR_P_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.DMA_CHDR.Reg, volatile.LoadUint32(&o.DMA_CHDR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHDR_P_CH_DIS() uint32 {
	return volatile.LoadUint32(&o.DMA_CHDR.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHDR_C_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.DMA_CHDR.Reg, volatile.LoadUint32(&o.DMA_CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHDR_C_CH_DIS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHDR.Reg) & 0x2) >> 1
}

// ISI.DMA_CHSR: DMA Channel Status Register
func (o *ISI_Type) SetDMA_CHSR_P_CH_S(value uint32) {
	volatile.StoreUint32(&o.DMA_CHSR.Reg, volatile.LoadUint32(&o.DMA_CHSR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHSR_P_CH_S() uint32 {
	return volatile.LoadUint32(&o.DMA_CHSR.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHSR_C_CH_S(value uint32) {
	volatile.StoreUint32(&o.DMA_CHSR.Reg, volatile.LoadUint32(&o.DMA_CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHSR_C_CH_S() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHSR.Reg) & 0x2) >> 1
}

// ISI.DMA_P_ADDR: DMA Preview Base Address Register
func (o *ISI_Type) SetDMA_P_ADDR_P_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_P_ADDR.Reg, volatile.LoadUint32(&o.DMA_P_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_P_ADDR_P_ADDR() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_P_CTRL: DMA Preview Control Register
func (o *ISI_Type) SetDMA_P_CTRL_P_FETCH(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_FETCH() uint32 {
	return volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_P_CTRL_P_WB(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_WB() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetDMA_P_CTRL_P_IEN(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_IEN() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetDMA_P_CTRL_P_DONE(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_DONE() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x8) >> 3
}

// ISI.DMA_P_DSCR: DMA Preview Descriptor Address Register
func (o *ISI_Type) SetDMA_P_DSCR_P_DSCR(value uint32) {
	volatile.StoreUint32(&o.DMA_P_DSCR.Reg, volatile.LoadUint32(&o.DMA_P_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_P_DSCR_P_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_C_ADDR: DMA Codec Base Address Register
func (o *ISI_Type) SetDMA_C_ADDR_C_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_C_ADDR.Reg, volatile.LoadUint32(&o.DMA_C_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_C_ADDR_C_ADDR() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_C_CTRL: DMA Codec Control Register
func (o *ISI_Type) SetDMA_C_CTRL_C_FETCH(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_FETCH() uint32 {
	return volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_C_CTRL_C_WB(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_WB() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetDMA_C_CTRL_C_IEN(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_IEN() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetDMA_C_CTRL_C_DONE(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_DONE() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x8) >> 3
}

// ISI.DMA_C_DSCR: DMA Codec Descriptor Address Register
func (o *ISI_Type) SetDMA_C_DSCR_C_DSCR(value uint32) {
	volatile.StoreUint32(&o.DMA_C_DSCR.Reg, volatile.LoadUint32(&o.DMA_C_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_C_DSCR_C_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.WPMR: Write Protection Mode Register
func (o *ISI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ISI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ISI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ISI.WPSR: Write Protection Status Register
func (o *ISI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *ISI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ISI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG         [13]volatile.Register32 // 0x0
	_            [12]byte
	SCFG         [9]volatile.Register32 // 0x40
	_            [28]byte
	MATRIX_PR    [9]MATRIX_MATRIX_PR_Type // 0x80
	_            [56]byte
	MRCR         volatile.Register32 // 0x100
	_            [12]byte
	CCFG_CAN0    volatile.Register32 // 0x110
	CCFG_SYSIO   volatile.Register32 // 0x114
	CCFG_PCCR    volatile.Register32 // 0x118
	CCFG_DYNCKG  volatile.Register32 // 0x11C
	_            [4]byte
	CCFG_SMCNFCS volatile.Register32 // 0x124
	_            [188]byte
	WPMR         volatile.Register32 // 0x1E4
	WPSR         volatile.Register32 // 0x1E8
}

// MATRIX.MCFG: Master Configuration Register 0
func (o *MATRIX_Type) SetMCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MCFG[idx].Reg, volatile.LoadUint32(&o.MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MCFG[idx].Reg) & 0x7
}

// MATRIX.SCFG: Slave Configuration Register 0
func (o *MATRIX_Type) SetSCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x1ff)|value)
}
func (o *MATRIX_Type) GetSCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x1ff
}
func (o *MATRIX_Type) SetSCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetSCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetSCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x3c0000)|value<<18)
}
func (o *MATRIX_Type) GetSCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x3c0000) >> 18
}

// MATRIX.MRCR: Master Remap Control Register
func (o *MATRIX_Type) SetMRCR_RCB0(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMRCR_RCB0() uint32 {
	return volatile.LoadUint32(&o.MRCR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMRCR_RCB1(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMRCR_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetMRCR_RCB2(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetMRCR_RCB2() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetMRCR_RCB3(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetMRCR_RCB3() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetMRCR_RCB4(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetMRCR_RCB4() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetMRCR_RCB5(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetMRCR_RCB5() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetMRCR_RCB6(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetMRCR_RCB6() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetMRCR_RCB8(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x100)|value<<8)
}
func (o *MATRIX_Type) GetMRCR_RCB8() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x100) >> 8
}
func (o *MATRIX_Type) SetMRCR_RCB9(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x200)|value<<9)
}
func (o *MATRIX_Type) GetMRCR_RCB9() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x200) >> 9
}
func (o *MATRIX_Type) SetMRCR_RCB10(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x400)|value<<10)
}
func (o *MATRIX_Type) GetMRCR_RCB10() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x400) >> 10
}
func (o *MATRIX_Type) SetMRCR_RCB11(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x800)|value<<11)
}
func (o *MATRIX_Type) GetMRCR_RCB11() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x800) >> 11
}
func (o *MATRIX_Type) SetMRCR_RCB12(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x1000)|value<<12)
}
func (o *MATRIX_Type) GetMRCR_RCB12() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x1000) >> 12
}

// MATRIX.CCFG_CAN0: CAN0 Configuration Register
func (o *MATRIX_Type) SetCCFG_CAN0_CAN0DMABA(value uint32) {
	volatile.StoreUint32(&o.CCFG_CAN0.Reg, volatile.LoadUint32(&o.CCFG_CAN0.Reg)&^(0xffff0000)|value<<16)
}
func (o *MATRIX_Type) GetCCFG_CAN0_CAN0DMABA() uint32 {
	return (volatile.LoadUint32(&o.CCFG_CAN0.Reg) & 0xffff0000) >> 16
}

// MATRIX.CCFG_SYSIO: System I/O Configuration Register
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO4(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO4() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO5(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO5() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO6(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO6() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO7(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x80)|value<<7)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO7() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x80) >> 7
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO12(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x1000)|value<<12)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO12() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x1000) >> 12
}

// MATRIX.CCFG_PCCR: Peripheral Clock Configuration Register
func (o *MATRIX_Type) SetCCFG_PCCR_TC0CC(value uint32) {
	volatile.StoreUint32(&o.CCFG_PCCR.Reg, volatile.LoadUint32(&o.CCFG_PCCR.Reg)&^(0x100000)|value<<20)
}
func (o *MATRIX_Type) GetCCFG_PCCR_TC0CC() uint32 {
	return (volatile.LoadUint32(&o.CCFG_PCCR.Reg) & 0x100000) >> 20
}
func (o *MATRIX_Type) SetCCFG_PCCR_I2SC0CC(value uint32) {
	volatile.StoreUint32(&o.CCFG_PCCR.Reg, volatile.LoadUint32(&o.CCFG_PCCR.Reg)&^(0x200000)|value<<21)
}
func (o *MATRIX_Type) GetCCFG_PCCR_I2SC0CC() uint32 {
	return (volatile.LoadUint32(&o.CCFG_PCCR.Reg) & 0x200000) >> 21
}
func (o *MATRIX_Type) SetCCFG_PCCR_I2SC1CC(value uint32) {
	volatile.StoreUint32(&o.CCFG_PCCR.Reg, volatile.LoadUint32(&o.CCFG_PCCR.Reg)&^(0x400000)|value<<22)
}
func (o *MATRIX_Type) GetCCFG_PCCR_I2SC1CC() uint32 {
	return (volatile.LoadUint32(&o.CCFG_PCCR.Reg) & 0x400000) >> 22
}

// MATRIX.CCFG_DYNCKG: Dynamic Clock Gating Register
func (o *MATRIX_Type) SetCCFG_DYNCKG_MATCKG(value uint32) {
	volatile.StoreUint32(&o.CCFG_DYNCKG.Reg, volatile.LoadUint32(&o.CCFG_DYNCKG.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetCCFG_DYNCKG_MATCKG() uint32 {
	return volatile.LoadUint32(&o.CCFG_DYNCKG.Reg) & 0x1
}
func (o *MATRIX_Type) SetCCFG_DYNCKG_BRIDCKG(value uint32) {
	volatile.StoreUint32(&o.CCFG_DYNCKG.Reg, volatile.LoadUint32(&o.CCFG_DYNCKG.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetCCFG_DYNCKG_BRIDCKG() uint32 {
	return (volatile.LoadUint32(&o.CCFG_DYNCKG.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetCCFG_DYNCKG_EFCCKG(value uint32) {
	volatile.StoreUint32(&o.CCFG_DYNCKG.Reg, volatile.LoadUint32(&o.CCFG_DYNCKG.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetCCFG_DYNCKG_EFCCKG() uint32 {
	return (volatile.LoadUint32(&o.CCFG_DYNCKG.Reg) & 0x4) >> 2
}

// MATRIX.CCFG_SMCNFCS: SMC NAND Flash Chip Select Configuration Register
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS0(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS0() uint32 {
	return volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x1
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS1(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS1() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS2(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS2() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS3(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS3() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SDRAMEN(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SDRAMEN() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x10) >> 4
}

// MATRIX.WPMR: Write Protection Mode Register
func (o *MATRIX_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.WPSR: Write Protection Status Register
func (o *MATRIX_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Priority Register A for Slave 0
type MATRIX_MATRIX_PR_Type struct {
	PRAS volatile.Register32 // 0x80
	PRBS volatile.Register32 // 0x84
}

// MATRIX_MATRIX_PR.PRAS: Priority Register A for Slave 0
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x3)|value)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS.Reg) & 0x3
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x30) >> 4
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x300) >> 8
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x3000) >> 12
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x30000) >> 16
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x300000) >> 20
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x3000000) >> 24
}

// MATRIX_MATRIX_PR.PRBS: Priority Register B for Slave 0
func (o *MATRIX_MATRIX_PR_Type) SetPRBS_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS.Reg, volatile.LoadUint32(&o.PRBS.Reg)&^(0x3)|value)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRBS_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS.Reg) & 0x3
}
func (o *MATRIX_MATRIX_PR_Type) SetPRBS_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS.Reg, volatile.LoadUint32(&o.PRBS.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRBS_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS.Reg) & 0x30) >> 4
}
func (o *MATRIX_MATRIX_PR_Type) SetPRBS_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS.Reg, volatile.LoadUint32(&o.PRBS.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRBS_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS.Reg) & 0x300) >> 8
}
func (o *MATRIX_MATRIX_PR_Type) SetPRBS_M11PR(value uint32) {
	volatile.StoreUint32(&o.PRBS.Reg, volatile.LoadUint32(&o.PRBS.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRBS_M11PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS.Reg) & 0x3000) >> 12
}
func (o *MATRIX_MATRIX_PR_Type) SetPRBS_M12PR(value uint32) {
	volatile.StoreUint32(&o.PRBS.Reg, volatile.LoadUint32(&o.PRBS.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRBS_M12PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS.Reg) & 0x30000) >> 16
}

// Controller Area Network
type MCAN_Type struct {
	CREL   volatile.Register32 // 0x0
	ENDN   volatile.Register32 // 0x4
	CUST   volatile.Register32 // 0x8
	DBTP   volatile.Register32 // 0xC
	TEST   volatile.Register32 // 0x10
	RWD    volatile.Register32 // 0x14
	CCCR   volatile.Register32 // 0x18
	NBTP   volatile.Register32 // 0x1C
	TSCC   volatile.Register32 // 0x20
	TSCV   volatile.Register32 // 0x24
	TOCC   volatile.Register32 // 0x28
	TOCV   volatile.Register32 // 0x2C
	_      [16]byte
	ECR    volatile.Register32 // 0x40
	PSR    volatile.Register32 // 0x44
	TDCR   volatile.Register32 // 0x48
	_      [4]byte
	IR     volatile.Register32 // 0x50
	IE     volatile.Register32 // 0x54
	ILS    volatile.Register32 // 0x58
	ILE    volatile.Register32 // 0x5C
	_      [32]byte
	GFC    volatile.Register32 // 0x80
	SIDFC  volatile.Register32 // 0x84
	XIDFC  volatile.Register32 // 0x88
	_      [4]byte
	XIDAM  volatile.Register32 // 0x90
	HPMS   volatile.Register32 // 0x94
	NDAT1  volatile.Register32 // 0x98
	NDAT2  volatile.Register32 // 0x9C
	RXF0C  volatile.Register32 // 0xA0
	RXF0S  volatile.Register32 // 0xA4
	RXF0A  volatile.Register32 // 0xA8
	RXBC   volatile.Register32 // 0xAC
	RXF1C  volatile.Register32 // 0xB0
	RXF1S  volatile.Register32 // 0xB4
	RXF1A  volatile.Register32 // 0xB8
	RXESC  volatile.Register32 // 0xBC
	TXBC   volatile.Register32 // 0xC0
	TXFQS  volatile.Register32 // 0xC4
	TXESC  volatile.Register32 // 0xC8
	TXBRP  volatile.Register32 // 0xCC
	TXBAR  volatile.Register32 // 0xD0
	TXBCR  volatile.Register32 // 0xD4
	TXBTO  volatile.Register32 // 0xD8
	TXBCF  volatile.Register32 // 0xDC
	TXBTIE volatile.Register32 // 0xE0
	TXBCIE volatile.Register32 // 0xE4
	_      [8]byte
	TXEFC  volatile.Register32 // 0xF0
	TXEFS  volatile.Register32 // 0xF4
	TXEFA  volatile.Register32 // 0xF8
}

// MCAN.CREL: Core Release Register
func (o *MCAN_Type) SetCREL_DAY(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xff)|value)
}
func (o *MCAN_Type) GetCREL_DAY() uint32 {
	return volatile.LoadUint32(&o.CREL.Reg) & 0xff
}
func (o *MCAN_Type) SetCREL_MON(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xff00)|value<<8)
}
func (o *MCAN_Type) GetCREL_MON() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xff00) >> 8
}
func (o *MCAN_Type) SetCREL_YEAR(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf0000)|value<<16)
}
func (o *MCAN_Type) GetCREL_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf0000) >> 16
}
func (o *MCAN_Type) SetCREL_SUBSTEP(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf00000)|value<<20)
}
func (o *MCAN_Type) GetCREL_SUBSTEP() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf00000) >> 20
}
func (o *MCAN_Type) SetCREL_STEP(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf000000)|value<<24)
}
func (o *MCAN_Type) GetCREL_STEP() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf000000) >> 24
}
func (o *MCAN_Type) SetCREL_REL(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf0000000)|value<<28)
}
func (o *MCAN_Type) GetCREL_REL() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf0000000) >> 28
}

// MCAN.ENDN: Endian Register
func (o *MCAN_Type) SetENDN(value uint32) {
	volatile.StoreUint32(&o.ENDN.Reg, value)
}
func (o *MCAN_Type) GetENDN() uint32 {
	return volatile.LoadUint32(&o.ENDN.Reg)
}

// MCAN.CUST: Customer Register
func (o *MCAN_Type) SetCUST(value uint32) {
	volatile.StoreUint32(&o.CUST.Reg, value)
}
func (o *MCAN_Type) GetCUST() uint32 {
	return volatile.LoadUint32(&o.CUST.Reg)
}

// MCAN.DBTP: Data Bit Timing and Prescaler Register
func (o *MCAN_Type) SetDBTP_DSJW(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x7)|value)
}
func (o *MCAN_Type) GetDBTP_DSJW() uint32 {
	return volatile.LoadUint32(&o.DBTP.Reg) & 0x7
}
func (o *MCAN_Type) SetDBTP_DTSEG2(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0xf0)|value<<4)
}
func (o *MCAN_Type) GetDBTP_DTSEG2() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0xf0) >> 4
}
func (o *MCAN_Type) SetDBTP_DTSEG1(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x1f00)|value<<8)
}
func (o *MCAN_Type) GetDBTP_DTSEG1() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x1f00) >> 8
}
func (o *MCAN_Type) SetDBTP_DBRP(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x1f0000)|value<<16)
}
func (o *MCAN_Type) GetDBTP_DBRP() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x1f0000) >> 16
}
func (o *MCAN_Type) SetDBTP_TDC(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetDBTP_TDC() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x800000) >> 23
}

// MCAN.TEST: Test Register
func (o *MCAN_Type) SetTEST_LBCK(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetTEST_LBCK() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetTEST_TX(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x60)|value<<5)
}
func (o *MCAN_Type) GetTEST_TX() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x60) >> 5
}
func (o *MCAN_Type) SetTEST_RX(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetTEST_RX() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x80) >> 7
}

// MCAN.RWD: RAM Watchdog Register
func (o *MCAN_Type) SetRWD_WDC(value uint32) {
	volatile.StoreUint32(&o.RWD.Reg, volatile.LoadUint32(&o.RWD.Reg)&^(0xff)|value)
}
func (o *MCAN_Type) GetRWD_WDC() uint32 {
	return volatile.LoadUint32(&o.RWD.Reg) & 0xff
}
func (o *MCAN_Type) SetRWD_WDV(value uint32) {
	volatile.StoreUint32(&o.RWD.Reg, volatile.LoadUint32(&o.RWD.Reg)&^(0xff00)|value<<8)
}
func (o *MCAN_Type) GetRWD_WDV() uint32 {
	return (volatile.LoadUint32(&o.RWD.Reg) & 0xff00) >> 8
}

// MCAN.CCCR: CC Control Register
func (o *MCAN_Type) SetCCCR_INIT(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetCCCR_INIT() uint32 {
	return volatile.LoadUint32(&o.CCCR.Reg) & 0x1
}
func (o *MCAN_Type) SetCCCR_CCE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetCCCR_CCE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetCCCR_ASM(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetCCCR_ASM() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetCCCR_CSA(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetCCCR_CSA() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetCCCR_CSR(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetCCCR_CSR() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetCCCR_MON(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetCCCR_MON() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetCCCR_DAR(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetCCCR_DAR() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetCCCR_TEST(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetCCCR_TEST() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetCCCR_FDOE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetCCCR_FDOE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetCCCR_BRSE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetCCCR_BRSE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetCCCR_PXHD(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetCCCR_PXHD() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetCCCR_EFBI(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetCCCR_EFBI() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetCCCR_TXP(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetCCCR_TXP() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetCCCR_NISO(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetCCCR_NISO() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x8000) >> 15
}

// MCAN.NBTP: Nominal Bit Timing and Prescaler Register
func (o *MCAN_Type) SetNBTP_NTSEG2(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0x7f)|value)
}
func (o *MCAN_Type) GetNBTP_NTSEG2() uint32 {
	return volatile.LoadUint32(&o.NBTP.Reg) & 0x7f
}
func (o *MCAN_Type) SetNBTP_NTSEG1(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0xff00)|value<<8)
}
func (o *MCAN_Type) GetNBTP_NTSEG1() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0xff00) >> 8
}
func (o *MCAN_Type) SetNBTP_NBRP(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0x1ff0000)|value<<16)
}
func (o *MCAN_Type) GetNBTP_NBRP() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0x1ff0000) >> 16
}
func (o *MCAN_Type) SetNBTP_NSJW(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0xfe000000)|value<<25)
}
func (o *MCAN_Type) GetNBTP_NSJW() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0xfe000000) >> 25
}

// MCAN.TSCC: Timestamp Counter Configuration Register
func (o *MCAN_Type) SetTSCC_TSS(value uint32) {
	volatile.StoreUint32(&o.TSCC.Reg, volatile.LoadUint32(&o.TSCC.Reg)&^(0x3)|value)
}
func (o *MCAN_Type) GetTSCC_TSS() uint32 {
	return volatile.LoadUint32(&o.TSCC.Reg) & 0x3
}
func (o *MCAN_Type) SetTSCC_TCP(value uint32) {
	volatile.StoreUint32(&o.TSCC.Reg, volatile.LoadUint32(&o.TSCC.Reg)&^(0xf0000)|value<<16)
}
func (o *MCAN_Type) GetTSCC_TCP() uint32 {
	return (volatile.LoadUint32(&o.TSCC.Reg) & 0xf0000) >> 16
}

// MCAN.TSCV: Timestamp Counter Value Register
func (o *MCAN_Type) SetTSCV_TSC(value uint32) {
	volatile.StoreUint32(&o.TSCV.Reg, volatile.LoadUint32(&o.TSCV.Reg)&^(0xffff)|value)
}
func (o *MCAN_Type) GetTSCV_TSC() uint32 {
	return volatile.LoadUint32(&o.TSCV.Reg) & 0xffff
}

// MCAN.TOCC: Timeout Counter Configuration Register
func (o *MCAN_Type) SetTOCC_ETOC(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetTOCC_ETOC() uint32 {
	return volatile.LoadUint32(&o.TOCC.Reg) & 0x1
}
func (o *MCAN_Type) SetTOCC_TOS(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0x6)|value<<1)
}
func (o *MCAN_Type) GetTOCC_TOS() uint32 {
	return (volatile.LoadUint32(&o.TOCC.Reg) & 0x6) >> 1
}
func (o *MCAN_Type) SetTOCC_TOP(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCAN_Type) GetTOCC_TOP() uint32 {
	return (volatile.LoadUint32(&o.TOCC.Reg) & 0xffff0000) >> 16
}

// MCAN.TOCV: Timeout Counter Value Register
func (o *MCAN_Type) SetTOCV_TOC(value uint32) {
	volatile.StoreUint32(&o.TOCV.Reg, volatile.LoadUint32(&o.TOCV.Reg)&^(0xffff)|value)
}
func (o *MCAN_Type) GetTOCV_TOC() uint32 {
	return volatile.LoadUint32(&o.TOCV.Reg) & 0xffff
}

// MCAN.ECR: Error Counter Register
func (o *MCAN_Type) SetECR_TEC(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff)|value)
}
func (o *MCAN_Type) GetECR_TEC() uint32 {
	return volatile.LoadUint32(&o.ECR.Reg) & 0xff
}
func (o *MCAN_Type) SetECR_REC(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0x7f00)|value<<8)
}
func (o *MCAN_Type) GetECR_REC() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0x7f00) >> 8
}
func (o *MCAN_Type) SetECR_RP(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetECR_RP() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetECR_CEL(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff0000)|value<<16)
}
func (o *MCAN_Type) GetECR_CEL() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0xff0000) >> 16
}

// MCAN.PSR: Protocol Status Register
func (o *MCAN_Type) SetPSR_LEC(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x7)|value)
}
func (o *MCAN_Type) GetPSR_LEC() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x7
}
func (o *MCAN_Type) SetPSR_ACT(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x18)|value<<3)
}
func (o *MCAN_Type) GetPSR_ACT() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x18) >> 3
}
func (o *MCAN_Type) SetPSR_EP(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetPSR_EP() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetPSR_EW(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetPSR_EW() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetPSR_BO(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetPSR_BO() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetPSR_DLEC(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x700)|value<<8)
}
func (o *MCAN_Type) GetPSR_DLEC() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x700) >> 8
}
func (o *MCAN_Type) SetPSR_RESI(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetPSR_RESI() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetPSR_RBRS(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetPSR_RBRS() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetPSR_RFDF(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetPSR_RFDF() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetPSR_PXE(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetPSR_PXE() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetPSR_TDCV(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x7f0000)|value<<16)
}
func (o *MCAN_Type) GetPSR_TDCV() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x7f0000) >> 16
}

// MCAN.TDCR: Transmit Delay Compensation Register
func (o *MCAN_Type) SetTDCR_TDCF(value uint32) {
	volatile.StoreUint32(&o.TDCR.Reg, volatile.LoadUint32(&o.TDCR.Reg)&^(0x7f)|value)
}
func (o *MCAN_Type) GetTDCR_TDCF() uint32 {
	return volatile.LoadUint32(&o.TDCR.Reg) & 0x7f
}
func (o *MCAN_Type) SetTDCR_TDCO(value uint32) {
	volatile.StoreUint32(&o.TDCR.Reg, volatile.LoadUint32(&o.TDCR.Reg)&^(0x7f00)|value<<8)
}
func (o *MCAN_Type) GetTDCR_TDCO() uint32 {
	return (volatile.LoadUint32(&o.TDCR.Reg) & 0x7f00) >> 8
}

// MCAN.IR: Interrupt Register
func (o *MCAN_Type) SetIR_RF0N(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetIR_RF0N() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *MCAN_Type) SetIR_RF0W(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetIR_RF0W() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetIR_RF0F(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetIR_RF0F() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetIR_RF0L(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetIR_RF0L() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetIR_RF1N(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetIR_RF1N() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetIR_RF1W(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetIR_RF1W() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetIR_RF1F(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetIR_RF1F() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetIR_RF1L(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetIR_RF1L() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetIR_HPM(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetIR_HPM() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetIR_TC(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetIR_TC() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetIR_TCF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetIR_TCF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetIR_TFE(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetIR_TFE() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetIR_TEFN(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetIR_TEFN() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetIR_TEFW(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetIR_TEFW() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetIR_TEFF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetIR_TEFF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetIR_TEFL(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetIR_TEFL() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetIR_TSW(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetIR_TSW() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetIR_MRAF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetIR_MRAF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetIR_TOO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetIR_TOO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetIR_DRX(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetIR_DRX() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetIR_ELO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetIR_ELO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetIR_EP(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetIR_EP() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetIR_EW(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetIR_EW() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetIR_BO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetIR_BO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetIR_WDI(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetIR_WDI() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetIR_PEA(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetIR_PEA() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetIR_PED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetIR_PED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetIR_ARA(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetIR_ARA() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20000000) >> 29
}

// MCAN.IE: Interrupt Enable Register
func (o *MCAN_Type) SetIE_RF0NE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetIE_RF0NE() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}
func (o *MCAN_Type) SetIE_RF0WE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetIE_RF0WE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetIE_RF0FE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetIE_RF0FE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetIE_RF0LE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetIE_RF0LE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetIE_RF1NE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetIE_RF1NE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetIE_RF1WE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetIE_RF1WE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetIE_RF1FE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetIE_RF1FE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetIE_RF1LE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetIE_RF1LE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetIE_HPME(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetIE_HPME() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetIE_TCE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetIE_TCE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetIE_TCFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetIE_TCFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetIE_TFEE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetIE_TFEE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetIE_TEFNE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetIE_TEFNE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetIE_TEFWE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetIE_TEFWE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetIE_TEFFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetIE_TEFFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetIE_TEFLE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetIE_TEFLE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetIE_TSWE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetIE_TSWE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetIE_MRAFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetIE_MRAFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetIE_TOOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetIE_TOOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetIE_DRXE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetIE_DRXE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetIE_ELOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetIE_ELOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetIE_EPE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetIE_EPE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetIE_EWE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetIE_EWE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetIE_BOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetIE_BOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetIE_WDIE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetIE_WDIE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetIE_PEAE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetIE_PEAE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetIE_PEDE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetIE_PEDE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetIE_ARAE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetIE_ARAE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20000000) >> 29
}

// MCAN.ILS: Interrupt Line Select Register
func (o *MCAN_Type) SetILS_RF0NL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetILS_RF0NL() uint32 {
	return volatile.LoadUint32(&o.ILS.Reg) & 0x1
}
func (o *MCAN_Type) SetILS_RF0WL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetILS_RF0WL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetILS_RF0FL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetILS_RF0FL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetILS_RF0LL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetILS_RF0LL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetILS_RF1NL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetILS_RF1NL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetILS_RF1WL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetILS_RF1WL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetILS_RF1FL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetILS_RF1FL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetILS_RF1LL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetILS_RF1LL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetILS_HPML(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetILS_HPML() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetILS_TCL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetILS_TCL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetILS_TCFL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetILS_TCFL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetILS_TFEL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetILS_TFEL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetILS_TEFNL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetILS_TEFNL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetILS_TEFWL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetILS_TEFWL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetILS_TEFFL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetILS_TEFFL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetILS_TEFLL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetILS_TEFLL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetILS_TSWL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetILS_TSWL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetILS_MRAFL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetILS_MRAFL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetILS_TOOL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetILS_TOOL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetILS_DRXL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetILS_DRXL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetILS_ELOL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetILS_ELOL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetILS_EPL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetILS_EPL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetILS_EWL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetILS_EWL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetILS_BOL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetILS_BOL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetILS_WDIL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetILS_WDIL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetILS_PEAL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetILS_PEAL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetILS_PEDL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetILS_PEDL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetILS_ARAL(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetILS_ARAL() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x20000000) >> 29
}

// MCAN.ILE: Interrupt Line Enable Register
func (o *MCAN_Type) SetILE_EINT0(value uint32) {
	volatile.StoreUint32(&o.ILE.Reg, volatile.LoadUint32(&o.ILE.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetILE_EINT0() uint32 {
	return volatile.LoadUint32(&o.ILE.Reg) & 0x1
}
func (o *MCAN_Type) SetILE_EINT1(value uint32) {
	volatile.StoreUint32(&o.ILE.Reg, volatile.LoadUint32(&o.ILE.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetILE_EINT1() uint32 {
	return (volatile.LoadUint32(&o.ILE.Reg) & 0x2) >> 1
}

// MCAN.GFC: Global Filter Configuration Register
func (o *MCAN_Type) SetGFC_RRFE(value uint32) {
	volatile.StoreUint32(&o.GFC.Reg, volatile.LoadUint32(&o.GFC.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetGFC_RRFE() uint32 {
	return volatile.LoadUint32(&o.GFC.Reg) & 0x1
}
func (o *MCAN_Type) SetGFC_RRFS(value uint32) {
	volatile.StoreUint32(&o.GFC.Reg, volatile.LoadUint32(&o.GFC.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetGFC_RRFS() uint32 {
	return (volatile.LoadUint32(&o.GFC.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetGFC_ANFE(value uint32) {
	volatile.StoreUint32(&o.GFC.Reg, volatile.LoadUint32(&o.GFC.Reg)&^(0xc)|value<<2)
}
func (o *MCAN_Type) GetGFC_ANFE() uint32 {
	return (volatile.LoadUint32(&o.GFC.Reg) & 0xc) >> 2
}
func (o *MCAN_Type) SetGFC_ANFS(value uint32) {
	volatile.StoreUint32(&o.GFC.Reg, volatile.LoadUint32(&o.GFC.Reg)&^(0x30)|value<<4)
}
func (o *MCAN_Type) GetGFC_ANFS() uint32 {
	return (volatile.LoadUint32(&o.GFC.Reg) & 0x30) >> 4
}

// MCAN.SIDFC: Standard ID Filter Configuration Register
func (o *MCAN_Type) SetSIDFC_FLSSA(value uint32) {
	volatile.StoreUint32(&o.SIDFC.Reg, volatile.LoadUint32(&o.SIDFC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetSIDFC_FLSSA() uint32 {
	return (volatile.LoadUint32(&o.SIDFC.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetSIDFC_LSS(value uint32) {
	volatile.StoreUint32(&o.SIDFC.Reg, volatile.LoadUint32(&o.SIDFC.Reg)&^(0xff0000)|value<<16)
}
func (o *MCAN_Type) GetSIDFC_LSS() uint32 {
	return (volatile.LoadUint32(&o.SIDFC.Reg) & 0xff0000) >> 16
}

// MCAN.XIDFC: Extended ID Filter Configuration Register
func (o *MCAN_Type) SetXIDFC_FLESA(value uint32) {
	volatile.StoreUint32(&o.XIDFC.Reg, volatile.LoadUint32(&o.XIDFC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetXIDFC_FLESA() uint32 {
	return (volatile.LoadUint32(&o.XIDFC.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetXIDFC_LSE(value uint32) {
	volatile.StoreUint32(&o.XIDFC.Reg, volatile.LoadUint32(&o.XIDFC.Reg)&^(0x7f0000)|value<<16)
}
func (o *MCAN_Type) GetXIDFC_LSE() uint32 {
	return (volatile.LoadUint32(&o.XIDFC.Reg) & 0x7f0000) >> 16
}

// MCAN.XIDAM: Extended ID AND Mask Register
func (o *MCAN_Type) SetXIDAM_EIDM(value uint32) {
	volatile.StoreUint32(&o.XIDAM.Reg, volatile.LoadUint32(&o.XIDAM.Reg)&^(0x1fffffff)|value)
}
func (o *MCAN_Type) GetXIDAM_EIDM() uint32 {
	return volatile.LoadUint32(&o.XIDAM.Reg) & 0x1fffffff
}

// MCAN.HPMS: High Priority Message Status Register
func (o *MCAN_Type) SetHPMS_BIDX(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetHPMS_BIDX() uint32 {
	return volatile.LoadUint32(&o.HPMS.Reg) & 0x3f
}
func (o *MCAN_Type) SetHPMS_MSI(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0xc0)|value<<6)
}
func (o *MCAN_Type) GetHPMS_MSI() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0xc0) >> 6
}
func (o *MCAN_Type) SetHPMS_FIDX(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x7f00)|value<<8)
}
func (o *MCAN_Type) GetHPMS_FIDX() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0x7f00) >> 8
}
func (o *MCAN_Type) SetHPMS_FLST(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetHPMS_FLST() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0x8000) >> 15
}

// MCAN.NDAT1: New Data 1 Register
func (o *MCAN_Type) SetNDAT1_ND0(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetNDAT1_ND0() uint32 {
	return volatile.LoadUint32(&o.NDAT1.Reg) & 0x1
}
func (o *MCAN_Type) SetNDAT1_ND1(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetNDAT1_ND1() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetNDAT1_ND2(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetNDAT1_ND2() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetNDAT1_ND3(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetNDAT1_ND3() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetNDAT1_ND4(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetNDAT1_ND4() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetNDAT1_ND5(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetNDAT1_ND5() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetNDAT1_ND6(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetNDAT1_ND6() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetNDAT1_ND7(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetNDAT1_ND7() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetNDAT1_ND8(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetNDAT1_ND8() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetNDAT1_ND9(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetNDAT1_ND9() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetNDAT1_ND10(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetNDAT1_ND10() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetNDAT1_ND11(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetNDAT1_ND11() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetNDAT1_ND12(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetNDAT1_ND12() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetNDAT1_ND13(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetNDAT1_ND13() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetNDAT1_ND14(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetNDAT1_ND14() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetNDAT1_ND15(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetNDAT1_ND15() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetNDAT1_ND16(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetNDAT1_ND16() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetNDAT1_ND17(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetNDAT1_ND17() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetNDAT1_ND18(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetNDAT1_ND18() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetNDAT1_ND19(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetNDAT1_ND19() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetNDAT1_ND20(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetNDAT1_ND20() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetNDAT1_ND21(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetNDAT1_ND21() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetNDAT1_ND22(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetNDAT1_ND22() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetNDAT1_ND23(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetNDAT1_ND23() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetNDAT1_ND24(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetNDAT1_ND24() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetNDAT1_ND25(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetNDAT1_ND25() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetNDAT1_ND26(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetNDAT1_ND26() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetNDAT1_ND27(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetNDAT1_ND27() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetNDAT1_ND28(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetNDAT1_ND28() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetNDAT1_ND29(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetNDAT1_ND29() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetNDAT1_ND30(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetNDAT1_ND30() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetNDAT1_ND31(value uint32) {
	volatile.StoreUint32(&o.NDAT1.Reg, volatile.LoadUint32(&o.NDAT1.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetNDAT1_ND31() uint32 {
	return (volatile.LoadUint32(&o.NDAT1.Reg) & 0x80000000) >> 31
}

// MCAN.NDAT2: New Data 2 Register
func (o *MCAN_Type) SetNDAT2_ND32(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetNDAT2_ND32() uint32 {
	return volatile.LoadUint32(&o.NDAT2.Reg) & 0x1
}
func (o *MCAN_Type) SetNDAT2_ND33(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetNDAT2_ND33() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetNDAT2_ND34(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetNDAT2_ND34() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetNDAT2_ND35(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetNDAT2_ND35() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetNDAT2_ND36(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetNDAT2_ND36() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetNDAT2_ND37(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetNDAT2_ND37() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetNDAT2_ND38(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetNDAT2_ND38() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetNDAT2_ND39(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetNDAT2_ND39() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetNDAT2_ND40(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetNDAT2_ND40() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetNDAT2_ND41(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetNDAT2_ND41() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetNDAT2_ND42(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetNDAT2_ND42() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetNDAT2_ND43(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetNDAT2_ND43() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetNDAT2_ND44(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetNDAT2_ND44() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetNDAT2_ND45(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetNDAT2_ND45() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetNDAT2_ND46(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetNDAT2_ND46() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetNDAT2_ND47(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetNDAT2_ND47() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetNDAT2_ND48(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetNDAT2_ND48() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetNDAT2_ND49(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetNDAT2_ND49() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetNDAT2_ND50(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetNDAT2_ND50() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetNDAT2_ND51(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetNDAT2_ND51() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetNDAT2_ND52(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetNDAT2_ND52() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetNDAT2_ND53(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetNDAT2_ND53() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetNDAT2_ND54(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetNDAT2_ND54() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetNDAT2_ND55(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetNDAT2_ND55() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetNDAT2_ND56(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetNDAT2_ND56() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetNDAT2_ND57(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetNDAT2_ND57() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetNDAT2_ND58(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetNDAT2_ND58() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetNDAT2_ND59(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetNDAT2_ND59() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetNDAT2_ND60(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetNDAT2_ND60() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetNDAT2_ND61(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetNDAT2_ND61() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetNDAT2_ND62(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetNDAT2_ND62() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetNDAT2_ND63(value uint32) {
	volatile.StoreUint32(&o.NDAT2.Reg, volatile.LoadUint32(&o.NDAT2.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetNDAT2_ND63() uint32 {
	return (volatile.LoadUint32(&o.NDAT2.Reg) & 0x80000000) >> 31
}

// MCAN.RXF0C: Receive FIFO 0 Configuration Register
func (o *MCAN_Type) SetRXF0C_F0SA(value uint32) {
	volatile.StoreUint32(&o.RXF0C.Reg, volatile.LoadUint32(&o.RXF0C.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetRXF0C_F0SA() uint32 {
	return (volatile.LoadUint32(&o.RXF0C.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetRXF0C_F0S(value uint32) {
	volatile.StoreUint32(&o.RXF0C.Reg, volatile.LoadUint32(&o.RXF0C.Reg)&^(0x7f0000)|value<<16)
}
func (o *MCAN_Type) GetRXF0C_F0S() uint32 {
	return (volatile.LoadUint32(&o.RXF0C.Reg) & 0x7f0000) >> 16
}
func (o *MCAN_Type) SetRXF0C_F0WM(value uint32) {
	volatile.StoreUint32(&o.RXF0C.Reg, volatile.LoadUint32(&o.RXF0C.Reg)&^(0x7f000000)|value<<24)
}
func (o *MCAN_Type) GetRXF0C_F0WM() uint32 {
	return (volatile.LoadUint32(&o.RXF0C.Reg) & 0x7f000000) >> 24
}
func (o *MCAN_Type) SetRXF0C_F0OM(value uint32) {
	volatile.StoreUint32(&o.RXF0C.Reg, volatile.LoadUint32(&o.RXF0C.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetRXF0C_F0OM() uint32 {
	return (volatile.LoadUint32(&o.RXF0C.Reg) & 0x80000000) >> 31
}

// MCAN.RXF0S: Receive FIFO 0 Status Register
func (o *MCAN_Type) SetRXF0S_F0FL(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x7f)|value)
}
func (o *MCAN_Type) GetRXF0S_F0FL() uint32 {
	return volatile.LoadUint32(&o.RXF0S.Reg) & 0x7f
}
func (o *MCAN_Type) SetRXF0S_F0GI(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x3f00)|value<<8)
}
func (o *MCAN_Type) GetRXF0S_F0GI() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x3f00) >> 8
}
func (o *MCAN_Type) SetRXF0S_F0PI(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x3f0000)|value<<16)
}
func (o *MCAN_Type) GetRXF0S_F0PI() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x3f0000) >> 16
}
func (o *MCAN_Type) SetRXF0S_F0F(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetRXF0S_F0F() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetRXF0S_RF0L(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetRXF0S_RF0L() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x2000000) >> 25
}

// MCAN.RXF0A: Receive FIFO 0 Acknowledge Register
func (o *MCAN_Type) SetRXF0A_F0AI(value uint32) {
	volatile.StoreUint32(&o.RXF0A.Reg, volatile.LoadUint32(&o.RXF0A.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetRXF0A_F0AI() uint32 {
	return volatile.LoadUint32(&o.RXF0A.Reg) & 0x3f
}

// MCAN.RXBC: Receive Rx Buffer Configuration Register
func (o *MCAN_Type) SetRXBC_RBSA(value uint32) {
	volatile.StoreUint32(&o.RXBC.Reg, volatile.LoadUint32(&o.RXBC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetRXBC_RBSA() uint32 {
	return (volatile.LoadUint32(&o.RXBC.Reg) & 0xfffc) >> 2
}

// MCAN.RXF1C: Receive FIFO 1 Configuration Register
func (o *MCAN_Type) SetRXF1C_F1SA(value uint32) {
	volatile.StoreUint32(&o.RXF1C.Reg, volatile.LoadUint32(&o.RXF1C.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetRXF1C_F1SA() uint32 {
	return (volatile.LoadUint32(&o.RXF1C.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetRXF1C_F1S(value uint32) {
	volatile.StoreUint32(&o.RXF1C.Reg, volatile.LoadUint32(&o.RXF1C.Reg)&^(0x7f0000)|value<<16)
}
func (o *MCAN_Type) GetRXF1C_F1S() uint32 {
	return (volatile.LoadUint32(&o.RXF1C.Reg) & 0x7f0000) >> 16
}
func (o *MCAN_Type) SetRXF1C_F1WM(value uint32) {
	volatile.StoreUint32(&o.RXF1C.Reg, volatile.LoadUint32(&o.RXF1C.Reg)&^(0x7f000000)|value<<24)
}
func (o *MCAN_Type) GetRXF1C_F1WM() uint32 {
	return (volatile.LoadUint32(&o.RXF1C.Reg) & 0x7f000000) >> 24
}
func (o *MCAN_Type) SetRXF1C_F1OM(value uint32) {
	volatile.StoreUint32(&o.RXF1C.Reg, volatile.LoadUint32(&o.RXF1C.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetRXF1C_F1OM() uint32 {
	return (volatile.LoadUint32(&o.RXF1C.Reg) & 0x80000000) >> 31
}

// MCAN.RXF1S: Receive FIFO 1 Status Register
func (o *MCAN_Type) SetRXF1S_F1FL(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x7f)|value)
}
func (o *MCAN_Type) GetRXF1S_F1FL() uint32 {
	return volatile.LoadUint32(&o.RXF1S.Reg) & 0x7f
}
func (o *MCAN_Type) SetRXF1S_F1GI(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x3f00)|value<<8)
}
func (o *MCAN_Type) GetRXF1S_F1GI() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x3f00) >> 8
}
func (o *MCAN_Type) SetRXF1S_F1PI(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x3f0000)|value<<16)
}
func (o *MCAN_Type) GetRXF1S_F1PI() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x3f0000) >> 16
}
func (o *MCAN_Type) SetRXF1S_F1F(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetRXF1S_F1F() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetRXF1S_RF1L(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetRXF1S_RF1L() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetRXF1S_DMS(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0xc0000000)|value<<30)
}
func (o *MCAN_Type) GetRXF1S_DMS() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0xc0000000) >> 30
}

// MCAN.RXF1A: Receive FIFO 1 Acknowledge Register
func (o *MCAN_Type) SetRXF1A_F1AI(value uint32) {
	volatile.StoreUint32(&o.RXF1A.Reg, volatile.LoadUint32(&o.RXF1A.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetRXF1A_F1AI() uint32 {
	return volatile.LoadUint32(&o.RXF1A.Reg) & 0x3f
}

// MCAN.RXESC: Receive Buffer / FIFO Element Size Configuration Register
func (o *MCAN_Type) SetRXESC_F0DS(value uint32) {
	volatile.StoreUint32(&o.RXESC.Reg, volatile.LoadUint32(&o.RXESC.Reg)&^(0x7)|value)
}
func (o *MCAN_Type) GetRXESC_F0DS() uint32 {
	return volatile.LoadUint32(&o.RXESC.Reg) & 0x7
}
func (o *MCAN_Type) SetRXESC_F1DS(value uint32) {
	volatile.StoreUint32(&o.RXESC.Reg, volatile.LoadUint32(&o.RXESC.Reg)&^(0x70)|value<<4)
}
func (o *MCAN_Type) GetRXESC_F1DS() uint32 {
	return (volatile.LoadUint32(&o.RXESC.Reg) & 0x70) >> 4
}
func (o *MCAN_Type) SetRXESC_RBDS(value uint32) {
	volatile.StoreUint32(&o.RXESC.Reg, volatile.LoadUint32(&o.RXESC.Reg)&^(0x700)|value<<8)
}
func (o *MCAN_Type) GetRXESC_RBDS() uint32 {
	return (volatile.LoadUint32(&o.RXESC.Reg) & 0x700) >> 8
}

// MCAN.TXBC: Transmit Buffer Configuration Register
func (o *MCAN_Type) SetTXBC_TBSA(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetTXBC_TBSA() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetTXBC_NDTB(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0x3f0000)|value<<16)
}
func (o *MCAN_Type) GetTXBC_NDTB() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0x3f0000) >> 16
}
func (o *MCAN_Type) SetTXBC_TFQS(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0x3f000000)|value<<24)
}
func (o *MCAN_Type) GetTXBC_TFQS() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0x3f000000) >> 24
}
func (o *MCAN_Type) SetTXBC_TFQM(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetTXBC_TFQM() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0x40000000) >> 30
}

// MCAN.TXFQS: Transmit FIFO/Queue Status Register
func (o *MCAN_Type) SetTXFQS_TFFL(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetTXFQS_TFFL() uint32 {
	return volatile.LoadUint32(&o.TXFQS.Reg) & 0x3f
}
func (o *MCAN_Type) SetTXFQS_TFGI(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x1f00)|value<<8)
}
func (o *MCAN_Type) GetTXFQS_TFGI() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x1f00) >> 8
}
func (o *MCAN_Type) SetTXFQS_TFQPI(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x1f0000)|value<<16)
}
func (o *MCAN_Type) GetTXFQS_TFQPI() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x1f0000) >> 16
}
func (o *MCAN_Type) SetTXFQS_TFQF(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetTXFQS_TFQF() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x200000) >> 21
}

// MCAN.TXESC: Transmit Buffer Element Size Configuration Register
func (o *MCAN_Type) SetTXESC_TBDS(value uint32) {
	volatile.StoreUint32(&o.TXESC.Reg, volatile.LoadUint32(&o.TXESC.Reg)&^(0x7)|value)
}
func (o *MCAN_Type) GetTXESC_TBDS() uint32 {
	return volatile.LoadUint32(&o.TXESC.Reg) & 0x7
}

// MCAN.TXBRP: Transmit Buffer Request Pending Register
func (o *MCAN_Type) SetTXBRP_TRP0(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetTXBRP_TRP0() uint32 {
	return volatile.LoadUint32(&o.TXBRP.Reg) & 0x1
}
func (o *MCAN_Type) SetTXBRP_TRP1(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetTXBRP_TRP1() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetTXBRP_TRP2(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetTXBRP_TRP2() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetTXBRP_TRP3(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetTXBRP_TRP3() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetTXBRP_TRP4(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetTXBRP_TRP4() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetTXBRP_TRP5(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetTXBRP_TRP5() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetTXBRP_TRP6(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetTXBRP_TRP6() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetTXBRP_TRP7(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetTXBRP_TRP7() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetTXBRP_TRP8(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetTXBRP_TRP8() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetTXBRP_TRP9(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetTXBRP_TRP9() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetTXBRP_TRP10(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetTXBRP_TRP10() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetTXBRP_TRP11(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetTXBRP_TRP11() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetTXBRP_TRP12(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetTXBRP_TRP12() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetTXBRP_TRP13(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetTXBRP_TRP13() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetTXBRP_TRP14(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetTXBRP_TRP14() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetTXBRP_TRP15(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetTXBRP_TRP15() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetTXBRP_TRP16(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetTXBRP_TRP16() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetTXBRP_TRP17(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetTXBRP_TRP17() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetTXBRP_TRP18(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetTXBRP_TRP18() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetTXBRP_TRP19(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetTXBRP_TRP19() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetTXBRP_TRP20(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetTXBRP_TRP20() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetTXBRP_TRP21(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetTXBRP_TRP21() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetTXBRP_TRP22(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetTXBRP_TRP22() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetTXBRP_TRP23(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetTXBRP_TRP23() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetTXBRP_TRP24(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetTXBRP_TRP24() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetTXBRP_TRP25(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetTXBRP_TRP25() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetTXBRP_TRP26(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetTXBRP_TRP26() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetTXBRP_TRP27(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetTXBRP_TRP27() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetTXBRP_TRP28(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetTXBRP_TRP28() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetTXBRP_TRP29(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetTXBRP_TRP29() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetTXBRP_TRP30(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetTXBRP_TRP30() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetTXBRP_TRP31(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetTXBRP_TRP31() uint32 {
	return (volatile.LoadUint32(&o.TXBRP.Reg) & 0x80000000) >> 31
}

// MCAN.TXBAR: Transmit Buffer Add Request Register
func (o *MCAN_Type) SetTXBAR_AR0(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetTXBAR_AR0() uint32 {
	return volatile.LoadUint32(&o.TXBAR.Reg) & 0x1
}
func (o *MCAN_Type) SetTXBAR_AR1(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetTXBAR_AR1() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetTXBAR_AR2(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetTXBAR_AR2() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetTXBAR_AR3(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetTXBAR_AR3() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetTXBAR_AR4(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetTXBAR_AR4() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetTXBAR_AR5(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetTXBAR_AR5() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetTXBAR_AR6(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetTXBAR_AR6() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetTXBAR_AR7(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetTXBAR_AR7() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetTXBAR_AR8(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetTXBAR_AR8() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetTXBAR_AR9(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetTXBAR_AR9() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetTXBAR_AR10(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetTXBAR_AR10() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetTXBAR_AR11(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetTXBAR_AR11() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetTXBAR_AR12(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetTXBAR_AR12() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetTXBAR_AR13(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetTXBAR_AR13() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetTXBAR_AR14(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetTXBAR_AR14() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetTXBAR_AR15(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetTXBAR_AR15() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetTXBAR_AR16(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetTXBAR_AR16() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetTXBAR_AR17(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetTXBAR_AR17() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetTXBAR_AR18(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetTXBAR_AR18() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetTXBAR_AR19(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetTXBAR_AR19() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetTXBAR_AR20(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetTXBAR_AR20() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetTXBAR_AR21(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetTXBAR_AR21() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetTXBAR_AR22(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetTXBAR_AR22() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetTXBAR_AR23(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetTXBAR_AR23() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetTXBAR_AR24(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetTXBAR_AR24() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetTXBAR_AR25(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetTXBAR_AR25() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetTXBAR_AR26(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetTXBAR_AR26() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetTXBAR_AR27(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetTXBAR_AR27() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetTXBAR_AR28(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetTXBAR_AR28() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetTXBAR_AR29(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetTXBAR_AR29() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetTXBAR_AR30(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetTXBAR_AR30() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetTXBAR_AR31(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetTXBAR_AR31() uint32 {
	return (volatile.LoadUint32(&o.TXBAR.Reg) & 0x80000000) >> 31
}

// MCAN.TXBCR: Transmit Buffer Cancellation Request Register
func (o *MCAN_Type) SetTXBCR_CR0(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetTXBCR_CR0() uint32 {
	return volatile.LoadUint32(&o.TXBCR.Reg) & 0x1
}
func (o *MCAN_Type) SetTXBCR_CR1(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetTXBCR_CR1() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetTXBCR_CR2(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetTXBCR_CR2() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetTXBCR_CR3(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetTXBCR_CR3() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetTXBCR_CR4(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetTXBCR_CR4() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetTXBCR_CR5(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetTXBCR_CR5() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetTXBCR_CR6(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetTXBCR_CR6() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetTXBCR_CR7(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetTXBCR_CR7() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetTXBCR_CR8(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetTXBCR_CR8() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetTXBCR_CR9(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetTXBCR_CR9() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetTXBCR_CR10(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetTXBCR_CR10() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetTXBCR_CR11(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetTXBCR_CR11() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetTXBCR_CR12(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetTXBCR_CR12() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetTXBCR_CR13(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetTXBCR_CR13() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetTXBCR_CR14(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetTXBCR_CR14() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetTXBCR_CR15(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetTXBCR_CR15() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetTXBCR_CR16(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetTXBCR_CR16() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetTXBCR_CR17(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetTXBCR_CR17() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetTXBCR_CR18(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetTXBCR_CR18() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetTXBCR_CR19(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetTXBCR_CR19() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetTXBCR_CR20(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetTXBCR_CR20() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetTXBCR_CR21(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetTXBCR_CR21() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetTXBCR_CR22(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetTXBCR_CR22() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetTXBCR_CR23(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetTXBCR_CR23() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetTXBCR_CR24(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetTXBCR_CR24() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetTXBCR_CR25(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetTXBCR_CR25() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetTXBCR_CR26(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetTXBCR_CR26() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetTXBCR_CR27(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetTXBCR_CR27() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetTXBCR_CR28(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetTXBCR_CR28() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetTXBCR_CR29(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetTXBCR_CR29() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetTXBCR_CR30(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetTXBCR_CR30() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetTXBCR_CR31(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetTXBCR_CR31() uint32 {
	return (volatile.LoadUint32(&o.TXBCR.Reg) & 0x80000000) >> 31
}

// MCAN.TXBTO: Transmit Buffer Transmission Occurred Register
func (o *MCAN_Type) SetTXBTO_TO0(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetTXBTO_TO0() uint32 {
	return volatile.LoadUint32(&o.TXBTO.Reg) & 0x1
}
func (o *MCAN_Type) SetTXBTO_TO1(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetTXBTO_TO1() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetTXBTO_TO2(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetTXBTO_TO2() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetTXBTO_TO3(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetTXBTO_TO3() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetTXBTO_TO4(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetTXBTO_TO4() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetTXBTO_TO5(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetTXBTO_TO5() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetTXBTO_TO6(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetTXBTO_TO6() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetTXBTO_TO7(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetTXBTO_TO7() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetTXBTO_TO8(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetTXBTO_TO8() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetTXBTO_TO9(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetTXBTO_TO9() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetTXBTO_TO10(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetTXBTO_TO10() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetTXBTO_TO11(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetTXBTO_TO11() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetTXBTO_TO12(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetTXBTO_TO12() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetTXBTO_TO13(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetTXBTO_TO13() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetTXBTO_TO14(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetTXBTO_TO14() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetTXBTO_TO15(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetTXBTO_TO15() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetTXBTO_TO16(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetTXBTO_TO16() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetTXBTO_TO17(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetTXBTO_TO17() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetTXBTO_TO18(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetTXBTO_TO18() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetTXBTO_TO19(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetTXBTO_TO19() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetTXBTO_TO20(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetTXBTO_TO20() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetTXBTO_TO21(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetTXBTO_TO21() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetTXBTO_TO22(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetTXBTO_TO22() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetTXBTO_TO23(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetTXBTO_TO23() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetTXBTO_TO24(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetTXBTO_TO24() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetTXBTO_TO25(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetTXBTO_TO25() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetTXBTO_TO26(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetTXBTO_TO26() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetTXBTO_TO27(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetTXBTO_TO27() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetTXBTO_TO28(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetTXBTO_TO28() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetTXBTO_TO29(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetTXBTO_TO29() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetTXBTO_TO30(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetTXBTO_TO30() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetTXBTO_TO31(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetTXBTO_TO31() uint32 {
	return (volatile.LoadUint32(&o.TXBTO.Reg) & 0x80000000) >> 31
}

// MCAN.TXBCF: Transmit Buffer Cancellation Finished Register
func (o *MCAN_Type) SetTXBCF_CF0(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetTXBCF_CF0() uint32 {
	return volatile.LoadUint32(&o.TXBCF.Reg) & 0x1
}
func (o *MCAN_Type) SetTXBCF_CF1(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetTXBCF_CF1() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetTXBCF_CF2(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetTXBCF_CF2() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetTXBCF_CF3(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetTXBCF_CF3() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetTXBCF_CF4(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetTXBCF_CF4() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetTXBCF_CF5(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetTXBCF_CF5() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetTXBCF_CF6(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetTXBCF_CF6() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetTXBCF_CF7(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetTXBCF_CF7() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetTXBCF_CF8(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetTXBCF_CF8() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetTXBCF_CF9(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetTXBCF_CF9() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetTXBCF_CF10(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetTXBCF_CF10() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetTXBCF_CF11(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetTXBCF_CF11() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetTXBCF_CF12(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetTXBCF_CF12() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetTXBCF_CF13(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetTXBCF_CF13() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetTXBCF_CF14(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetTXBCF_CF14() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetTXBCF_CF15(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetTXBCF_CF15() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetTXBCF_CF16(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetTXBCF_CF16() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetTXBCF_CF17(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetTXBCF_CF17() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetTXBCF_CF18(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetTXBCF_CF18() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetTXBCF_CF19(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetTXBCF_CF19() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetTXBCF_CF20(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetTXBCF_CF20() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetTXBCF_CF21(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetTXBCF_CF21() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetTXBCF_CF22(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetTXBCF_CF22() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetTXBCF_CF23(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetTXBCF_CF23() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetTXBCF_CF24(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetTXBCF_CF24() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetTXBCF_CF25(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetTXBCF_CF25() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetTXBCF_CF26(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetTXBCF_CF26() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetTXBCF_CF27(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetTXBCF_CF27() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetTXBCF_CF28(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetTXBCF_CF28() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetTXBCF_CF29(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetTXBCF_CF29() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetTXBCF_CF30(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetTXBCF_CF30() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetTXBCF_CF31(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetTXBCF_CF31() uint32 {
	return (volatile.LoadUint32(&o.TXBCF.Reg) & 0x80000000) >> 31
}

// MCAN.TXBTIE: Transmit Buffer Transmission Interrupt Enable Register
func (o *MCAN_Type) SetTXBTIE_TIE0(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetTXBTIE_TIE0() uint32 {
	return volatile.LoadUint32(&o.TXBTIE.Reg) & 0x1
}
func (o *MCAN_Type) SetTXBTIE_TIE1(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetTXBTIE_TIE1() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetTXBTIE_TIE2(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetTXBTIE_TIE2() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetTXBTIE_TIE3(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetTXBTIE_TIE3() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetTXBTIE_TIE4(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetTXBTIE_TIE4() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetTXBTIE_TIE5(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetTXBTIE_TIE5() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetTXBTIE_TIE6(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetTXBTIE_TIE6() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetTXBTIE_TIE7(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetTXBTIE_TIE7() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetTXBTIE_TIE8(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetTXBTIE_TIE8() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetTXBTIE_TIE9(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetTXBTIE_TIE9() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetTXBTIE_TIE10(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetTXBTIE_TIE10() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetTXBTIE_TIE11(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetTXBTIE_TIE11() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetTXBTIE_TIE12(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetTXBTIE_TIE12() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetTXBTIE_TIE13(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetTXBTIE_TIE13() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetTXBTIE_TIE14(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetTXBTIE_TIE14() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetTXBTIE_TIE15(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetTXBTIE_TIE15() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetTXBTIE_TIE16(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetTXBTIE_TIE16() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetTXBTIE_TIE17(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetTXBTIE_TIE17() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetTXBTIE_TIE18(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetTXBTIE_TIE18() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetTXBTIE_TIE19(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetTXBTIE_TIE19() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetTXBTIE_TIE20(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetTXBTIE_TIE20() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetTXBTIE_TIE21(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetTXBTIE_TIE21() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetTXBTIE_TIE22(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetTXBTIE_TIE22() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetTXBTIE_TIE23(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetTXBTIE_TIE23() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetTXBTIE_TIE24(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetTXBTIE_TIE24() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetTXBTIE_TIE25(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetTXBTIE_TIE25() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetTXBTIE_TIE26(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetTXBTIE_TIE26() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetTXBTIE_TIE27(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetTXBTIE_TIE27() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetTXBTIE_TIE28(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetTXBTIE_TIE28() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetTXBTIE_TIE29(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetTXBTIE_TIE29() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetTXBTIE_TIE30(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetTXBTIE_TIE30() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetTXBTIE_TIE31(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetTXBTIE_TIE31() uint32 {
	return (volatile.LoadUint32(&o.TXBTIE.Reg) & 0x80000000) >> 31
}

// MCAN.TXBCIE: Transmit Buffer Cancellation Finished Interrupt Enable Register
func (o *MCAN_Type) SetTXBCIE_CFIE0(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetTXBCIE_CFIE0() uint32 {
	return volatile.LoadUint32(&o.TXBCIE.Reg) & 0x1
}
func (o *MCAN_Type) SetTXBCIE_CFIE1(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetTXBCIE_CFIE1() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetTXBCIE_CFIE2(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetTXBCIE_CFIE2() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetTXBCIE_CFIE3(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetTXBCIE_CFIE3() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetTXBCIE_CFIE4(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetTXBCIE_CFIE4() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetTXBCIE_CFIE5(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetTXBCIE_CFIE5() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetTXBCIE_CFIE6(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetTXBCIE_CFIE6() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetTXBCIE_CFIE7(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetTXBCIE_CFIE7() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetTXBCIE_CFIE8(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetTXBCIE_CFIE8() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetTXBCIE_CFIE9(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetTXBCIE_CFIE9() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetTXBCIE_CFIE10(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetTXBCIE_CFIE10() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetTXBCIE_CFIE11(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetTXBCIE_CFIE11() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetTXBCIE_CFIE12(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetTXBCIE_CFIE12() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetTXBCIE_CFIE13(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetTXBCIE_CFIE13() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetTXBCIE_CFIE14(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetTXBCIE_CFIE14() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetTXBCIE_CFIE15(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetTXBCIE_CFIE15() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetTXBCIE_CFIE16(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetTXBCIE_CFIE16() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetTXBCIE_CFIE17(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetTXBCIE_CFIE17() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetTXBCIE_CFIE18(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetTXBCIE_CFIE18() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetTXBCIE_CFIE19(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetTXBCIE_CFIE19() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetTXBCIE_CFIE20(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetTXBCIE_CFIE20() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetTXBCIE_CFIE21(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetTXBCIE_CFIE21() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetTXBCIE_CFIE22(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetTXBCIE_CFIE22() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetTXBCIE_CFIE23(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetTXBCIE_CFIE23() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetTXBCIE_CFIE24(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetTXBCIE_CFIE24() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetTXBCIE_CFIE25(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetTXBCIE_CFIE25() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetTXBCIE_CFIE26(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetTXBCIE_CFIE26() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetTXBCIE_CFIE27(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetTXBCIE_CFIE27() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetTXBCIE_CFIE28(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetTXBCIE_CFIE28() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetTXBCIE_CFIE29(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetTXBCIE_CFIE29() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetTXBCIE_CFIE30(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetTXBCIE_CFIE30() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetTXBCIE_CFIE31(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetTXBCIE_CFIE31() uint32 {
	return (volatile.LoadUint32(&o.TXBCIE.Reg) & 0x80000000) >> 31
}

// MCAN.TXEFC: Transmit Event FIFO Configuration Register
func (o *MCAN_Type) SetTXEFC_EFSA(value uint32) {
	volatile.StoreUint32(&o.TXEFC.Reg, volatile.LoadUint32(&o.TXEFC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetTXEFC_EFSA() uint32 {
	return (volatile.LoadUint32(&o.TXEFC.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetTXEFC_EFS(value uint32) {
	volatile.StoreUint32(&o.TXEFC.Reg, volatile.LoadUint32(&o.TXEFC.Reg)&^(0x3f0000)|value<<16)
}
func (o *MCAN_Type) GetTXEFC_EFS() uint32 {
	return (volatile.LoadUint32(&o.TXEFC.Reg) & 0x3f0000) >> 16
}
func (o *MCAN_Type) SetTXEFC_EFWM(value uint32) {
	volatile.StoreUint32(&o.TXEFC.Reg, volatile.LoadUint32(&o.TXEFC.Reg)&^(0x3f000000)|value<<24)
}
func (o *MCAN_Type) GetTXEFC_EFWM() uint32 {
	return (volatile.LoadUint32(&o.TXEFC.Reg) & 0x3f000000) >> 24
}

// MCAN.TXEFS: Transmit Event FIFO Status Register
func (o *MCAN_Type) SetTXEFS_EFFL(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetTXEFS_EFFL() uint32 {
	return volatile.LoadUint32(&o.TXEFS.Reg) & 0x3f
}
func (o *MCAN_Type) SetTXEFS_EFGI(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x1f00)|value<<8)
}
func (o *MCAN_Type) GetTXEFS_EFGI() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x1f00) >> 8
}
func (o *MCAN_Type) SetTXEFS_EFPI(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x1f0000)|value<<16)
}
func (o *MCAN_Type) GetTXEFS_EFPI() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x1f0000) >> 16
}
func (o *MCAN_Type) SetTXEFS_EFF(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetTXEFS_EFF() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetTXEFS_TEFL(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetTXEFS_TEFL() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x2000000) >> 25
}

// MCAN.TXEFA: Transmit Event FIFO Acknowledge Register
func (o *MCAN_Type) SetTXEFA_EFAI(value uint32) {
	volatile.StoreUint32(&o.TXEFA.Reg, volatile.LoadUint32(&o.TXEFA.Reg)&^(0x1f)|value)
}
func (o *MCAN_Type) GetTXEFA_EFAI() uint32 {
	return volatile.LoadUint32(&o.TXEFA.Reg) & 0x1f
}

// Parallel Input/Output Controller
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [20]byte
	DRIVER  volatile.Register32 // 0x118
	_       [52]byte
	PCMR    volatile.Register32 // 0x150
	PCIER   volatile.Register32 // 0x154
	PCIDR   volatile.Register32 // 0x158
	PCIMR   volatile.Register32 // 0x15C
	PCISR   volatile.Register32 // 0x160
	PCRHR   volatile.Register32 // 0x164
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000000) >> 31
}

// PIO.SODR: Set Output Data Register
func (o *PIO_Type) SetSODR_P0(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSODR_P0() uint32 {
	return volatile.LoadUint32(&o.SODR.Reg) & 0x1
}
func (o *PIO_Type) SetSODR_P1(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSODR_P1() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSODR_P2(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSODR_P2() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSODR_P3(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSODR_P3() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSODR_P4(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSODR_P4() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSODR_P5(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSODR_P5() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSODR_P6(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSODR_P6() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSODR_P7(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSODR_P7() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSODR_P8(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSODR_P8() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSODR_P9(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSODR_P9() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSODR_P10(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSODR_P10() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSODR_P11(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSODR_P11() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSODR_P12(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSODR_P12() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSODR_P13(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSODR_P13() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSODR_P14(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSODR_P14() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSODR_P15(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSODR_P15() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSODR_P16(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSODR_P16() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSODR_P17(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSODR_P17() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSODR_P18(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSODR_P18() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSODR_P19(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSODR_P19() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSODR_P20(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSODR_P20() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSODR_P21(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSODR_P21() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSODR_P22(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSODR_P22() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSODR_P23(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSODR_P23() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSODR_P24(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSODR_P24() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSODR_P25(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSODR_P25() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSODR_P26(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSODR_P26() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSODR_P27(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSODR_P27() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSODR_P28(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSODR_P28() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSODR_P29(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSODR_P29() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSODR_P30(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSODR_P30() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSODR_P31(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSODR_P31() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000000) >> 31
}

// PIO.CODR: Clear Output Data Register
func (o *PIO_Type) SetCODR_P0(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetCODR_P0() uint32 {
	return volatile.LoadUint32(&o.CODR.Reg) & 0x1
}
func (o *PIO_Type) SetCODR_P1(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetCODR_P1() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetCODR_P2(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetCODR_P2() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetCODR_P3(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetCODR_P3() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetCODR_P4(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetCODR_P4() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetCODR_P5(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetCODR_P5() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetCODR_P6(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetCODR_P6() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetCODR_P7(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetCODR_P7() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetCODR_P8(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetCODR_P8() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetCODR_P9(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetCODR_P9() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetCODR_P10(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetCODR_P10() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetCODR_P11(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetCODR_P11() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetCODR_P12(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetCODR_P12() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetCODR_P13(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetCODR_P13() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetCODR_P14(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetCODR_P14() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetCODR_P15(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetCODR_P15() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetCODR_P16(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetCODR_P16() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetCODR_P17(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetCODR_P17() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetCODR_P18(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetCODR_P18() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetCODR_P19(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetCODR_P19() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetCODR_P20(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetCODR_P20() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetCODR_P21(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetCODR_P21() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetCODR_P22(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetCODR_P22() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetCODR_P23(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetCODR_P23() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetCODR_P24(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetCODR_P24() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetCODR_P25(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetCODR_P25() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetCODR_P26(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetCODR_P26() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetCODR_P27(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetCODR_P27() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetCODR_P28(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetCODR_P28() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetCODR_P29(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetCODR_P29() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetCODR_P30(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetCODR_P30() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetCODR_P31(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetCODR_P31() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000000) >> 31
}

// PIO.ODSR: Output Data Status Register
func (o *PIO_Type) SetODSR_P0(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODSR_P0() uint32 {
	return volatile.LoadUint32(&o.ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetODSR_P1(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODSR_P2(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODSR_P3(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODSR_P4(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODSR_P5(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODSR_P6(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODSR_P7(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODSR_P8(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODSR_P9(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODSR_P10(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODSR_P11(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODSR_P12(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODSR_P13(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODSR_P14(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODSR_P15(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODSR_P16(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODSR_P17(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODSR_P18(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODSR_P19(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODSR_P20(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODSR_P21(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODSR_P22(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODSR_P23(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODSR_P24(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODSR_P25(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODSR_P26(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODSR_P27(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODSR_P28(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODSR_P29(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODSR_P30(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODSR_P31(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PDSR: Pin Data Status Register
func (o *PIO_Type) SetPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000000) >> 31
}

// PIO.IER: Interrupt Enable Register
func (o *PIO_Type) SetIER_P0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIER_P0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PIO_Type) SetIER_P1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIER_P1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIER_P2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIER_P2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIER_P3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIER_P3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIER_P4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIER_P4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIER_P5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIER_P5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIER_P6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIER_P6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIER_P7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIER_P7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIER_P8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIER_P8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIER_P9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIER_P9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIER_P10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIER_P10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIER_P11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIER_P11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIER_P12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIER_P12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIER_P13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIER_P13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIER_P14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIER_P14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIER_P15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIER_P15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIER_P16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIER_P16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIER_P17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIER_P17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIER_P18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIER_P18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIER_P19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIER_P19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIER_P20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIER_P20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIER_P21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIER_P21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIER_P22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIER_P22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIER_P23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIER_P23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIER_P24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIER_P24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIER_P25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIER_P25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIER_P26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIER_P26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIER_P27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIER_P27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIER_P28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIER_P28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIER_P29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIER_P29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIER_P30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIER_P30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIER_P31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIER_P31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// PIO.IDR: Interrupt Disable Register
func (o *PIO_Type) SetIDR_P0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIDR_P0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PIO_Type) SetIDR_P1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIDR_P2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIDR_P3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIDR_P4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIDR_P5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIDR_P6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIDR_P7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIDR_P8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIDR_P9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIDR_P10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIDR_P11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIDR_P12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIDR_P13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIDR_P14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIDR_P15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIDR_P16(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIDR_P17(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIDR_P18(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIDR_P19(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIDR_P20(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIDR_P21(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIDR_P22(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIDR_P23(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIDR_P24(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIDR_P25(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIDR_P26(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIDR_P27(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIDR_P28(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIDR_P29(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIDR_P30(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIDR_P31(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// PIO.IMR: Interrupt Mask Register
func (o *PIO_Type) SetIMR_P0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIMR_P0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PIO_Type) SetIMR_P1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIMR_P1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIMR_P2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIMR_P2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIMR_P3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIMR_P3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIMR_P4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIMR_P4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIMR_P5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIMR_P5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIMR_P6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIMR_P6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIMR_P7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIMR_P7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIMR_P8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIMR_P8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIMR_P9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIMR_P9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIMR_P10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIMR_P10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIMR_P11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIMR_P11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIMR_P12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIMR_P12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIMR_P13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIMR_P13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIMR_P14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIMR_P14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIMR_P15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIMR_P15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIMR_P16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIMR_P16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIMR_P17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIMR_P17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIMR_P18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIMR_P18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIMR_P19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIMR_P19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIMR_P20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIMR_P20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIMR_P21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIMR_P21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIMR_P22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIMR_P22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIMR_P23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIMR_P23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIMR_P24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIMR_P24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIMR_P25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIMR_P25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIMR_P26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIMR_P26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIMR_P27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIMR_P27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIMR_P28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIMR_P28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIMR_P29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIMR_P29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIMR_P30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIMR_P30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIMR_P31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIMR_P31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// PIO.ISR: Interrupt Status Register
func (o *PIO_Type) SetISR_P0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetISR_P0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PIO_Type) SetISR_P1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetISR_P1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetISR_P2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetISR_P2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetISR_P3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetISR_P3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetISR_P4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetISR_P4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetISR_P5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetISR_P5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetISR_P6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetISR_P6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetISR_P7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetISR_P7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetISR_P8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetISR_P8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetISR_P9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetISR_P9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetISR_P10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetISR_P10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetISR_P11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetISR_P11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetISR_P12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetISR_P12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetISR_P13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetISR_P13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetISR_P14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetISR_P14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetISR_P15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetISR_P15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetISR_P16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetISR_P16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetISR_P17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetISR_P17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetISR_P18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetISR_P18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetISR_P19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetISR_P19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetISR_P20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetISR_P20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetISR_P21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetISR_P21() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetISR_P22(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetISR_P22() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetISR_P23(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetISR_P23() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetISR_P24(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetISR_P24() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetISR_P25(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetISR_P25() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetISR_P26(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetISR_P26() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetISR_P27(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetISR_P27() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetISR_P28(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetISR_P28() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetISR_P29(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetISR_P29() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetISR_P30(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetISR_P30() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetISR_P31(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetISR_P31() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// PIO.MDER: Multi-driver Enable Register
func (o *PIO_Type) SetMDER_P0(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDER_P0() uint32 {
	return volatile.LoadUint32(&o.MDER.Reg) & 0x1
}
func (o *PIO_Type) SetMDER_P1(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDER_P1() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDER_P2(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDER_P2() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDER_P3(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDER_P3() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDER_P4(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDER_P4() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDER_P5(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDER_P5() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDER_P6(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDER_P6() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDER_P7(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDER_P7() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDER_P8(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDER_P8() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDER_P9(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDER_P9() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDER_P10(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDER_P10() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDER_P11(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDER_P11() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDER_P12(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDER_P12() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDER_P13(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDER_P13() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDER_P14(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDER_P14() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDER_P15(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDER_P15() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDER_P16(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDER_P16() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDER_P17(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDER_P17() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDER_P18(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDER_P18() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDER_P19(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDER_P19() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDER_P20(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDER_P20() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDER_P21(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDER_P21() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDER_P22(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDER_P22() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDER_P23(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDER_P23() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDER_P24(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDER_P24() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDER_P25(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDER_P25() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDER_P26(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDER_P26() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDER_P27(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDER_P27() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDER_P28(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDER_P28() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDER_P29(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDER_P29() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDER_P30(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDER_P30() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDER_P31(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDER_P31() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000000) >> 31
}

// PIO.MDDR: Multi-driver Disable Register
func (o *PIO_Type) SetMDDR_P0(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDDR_P0() uint32 {
	return volatile.LoadUint32(&o.MDDR.Reg) & 0x1
}
func (o *PIO_Type) SetMDDR_P1(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDDR_P2(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDDR_P3(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDDR_P4(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDDR_P5(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDDR_P6(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDDR_P7(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDDR_P8(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDDR_P9(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDDR_P10(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDDR_P11(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDDR_P12(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDDR_P13(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDDR_P14(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDDR_P15(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDDR_P16(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDDR_P17(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDDR_P18(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDDR_P19(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDDR_P20(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDDR_P21(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDDR_P22(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDDR_P23(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDDR_P24(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDDR_P25(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDDR_P26(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDDR_P27(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDDR_P28(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDDR_P29(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDDR_P30(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDDR_P31(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000000) >> 31
}

// PIO.MDSR: Multi-driver Status Register
func (o *PIO_Type) SetMDSR_P0(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDSR_P0() uint32 {
	return volatile.LoadUint32(&o.MDSR.Reg) & 0x1
}
func (o *PIO_Type) SetMDSR_P1(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDSR_P2(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDSR_P3(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDSR_P4(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDSR_P5(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDSR_P6(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDSR_P7(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDSR_P8(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDSR_P9(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDSR_P10(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDSR_P11(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDSR_P12(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDSR_P13(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDSR_P14(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDSR_P15(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDSR_P16(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDSR_P17(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDSR_P18(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDSR_P19(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDSR_P20(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDSR_P21(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDSR_P22(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDSR_P23(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDSR_P24(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDSR_P25(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDSR_P26(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDSR_P27(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDSR_P28(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDSR_P29(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDSR_P30(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDSR_P31(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000000) >> 31
}

// PIO.PUDR: Pull-up Disable Register
func (o *PIO_Type) SetPUDR_P0(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUDR_P0() uint32 {
	return volatile.LoadUint32(&o.PUDR.Reg) & 0x1
}
func (o *PIO_Type) SetPUDR_P1(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUDR_P2(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUDR_P3(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUDR_P4(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUDR_P5(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUDR_P6(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUDR_P7(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUDR_P8(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUDR_P9(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUDR_P10(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUDR_P11(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUDR_P12(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUDR_P13(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUDR_P14(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUDR_P15(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUDR_P16(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUDR_P17(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUDR_P18(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUDR_P19(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUDR_P20(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUDR_P21(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUDR_P22(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUDR_P23(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUDR_P24(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUDR_P25(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUDR_P26(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUDR_P27(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUDR_P28(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUDR_P29(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUDR_P30(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUDR_P31(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000000) >> 31
}

// PIO.PUER: Pull-up Enable Register
func (o *PIO_Type) SetPUER_P0(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUER_P0() uint32 {
	return volatile.LoadUint32(&o.PUER.Reg) & 0x1
}
func (o *PIO_Type) SetPUER_P1(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUER_P1() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUER_P2(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUER_P2() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUER_P3(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUER_P3() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUER_P4(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUER_P4() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUER_P5(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUER_P5() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUER_P6(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUER_P6() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUER_P7(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUER_P7() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUER_P8(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUER_P8() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUER_P9(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUER_P9() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUER_P10(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUER_P10() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUER_P11(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUER_P11() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUER_P12(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUER_P12() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUER_P13(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUER_P13() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUER_P14(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUER_P14() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUER_P15(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUER_P15() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUER_P16(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUER_P16() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUER_P17(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUER_P17() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUER_P18(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUER_P18() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUER_P19(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUER_P19() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUER_P20(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUER_P20() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUER_P21(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUER_P21() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUER_P22(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUER_P22() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUER_P23(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUER_P23() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUER_P24(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUER_P24() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUER_P25(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUER_P25() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUER_P26(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUER_P26() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUER_P27(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUER_P27() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUER_P28(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUER_P28() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUER_P29(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUER_P29() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUER_P30(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUER_P30() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUER_P31(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUER_P31() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000000) >> 31
}

// PIO.PUSR: Pad Pull-up Status Register
func (o *PIO_Type) SetPUSR_P0(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUSR_P0() uint32 {
	return volatile.LoadUint32(&o.PUSR.Reg) & 0x1
}
func (o *PIO_Type) SetPUSR_P1(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUSR_P2(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUSR_P3(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUSR_P4(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUSR_P5(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUSR_P6(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUSR_P7(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUSR_P8(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUSR_P9(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUSR_P10(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUSR_P11(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUSR_P12(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUSR_P13(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUSR_P14(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUSR_P15(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUSR_P16(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUSR_P17(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUSR_P18(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUSR_P19(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUSR_P20(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUSR_P21(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUSR_P22(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUSR_P23(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUSR_P24(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUSR_P25(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUSR_P26(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUSR_P27(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUSR_P28(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUSR_P29(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUSR_P30(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUSR_P31(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000000) >> 31
}

// PIO.ABCDSR: Peripheral ABCD Select Register 0
func (o *PIO_Type) SetABCDSR_P0(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetABCDSR_P0(idx int) uint32 {
	return volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1
}
func (o *PIO_Type) SetABCDSR_P1(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetABCDSR_P1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetABCDSR_P2(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetABCDSR_P2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetABCDSR_P3(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetABCDSR_P3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetABCDSR_P4(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetABCDSR_P4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetABCDSR_P5(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetABCDSR_P5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetABCDSR_P6(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetABCDSR_P6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetABCDSR_P7(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetABCDSR_P7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetABCDSR_P8(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetABCDSR_P8(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetABCDSR_P9(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetABCDSR_P9(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetABCDSR_P10(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetABCDSR_P10(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetABCDSR_P11(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetABCDSR_P11(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetABCDSR_P12(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetABCDSR_P12(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetABCDSR_P13(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetABCDSR_P13(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetABCDSR_P14(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetABCDSR_P14(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetABCDSR_P15(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetABCDSR_P15(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetABCDSR_P16(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetABCDSR_P16(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetABCDSR_P17(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetABCDSR_P17(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetABCDSR_P18(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetABCDSR_P18(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetABCDSR_P19(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetABCDSR_P19(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetABCDSR_P20(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetABCDSR_P20(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetABCDSR_P21(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetABCDSR_P21(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetABCDSR_P22(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetABCDSR_P22(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetABCDSR_P23(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetABCDSR_P23(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetABCDSR_P24(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetABCDSR_P24(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetABCDSR_P25(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetABCDSR_P25(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetABCDSR_P26(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetABCDSR_P26(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetABCDSR_P27(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetABCDSR_P27(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetABCDSR_P28(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetABCDSR_P28(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetABCDSR_P29(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetABCDSR_P29(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetABCDSR_P30(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetABCDSR_P30(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetABCDSR_P31(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetABCDSR_P31(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000000) >> 31
}

// PIO.IFSCDR: Input Filter Slow Clock Disable Register
func (o *PIO_Type) SetIFSCDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSCER: Input Filter Slow Clock Enable Register
func (o *PIO_Type) SetIFSCER_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCER_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCER.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCER_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCER_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCER_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCER_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCER_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCER_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCER_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCER_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCER_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCER_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCER_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCER_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCER_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCER_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCER_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCER_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCER_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCER_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCER_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCER_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCER_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCER_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCER_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCER_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCER_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCER_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCER_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCER_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCER_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCER_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCER_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000000) >> 31
}

// PIO.IFSCSR: Input Filter Slow Clock Status Register
func (o *PIO_Type) SetIFSCSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000000) >> 31
}

// PIO.SCDR: Slow Clock Divider Debouncing Register
func (o *PIO_Type) SetSCDR_DIV(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x3fff)|value)
}
func (o *PIO_Type) GetSCDR_DIV() uint32 {
	return volatile.LoadUint32(&o.SCDR.Reg) & 0x3fff
}

// PIO.PPDDR: Pad Pull-down Disable Register
func (o *PIO_Type) SetPPDDR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDDR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDDR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDDR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDDR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDDR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDDR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDDR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDDR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDDR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDDR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDDR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDDR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDDR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDDR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDDR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDDR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDDR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDDR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDDR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDDR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDDR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDDR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDDR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDDR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDDR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDDR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDDR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDDR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDDR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDDR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDDR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDDR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDDR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000000) >> 31
}

// PIO.PPDER: Pad Pull-down Enable Register
func (o *PIO_Type) SetPPDER_P0(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDER_P0() uint32 {
	return volatile.LoadUint32(&o.PPDER.Reg) & 0x1
}
func (o *PIO_Type) SetPPDER_P1(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDER_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDER_P2(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDER_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDER_P3(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDER_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDER_P4(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDER_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDER_P5(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDER_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDER_P6(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDER_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDER_P7(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDER_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDER_P8(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDER_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDER_P9(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDER_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDER_P10(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDER_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDER_P11(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDER_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDER_P12(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDER_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDER_P13(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDER_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDER_P14(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDER_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDER_P15(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDER_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDER_P16(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDER_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDER_P17(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDER_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDER_P18(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDER_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDER_P19(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDER_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDER_P20(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDER_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDER_P21(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDER_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDER_P22(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDER_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDER_P23(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDER_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDER_P24(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDER_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDER_P25(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDER_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDER_P26(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDER_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDER_P27(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDER_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDER_P28(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDER_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDER_P29(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDER_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDER_P30(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDER_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDER_P31(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDER_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000000) >> 31
}

// PIO.PPDSR: Pad Pull-down Status Register
func (o *PIO_Type) SetPPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000000) >> 31
}

// PIO.OWER: Output Write Enable
func (o *PIO_Type) SetOWER_P0(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWER_P0() uint32 {
	return volatile.LoadUint32(&o.OWER.Reg) & 0x1
}
func (o *PIO_Type) SetOWER_P1(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWER_P1() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWER_P2(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWER_P2() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWER_P3(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWER_P3() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWER_P4(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWER_P4() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWER_P5(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWER_P5() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWER_P6(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWER_P6() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWER_P7(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWER_P7() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWER_P8(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWER_P8() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWER_P9(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWER_P9() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWER_P10(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWER_P10() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWER_P11(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWER_P11() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWER_P12(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWER_P12() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWER_P13(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWER_P13() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWER_P14(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWER_P14() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWER_P15(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWER_P15() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWER_P16(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWER_P16() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWER_P17(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWER_P17() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWER_P18(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWER_P18() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWER_P19(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWER_P19() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWER_P20(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWER_P20() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWER_P21(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWER_P21() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWER_P22(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWER_P22() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWER_P23(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWER_P23() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWER_P24(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWER_P24() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWER_P25(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWER_P25() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWER_P26(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWER_P26() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWER_P27(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWER_P27() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWER_P28(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWER_P28() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWER_P29(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWER_P29() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWER_P30(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWER_P30() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWER_P31(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWER_P31() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000000) >> 31
}

// PIO.OWDR: Output Write Disable
func (o *PIO_Type) SetOWDR_P0(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWDR_P0() uint32 {
	return volatile.LoadUint32(&o.OWDR.Reg) & 0x1
}
func (o *PIO_Type) SetOWDR_P1(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWDR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWDR_P2(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWDR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWDR_P3(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWDR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWDR_P4(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWDR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWDR_P5(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWDR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWDR_P6(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWDR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWDR_P7(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWDR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWDR_P8(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWDR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWDR_P9(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWDR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWDR_P10(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWDR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWDR_P11(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWDR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWDR_P12(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWDR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWDR_P13(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWDR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWDR_P14(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWDR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWDR_P15(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWDR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWDR_P16(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWDR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWDR_P17(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWDR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWDR_P18(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWDR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWDR_P19(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWDR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWDR_P20(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWDR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWDR_P21(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWDR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWDR_P22(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWDR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWDR_P23(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWDR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWDR_P24(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWDR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWDR_P25(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWDR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWDR_P26(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWDR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWDR_P27(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWDR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWDR_P28(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWDR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWDR_P29(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWDR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWDR_P30(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWDR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWDR_P31(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWDR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000000) >> 31
}

// PIO.OWSR: Output Write Status Register
func (o *PIO_Type) SetOWSR_P0(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWSR_P0() uint32 {
	return volatile.LoadUint32(&o.OWSR.Reg) & 0x1
}
func (o *PIO_Type) SetOWSR_P1(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWSR_P2(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWSR_P3(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWSR_P4(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWSR_P5(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWSR_P6(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWSR_P7(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWSR_P8(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWSR_P9(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWSR_P10(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWSR_P11(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWSR_P12(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWSR_P13(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWSR_P14(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWSR_P15(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWSR_P16(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWSR_P17(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWSR_P18(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWSR_P19(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWSR_P20(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWSR_P21(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWSR_P22(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWSR_P23(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWSR_P24(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWSR_P25(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWSR_P26(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWSR_P27(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWSR_P28(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWSR_P29(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWSR_P30(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWSR_P31(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000000) >> 31
}

// PIO.AIMER: Additional Interrupt Modes Enable Register
func (o *PIO_Type) SetAIMER_P0(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMER_P0() uint32 {
	return volatile.LoadUint32(&o.AIMER.Reg) & 0x1
}
func (o *PIO_Type) SetAIMER_P1(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMER_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMER_P2(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMER_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMER_P3(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMER_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMER_P4(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMER_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMER_P5(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMER_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMER_P6(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMER_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMER_P7(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMER_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMER_P8(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMER_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMER_P9(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMER_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMER_P10(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMER_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMER_P11(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMER_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMER_P12(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMER_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMER_P13(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMER_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMER_P14(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMER_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMER_P15(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMER_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMER_P16(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMER_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMER_P17(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMER_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMER_P18(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMER_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMER_P19(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMER_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMER_P20(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMER_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMER_P21(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMER_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMER_P22(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMER_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMER_P23(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMER_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMER_P24(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMER_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMER_P25(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMER_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMER_P26(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMER_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMER_P27(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMER_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMER_P28(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMER_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMER_P29(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMER_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMER_P30(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMER_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMER_P31(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMER_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000000) >> 31
}

// PIO.AIMDR: Additional Interrupt Modes Disable Register
func (o *PIO_Type) SetAIMDR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMDR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMDR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMDR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMDR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMDR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMDR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMDR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMDR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMDR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMDR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMDR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMDR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMDR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMDR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMDR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMDR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMDR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMDR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMDR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMDR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMDR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMDR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMDR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMDR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMDR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMDR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMDR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMDR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMDR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMDR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMDR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMDR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMDR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMDR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMDR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMDR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMDR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMDR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMDR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMDR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMDR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMDR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMDR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMDR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMDR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMDR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMDR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMDR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMDR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMDR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMDR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMDR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMDR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMDR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMDR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMDR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMDR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMDR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMDR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMDR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMDR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMDR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMDR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMDR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000000) >> 31
}

// PIO.AIMMR: Additional Interrupt Modes Mask Register
func (o *PIO_Type) SetAIMMR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMMR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMMR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMMR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMMR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMMR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMMR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMMR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMMR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMMR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMMR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMMR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMMR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMMR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMMR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMMR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMMR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMMR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMMR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMMR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMMR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMMR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMMR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMMR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMMR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMMR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMMR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMMR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMMR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMMR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMMR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMMR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMMR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMMR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMMR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMMR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMMR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMMR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMMR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMMR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMMR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMMR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMMR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMMR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMMR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMMR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMMR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMMR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMMR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMMR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMMR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMMR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMMR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMMR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMMR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMMR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMMR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMMR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMMR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMMR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMMR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMMR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMMR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMMR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMMR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000000) >> 31
}

// PIO.ESR: Edge Select Register
func (o *PIO_Type) SetESR_P0(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetESR_P0() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}
func (o *PIO_Type) SetESR_P1(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetESR_P1() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetESR_P2(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetESR_P2() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetESR_P3(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetESR_P3() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetESR_P4(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetESR_P4() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetESR_P5(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetESR_P5() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetESR_P6(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetESR_P6() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetESR_P7(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetESR_P7() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetESR_P8(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetESR_P8() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetESR_P9(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetESR_P9() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetESR_P10(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetESR_P10() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetESR_P11(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetESR_P11() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetESR_P12(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetESR_P12() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetESR_P13(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetESR_P13() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetESR_P14(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetESR_P14() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetESR_P15(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetESR_P15() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetESR_P16(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetESR_P16() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetESR_P17(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetESR_P17() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetESR_P18(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetESR_P18() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetESR_P19(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetESR_P19() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetESR_P20(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetESR_P20() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetESR_P21(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetESR_P21() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetESR_P22(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetESR_P22() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetESR_P23(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetESR_P23() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetESR_P24(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetESR_P24() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetESR_P25(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetESR_P25() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetESR_P26(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetESR_P26() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetESR_P27(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetESR_P27() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetESR_P28(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetESR_P28() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetESR_P29(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetESR_P29() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetESR_P30(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetESR_P30() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetESR_P31(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetESR_P31() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000000) >> 31
}

// PIO.LSR: Level Select Register
func (o *PIO_Type) SetLSR_P0(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLSR_P0() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *PIO_Type) SetLSR_P1(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLSR_P2(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLSR_P3(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLSR_P4(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLSR_P5(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLSR_P6(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLSR_P7(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLSR_P8(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLSR_P9(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLSR_P10(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLSR_P11(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLSR_P12(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLSR_P13(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLSR_P14(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLSR_P15(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLSR_P16(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLSR_P17(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLSR_P18(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLSR_P19(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLSR_P20(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLSR_P21(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLSR_P22(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLSR_P23(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLSR_P24(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLSR_P25(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLSR_P26(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLSR_P27(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLSR_P28(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLSR_P29(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLSR_P30(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLSR_P31(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000000) >> 31
}

// PIO.ELSR: Edge/Level Status Register
func (o *PIO_Type) SetELSR_P0(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetELSR_P0() uint32 {
	return volatile.LoadUint32(&o.ELSR.Reg) & 0x1
}
func (o *PIO_Type) SetELSR_P1(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetELSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetELSR_P2(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetELSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetELSR_P3(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetELSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetELSR_P4(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetELSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetELSR_P5(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetELSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetELSR_P6(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetELSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetELSR_P7(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetELSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetELSR_P8(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetELSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetELSR_P9(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetELSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetELSR_P10(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetELSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetELSR_P11(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetELSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetELSR_P12(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetELSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetELSR_P13(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetELSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetELSR_P14(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetELSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetELSR_P15(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetELSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetELSR_P16(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetELSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetELSR_P17(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetELSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetELSR_P18(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetELSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetELSR_P19(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetELSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetELSR_P20(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetELSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetELSR_P21(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetELSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetELSR_P22(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetELSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetELSR_P23(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetELSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetELSR_P24(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetELSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetELSR_P25(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetELSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetELSR_P26(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetELSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetELSR_P27(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetELSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetELSR_P28(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetELSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetELSR_P29(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetELSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetELSR_P30(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetELSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetELSR_P31(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetELSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000000) >> 31
}

// PIO.FELLSR: Falling Edge/Low-Level Select Register
func (o *PIO_Type) SetFELLSR_P0(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFELLSR_P0() uint32 {
	return volatile.LoadUint32(&o.FELLSR.Reg) & 0x1
}
func (o *PIO_Type) SetFELLSR_P1(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFELLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFELLSR_P2(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFELLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFELLSR_P3(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFELLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFELLSR_P4(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFELLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFELLSR_P5(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFELLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFELLSR_P6(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFELLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFELLSR_P7(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFELLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFELLSR_P8(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFELLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFELLSR_P9(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFELLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFELLSR_P10(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFELLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFELLSR_P11(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFELLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFELLSR_P12(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFELLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFELLSR_P13(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFELLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFELLSR_P14(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFELLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFELLSR_P15(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFELLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFELLSR_P16(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFELLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFELLSR_P17(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFELLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFELLSR_P18(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFELLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFELLSR_P19(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFELLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFELLSR_P20(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFELLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFELLSR_P21(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFELLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFELLSR_P22(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFELLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFELLSR_P23(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFELLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFELLSR_P24(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFELLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFELLSR_P25(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFELLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFELLSR_P26(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFELLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFELLSR_P27(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFELLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFELLSR_P28(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFELLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFELLSR_P29(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFELLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFELLSR_P30(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFELLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFELLSR_P31(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFELLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000000) >> 31
}

// PIO.REHLSR: Rising Edge/High-Level Select Register
func (o *PIO_Type) SetREHLSR_P0(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetREHLSR_P0() uint32 {
	return volatile.LoadUint32(&o.REHLSR.Reg) & 0x1
}
func (o *PIO_Type) SetREHLSR_P1(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetREHLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetREHLSR_P2(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetREHLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetREHLSR_P3(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetREHLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetREHLSR_P4(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetREHLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetREHLSR_P5(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetREHLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetREHLSR_P6(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetREHLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetREHLSR_P7(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetREHLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetREHLSR_P8(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetREHLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetREHLSR_P9(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetREHLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetREHLSR_P10(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetREHLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetREHLSR_P11(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetREHLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetREHLSR_P12(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetREHLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetREHLSR_P13(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetREHLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetREHLSR_P14(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetREHLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetREHLSR_P15(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetREHLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetREHLSR_P16(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetREHLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetREHLSR_P17(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetREHLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetREHLSR_P18(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetREHLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetREHLSR_P19(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetREHLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetREHLSR_P20(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetREHLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetREHLSR_P21(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetREHLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetREHLSR_P22(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetREHLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetREHLSR_P23(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetREHLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetREHLSR_P24(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetREHLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetREHLSR_P25(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetREHLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetREHLSR_P26(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetREHLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetREHLSR_P27(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetREHLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetREHLSR_P28(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetREHLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetREHLSR_P29(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetREHLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetREHLSR_P30(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetREHLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetREHLSR_P31(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetREHLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000000) >> 31
}

// PIO.FRLHSR: Fall/Rise - Low/High Status Register
func (o *PIO_Type) SetFRLHSR_P0(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFRLHSR_P0() uint32 {
	return volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1
}
func (o *PIO_Type) SetFRLHSR_P1(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFRLHSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFRLHSR_P2(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFRLHSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFRLHSR_P3(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFRLHSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFRLHSR_P4(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFRLHSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFRLHSR_P5(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFRLHSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFRLHSR_P6(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFRLHSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFRLHSR_P7(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFRLHSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFRLHSR_P8(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFRLHSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFRLHSR_P9(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFRLHSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFRLHSR_P10(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFRLHSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFRLHSR_P11(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFRLHSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFRLHSR_P12(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFRLHSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFRLHSR_P13(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFRLHSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFRLHSR_P14(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFRLHSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFRLHSR_P15(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFRLHSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFRLHSR_P16(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFRLHSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFRLHSR_P17(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFRLHSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFRLHSR_P18(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFRLHSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFRLHSR_P19(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFRLHSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFRLHSR_P20(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFRLHSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFRLHSR_P21(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFRLHSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFRLHSR_P22(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFRLHSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFRLHSR_P23(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFRLHSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFRLHSR_P24(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFRLHSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFRLHSR_P25(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFRLHSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFRLHSR_P26(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFRLHSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFRLHSR_P27(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFRLHSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFRLHSR_P28(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFRLHSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFRLHSR_P29(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFRLHSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFRLHSR_P30(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFRLHSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFRLHSR_P31(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFRLHSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000000) >> 31
}

// PIO.LOCKSR: Lock Status
func (o *PIO_Type) SetLOCKSR_P0(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLOCKSR_P0() uint32 {
	return volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1
}
func (o *PIO_Type) SetLOCKSR_P1(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLOCKSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLOCKSR_P2(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLOCKSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLOCKSR_P3(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLOCKSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLOCKSR_P4(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLOCKSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLOCKSR_P5(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLOCKSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLOCKSR_P6(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLOCKSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLOCKSR_P7(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLOCKSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLOCKSR_P8(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLOCKSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLOCKSR_P9(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLOCKSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLOCKSR_P10(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLOCKSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLOCKSR_P11(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLOCKSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLOCKSR_P12(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLOCKSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLOCKSR_P13(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLOCKSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLOCKSR_P14(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLOCKSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLOCKSR_P15(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLOCKSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLOCKSR_P16(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLOCKSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLOCKSR_P17(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLOCKSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLOCKSR_P18(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLOCKSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLOCKSR_P19(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLOCKSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLOCKSR_P20(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLOCKSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLOCKSR_P21(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLOCKSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLOCKSR_P22(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLOCKSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLOCKSR_P23(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLOCKSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLOCKSR_P24(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLOCKSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLOCKSR_P25(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLOCKSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLOCKSR_P26(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLOCKSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLOCKSR_P27(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLOCKSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLOCKSR_P28(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLOCKSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLOCKSR_P29(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLOCKSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLOCKSR_P30(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLOCKSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLOCKSR_P31(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLOCKSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000000) >> 31
}

// PIO.WPMR: Write Protection Mode Register
func (o *PIO_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *PIO_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PIO_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// PIO.WPSR: Write Protection Status Register
func (o *PIO_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PIO_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PIO_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// PIO.SCHMITT: Schmitt Trigger Register
func (o *PIO_Type) SetSCHMITT_SCHMITT0(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT0() uint32 {
	return volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT1(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT1() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT2(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT2() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSCHMITT_SCHMITT3(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT3() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSCHMITT_SCHMITT4(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT4() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSCHMITT_SCHMITT5(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT5() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSCHMITT_SCHMITT6(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT6() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSCHMITT_SCHMITT7(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT7() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSCHMITT_SCHMITT8(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT8() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSCHMITT_SCHMITT9(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT9() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSCHMITT_SCHMITT10(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT10() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSCHMITT_SCHMITT11(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT11() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSCHMITT_SCHMITT12(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT12() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSCHMITT_SCHMITT13(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT13() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSCHMITT_SCHMITT14(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT14() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSCHMITT_SCHMITT15(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT15() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSCHMITT_SCHMITT16(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT16() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSCHMITT_SCHMITT17(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT17() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSCHMITT_SCHMITT18(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT18() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSCHMITT_SCHMITT19(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT19() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSCHMITT_SCHMITT20(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT20() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSCHMITT_SCHMITT21(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT21() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSCHMITT_SCHMITT22(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT22() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSCHMITT_SCHMITT23(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT23() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSCHMITT_SCHMITT24(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT24() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSCHMITT_SCHMITT25(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT25() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSCHMITT_SCHMITT26(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT26() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSCHMITT_SCHMITT27(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT27() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSCHMITT_SCHMITT28(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT28() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSCHMITT_SCHMITT29(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT29() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSCHMITT_SCHMITT30(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT30() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSCHMITT_SCHMITT31(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT31() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000000) >> 31
}

// PIO.DRIVER: I/O Drive Register
func (o *PIO_Type) SetDRIVER_LINE0(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetDRIVER_LINE0() uint32 {
	return volatile.LoadUint32(&o.DRIVER.Reg) & 0x1
}
func (o *PIO_Type) SetDRIVER_LINE1(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetDRIVER_LINE1() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetDRIVER_LINE2(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetDRIVER_LINE2() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetDRIVER_LINE3(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetDRIVER_LINE3() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetDRIVER_LINE4(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetDRIVER_LINE4() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetDRIVER_LINE5(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetDRIVER_LINE5() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetDRIVER_LINE6(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetDRIVER_LINE6() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetDRIVER_LINE7(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetDRIVER_LINE7() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetDRIVER_LINE8(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetDRIVER_LINE8() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetDRIVER_LINE9(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetDRIVER_LINE9() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetDRIVER_LINE10(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetDRIVER_LINE10() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetDRIVER_LINE11(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetDRIVER_LINE11() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetDRIVER_LINE12(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetDRIVER_LINE12() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetDRIVER_LINE13(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetDRIVER_LINE13() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetDRIVER_LINE14(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetDRIVER_LINE14() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetDRIVER_LINE15(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetDRIVER_LINE15() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetDRIVER_LINE16(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetDRIVER_LINE16() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetDRIVER_LINE17(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetDRIVER_LINE17() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetDRIVER_LINE18(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetDRIVER_LINE18() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetDRIVER_LINE19(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetDRIVER_LINE19() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetDRIVER_LINE20(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetDRIVER_LINE20() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetDRIVER_LINE21(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetDRIVER_LINE21() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetDRIVER_LINE22(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetDRIVER_LINE22() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetDRIVER_LINE23(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetDRIVER_LINE23() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetDRIVER_LINE24(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetDRIVER_LINE24() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetDRIVER_LINE25(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetDRIVER_LINE25() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetDRIVER_LINE26(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetDRIVER_LINE26() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetDRIVER_LINE27(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetDRIVER_LINE27() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetDRIVER_LINE28(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetDRIVER_LINE28() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetDRIVER_LINE29(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetDRIVER_LINE29() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetDRIVER_LINE30(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetDRIVER_LINE30() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetDRIVER_LINE31(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetDRIVER_LINE31() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x80000000) >> 31
}

// PIO.PCMR: Parallel Capture Mode Register
func (o *PIO_Type) SetPCMR_PCEN(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCMR_PCEN() uint32 {
	return volatile.LoadUint32(&o.PCMR.Reg) & 0x1
}
func (o *PIO_Type) SetPCMR_DSIZE(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x30)|value<<4)
}
func (o *PIO_Type) GetPCMR_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x30) >> 4
}
func (o *PIO_Type) SetPCMR_ALWYS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPCMR_ALWYS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPCMR_HALFS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPCMR_HALFS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPCMR_FRSTS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPCMR_FRSTS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x800) >> 11
}

// PIO.PCIER: Parallel Capture Interrupt Enable Register
func (o *PIO_Type) SetPCIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIER_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIER.Reg) & 0x1
}
func (o *PIO_Type) SetPCIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x8) >> 3
}

// PIO.PCIDR: Parallel Capture Interrupt Disable Register
func (o *PIO_Type) SetPCIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIDR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIDR.Reg) & 0x1
}
func (o *PIO_Type) SetPCIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x8) >> 3
}

// PIO.PCIMR: Parallel Capture Interrupt Mask Register
func (o *PIO_Type) SetPCIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIMR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIMR.Reg) & 0x1
}
func (o *PIO_Type) SetPCIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x8) >> 3
}

// PIO.PCISR: Parallel Capture Interrupt Status Register
func (o *PIO_Type) SetPCISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCISR.Reg, volatile.LoadUint32(&o.PCISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCISR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCISR.Reg) & 0x1
}
func (o *PIO_Type) SetPCISR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCISR.Reg, volatile.LoadUint32(&o.PCISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCISR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCISR.Reg) & 0x2) >> 1
}

// PIO.PCRHR: Parallel Capture Reception Holding Register
func (o *PIO_Type) SetPCRHR(value uint32) {
	volatile.StoreUint32(&o.PCRHR.Reg, value)
}
func (o *PIO_Type) GetPCRHR() uint32 {
	return volatile.LoadUint32(&o.PCRHR.Reg)
}

// Power Management Controller
type PMC_Type struct {
	SCER       volatile.Register32 // 0x0
	SCDR       volatile.Register32 // 0x4
	SCSR       volatile.Register32 // 0x8
	_          [4]byte
	PCER0      volatile.Register32 // 0x10
	PCDR0      volatile.Register32 // 0x14
	PCSR0      volatile.Register32 // 0x18
	CKGR_UCKR  volatile.Register32 // 0x1C
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	MCKR       volatile.Register32 // 0x30
	_          [4]byte
	USB        volatile.Register32 // 0x38
	_          [4]byte
	PCK        [8]volatile.Register32 // 0x40
	IER        volatile.Register32    // 0x60
	IDR        volatile.Register32    // 0x64
	SR         volatile.Register32    // 0x68
	IMR        volatile.Register32    // 0x6C
	FSMR       volatile.Register32    // 0x70
	FSPR       volatile.Register32    // 0x74
	FOCR       volatile.Register32    // 0x78
	_          [104]byte
	WPMR       volatile.Register32 // 0xE4
	WPSR       volatile.Register32 // 0xE8
	_          [20]byte
	PCER1      volatile.Register32 // 0x100
	PCDR1      volatile.Register32 // 0x104
	PCSR1      volatile.Register32 // 0x108
	PCR        volatile.Register32 // 0x10C
	OCR        volatile.Register32 // 0x110
	SLPWK_ER0  volatile.Register32 // 0x114
	SLPWK_DR0  volatile.Register32 // 0x118
	SLPWK_SR0  volatile.Register32 // 0x11C
	SLPWK_ASR0 volatile.Register32 // 0x120
	_          [12]byte
	PMMR       volatile.Register32 // 0x130
	SLPWK_ER1  volatile.Register32 // 0x134
	SLPWK_DR1  volatile.Register32 // 0x138
	SLPWK_SR1  volatile.Register32 // 0x13C
	SLPWK_ASR1 volatile.Register32 // 0x140
	SLPWK_AIPR volatile.Register32 // 0x144
}

// PMC.SCER: System Clock Enable Register
func (o *PMC_Type) SetSCER_USBCLK(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSCER_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSCER_PCK0(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSCER_PCK0() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSCER_PCK1(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSCER_PCK1() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSCER_PCK2(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSCER_PCK2() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSCER_PCK3(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSCER_PCK3() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSCER_PCK4(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSCER_PCK4() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSCER_PCK5(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSCER_PCK5() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSCER_PCK6(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSCER_PCK6() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSCER_PCK7(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSCER_PCK7() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x8000) >> 15
}

// PMC.SCDR: System Clock Disable Register
func (o *PMC_Type) SetSCDR_USBCLK(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSCDR_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSCDR_PCK0(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSCDR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSCDR_PCK1(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSCDR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSCDR_PCK2(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSCDR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSCDR_PCK3(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSCDR_PCK3() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSCDR_PCK4(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSCDR_PCK4() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSCDR_PCK5(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSCDR_PCK5() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSCDR_PCK6(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSCDR_PCK6() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSCDR_PCK7(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSCDR_PCK7() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x8000) >> 15
}

// PMC.SCSR: System Clock Status Register
func (o *PMC_Type) SetSCSR_HCLKS(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSCSR_HCLKS() uint32 {
	return volatile.LoadUint32(&o.SCSR.Reg) & 0x1
}
func (o *PMC_Type) SetSCSR_USBCLK(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSCSR_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSCSR_PCK0(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSCSR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSCSR_PCK1(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSCSR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSCSR_PCK2(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSCSR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSCSR_PCK3(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSCSR_PCK3() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSCSR_PCK4(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSCSR_PCK4() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSCSR_PCK5(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSCSR_PCK5() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSCSR_PCK6(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSCSR_PCK6() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSCSR_PCK7(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSCSR_PCK7() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x8000) >> 15
}

// PMC.PCER0: Peripheral Clock Enable Register 0
func (o *PMC_Type) SetPCER0_PID7(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCER0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCER0_PID8(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCER0_PID10(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCER0_PID11(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCER0_PID13(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCER0_PID14(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCER0_PID16(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCER0_PID19(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCER0_PID20(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCER0_PID22(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPCER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPCER0_PID23(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPCER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPCER0_PID24(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCER0_PID25(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCER0_PID26(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCER0_PID27(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCER0_PID28(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPCER0_PID29(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPCER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPCER0_PID30(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPCER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPCER0_PID31(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPCER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x80000000) >> 31
}

// PMC.PCDR0: Peripheral Clock Disable Register 0
func (o *PMC_Type) SetPCDR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCDR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCDR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCDR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCDR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCDR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCDR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCDR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCDR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCDR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCDR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCDR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCDR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCDR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCDR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCDR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCDR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCDR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCDR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPCDR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPCDR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPCDR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPCDR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCDR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCDR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCDR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCDR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCDR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCDR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCDR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCDR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCDR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPCDR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPCDR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPCDR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPCDR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPCDR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPCDR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x80000000) >> 31
}

// PMC.PCSR0: Peripheral Clock Status Register 0
func (o *PMC_Type) SetPCSR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCSR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCSR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCSR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCSR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCSR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCSR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCSR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCSR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCSR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCSR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCSR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCSR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCSR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCSR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCSR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCSR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCSR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCSR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPCSR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPCSR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPCSR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPCSR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCSR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCSR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCSR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCSR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCSR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCSR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCSR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCSR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCSR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPCSR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPCSR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPCSR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPCSR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPCSR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPCSR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x80000000) >> 31
}

// PMC.CKGR_UCKR: UTMI Clock Register
func (o *PMC_Type) SetCKGR_UCKR_UPLLEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_UCKR_UPLLCOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0xf00000)|value<<20)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLCOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0xf00000) >> 20
}

// PMC.CKGR_MOR: Main Oscillator Register
func (o *PMC_Type) SetCKGR_MOR_MOSCXTEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTEN() uint32 {
	return volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTBY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTBY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetCKGR_MOR_WAITMODE(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetCKGR_MOR_WAITMODE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCF() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTST(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff00)|value<<8)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTST() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff00) >> 8
}
func (o *PMC_Type) SetCKGR_MOR_KEY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MOR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff0000) >> 16
}
func (o *PMC_Type) SetCKGR_MOR_MOSCSEL(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCSEL() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetCKGR_MOR_CFDEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetCKGR_MOR_CFDEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetCKGR_MOR_XT32KFME(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetCKGR_MOR_XT32KFME() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x4000000) >> 26
}

// PMC.CKGR_MCFR: Main Clock Frequency Register
func (o *PMC_Type) SetCKGR_MCFR_MAINF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0xffff)|value)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINF() uint32 {
	return volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0xffff
}
func (o *PMC_Type) SetCKGR_MCFR_MAINFRDY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINFRDY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_MCFR_RCMEAS(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetCKGR_MCFR_RCMEAS() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetCKGR_MCFR_CCSS(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MCFR_CCSS() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x1000000) >> 24
}

// PMC.CKGR_PLLAR: PLLA Register
func (o *PMC_Type) SetCKGR_PLLAR_DIVA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLAR_DIVA() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLAR_PLLACOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLAR_PLLACOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLAR_MULA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLAR_MULA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLAR_ONE(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetCKGR_PLLAR_ONE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x20000000) >> 29
}

// PMC.MCKR: Master Clock Register
func (o *PMC_Type) SetMCKR_CSS(value uint32) {
	volatile.StoreUint32(&o.MCKR.Reg, volatile.LoadUint32(&o.MCKR.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetMCKR_CSS() uint32 {
	return volatile.LoadUint32(&o.MCKR.Reg) & 0x3
}
func (o *PMC_Type) SetMCKR_PRES(value uint32) {
	volatile.StoreUint32(&o.MCKR.Reg, volatile.LoadUint32(&o.MCKR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetMCKR_PRES() uint32 {
	return (volatile.LoadUint32(&o.MCKR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetMCKR_MDIV(value uint32) {
	volatile.StoreUint32(&o.MCKR.Reg, volatile.LoadUint32(&o.MCKR.Reg)&^(0x300)|value<<8)
}
func (o *PMC_Type) GetMCKR_MDIV() uint32 {
	return (volatile.LoadUint32(&o.MCKR.Reg) & 0x300) >> 8
}
func (o *PMC_Type) SetMCKR_UPLLDIV2(value uint32) {
	volatile.StoreUint32(&o.MCKR.Reg, volatile.LoadUint32(&o.MCKR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetMCKR_UPLLDIV2() uint32 {
	return (volatile.LoadUint32(&o.MCKR.Reg) & 0x2000) >> 13
}

// PMC.USB: USB Clock Register
func (o *PMC_Type) SetUSB_USBS(value uint32) {
	volatile.StoreUint32(&o.USB.Reg, volatile.LoadUint32(&o.USB.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetUSB_USBS() uint32 {
	return volatile.LoadUint32(&o.USB.Reg) & 0x1
}
func (o *PMC_Type) SetUSB_USBDIV(value uint32) {
	volatile.StoreUint32(&o.USB.Reg, volatile.LoadUint32(&o.USB.Reg)&^(0xf00)|value<<8)
}
func (o *PMC_Type) GetUSB_USBDIV() uint32 {
	return (volatile.LoadUint32(&o.USB.Reg) & 0xf00) >> 8
}

// PMC.PCK: Programmable Clock Register
func (o *PMC_Type) SetPCK_CSS(idx int, value uint32) {
	volatile.StoreUint32(&o.PCK[idx].Reg, volatile.LoadUint32(&o.PCK[idx].Reg)&^(0x7)|value)
}
func (o *PMC_Type) GetPCK_CSS(idx int) uint32 {
	return volatile.LoadUint32(&o.PCK[idx].Reg) & 0x7
}
func (o *PMC_Type) SetPCK_PRES(idx int, value uint32) {
	volatile.StoreUint32(&o.PCK[idx].Reg, volatile.LoadUint32(&o.PCK[idx].Reg)&^(0xff0)|value<<4)
}
func (o *PMC_Type) GetPCK_PRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.PCK[idx].Reg) & 0xff0) >> 4
}

// PMC.IER: Interrupt Enable Register
func (o *PMC_Type) SetIER_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetIER_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PMC_Type) SetIER_LOCKA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetIER_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetIER_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetIER_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetIER_LOCKU(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetIER_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetIER_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetIER_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetIER_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetIER_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetIER_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetIER_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetIER_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetIER_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetIER_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetIER_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetIER_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetIER_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetIER_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetIER_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetIER_PCKRDY7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetIER_PCKRDY7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetIER_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetIER_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetIER_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetIER_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetIER_CFDEV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetIER_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetIER_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetIER_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}

// PMC.IDR: Interrupt Disable Register
func (o *PMC_Type) SetIDR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetIDR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PMC_Type) SetIDR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetIDR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetIDR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetIDR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetIDR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetIDR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetIDR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetIDR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetIDR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetIDR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetIDR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetIDR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetIDR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetIDR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetIDR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetIDR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetIDR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetIDR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetIDR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetIDR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetIDR_PCKRDY7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetIDR_PCKRDY7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetIDR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetIDR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetIDR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetIDR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetIDR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetIDR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetIDR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetIDR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}

// PMC.SR: Status Register
func (o *PMC_Type) SetSR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PMC_Type) SetSR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetSR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetSR_OSCSELS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSR_OSCSELS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSR_PCKRDY7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSR_PCKRDY7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSR_CFDS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSR_CFDS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSR_FOS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSR_FOS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}

// PMC.IMR: Interrupt Mask Register
func (o *PMC_Type) SetIMR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetIMR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PMC_Type) SetIMR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetIMR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetIMR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetIMR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetIMR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetIMR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetIMR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetIMR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetIMR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetIMR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetIMR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetIMR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetIMR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetIMR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetIMR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetIMR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetIMR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetIMR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetIMR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetIMR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetIMR_PCKRDY7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetIMR_PCKRDY7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetIMR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetIMR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetIMR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetIMR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetIMR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetIMR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetIMR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetIMR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}

// PMC.FSMR: Fast Startup Mode Register
func (o *PMC_Type) SetFSMR_FSTT0(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetFSMR_FSTT0() uint32 {
	return volatile.LoadUint32(&o.FSMR.Reg) & 0x1
}
func (o *PMC_Type) SetFSMR_FSTT1(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetFSMR_FSTT1() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetFSMR_FSTT2(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetFSMR_FSTT2() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetFSMR_FSTT3(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetFSMR_FSTT3() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetFSMR_FSTT4(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetFSMR_FSTT4() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetFSMR_FSTT5(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetFSMR_FSTT5() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetFSMR_FSTT6(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetFSMR_FSTT6() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetFSMR_FSTT7(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetFSMR_FSTT7() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetFSMR_FSTT8(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetFSMR_FSTT8() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetFSMR_FSTT9(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetFSMR_FSTT9() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetFSMR_FSTT10(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetFSMR_FSTT10() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetFSMR_FSTT11(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetFSMR_FSTT11() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetFSMR_FSTT12(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetFSMR_FSTT12() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetFSMR_FSTT13(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetFSMR_FSTT13() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetFSMR_FSTT14(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetFSMR_FSTT14() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetFSMR_FSTT15(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetFSMR_FSTT15() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetFSMR_RTTAL(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetFSMR_RTTAL() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetFSMR_RTCAL(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetFSMR_RTCAL() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetFSMR_USBAL(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetFSMR_USBAL() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetFSMR_LPM(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetFSMR_LPM() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetFSMR_FLPM(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x600000)|value<<21)
}
func (o *PMC_Type) GetFSMR_FLPM() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x600000) >> 21
}
func (o *PMC_Type) SetFSMR_FFLPM(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetFSMR_FFLPM() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x800000) >> 23
}

// PMC.FSPR: Fast Startup Polarity Register
func (o *PMC_Type) SetFSPR_FSTP0(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetFSPR_FSTP0() uint32 {
	return volatile.LoadUint32(&o.FSPR.Reg) & 0x1
}
func (o *PMC_Type) SetFSPR_FSTP1(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetFSPR_FSTP1() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetFSPR_FSTP2(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetFSPR_FSTP2() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetFSPR_FSTP3(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetFSPR_FSTP3() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetFSPR_FSTP4(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetFSPR_FSTP4() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetFSPR_FSTP5(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetFSPR_FSTP5() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetFSPR_FSTP6(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetFSPR_FSTP6() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetFSPR_FSTP7(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetFSPR_FSTP7() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetFSPR_FSTP8(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetFSPR_FSTP8() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetFSPR_FSTP9(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetFSPR_FSTP9() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetFSPR_FSTP10(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetFSPR_FSTP10() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetFSPR_FSTP11(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetFSPR_FSTP11() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetFSPR_FSTP12(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetFSPR_FSTP12() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetFSPR_FSTP13(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetFSPR_FSTP13() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetFSPR_FSTP14(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetFSPR_FSTP14() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetFSPR_FSTP15(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetFSPR_FSTP15() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x8000) >> 15
}

// PMC.FOCR: Fault Output Clear Register
func (o *PMC_Type) SetFOCR_FOCLR(value uint32) {
	volatile.StoreUint32(&o.FOCR.Reg, volatile.LoadUint32(&o.FOCR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetFOCR_FOCLR() uint32 {
	return volatile.LoadUint32(&o.FOCR.Reg) & 0x1
}

// PMC.WPMR: Write Protection Mode Register
func (o *PMC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *PMC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PMC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// PMC.WPSR: Write Protection Status Register
func (o *PMC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PMC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PMC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// PMC.PCER1: Peripheral Clock Enable Register 1
func (o *PMC_Type) SetPCER1_PID32(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPCER1_PID32() uint32 {
	return volatile.LoadUint32(&o.PCER1.Reg) & 0x1
}
func (o *PMC_Type) SetPCER1_PID33(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPCER1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPCER1_PID34(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPCER1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPCER1_PID35(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPCER1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPCER1_PID39(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCER1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCER1_PID40(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCER1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCER1_PID43(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCER1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCER1_PID44(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCER1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCER1_PID45(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCER1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCER1_PID46(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCER1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCER1_PID47(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCER1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCER1_PID48(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCER1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCER1_PID49(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCER1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCER1_PID50(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCER1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCER1_PID51(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCER1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCER1_PID52(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCER1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCER1_PID56(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCER1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCER1_PID57(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCER1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCER1_PID58(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCER1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCER1_PID59(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCER1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCER1_PID60(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCER1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x10000000) >> 28
}

// PMC.PCDR1: Peripheral Clock Disable Register 1
func (o *PMC_Type) SetPCDR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPCDR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PCDR1.Reg) & 0x1
}
func (o *PMC_Type) SetPCDR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPCDR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPCDR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPCDR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPCDR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPCDR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPCDR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCDR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCDR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCDR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCDR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCDR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCDR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCDR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCDR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCDR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCDR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCDR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCDR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCDR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCDR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCDR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCDR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCDR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCDR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCDR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCDR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCDR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCDR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCDR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCDR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCDR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCDR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCDR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCDR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCDR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCDR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCDR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCDR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCDR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x10000000) >> 28
}

// PMC.PCSR1: Peripheral Clock Status Register 1
func (o *PMC_Type) SetPCSR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPCSR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PCSR1.Reg) & 0x1
}
func (o *PMC_Type) SetPCSR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPCSR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPCSR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPCSR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPCSR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPCSR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPCSR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCSR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCSR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCSR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCSR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCSR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCSR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCSR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCSR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCSR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCSR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCSR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCSR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCSR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCSR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCSR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCSR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCSR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCSR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCSR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCSR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCSR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCSR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCSR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCSR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCSR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCSR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCSR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCSR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCSR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCSR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCSR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCSR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCSR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x10000000) >> 28
}

// PMC.PCR: Peripheral Control Register
func (o *PMC_Type) SetPCR_PID(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x7f)|value)
}
func (o *PMC_Type) GetPCR_PID() uint32 {
	return volatile.LoadUint32(&o.PCR.Reg) & 0x7f
}
func (o *PMC_Type) SetPCR_GCLKCSS(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x700)|value<<8)
}
func (o *PMC_Type) GetPCR_GCLKCSS() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x700) >> 8
}
func (o *PMC_Type) SetPCR_CMD(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCR_CMD() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCR_GCLKDIV(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xff00000)|value<<20)
}
func (o *PMC_Type) GetPCR_GCLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xff00000) >> 20
}
func (o *PMC_Type) SetPCR_EN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCR_EN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPCR_GCLKEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPCR_GCLKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x20000000) >> 29
}

// PMC.OCR: Oscillator Calibration Register
func (o *PMC_Type) SetOCR_CAL4(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x7f)|value)
}
func (o *PMC_Type) GetOCR_CAL4() uint32 {
	return volatile.LoadUint32(&o.OCR.Reg) & 0x7f
}
func (o *PMC_Type) SetOCR_SEL4(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetOCR_SEL4() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetOCR_CAL8(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x7f00)|value<<8)
}
func (o *PMC_Type) GetOCR_CAL8() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x7f00) >> 8
}
func (o *PMC_Type) SetOCR_SEL8(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetOCR_SEL8() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetOCR_CAL12(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x7f0000)|value<<16)
}
func (o *PMC_Type) GetOCR_CAL12() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x7f0000) >> 16
}
func (o *PMC_Type) SetOCR_SEL12(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetOCR_SEL12() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x800000) >> 23
}

// PMC.SLPWK_ER0: SleepWalking Enable Register 0
func (o *PMC_Type) SetSLPWK_ER0_PID7(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_ER0_PID7() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_ER0_PID8(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_ER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_ER0_PID10(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_ER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_ER0_PID11(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_ER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_ER0_PID13(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_ER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_ER0_PID14(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_ER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_ER0_PID16(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_ER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_ER0_PID19(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_ER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_ER0_PID20(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_ER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_ER0_PID22(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetSLPWK_ER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetSLPWK_ER0_PID23(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetSLPWK_ER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetSLPWK_ER0_PID24(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_ER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_ER0_PID25(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_ER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_ER0_PID26(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_ER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_ER0_PID27(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_ER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_ER0_PID28(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_ER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetSLPWK_ER0_PID29(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetSLPWK_ER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetSLPWK_ER0_PID30(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetSLPWK_ER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetSLPWK_ER0_PID31(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetSLPWK_ER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x80000000) >> 31
}

// PMC.SLPWK_DR0: SleepWalking Disable Register 0
func (o *PMC_Type) SetSLPWK_DR0_PID7(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_DR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_DR0_PID8(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_DR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_DR0_PID10(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_DR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_DR0_PID11(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_DR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_DR0_PID13(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_DR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_DR0_PID14(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_DR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_DR0_PID16(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_DR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_DR0_PID19(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_DR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_DR0_PID20(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_DR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_DR0_PID22(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetSLPWK_DR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetSLPWK_DR0_PID23(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetSLPWK_DR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetSLPWK_DR0_PID24(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_DR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_DR0_PID25(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_DR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_DR0_PID26(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_DR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_DR0_PID27(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_DR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_DR0_PID28(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_DR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetSLPWK_DR0_PID29(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetSLPWK_DR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetSLPWK_DR0_PID30(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetSLPWK_DR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetSLPWK_DR0_PID31(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetSLPWK_DR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x80000000) >> 31
}

// PMC.SLPWK_SR0: SleepWalking Status Register 0
func (o *PMC_Type) SetSLPWK_SR0_PID7(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_SR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_SR0_PID8(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_SR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_SR0_PID10(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_SR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_SR0_PID11(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_SR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_SR0_PID13(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_SR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_SR0_PID14(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_SR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_SR0_PID16(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_SR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_SR0_PID19(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_SR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_SR0_PID20(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_SR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_SR0_PID22(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetSLPWK_SR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetSLPWK_SR0_PID23(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetSLPWK_SR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetSLPWK_SR0_PID24(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_SR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_SR0_PID25(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_SR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_SR0_PID26(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_SR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_SR0_PID27(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_SR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_SR0_PID28(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_SR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetSLPWK_SR0_PID29(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetSLPWK_SR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetSLPWK_SR0_PID30(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetSLPWK_SR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetSLPWK_SR0_PID31(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetSLPWK_SR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x80000000) >> 31
}

// PMC.SLPWK_ASR0: SleepWalking Activity Status Register 0
func (o *PMC_Type) SetSLPWK_ASR0_PID7(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_ASR0_PID8(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_ASR0_PID10(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_ASR0_PID11(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_ASR0_PID13(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_ASR0_PID14(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_ASR0_PID16(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_ASR0_PID19(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_ASR0_PID20(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_ASR0_PID22(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetSLPWK_ASR0_PID23(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetSLPWK_ASR0_PID24(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_ASR0_PID25(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_ASR0_PID26(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_ASR0_PID27(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_ASR0_PID28(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetSLPWK_ASR0_PID29(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetSLPWK_ASR0_PID30(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetSLPWK_ASR0_PID31(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x80000000) >> 31
}

// PMC.PMMR: PLL Maximum Multiplier Value Register
func (o *PMC_Type) SetPMMR_PLLA_MMAX(value uint32) {
	volatile.StoreUint32(&o.PMMR.Reg, volatile.LoadUint32(&o.PMMR.Reg)&^(0x7ff)|value)
}
func (o *PMC_Type) GetPMMR_PLLA_MMAX() uint32 {
	return volatile.LoadUint32(&o.PMMR.Reg) & 0x7ff
}

// PMC.SLPWK_ER1: SleepWalking Enable Register 1
func (o *PMC_Type) SetSLPWK_ER1_PID32(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_ER1_PID32() uint32 {
	return volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x1
}
func (o *PMC_Type) SetSLPWK_ER1_PID33(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSLPWK_ER1_PID33() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSLPWK_ER1_PID34(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetSLPWK_ER1_PID34() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetSLPWK_ER1_PID35(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSLPWK_ER1_PID35() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSLPWK_ER1_PID39(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_ER1_PID39() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_ER1_PID40(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_ER1_PID40() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_ER1_PID43(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_ER1_PID43() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_ER1_PID44(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_ER1_PID44() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_ER1_PID45(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_ER1_PID45() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_ER1_PID46(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_ER1_PID46() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_ER1_PID47(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_ER1_PID47() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_ER1_PID48(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_ER1_PID48() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_ER1_PID49(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_ER1_PID49() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_ER1_PID50(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_ER1_PID50() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_ER1_PID51(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_ER1_PID51() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_ER1_PID52(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_ER1_PID52() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_ER1_PID56(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_ER1_PID56() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_ER1_PID57(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_ER1_PID57() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_ER1_PID58(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_ER1_PID58() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_ER1_PID59(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_ER1_PID59() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_ER1_PID60(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_ER1_PID60() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x10000000) >> 28
}

// PMC.SLPWK_DR1: SleepWalking Disable Register 1
func (o *PMC_Type) SetSLPWK_DR1_PID32(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_DR1_PID32() uint32 {
	return volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x1
}
func (o *PMC_Type) SetSLPWK_DR1_PID33(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSLPWK_DR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSLPWK_DR1_PID34(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetSLPWK_DR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetSLPWK_DR1_PID35(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSLPWK_DR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSLPWK_DR1_PID39(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_DR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_DR1_PID40(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_DR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_DR1_PID43(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_DR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_DR1_PID44(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_DR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_DR1_PID45(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_DR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_DR1_PID46(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_DR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_DR1_PID47(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_DR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_DR1_PID48(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_DR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_DR1_PID49(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_DR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_DR1_PID50(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_DR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_DR1_PID51(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_DR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_DR1_PID52(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_DR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_DR1_PID56(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_DR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_DR1_PID57(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_DR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_DR1_PID58(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_DR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_DR1_PID59(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_DR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_DR1_PID60(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_DR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x10000000) >> 28
}

// PMC.SLPWK_SR1: SleepWalking Status Register 1
func (o *PMC_Type) SetSLPWK_SR1_PID32(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_SR1_PID32() uint32 {
	return volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x1
}
func (o *PMC_Type) SetSLPWK_SR1_PID33(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSLPWK_SR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSLPWK_SR1_PID34(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetSLPWK_SR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetSLPWK_SR1_PID35(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSLPWK_SR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSLPWK_SR1_PID39(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_SR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_SR1_PID40(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_SR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_SR1_PID43(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_SR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_SR1_PID44(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_SR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_SR1_PID45(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_SR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_SR1_PID46(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_SR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_SR1_PID47(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_SR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_SR1_PID48(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_SR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_SR1_PID49(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_SR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_SR1_PID50(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_SR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_SR1_PID51(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_SR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_SR1_PID52(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_SR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_SR1_PID56(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_SR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_SR1_PID57(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_SR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_SR1_PID58(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_SR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_SR1_PID59(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_SR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_SR1_PID60(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_SR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x10000000) >> 28
}

// PMC.SLPWK_ASR1: SleepWalking Activity Status Register 1
func (o *PMC_Type) SetSLPWK_ASR1_PID32(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID32() uint32 {
	return volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x1
}
func (o *PMC_Type) SetSLPWK_ASR1_PID33(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSLPWK_ASR1_PID34(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetSLPWK_ASR1_PID35(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSLPWK_ASR1_PID39(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_ASR1_PID40(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_ASR1_PID43(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_ASR1_PID44(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_ASR1_PID45(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_ASR1_PID46(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_ASR1_PID47(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_ASR1_PID48(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_ASR1_PID49(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_ASR1_PID50(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_ASR1_PID51(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_ASR1_PID52(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_ASR1_PID56(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_ASR1_PID57(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_ASR1_PID58(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_ASR1_PID59(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_ASR1_PID60(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x10000000) >> 28
}

// PMC.SLPWK_AIPR: SleepWalking Activity In Progress Register
func (o *PMC_Type) SetSLPWK_AIPR_AIP(value uint32) {
	volatile.StoreUint32(&o.SLPWK_AIPR.Reg, volatile.LoadUint32(&o.SLPWK_AIPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_AIPR_AIP() uint32 {
	return volatile.LoadUint32(&o.SLPWK_AIPR.Reg) & 0x1
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK        volatile.Register32 // 0x0
	ENA        volatile.Register32 // 0x4
	DIS        volatile.Register32 // 0x8
	SR         volatile.Register32 // 0xC
	IER1       volatile.Register32 // 0x10
	IDR1       volatile.Register32 // 0x14
	IMR1       volatile.Register32 // 0x18
	ISR1       volatile.Register32 // 0x1C
	SCM        volatile.Register32 // 0x20
	DMAR       volatile.Register32 // 0x24
	SCUC       volatile.Register32 // 0x28
	SCUP       volatile.Register32 // 0x2C
	SCUPUPD    volatile.Register32 // 0x30
	IER2       volatile.Register32 // 0x34
	IDR2       volatile.Register32 // 0x38
	IMR2       volatile.Register32 // 0x3C
	ISR2       volatile.Register32 // 0x40
	OOV        volatile.Register32 // 0x44
	OS         volatile.Register32 // 0x48
	OSS        volatile.Register32 // 0x4C
	OSC        volatile.Register32 // 0x50
	OSSUPD     volatile.Register32 // 0x54
	OSCUPD     volatile.Register32 // 0x58
	FMR        volatile.Register32 // 0x5C
	FSR        volatile.Register32 // 0x60
	FCR        volatile.Register32 // 0x64
	FPV1       volatile.Register32 // 0x68
	FPE        volatile.Register32 // 0x6C
	_          [12]byte
	ELMR       [2]volatile.Register32 // 0x7C
	_          [28]byte
	SSPR       volatile.Register32 // 0xA0
	SSPUP      volatile.Register32 // 0xA4
	_          [8]byte
	SMMR       volatile.Register32 // 0xB0
	_          [12]byte
	FPV2       volatile.Register32 // 0xC0
	_          [32]byte
	WPCR       volatile.Register32 // 0xE4
	WPSR       volatile.Register32 // 0xE8
	_          [68]byte
	PWM_CMP    [8]PWM_PWM_CMP_Type // 0x130
	_          [80]byte
	PWM_CH_NUM [4]PWM_PWM_CH_NUM_Type // 0x200
	_          [384]byte
	CMUPD0     volatile.Register32 // 0x400
	_          [28]byte
	CMUPD1     volatile.Register32 // 0x420
	_          [8]byte
	ETRG1      volatile.Register32 // 0x42C
	LEBR1      volatile.Register32 // 0x430
	_          [12]byte
	CMUPD2     volatile.Register32 // 0x440
	_          [8]byte
	ETRG2      volatile.Register32 // 0x44C
	LEBR2      volatile.Register32 // 0x450
	_          [12]byte
	CMUPD3     volatile.Register32 // 0x460
}

// PWM.CLK: PWM Clock Register
func (o *PWM_Type) SetCLK_DIVA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetCLK_DIVA() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0xff
}
func (o *PWM_Type) SetCLK_PREA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCLK_PREA() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCLK_DIVB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetCLK_DIVB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetCLK_PREB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetCLK_PREB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER1: PWM Interrupt Enable Register 1
func (o *PWM_Type) SetIER1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *PWM_Type) SetIER1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80000) >> 19
}

// PWM.IDR1: PWM Interrupt Disable Register 1
func (o *PWM_Type) SetIDR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *PWM_Type) SetIDR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80000) >> 19
}

// PWM.IMR1: PWM Interrupt Mask Register 1
func (o *PWM_Type) SetIMR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *PWM_Type) SetIMR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}

// PWM.ISR1: PWM Interrupt Status Register 1
func (o *PWM_Type) SetISR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR1.Reg) & 0x1
}
func (o *PWM_Type) SetISR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x80000) >> 19
}

// PWM.SCM: PWM Sync Channels Mode Register
func (o *PWM_Type) SetSCM_SYNC0(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCM_SYNC0() uint32 {
	return volatile.LoadUint32(&o.SCM.Reg) & 0x1
}
func (o *PWM_Type) SetSCM_SYNC1(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSCM_SYNC1() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSCM_SYNC2(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSCM_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSCM_SYNC3(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSCM_SYNC3() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSCM_UPDM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x30000)|value<<16)
}
func (o *PWM_Type) GetSCM_UPDM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x30000) >> 16
}
func (o *PWM_Type) SetSCM_PTRM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetSCM_PTRM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetSCM_PTRCS(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0xe00000)|value<<21)
}
func (o *PWM_Type) GetSCM_PTRCS() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0xe00000) >> 21
}

// PWM.DMAR: PWM DMA Register
func (o *PWM_Type) SetDMAR_DMADUTY(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetDMAR_DMADUTY() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffffff
}

// PWM.SCUC: PWM Sync Channels Update Control Register
func (o *PWM_Type) SetSCUC_UPDULOCK(value uint32) {
	volatile.StoreUint32(&o.SCUC.Reg, volatile.LoadUint32(&o.SCUC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCUC_UPDULOCK() uint32 {
	return volatile.LoadUint32(&o.SCUC.Reg) & 0x1
}

// PWM.SCUP: PWM Sync Channels Update Period Register
func (o *PWM_Type) SetSCUP_UPR(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUP_UPR() uint32 {
	return volatile.LoadUint32(&o.SCUP.Reg) & 0xf
}
func (o *PWM_Type) SetSCUP_UPRCNT(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetSCUP_UPRCNT() uint32 {
	return (volatile.LoadUint32(&o.SCUP.Reg) & 0xf0) >> 4
}

// PWM.SCUPUPD: PWM Sync Channels Update Period Update Register
func (o *PWM_Type) SetSCUPUPD_UPRUPD(value uint32) {
	volatile.StoreUint32(&o.SCUPUPD.Reg, volatile.LoadUint32(&o.SCUPUPD.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUPUPD_UPRUPD() uint32 {
	return volatile.LoadUint32(&o.SCUPUPD.Reg) & 0xf
}

// PWM.IER2: PWM Interrupt Enable Register 2
func (o *PWM_Type) SetIER2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *PWM_Type) SetIER2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIER2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIER2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIER2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIER2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIER2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIER2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIER2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIER2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIER2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIER2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIER2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIER2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIER2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIER2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIER2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIER2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIER2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIER2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIER2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIER2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIER2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIER2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIER2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIER2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800000) >> 23
}

// PWM.IDR2: PWM Interrupt Disable Register 2
func (o *PWM_Type) SetIDR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *PWM_Type) SetIDR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIDR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIDR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIDR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIDR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIDR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIDR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIDR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIDR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIDR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIDR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIDR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIDR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIDR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIDR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIDR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIDR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIDR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIDR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIDR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIDR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIDR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIDR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIDR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIDR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800000) >> 23
}

// PWM.IMR2: PWM Interrupt Mask Register 2
func (o *PWM_Type) SetIMR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *PWM_Type) SetIMR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIMR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIMR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIMR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIMR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIMR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIMR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIMR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIMR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIMR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIMR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIMR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIMR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIMR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIMR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIMR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIMR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIMR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIMR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIMR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIMR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIMR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIMR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIMR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIMR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800000) >> 23
}

// PWM.ISR2: PWM Interrupt Status Register 2
func (o *PWM_Type) SetISR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.ISR2.Reg) & 0x1
}
func (o *PWM_Type) SetISR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetISR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetISR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetISR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetISR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetISR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetISR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetISR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetISR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetISR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetISR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetISR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetISR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetISR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetISR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetISR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetISR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetISR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetISR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetISR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetISR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetISR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetISR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetISR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetISR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800000) >> 23
}

// PWM.OOV: PWM Output Override Value Register
func (o *PWM_Type) SetOOV_OOVH0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOOV_OOVH0() uint32 {
	return volatile.LoadUint32(&o.OOV.Reg) & 0x1
}
func (o *PWM_Type) SetOOV_OOVH1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOOV_OOVH1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOOV_OOVH2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOOV_OOVH2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOOV_OOVH3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOOV_OOVH3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOOV_OOVL0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOOV_OOVL0() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOOV_OOVL1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOOV_OOVL1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOOV_OOVL2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOOV_OOVL2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOOV_OOVL3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOOV_OOVL3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x80000) >> 19
}

// PWM.OS: PWM Output Selection Register
func (o *PWM_Type) SetOS_OSH0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOS_OSH0() uint32 {
	return volatile.LoadUint32(&o.OS.Reg) & 0x1
}
func (o *PWM_Type) SetOS_OSH1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOS_OSH1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOS_OSH2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOS_OSH2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOS_OSH3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOS_OSH3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOS_OSL0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOS_OSL0() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOS_OSL1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOS_OSL1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOS_OSL2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOS_OSL2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOS_OSL3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOS_OSL3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x80000) >> 19
}

// PWM.OSS: PWM Output Selection Set Register
func (o *PWM_Type) SetOSS_OSSH0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSS_OSSH0() uint32 {
	return volatile.LoadUint32(&o.OSS.Reg) & 0x1
}
func (o *PWM_Type) SetOSS_OSSH1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSS_OSSH1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSS_OSSH2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSS_OSSH2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSS_OSSH3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSS_OSSH3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSS_OSSL0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSS_OSSL0() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSS_OSSL1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSS_OSSL1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSS_OSSL2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSS_OSSL2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSS_OSSL3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSS_OSSL3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x80000) >> 19
}

// PWM.OSC: PWM Output Selection Clear Register
func (o *PWM_Type) SetOSC_OSCH0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSC_OSCH0() uint32 {
	return volatile.LoadUint32(&o.OSC.Reg) & 0x1
}
func (o *PWM_Type) SetOSC_OSCH1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSC_OSCH1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSC_OSCH2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSC_OSCH2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSC_OSCH3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSC_OSCH3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSC_OSCL0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSC_OSCL0() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSC_OSCL1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSC_OSCL1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSC_OSCL2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSC_OSCL2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSC_OSCL3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSC_OSCL3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x80000) >> 19
}

// PWM.OSSUPD: PWM Output Selection Set Update Register
func (o *PWM_Type) SetOSSUPD_OSSUPH0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH0() uint32 {
	return volatile.LoadUint32(&o.OSSUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSSUPD_OSSUPH3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSSUPD_OSSUPL0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSSUPD_OSSUPL1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSSUPD_OSSUPL2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSSUPD_OSSUPL3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x80000) >> 19
}

// PWM.OSCUPD: PWM Output Selection Clear Update Register
func (o *PWM_Type) SetOSCUPD_OSCUPH0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH0() uint32 {
	return volatile.LoadUint32(&o.OSCUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSCUPD_OSCUPH3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSCUPD_OSCUPL0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSCUPD_OSCUPL1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSCUPD_OSCUPL2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSCUPD_OSCUPL3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x80000) >> 19
}

// PWM.FMR: PWM Fault Mode Register
func (o *PWM_Type) SetFMR_FPOL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFMR_FPOL() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0xff
}
func (o *PWM_Type) SetFMR_FMOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFMR_FMOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFMR_FFIL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFMR_FFIL() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff0000) >> 16
}

// PWM.FSR: PWM Fault Status Register
func (o *PWM_Type) SetFSR_FIV(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFSR_FIV() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0xff
}
func (o *PWM_Type) SetFSR_FS(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFSR_FS() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0xff00) >> 8
}

// PWM.FCR: PWM Fault Clear Register
func (o *PWM_Type) SetFCR_FCLR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFCR_FCLR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// PWM.FPV1: PWM Fault Protection Value Register 1
func (o *PWM_Type) SetFPV1_FPVH0(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetFPV1_FPVH0() uint32 {
	return volatile.LoadUint32(&o.FPV1.Reg) & 0x1
}
func (o *PWM_Type) SetFPV1_FPVH1(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetFPV1_FPVH1() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetFPV1_FPVH2(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetFPV1_FPVH2() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetFPV1_FPVH3(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetFPV1_FPVH3() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetFPV1_FPVL0(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetFPV1_FPVL0() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetFPV1_FPVL1(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetFPV1_FPVL1() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetFPV1_FPVL2(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetFPV1_FPVL2() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetFPV1_FPVL3(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetFPV1_FPVL3() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x80000) >> 19
}

// PWM.FPE: PWM Fault Protection Enable Register
func (o *PWM_Type) SetFPE_FPE0(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFPE_FPE0() uint32 {
	return volatile.LoadUint32(&o.FPE.Reg) & 0xff
}
func (o *PWM_Type) SetFPE_FPE1(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFPE_FPE1() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFPE_FPE2(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFPE_FPE2() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetFPE_FPE3(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff000000)|value<<24)
}
func (o *PWM_Type) GetFPE_FPE3() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff000000) >> 24
}

// PWM.ELMR: PWM Event Line 0 Mode Register 0
func (o *PWM_Type) SetELMR_CSEL0(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetELMR_CSEL0(idx int) uint32 {
	return volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x1
}
func (o *PWM_Type) SetELMR_CSEL1(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetELMR_CSEL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetELMR_CSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetELMR_CSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetELMR_CSEL3(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetELMR_CSEL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetELMR_CSEL4(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetELMR_CSEL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetELMR_CSEL5(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetELMR_CSEL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetELMR_CSEL6(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetELMR_CSEL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetELMR_CSEL7(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetELMR_CSEL7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x80) >> 7
}

// PWM.SSPR: PWM Spread Spectrum Register
func (o *PWM_Type) SetSSPR_SPRD(value uint32) {
	volatile.StoreUint32(&o.SSPR.Reg, volatile.LoadUint32(&o.SSPR.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetSSPR_SPRD() uint32 {
	return volatile.LoadUint32(&o.SSPR.Reg) & 0xffffff
}
func (o *PWM_Type) SetSSPR_SPRDM(value uint32) {
	volatile.StoreUint32(&o.SSPR.Reg, volatile.LoadUint32(&o.SSPR.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetSSPR_SPRDM() uint32 {
	return (volatile.LoadUint32(&o.SSPR.Reg) & 0x1000000) >> 24
}

// PWM.SSPUP: PWM Spread Spectrum Update Register
func (o *PWM_Type) SetSSPUP_SPRDUP(value uint32) {
	volatile.StoreUint32(&o.SSPUP.Reg, volatile.LoadUint32(&o.SSPUP.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetSSPUP_SPRDUP() uint32 {
	return volatile.LoadUint32(&o.SSPUP.Reg) & 0xffffff
}

// PWM.SMMR: PWM Stepper Motor Mode Register
func (o *PWM_Type) SetSMMR_GCEN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSMMR_GCEN0() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0x1
}
func (o *PWM_Type) SetSMMR_GCEN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSMMR_GCEN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSMMR_DOWN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetSMMR_DOWN0() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetSMMR_DOWN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetSMMR_DOWN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x20000) >> 17
}

// PWM.FPV2: PWM Fault Protection Value 2 Register
func (o *PWM_Type) SetFPV2_FPZH0(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetFPV2_FPZH0() uint32 {
	return volatile.LoadUint32(&o.FPV2.Reg) & 0x1
}
func (o *PWM_Type) SetFPV2_FPZH1(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetFPV2_FPZH1() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetFPV2_FPZH2(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetFPV2_FPZH2() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetFPV2_FPZH3(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetFPV2_FPZH3() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetFPV2_FPZL0(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetFPV2_FPZL0() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetFPV2_FPZL1(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetFPV2_FPZL1() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetFPV2_FPZL2(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetFPV2_FPZL2() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetFPV2_FPZL3(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetFPV2_FPZL3() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x80000) >> 19
}

// PWM.WPCR: PWM Write Protection Control Register
func (o *PWM_Type) SetWPCR_WPCMD(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetWPCR_WPCMD() uint32 {
	return volatile.LoadUint32(&o.WPCR.Reg) & 0x3
}
func (o *PWM_Type) SetWPCR_WPRG0(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPCR_WPRG0() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPCR_WPRG1(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPCR_WPRG1() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPCR_WPRG2(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPCR_WPRG2() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPCR_WPRG3(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPCR_WPRG3() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPCR_WPRG4(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetWPCR_WPRG4() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetWPCR_WPRG5(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPCR_WPRG5() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPCR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PWM_Type) GetWPCR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0xffffff00) >> 8
}

// PWM.WPSR: PWM Write Protection Status Register
func (o *PWM_Type) SetWPSR_WPSWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetWPSR_WPSWS0() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PWM_Type) SetWPSR_WPSWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetWPSR_WPSWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetWPSR_WPSWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPSR_WPSWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPSR_WPSWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPSR_WPSWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPSR_WPSWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPSR_WPSWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPSR_WPSWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPSR_WPSWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPSR_WPVS() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPSR_WPHWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetWPSR_WPHWS0() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetWPSR_WPHWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetWPSR_WPHWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetWPSR_WPHWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetWPSR_WPHWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetWPSR_WPHWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetWPSR_WPHWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetWPSR_WPHWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetWPSR_WPHWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetWPSR_WPHWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetWPSR_WPHWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff0000) >> 16
}

// PWM.CMUPD0: PWM Channel Mode Update Register (ch_num = 0)
func (o *PWM_Type) SetCMUPD0_CPOLUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD0.Reg, volatile.LoadUint32(&o.CMUPD0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMUPD0_CPOLUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMUPD0_CPOLINVUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD0.Reg, volatile.LoadUint32(&o.CMUPD0.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCMUPD0_CPOLINVUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD0.Reg) & 0x2000) >> 13
}

// PWM.CMUPD1: PWM Channel Mode Update Register (ch_num = 1)
func (o *PWM_Type) SetCMUPD1_CPOLUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD1.Reg, volatile.LoadUint32(&o.CMUPD1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMUPD1_CPOLUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMUPD1_CPOLINVUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD1.Reg, volatile.LoadUint32(&o.CMUPD1.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCMUPD1_CPOLINVUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD1.Reg) & 0x2000) >> 13
}

// PWM.ETRG1: PWM External Trigger Register (trg_num = 1)
func (o *PWM_Type) SetETRG1_MAXCNT(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetETRG1_MAXCNT() uint32 {
	return volatile.LoadUint32(&o.ETRG1.Reg) & 0xffffff
}
func (o *PWM_Type) SetETRG1_TRGMODE(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x3000000)|value<<24)
}
func (o *PWM_Type) GetETRG1_TRGMODE() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x3000000) >> 24
}
func (o *PWM_Type) SetETRG1_TRGEDGE(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x10000000)|value<<28)
}
func (o *PWM_Type) GetETRG1_TRGEDGE() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x10000000) >> 28
}
func (o *PWM_Type) SetETRG1_TRGFILT(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x20000000)|value<<29)
}
func (o *PWM_Type) GetETRG1_TRGFILT() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x20000000) >> 29
}
func (o *PWM_Type) SetETRG1_TRGSRC(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x40000000)|value<<30)
}
func (o *PWM_Type) GetETRG1_TRGSRC() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x40000000) >> 30
}
func (o *PWM_Type) SetETRG1_RFEN(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetETRG1_RFEN() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x80000000) >> 31
}

// PWM.LEBR1: PWM Leading-Edge Blanking Register (trg_num = 1)
func (o *PWM_Type) SetLEBR1_LEBDELAY(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x7f)|value)
}
func (o *PWM_Type) GetLEBR1_LEBDELAY() uint32 {
	return volatile.LoadUint32(&o.LEBR1.Reg) & 0x7f
}
func (o *PWM_Type) SetLEBR1_PWMLFEN(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetLEBR1_PWMLFEN() uint32 {
	return (volatile.LoadUint32(&o.LEBR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetLEBR1_PWMLREN(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetLEBR1_PWMLREN() uint32 {
	return (volatile.LoadUint32(&o.LEBR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetLEBR1_PWMHFEN(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetLEBR1_PWMHFEN() uint32 {
	return (volatile.LoadUint32(&o.LEBR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetLEBR1_PWMHREN(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetLEBR1_PWMHREN() uint32 {
	return (volatile.LoadUint32(&o.LEBR1.Reg) & 0x80000) >> 19
}

// PWM.CMUPD2: PWM Channel Mode Update Register (ch_num = 2)
func (o *PWM_Type) SetCMUPD2_CPOLUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD2.Reg, volatile.LoadUint32(&o.CMUPD2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMUPD2_CPOLUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMUPD2_CPOLINVUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD2.Reg, volatile.LoadUint32(&o.CMUPD2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCMUPD2_CPOLINVUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD2.Reg) & 0x2000) >> 13
}

// PWM.ETRG2: PWM External Trigger Register (trg_num = 2)
func (o *PWM_Type) SetETRG2_MAXCNT(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetETRG2_MAXCNT() uint32 {
	return volatile.LoadUint32(&o.ETRG2.Reg) & 0xffffff
}
func (o *PWM_Type) SetETRG2_TRGMODE(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x3000000)|value<<24)
}
func (o *PWM_Type) GetETRG2_TRGMODE() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x3000000) >> 24
}
func (o *PWM_Type) SetETRG2_TRGEDGE(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x10000000)|value<<28)
}
func (o *PWM_Type) GetETRG2_TRGEDGE() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x10000000) >> 28
}
func (o *PWM_Type) SetETRG2_TRGFILT(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x20000000)|value<<29)
}
func (o *PWM_Type) GetETRG2_TRGFILT() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x20000000) >> 29
}
func (o *PWM_Type) SetETRG2_TRGSRC(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x40000000)|value<<30)
}
func (o *PWM_Type) GetETRG2_TRGSRC() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x40000000) >> 30
}
func (o *PWM_Type) SetETRG2_RFEN(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetETRG2_RFEN() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x80000000) >> 31
}

// PWM.LEBR2: PWM Leading-Edge Blanking Register (trg_num = 2)
func (o *PWM_Type) SetLEBR2_LEBDELAY(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x7f)|value)
}
func (o *PWM_Type) GetLEBR2_LEBDELAY() uint32 {
	return volatile.LoadUint32(&o.LEBR2.Reg) & 0x7f
}
func (o *PWM_Type) SetLEBR2_PWMLFEN(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetLEBR2_PWMLFEN() uint32 {
	return (volatile.LoadUint32(&o.LEBR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetLEBR2_PWMLREN(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetLEBR2_PWMLREN() uint32 {
	return (volatile.LoadUint32(&o.LEBR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetLEBR2_PWMHFEN(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetLEBR2_PWMHFEN() uint32 {
	return (volatile.LoadUint32(&o.LEBR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetLEBR2_PWMHREN(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetLEBR2_PWMHREN() uint32 {
	return (volatile.LoadUint32(&o.LEBR2.Reg) & 0x80000) >> 19
}

// PWM.CMUPD3: PWM Channel Mode Update Register (ch_num = 3)
func (o *PWM_Type) SetCMUPD3_CPOLUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD3.Reg, volatile.LoadUint32(&o.CMUPD3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMUPD3_CPOLUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMUPD3_CPOLINVUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD3.Reg, volatile.LoadUint32(&o.CMUPD3.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCMUPD3_CPOLINVUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD3.Reg) & 0x2000) >> 13
}

// PWM Comparison 0 Value Register
type PWM_PWM_CMP_Type struct {
	CMPV    volatile.Register32 // 0x130
	CMPVUPD volatile.Register32 // 0x134
	CMPM    volatile.Register32 // 0x138
	CMPMUPD volatile.Register32 // 0x13C
}

// PWM_PWM_CMP.CMPV: PWM Comparison 0 Value Register
func (o *PWM_PWM_CMP_Type) SetCMPV_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV.Reg, volatile.LoadUint32(&o.CMPV.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CMP_Type) GetCMPV_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV.Reg) & 0xffffff
}
func (o *PWM_PWM_CMP_Type) SetCMPV_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV.Reg, volatile.LoadUint32(&o.CMPV.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_PWM_CMP_Type) GetCMPV_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV.Reg) & 0x1000000) >> 24
}

// PWM_PWM_CMP.CMPVUPD: PWM Comparison 0 Value Update Register
func (o *PWM_PWM_CMP_Type) SetCMPVUPD_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD.Reg, volatile.LoadUint32(&o.CMPVUPD.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CMP_Type) GetCMPVUPD_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD.Reg) & 0xffffff
}
func (o *PWM_PWM_CMP_Type) SetCMPVUPD_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD.Reg, volatile.LoadUint32(&o.CMPVUPD.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_PWM_CMP_Type) GetCMPVUPD_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD.Reg) & 0x1000000) >> 24
}

// PWM_PWM_CMP.CMPM: PWM Comparison 0 Mode Register
func (o *PWM_PWM_CMP_Type) SetCMPM_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0x1)|value)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM.Reg) & 0x1
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf0) >> 4
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf00) >> 8
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf000) >> 12
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf0000) >> 16
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf00000) >> 20
}

// PWM_PWM_CMP.CMPMUPD: PWM Comparison 0 Mode Update Register
func (o *PWM_PWM_CMP_Type) SetCMPMUPD_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD.Reg, volatile.LoadUint32(&o.CMPMUPD.Reg)&^(0x1)|value)
}
func (o *PWM_PWM_CMP_Type) GetCMPMUPD_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD.Reg) & 0x1
}
func (o *PWM_PWM_CMP_Type) SetCMPMUPD_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD.Reg, volatile.LoadUint32(&o.CMPMUPD.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_PWM_CMP_Type) GetCMPMUPD_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD.Reg) & 0xf0) >> 4
}
func (o *PWM_PWM_CMP_Type) SetCMPMUPD_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD.Reg, volatile.LoadUint32(&o.CMPMUPD.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_PWM_CMP_Type) GetCMPMUPD_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD.Reg) & 0xf00) >> 8
}
func (o *PWM_PWM_CMP_Type) SetCMPMUPD_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD.Reg, volatile.LoadUint32(&o.CMPMUPD.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_PWM_CMP_Type) GetCMPMUPD_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD.Reg) & 0xf0000) >> 16
}

// PWM Channel Mode Register
type PWM_PWM_CH_NUM_Type struct {
	CMR     volatile.Register32 // 0x200
	CDTY    volatile.Register32 // 0x204
	CDTYUPD volatile.Register32 // 0x208
	CPRD    volatile.Register32 // 0x20C
	CPRDUPD volatile.Register32 // 0x210
	CCNT    volatile.Register32 // 0x214
	DT      volatile.Register32 // 0x218
	DTUPD   volatile.Register32 // 0x21C
}

// PWM_PWM_CH_NUM.CMR: PWM Channel Mode Register
func (o *PWM_PWM_CH_NUM_Type) SetCMR_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xf)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xf
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x100) >> 8
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x200) >> 9
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_CES(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x400) >> 10
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_UPDS(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_UPDS() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x800) >> 11
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_DPOLI(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_DPOLI() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x1000) >> 12
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_TCTS(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_TCTS() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x2000) >> 13
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x10000) >> 16
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x20000) >> 17
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x40000) >> 18
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_PPM(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_PPM() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x80000) >> 19
}

// PWM_PWM_CH_NUM.CDTY: PWM Channel Duty Cycle Register
func (o *PWM_PWM_CH_NUM_Type) SetCDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY.Reg, volatile.LoadUint32(&o.CDTY.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.CDTYUPD: PWM Channel Duty Cycle Update Register
func (o *PWM_PWM_CH_NUM_Type) SetCDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD.Reg, volatile.LoadUint32(&o.CDTYUPD.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.CPRD: PWM Channel Period Register
func (o *PWM_PWM_CH_NUM_Type) SetCPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD.Reg, volatile.LoadUint32(&o.CPRD.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.CPRDUPD: PWM Channel Period Update Register
func (o *PWM_PWM_CH_NUM_Type) SetCPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD.Reg, volatile.LoadUint32(&o.CPRDUPD.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.CCNT: PWM Channel Counter Register
func (o *PWM_PWM_CH_NUM_Type) SetCCNT_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT.Reg, volatile.LoadUint32(&o.CCNT.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCCNT_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.DT: PWM Channel Dead Time Register
func (o *PWM_PWM_CH_NUM_Type) SetDT_DTH(value uint32) {
	volatile.StoreUint32(&o.DT.Reg, volatile.LoadUint32(&o.DT.Reg)&^(0xffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetDT_DTH() uint32 {
	return volatile.LoadUint32(&o.DT.Reg) & 0xffff
}
func (o *PWM_PWM_CH_NUM_Type) SetDT_DTL(value uint32) {
	volatile.StoreUint32(&o.DT.Reg, volatile.LoadUint32(&o.DT.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_PWM_CH_NUM_Type) GetDT_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT.Reg) & 0xffff0000) >> 16
}

// PWM_PWM_CH_NUM.DTUPD: PWM Channel Dead Time Update Register
func (o *PWM_PWM_CH_NUM_Type) SetDTUPD_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD.Reg, volatile.LoadUint32(&o.DTUPD.Reg)&^(0xffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetDTUPD_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD.Reg) & 0xffff
}
func (o *PWM_PWM_CH_NUM_Type) SetDTUPD_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD.Reg, volatile.LoadUint32(&o.DTUPD.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_PWM_CH_NUM_Type) GetDTUPD_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD.Reg) & 0xffff0000) >> 16
}

// Quad Serial Peripheral Interface
type QSPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	SCR  volatile.Register32 // 0x20
	_    [12]byte
	IAR  volatile.Register32 // 0x30
	ICR  volatile.Register32 // 0x34
	IFR  volatile.Register32 // 0x38
	_    [4]byte
	SMR  volatile.Register32 // 0x40
	SKR  volatile.Register32 // 0x44
	_    [156]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// QSPI.CR: Control Register
func (o *QSPI_Type) SetCR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetCR_QSPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *QSPI_Type) SetCR_QSPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetCR_QSPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *QSPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *QSPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *QSPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// QSPI.MR: Mode Register
func (o *QSPI_Type) SetMR_SMM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetMR_SMM() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *QSPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetMR_CSMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *QSPI_Type) GetMR_CSMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *QSPI_Type) SetMR_NBBITS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *QSPI_Type) GetMR_NBBITS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *QSPI_Type) SetMR_DLYBCT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetMR_DLYBCT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff0000) >> 16
}
func (o *QSPI_Type) SetMR_DLYCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *QSPI_Type) GetMR_DLYCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// QSPI.RDR: Receive Data Register
func (o *QSPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *QSPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}

// QSPI.TDR: Transmit Data Register
func (o *QSPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *QSPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}

// QSPI.SR: Status Register
func (o *QSPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *QSPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetSR_CSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *QSPI_Type) GetSR_CSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *QSPI_Type) SetSR_CSS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *QSPI_Type) GetSR_CSS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *QSPI_Type) SetSR_INSTRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetSR_INSTRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *QSPI_Type) SetSR_QSPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *QSPI_Type) GetSR_QSPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}

// QSPI.IER: Interrupt Enable Register
func (o *QSPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *QSPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetIER_CSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *QSPI_Type) GetIER_CSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *QSPI_Type) SetIER_CSS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *QSPI_Type) GetIER_CSS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *QSPI_Type) SetIER_INSTRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetIER_INSTRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}

// QSPI.IDR: Interrupt Disable Register
func (o *QSPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *QSPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetIDR_CSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *QSPI_Type) GetIDR_CSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *QSPI_Type) SetIDR_CSS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *QSPI_Type) GetIDR_CSS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *QSPI_Type) SetIDR_INSTRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetIDR_INSTRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}

// QSPI.IMR: Interrupt Mask Register
func (o *QSPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *QSPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetIMR_CSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *QSPI_Type) GetIMR_CSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *QSPI_Type) SetIMR_CSS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *QSPI_Type) GetIMR_CSS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *QSPI_Type) SetIMR_INSTRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetIMR_INSTRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}

// QSPI.SCR: Serial Clock Register
func (o *QSPI_Type) SetSCR_CPOL(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetSCR_CPOL() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *QSPI_Type) SetSCR_CPHA(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetSCR_CPHA() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetSCR_SCBR(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff00)|value<<8)
}
func (o *QSPI_Type) GetSCR_SCBR() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xff00) >> 8
}
func (o *QSPI_Type) SetSCR_DLYBS(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetSCR_DLYBS() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xff0000) >> 16
}

// QSPI.IAR: Instruction Address Register
func (o *QSPI_Type) SetIAR(value uint32) {
	volatile.StoreUint32(&o.IAR.Reg, value)
}
func (o *QSPI_Type) GetIAR() uint32 {
	return volatile.LoadUint32(&o.IAR.Reg)
}

// QSPI.ICR: Instruction Code Register
func (o *QSPI_Type) SetICR_INST(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetICR_INST() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0xff
}
func (o *QSPI_Type) SetICR_OPT(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetICR_OPT() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff0000) >> 16
}

// QSPI.IFR: Instruction Frame Register
func (o *QSPI_Type) SetIFR_WIDTH(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x7)|value)
}
func (o *QSPI_Type) GetIFR_WIDTH() uint32 {
	return volatile.LoadUint32(&o.IFR.Reg) & 0x7
}
func (o *QSPI_Type) SetIFR_INSTEN(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x10)|value<<4)
}
func (o *QSPI_Type) GetIFR_INSTEN() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x10) >> 4
}
func (o *QSPI_Type) SetIFR_ADDREN(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x20)|value<<5)
}
func (o *QSPI_Type) GetIFR_ADDREN() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x20) >> 5
}
func (o *QSPI_Type) SetIFR_OPTEN(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x40)|value<<6)
}
func (o *QSPI_Type) GetIFR_OPTEN() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x40) >> 6
}
func (o *QSPI_Type) SetIFR_DATAEN(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x80)|value<<7)
}
func (o *QSPI_Type) GetIFR_DATAEN() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x80) >> 7
}
func (o *QSPI_Type) SetIFR_OPTL(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x300)|value<<8)
}
func (o *QSPI_Type) GetIFR_OPTL() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x300) >> 8
}
func (o *QSPI_Type) SetIFR_ADDRL(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetIFR_ADDRL() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x400) >> 10
}
func (o *QSPI_Type) SetIFR_TFRTYP(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x3000)|value<<12)
}
func (o *QSPI_Type) GetIFR_TFRTYP() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x3000) >> 12
}
func (o *QSPI_Type) SetIFR_CRM(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x4000)|value<<14)
}
func (o *QSPI_Type) GetIFR_CRM() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x4000) >> 14
}
func (o *QSPI_Type) SetIFR_NBDUM(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x1f0000)|value<<16)
}
func (o *QSPI_Type) GetIFR_NBDUM() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x1f0000) >> 16
}

// QSPI.SMR: Scrambling Mode Register
func (o *QSPI_Type) SetSMR_SCREN(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetSMR_SCREN() uint32 {
	return volatile.LoadUint32(&o.SMR.Reg) & 0x1
}
func (o *QSPI_Type) SetSMR_RVDIS(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetSMR_RVDIS() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x2) >> 1
}

// QSPI.SKR: Scrambling Key Register
func (o *QSPI_Type) SetSKR(value uint32) {
	volatile.StoreUint32(&o.SKR.Reg, value)
}
func (o *QSPI_Type) GetSKR() uint32 {
	return volatile.LoadUint32(&o.SKR.Reg)
}

// QSPI.WPMR: Write Protection Mode Register
func (o *QSPI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *QSPI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *QSPI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// QSPI.WPSR: Write Protection Status Register
func (o *QSPI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *QSPI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *QSPI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// Reset Controller
type RSTC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// RSTC.CR: Control Register
func (o *RSTC_Type) SetCR_PROCRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RSTC_Type) GetCR_PROCRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RSTC_Type) SetCR_EXTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RSTC_Type) GetCR_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RSTC_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *RSTC_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// RSTC.SR: Status Register
func (o *RSTC_Type) SetSR_URSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RSTC_Type) GetSR_URSTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RSTC_Type) SetSR_RSTTYP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x700)|value<<8)
}
func (o *RSTC_Type) GetSR_RSTTYP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x700) >> 8
}
func (o *RSTC_Type) SetSR_NRSTL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *RSTC_Type) GetSR_NRSTL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *RSTC_Type) SetSR_SRCMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *RSTC_Type) GetSR_SRCMP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// RSTC.MR: Mode Register
func (o *RSTC_Type) SetMR_URSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *RSTC_Type) GetMR_URSTEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *RSTC_Type) SetMR_URSTIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *RSTC_Type) GetMR_URSTIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *RSTC_Type) SetMR_ERSTL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *RSTC_Type) GetMR_ERSTL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *RSTC_Type) SetMR_KEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *RSTC_Type) GetMR_KEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// Reinforced Safety Watchdog Timer
type RSWDT_Type struct {
	CR volatile.Register32 // 0x0
	MR volatile.Register32 // 0x4
	SR volatile.Register32 // 0x8
}

// RSWDT.CR: Control Register
func (o *RSWDT_Type) SetCR_WDRSTT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RSWDT_Type) GetCR_WDRSTT() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RSWDT_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *RSWDT_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// RSWDT.MR: Mode Register
func (o *RSWDT_Type) SetMR_WDV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xfff)|value)
}
func (o *RSWDT_Type) GetMR_WDV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xfff
}
func (o *RSWDT_Type) SetMR_WDFIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *RSWDT_Type) GetMR_WDFIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *RSWDT_Type) SetMR_WDRSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *RSWDT_Type) GetMR_WDRSTEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *RSWDT_Type) SetMR_WDDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *RSWDT_Type) GetMR_WDDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}
func (o *RSWDT_Type) SetMR_ALLONES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xfff0000)|value<<16)
}
func (o *RSWDT_Type) GetMR_ALLONES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xfff0000) >> 16
}
func (o *RSWDT_Type) SetMR_WDDBGHLT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *RSWDT_Type) GetMR_WDDBGHLT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *RSWDT_Type) SetMR_WDIDLEHLT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *RSWDT_Type) GetMR_WDIDLEHLT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}

// RSWDT.SR: Status Register
func (o *RSWDT_Type) SetSR_WDUNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RSWDT_Type) GetSR_WDUNF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Real-time Clock
type RTC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	TIMR   volatile.Register32 // 0x8
	CALR   volatile.Register32 // 0xC
	TIMALR volatile.Register32 // 0x10
	CALALR volatile.Register32 // 0x14
	SR     volatile.Register32 // 0x18
	SCCR   volatile.Register32 // 0x1C
	IER    volatile.Register32 // 0x20
	IDR    volatile.Register32 // 0x24
	IMR    volatile.Register32 // 0x28
	VER    volatile.Register32 // 0x2C
}

// RTC.CR: Control Register
func (o *RTC_Type) SetCR_UPDTIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCR_UPDTIM() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RTC_Type) SetCR_UPDCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCR_UPDCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCR_TIMEVSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *RTC_Type) GetCR_TIMEVSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *RTC_Type) SetCR_CALEVSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *RTC_Type) GetCR_CALEVSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}

// RTC.MR: Mode Register
func (o *RTC_Type) SetMR_HRMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetMR_HRMOD() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *RTC_Type) SetMR_PERSIAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetMR_PERSIAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetMR_NEGPPM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetMR_NEGPPM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetMR_CORRECTION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7f00)|value<<8)
}
func (o *RTC_Type) GetMR_CORRECTION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7f00) >> 8
}
func (o *RTC_Type) SetMR_HIGHPPM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetMR_HIGHPPM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetMR_OUT0(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x70000)|value<<16)
}
func (o *RTC_Type) GetMR_OUT0() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x70000) >> 16
}
func (o *RTC_Type) SetMR_OUT1(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700000)|value<<20)
}
func (o *RTC_Type) GetMR_OUT1() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700000) >> 20
}
func (o *RTC_Type) SetMR_THIGH(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *RTC_Type) GetMR_THIGH() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *RTC_Type) SetMR_TPERIOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetMR_TPERIOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30000000) >> 28
}

// RTC.TIMR: Time Register
func (o *RTC_Type) SetTIMR_SEC(value uint32) {
	volatile.StoreUint32(&o.TIMR.Reg, volatile.LoadUint32(&o.TIMR.Reg)&^(0x7f)|value)
}
func (o *RTC_Type) GetTIMR_SEC() uint32 {
	return volatile.LoadUint32(&o.TIMR.Reg) & 0x7f
}
func (o *RTC_Type) SetTIMR_MIN(value uint32) {
	volatile.StoreUint32(&o.TIMR.Reg, volatile.LoadUint32(&o.TIMR.Reg)&^(0x7f00)|value<<8)
}
func (o *RTC_Type) GetTIMR_MIN() uint32 {
	return (volatile.LoadUint32(&o.TIMR.Reg) & 0x7f00) >> 8
}
func (o *RTC_Type) SetTIMR_HOUR(value uint32) {
	volatile.StoreUint32(&o.TIMR.Reg, volatile.LoadUint32(&o.TIMR.Reg)&^(0x3f0000)|value<<16)
}
func (o *RTC_Type) GetTIMR_HOUR() uint32 {
	return (volatile.LoadUint32(&o.TIMR.Reg) & 0x3f0000) >> 16
}
func (o *RTC_Type) SetTIMR_AMPM(value uint32) {
	volatile.StoreUint32(&o.TIMR.Reg, volatile.LoadUint32(&o.TIMR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTIMR_AMPM() uint32 {
	return (volatile.LoadUint32(&o.TIMR.Reg) & 0x400000) >> 22
}

// RTC.CALR: Calendar Register
func (o *RTC_Type) SetCALR_CENT(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x7f)|value)
}
func (o *RTC_Type) GetCALR_CENT() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x7f
}
func (o *RTC_Type) SetCALR_YEAR(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0xff00)|value<<8)
}
func (o *RTC_Type) GetCALR_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0xff00) >> 8
}
func (o *RTC_Type) SetCALR_MONTH(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RTC_Type) GetCALR_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x1f0000) >> 16
}
func (o *RTC_Type) SetCALR_DAY(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0xe00000)|value<<21)
}
func (o *RTC_Type) GetCALR_DAY() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0xe00000) >> 21
}
func (o *RTC_Type) SetCALR_DATE(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x3f000000)|value<<24)
}
func (o *RTC_Type) GetCALR_DATE() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x3f000000) >> 24
}

// RTC.TIMALR: Time Alarm Register
func (o *RTC_Type) SetTIMALR_SEC(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x7f)|value)
}
func (o *RTC_Type) GetTIMALR_SEC() uint32 {
	return volatile.LoadUint32(&o.TIMALR.Reg) & 0x7f
}
func (o *RTC_Type) SetTIMALR_SECEN(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTIMALR_SECEN() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTIMALR_MIN(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x7f00)|value<<8)
}
func (o *RTC_Type) GetTIMALR_MIN() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x7f00) >> 8
}
func (o *RTC_Type) SetTIMALR_MINEN(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTIMALR_MINEN() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTIMALR_HOUR(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x3f0000)|value<<16)
}
func (o *RTC_Type) GetTIMALR_HOUR() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x3f0000) >> 16
}
func (o *RTC_Type) SetTIMALR_AMPM(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTIMALR_AMPM() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTIMALR_HOUREN(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetTIMALR_HOUREN() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x800000) >> 23
}

// RTC.CALALR: Calendar Alarm Register
func (o *RTC_Type) SetCALALR_MONTH(value uint32) {
	volatile.StoreUint32(&o.CALALR.Reg, volatile.LoadUint32(&o.CALALR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RTC_Type) GetCALALR_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CALALR.Reg) & 0x1f0000) >> 16
}
func (o *RTC_Type) SetCALALR_MTHEN(value uint32) {
	volatile.StoreUint32(&o.CALALR.Reg, volatile.LoadUint32(&o.CALALR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCALALR_MTHEN() uint32 {
	return (volatile.LoadUint32(&o.CALALR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCALALR_DATE(value uint32) {
	volatile.StoreUint32(&o.CALALR.Reg, volatile.LoadUint32(&o.CALALR.Reg)&^(0x3f000000)|value<<24)
}
func (o *RTC_Type) GetCALALR_DATE() uint32 {
	return (volatile.LoadUint32(&o.CALALR.Reg) & 0x3f000000) >> 24
}
func (o *RTC_Type) SetCALALR_DATEEN(value uint32) {
	volatile.StoreUint32(&o.CALALR.Reg, volatile.LoadUint32(&o.CALALR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetCALALR_DATEEN() uint32 {
	return (volatile.LoadUint32(&o.CALALR.Reg) & 0x80000000) >> 31
}

// RTC.SR: Status Register
func (o *RTC_Type) SetSR_ACKUPD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSR_ACKUPD() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTC_Type) SetSR_ALARM(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSR_ALARM() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSR_SEC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSR_SEC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSR_TIMEV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSR_TIMEV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSR_CALEV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSR_CALEV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSR_TDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSR_TDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}

// RTC.SCCR: Status Clear Command Register
func (o *RTC_Type) SetSCCR_ACKCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSCCR_ACKCLR() uint32 {
	return volatile.LoadUint32(&o.SCCR.Reg) & 0x1
}
func (o *RTC_Type) SetSCCR_ALRCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSCCR_ALRCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSCCR_SECCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSCCR_SECCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSCCR_TIMCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSCCR_TIMCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSCCR_CALCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSCCR_CALCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSCCR_TDERRCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSCCR_TDERRCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x20) >> 5
}

// RTC.IER: Interrupt Enable Register
func (o *RTC_Type) SetIER_ACKEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIER_ACKEN() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *RTC_Type) SetIER_ALREN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIER_ALREN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIER_SECEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIER_SECEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIER_TIMEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetIER_TIMEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetIER_CALEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIER_CALEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIER_TDERREN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetIER_TDERREN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}

// RTC.IDR: Interrupt Disable Register
func (o *RTC_Type) SetIDR_ACKDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIDR_ACKDIS() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *RTC_Type) SetIDR_ALRDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIDR_ALRDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIDR_SECDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIDR_SECDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIDR_TIMDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetIDR_TIMDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetIDR_CALDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIDR_CALDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIDR_TDERRDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetIDR_TDERRDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}

// RTC.IMR: Interrupt Mask Register
func (o *RTC_Type) SetIMR_ACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIMR_ACK() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *RTC_Type) SetIMR_ALR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIMR_ALR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIMR_SEC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIMR_SEC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIMR_TIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetIMR_TIM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetIMR_CAL(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIMR_CAL() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIMR_TDERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetIMR_TDERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}

// RTC.VER: Valid Entry Register
func (o *RTC_Type) SetVER_NVTIM(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetVER_NVTIM() uint32 {
	return volatile.LoadUint32(&o.VER.Reg) & 0x1
}
func (o *RTC_Type) SetVER_NVCAL(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetVER_NVCAL() uint32 {
	return (volatile.LoadUint32(&o.VER.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetVER_NVTIMALR(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetVER_NVTIMALR() uint32 {
	return (volatile.LoadUint32(&o.VER.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetVER_NVCALALR(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetVER_NVCALALR() uint32 {
	return (volatile.LoadUint32(&o.VER.Reg) & 0x8) >> 3
}

// Real-time Timer
type RTT_Type struct {
	MR volatile.Register32 // 0x0
	AR volatile.Register32 // 0x4
	VR volatile.Register32 // 0x8
	SR volatile.Register32 // 0xC
}

// RTT.MR: Mode Register
func (o *RTT_Type) SetMR_RTPRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xffff)|value)
}
func (o *RTT_Type) GetMR_RTPRES() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xffff
}
func (o *RTT_Type) SetMR_ALMIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *RTT_Type) GetMR_ALMIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *RTT_Type) SetMR_RTTINCIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *RTT_Type) GetMR_RTTINCIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *RTT_Type) SetMR_RTTRST(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *RTT_Type) GetMR_RTTRST() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *RTT_Type) SetMR_RTTDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *RTT_Type) GetMR_RTTDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *RTT_Type) SetMR_RTC1HZ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTT_Type) GetMR_RTC1HZ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000000) >> 24
}

// RTT.AR: Alarm Register
func (o *RTT_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *RTT_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// RTT.VR: Value Register
func (o *RTT_Type) SetVR(value uint32) {
	volatile.StoreUint32(&o.VR.Reg, value)
}
func (o *RTT_Type) GetVR() uint32 {
	return volatile.LoadUint32(&o.VR.Reg)
}

// RTT.SR: Status Register
func (o *RTT_Type) SetSR_ALMS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTT_Type) GetSR_ALMS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTT_Type) SetSR_RTTINC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTT_Type) GetSR_RTTINC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.WPMR: Write Protection Mode Register
func (o *SSC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SSC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SSC.WPSR: Write Protection Status Register
func (o *SSC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SSC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *SSC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Supply Controller
type SUPC_Type struct {
	CR        volatile.Register32 // 0x0
	SMMR      volatile.Register32 // 0x4
	MR        volatile.Register32 // 0x8
	WUMR      volatile.Register32 // 0xC
	WUIR      volatile.Register32 // 0x10
	SR        volatile.Register32 // 0x14
	_         [188]byte
	SYSC_WPMR volatile.Register32 // 0xD4
}

// SUPC.CR: Supply Controller Control Register
func (o *SUPC_Type) SetCR_VROFF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetCR_VROFF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetCR_XTALSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetCR_XTALSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *SUPC_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// SUPC.SMMR: Supply Controller Supply Monitor Mode Register
func (o *SUPC_Type) SetSMMR_SMTH(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0xf)|value)
}
func (o *SUPC_Type) GetSMMR_SMTH() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0xf
}
func (o *SUPC_Type) SetSMMR_SMSMPL(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x700)|value<<8)
}
func (o *SUPC_Type) GetSMMR_SMSMPL() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x700) >> 8
}
func (o *SUPC_Type) SetSMMR_SMRSTEN(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1000)|value<<12)
}
func (o *SUPC_Type) GetSMMR_SMRSTEN() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x1000) >> 12
}
func (o *SUPC_Type) SetSMMR_SMIEN(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2000)|value<<13)
}
func (o *SUPC_Type) GetSMMR_SMIEN() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2000) >> 13
}

// SUPC.MR: Supply Controller Mode Register
func (o *SUPC_Type) SetMR_BODRSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *SUPC_Type) GetMR_BODRSTEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *SUPC_Type) SetMR_BODDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *SUPC_Type) GetMR_BODDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *SUPC_Type) SetMR_ONREG(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *SUPC_Type) GetMR_ONREG() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}
func (o *SUPC_Type) SetMR_BKUPRETON(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *SUPC_Type) GetMR_BKUPRETON() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *SUPC_Type) SetMR_OSCBYPASS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *SUPC_Type) GetMR_OSCBYPASS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *SUPC_Type) SetMR_KEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SUPC_Type) GetMR_KEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SUPC.WUMR: Supply Controller Wake-up Mode Register
func (o *SUPC_Type) SetWUMR_SMEN(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetWUMR_SMEN() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetWUMR_RTTEN(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetWUMR_RTTEN() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetWUMR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetWUMR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetWUMR_LPDBCEN0(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetWUMR_LPDBCEN0() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetWUMR_LPDBCEN1(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetWUMR_LPDBCEN1() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetWUMR_LPDBCCLR(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x80)|value<<7)
}
func (o *SUPC_Type) GetWUMR_LPDBCCLR() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x80) >> 7
}
func (o *SUPC_Type) SetWUMR_WKUPDBC(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x7000)|value<<12)
}
func (o *SUPC_Type) GetWUMR_WKUPDBC() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x7000) >> 12
}
func (o *SUPC_Type) SetWUMR_LPDBC(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x70000)|value<<16)
}
func (o *SUPC_Type) GetWUMR_LPDBC() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x70000) >> 16
}

// SUPC.WUIR: Supply Controller Wake-up Inputs Register
func (o *SUPC_Type) SetWUIR_WKUPEN0(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetWUIR_WKUPEN0() uint32 {
	return volatile.LoadUint32(&o.WUIR.Reg) & 0x1
}
func (o *SUPC_Type) SetWUIR_WKUPEN1(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetWUIR_WKUPEN1() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetWUIR_WKUPEN2(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetWUIR_WKUPEN2() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetWUIR_WKUPEN3(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetWUIR_WKUPEN3() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetWUIR_WKUPEN4(value uint3