/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.openide.explorer.ExplorerActionsImpl;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.etable.ETableTransferHandler;
import org.netbeans.swing.etable.TableColumnSelector;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.netbeans.swing.outline.TreePathSupport;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.awt.QuickSearch;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.NodePopupFactory;
import org.openide.explorer.view.NodeRenderDataProvider;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.OutlineViewDragSupport;
import org.openide.explorer.view.OutlineViewDropSupport;
import org.openide.explorer.view.PropertiesRowModel;
import org.openide.explorer.view.QuickSearchTableFilter;
import org.openide.explorer.view.SheetCell;
import org.openide.explorer.view.TableQuickSearchSupport;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.ViewUtil;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class OutlineView
extends JScrollPane {
    private static final String TREE_HORIZONTAL_SCROLLBAR = "TREE_HORIZONTAL_SCROLLBAR";
    private static RequestProcessor REVALIDATING_RP = new RequestProcessor("OutlineView", 1);
    private static final Logger logger = Logger.getLogger(OutlineView.class.getName());
    private OutlineViewOutline outline;
    ExplorerManager manager;
    private final Object managerLock = new Object();
    private PopupAdapter popupListener;
    private TableSelectionListener managerListener = null;
    private PropertyChangeListener wlpc;
    private VetoableChangeListener wlvc;
    private OutlineModel model;
    private NodeTreeModel treeModel;
    private PropertiesRowModel rowModel;
    private NodePopupFactory popupFactory;
    private transient boolean dragActive = true;
    private transient boolean dropActive = true;
    transient OutlineViewDragSupport dragSupport;
    transient OutlineViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;
    private ActionListener defaultTreeActionListener;
    private boolean isTreeHScrollBar = false;
    private JScrollBar hScrollBar;
    private int treeHorizontalScrollBarPolicy = this.isTreeHScrollBar ? 30 : 31;
    private ScrollListener listener;
    private Selection selection = null;
    private QuickSearch quickSearch;
    private Component searchPanel;
    private final Object searchConstraints = new Object();
    private KeyListener qsKeyListener;
    private NodeRenderDataProvider nodeRenderer;
    private boolean horizontalScrollBarIsNeeded = false;

    public OutlineView() {
        this((String)null);
    }

    public OutlineView(String string) {
        Color color;
        this.treeModel = new NodeTreeModel();
        this.rowModel = new PropertiesRowModel();
        this.model = this.createOutlineModel(this.treeModel, this.rowModel, string);
        this.outline = new OutlineViewOutline(this.model, this.rowModel);
        TableQuickSearchSupport tableQuickSearchSupport = this.outline.createDefaultTableQuickSearchSupport();
        this.attachQuickSearch(tableQuickSearchSupport, false, tableQuickSearchSupport.createSearchPopupMenu());
        this.qsKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                OutlineView.this.quickSearch.processKeyEvent(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                OutlineView.this.quickSearch.processKeyEvent(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OutlineView.this.quickSearch.processKeyEvent(keyEvent);
            }
        };
        this.outline.addKeyListener(this.qsKeyListener);
        this.rowModel.setOutline(this.outline);
        this.nodeRenderer = new NodeRenderDataProvider(this.outline);
        this.outline.setRenderDataProvider((RenderDataProvider)this.nodeRenderer);
        SheetCell.OutlineSheetCell outlineSheetCell = new SheetCell.OutlineSheetCell(this.outline);
        this.outline.setDefaultRenderer(Node.Property.class, outlineSheetCell);
        this.outline.setDefaultEditor(Node.Property.class, outlineSheetCell);
        this.hScrollBar = this.createHorizontalScrollBar();
        this.hScrollBar.setUnitIncrement(10);
        this.setLayout(new OutlineScrollLayout());
        this.add((Component)this.hScrollBar, TREE_HORIZONTAL_SCROLLBAR);
        this.setViewportView((Component)((Object)this.outline));
        this.setPopupAllowed(true);
        this.setRequestFocusEnabled(false);
        this.outline.setRequestFocusEnabled(true);
        Color color2 = UIManager.getColor("Table.background1");
        if (color2 == null) {
            color2 = UIManager.getColor("Table.background");
        }
        if (color2 != null) {
            this.getViewport().setBackground(color2);
        }
        this.getActionMap().put("org.openide.actions.PopupAction", new PopupAction());
        this.popupFactory = new OutlinePopupFactory();
        this.setDropTarget(DragDropUtilities.dragAndDropEnabled);
        this.defaultTreeActionListener = new DefaultTreeAction(this.outline);
        this.outline.registerKeyboardAction(this.defaultTreeActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        if (!UIManager.getLookAndFeel().getID().startsWith("FlatLaf")) {
            color = this.outline.getSelectionBackground();
            final Color color3 = this.outline.getSelectionForeground();
            this.outline.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    OutlineView.this.outline.setSelectionBackground(color);
                    OutlineView.this.outline.setSelectionForeground(color3);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    OutlineView.this.outline.setSelectionBackground(SheetCell.getNoFocusSelectionBackground());
                    OutlineView.this.outline.setSelectionForeground(SheetCell.getNoFocusSelectionForeground());
                }
            });
            this.outline.setSelectionBackground(SheetCell.getNoFocusSelectionBackground());
            this.outline.setSelectionForeground(SheetCell.getNoFocusSelectionForeground());
        }
        if ((color = (TableColumnSelector)Lookup.getDefault().lookup(TableColumnSelector.class)) != null) {
            this.outline.setColumnSelector((TableColumnSelector)color);
        }
        if (UIManager.getColor("control") != null) {
            this.getOutline().setGridColor(UIManager.getColor("control"));
        }
        if (DragDropUtilities.dragAndDropEnabled) {
            this.setDragSource(true);
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.initializeTreeScrollSupport();
    }

    private void attachQuickSearch(QuickSearch.Callback callback, boolean bl, JMenu jMenu) {
        if (this.quickSearch != null) {
            this.quickSearch.detach();
        }
        this.quickSearch = QuickSearch.attach((JComponent)this, (Object)this.searchConstraints, (QuickSearch.Callback)callback, (boolean)bl, (JMenu)jMenu);
    }

    @Override
    public void add(Component component, Object object) {
        if (object == this.searchConstraints) {
            this.searchPanel = component;
            object = null;
        }
        super.add(component, object);
    }

    @Override
    public void remove(Component component) {
        if (component == this.searchPanel) {
            this.searchPanel = null;
        }
        super.remove(component);
    }

    protected OutlineModel createOutlineModel(NodeTreeModel nodeTreeModel, RowModel rowModel, String string) {
        if (string == null) {
            string = NbBundle.getMessage(OutlineView.class, (String)"NodeOutlineModel_NodesColumnLabel");
        }
        return new NodeOutlineModel(nodeTreeModel, rowModel, false, string);
    }

    private void initializeTreeScrollSupport() {
        if (UIManager.getColor("Table.background") != null) {
            this.getViewport().setBackground(UIManager.getColor("Table.background"));
        }
        this.listener = new ScrollListener();
        if (this.isTreeHScrollBar) {
            this.outline.getColumnModel().addColumnModelListener(this.listener);
        }
        if (ViewUtil.isAquaLaF) {
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    if (mouseWheelEvent.isShiftDown() && !mouseWheelEvent.isAltDown() && !mouseWheelEvent.isAltGraphDown() && !mouseWheelEvent.isControlDown() && !mouseWheelEvent.isMetaDown() && OutlineView.this.horizontalWheelScroll(mouseWheelEvent)) {
                        mouseWheelEvent.consume();
                    }
                }
            });
        }
        final RequestProcessor.Task task = REVALIDATING_RP.create(new Runnable(){

            @Override
            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Exceptions.printStackTrace((Throwable)invocationTargetException);
                    }
                } else {
                    OutlineView.this.listener.revalidateScrollBar();
                    OutlineView.this.revalidate();
                }
            }
        });
        this.outline.setTreeWidthChangeTask(task);
        this.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                task.schedule(100);
            }
        });
        this.hScrollBar.addAdjustmentListener(this.listener);
        this.hScrollBar.getModel().addChangeListener(this.listener);
    }

    public int getTreeHorizontalScrollBarPolicy() {
        return this.treeHorizontalScrollBarPolicy;
    }

    public void setTreeHorizontalScrollBarPolicy(int n) {
        if (n == this.treeHorizontalScrollBarPolicy) {
            return;
        }
        switch (n) {
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid treeHorizontalScrollBarPolicy");
            }
        }
        int n2 = this.treeHorizontalScrollBarPolicy;
        this.treeHorizontalScrollBarPolicy = n;
        boolean bl = this.isTreeHScrollBar;
        boolean bl2 = this.isTreeHScrollBar = n != 31;
        if (bl != this.isTreeHScrollBar) {
            if (!bl) {
                this.outline.getColumnModel().addColumnModelListener(this.listener);
            } else {
                this.outline.getColumnModel().removeColumnModelListener(this.listener);
            }
            this.outline.setTreeHScrollingEnabled(this.isTreeHScrollBar, this.hScrollBar);
        }
        this.firePropertyChange("treeHorizontalScrollBarPolicy", n2, n);
        this.revalidate();
        this.repaint();
    }

    private void sayHorizontalScrollBarNeeded(boolean bl) {
        this.horizontalScrollBarIsNeeded = bl;
    }

    @Override
    public int getHorizontalScrollBarPolicy() {
        if (this.horizontalScrollBarIsNeeded) {
            return 32;
        }
        return super.getHorizontalScrollBarPolicy();
    }

    @Override
    public void requestFocus() {
        this.outline.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.outline.requestFocusInWindow();
    }

    public Outline getOutline() {
        return this.outline;
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    @Deprecated
    public void setProperties(Node.Property[] propertyArray) {
        this.setProperties(propertyArray, true);
    }

    private void setProperties(Node.Property[] propertyArray, boolean bl) {
        TableColumnModel tableColumnModel;
        if (bl && (tableColumnModel = this.outline.getColumnModel()) instanceof ETableColumnModel) {
            ((ETableColumnModel)tableColumnModel).clean();
        }
        this.rowModel.setProperties(propertyArray);
        this.outline.tableChanged(null);
    }

    public final void addPropertyColumn(String string, String string2) {
        this.addPropertyColumn(string, string2, null);
    }

    public final void addPropertyColumn(String string, String string2, String string3) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"displayName", (Object)string2);
        Node.Property[] propertyArray = this.rowModel.getProperties();
        Node.Property[] propertyArray2 = new Node.Property[propertyArray.length + 1];
        System.arraycopy(propertyArray, 0, propertyArray2, 0, propertyArray.length);
        propertyArray2[propertyArray.length] = new PrototypeProperty(string, string2, string3);
        this.setProperties(propertyArray2, false);
    }

    public final boolean removePropertyColumn(String string) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Node.Property[] propertyArray = this.rowModel.getProperties();
        LinkedList<Node.Property> linkedList = new LinkedList<Node.Property>(Arrays.asList(propertyArray));
        boolean bl = false;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Node.Property property = (Node.Property)iterator.next();
            if (!string.equals(property.getName())) continue;
            bl = true;
            iterator.remove();
            break;
        }
        if (bl) {
            propertyArray = linkedList.toArray(new Node.Property[propertyArray.length - 1]);
            this.setProperties(propertyArray, false);
        }
        return bl;
    }

    public final void setPropertyColumnDescription(String string, String string2) {
        Node.Property[] propertyArray;
        Parameters.notNull((CharSequence)"columnName", (Object)string);
        for (Node.Property property : propertyArray = this.rowModel.getProperties()) {
            if (!string.equals(property.getName())) continue;
            property.setShortDescription(string2);
        }
        if (string.equals(this.model.getColumnName(0))) {
            this.outline.setNodesColumnDescription(string2);
        }
    }

    public final void setPropertyColumns(String ... stringArray) {
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of names and display names: " + Arrays.asList(stringArray));
        }
        Node.Property[] propertyArray = new Node.Property[stringArray.length / 2];
        for (int i = 0; i < stringArray.length; i += 2) {
            propertyArray[i / 2] = new PrototypeProperty(stringArray[i], stringArray[i + 1]);
        }
        this.setProperties(propertyArray, true);
    }

    public final void setPropertyColumnAttribute(String string, String string2, Object object) throws IllegalArgumentException {
        Node.Property[] propertyArray = this.rowModel.getProperties();
        boolean bl = false;
        for (Node.Property property : propertyArray) {
            if (!string.equals(property.getName())) continue;
            property.setValue(string2, object);
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("Unknown column " + string);
        }
    }

    public void setPopupAllowed(boolean bl) {
        if (this.popupListener == null && bl) {
            this.popupListener = new PopupAdapter();
            this.outline.addMouseListener((MouseListener)((Object)this.popupListener));
            this.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !bl) {
            this.outline.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    public void setDefaultActionAllowed(boolean bl) {
        this.outline.setDefaultActionAllowed(bl);
    }

    public boolean isDefaultActionAllowed() {
        return this.outline.isDefaultActionAllowed();
    }

    public void setTreeSortable(boolean bl) {
        this.outline.setTreeSortable(bl);
    }

    public boolean isQuickSearchAllowed() {
        return this.quickSearch.isEnabled();
    }

    public void setQuickSearchAllowed(boolean bl) {
        if (bl == this.isQuickSearchAllowed()) {
            return;
        }
        this.quickSearch.setEnabled(bl);
        if (bl) {
            this.outline.addKeyListener(this.qsKeyListener);
        } else {
            this.outline.removeKeyListener(this.qsKeyListener);
        }
    }

    public void setQuickSearchTableFilter(QuickSearchTableFilter quickSearchTableFilter, boolean bl) {
        TableQuickSearchSupport tableQuickSearchSupport = this.outline.createTableQuickSearchSupport(quickSearchTableFilter);
        this.attachQuickSearch(tableQuickSearchSupport, bl, tableQuickSearchSupport.createSearchPopupMenu());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
        ViewUtil.adjustBackground((JComponent)((Object)this.outline));
        ViewUtil.adjustBackground(this.getViewport());
        if (this.selection != null) {
            this.selection.setTo(this.outline.getSelectionModel());
        }
    }

    public void readSettings(Properties properties, String string) {
        this.outline.readSettings(properties, string);
    }

    public void writeSettings(Properties properties, String string) {
        this.outline.writeSettings(properties, string);
    }

    public void setNodePopupFactory(NodePopupFactory nodePopupFactory) {
        this.popupFactory = nodePopupFactory;
    }

    public NodePopupFactory getNodePopupFactory() {
        return this.popupFactory;
    }

    private void lookupExplorerManager() {
        ExplorerManager explorerManager;
        if (this.managerListener == null) {
            this.managerListener = new TableSelectionListener();
        }
        if ((explorerManager = ExplorerManager.find(this)) != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListeners.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
        }
        this.outline.setExplorerManager(explorerManager);
        this.synchronizeRootContext();
        this.synchronizeSelectedNodes(true, new Node[0]);
        this.outline.getSelectionModel().removeListSelectionListener(this.managerListener);
        this.outline.getSelectionModel().addListSelectionListener(this.managerListener);
    }

    final void synchronizeRootContext() {
        if (null != this.treeModel) {
            this.treeModel.setNode(this.manager.getRootContext());
        }
    }

    final void synchronizeSelectedNodes(boolean bl, Node ... nodeArray) {
        JViewport jViewport;
        int n;
        int n2;
        Object object;
        if (!this.needToSynchronize()) {
            return;
        }
        this.expandSelection();
        this.outline.invalidate();
        this.invalidate();
        this.validate();
        Node[] nodeArray2 = this.manager.getSelectedNodes();
        this.outline.getSelectionModel().setValueIsAdjusting(true);
        this.outline.getSelectionModel().clearSelection();
        int n3 = this.outline.getRowCount();
        int n4 = -1;
        for (int i = 0; i < n3; ++i) {
            object = this.getNodeFromRow(i);
            for (n2 = 0; n2 < nodeArray2.length; ++n2) {
                if (object == null || !object.equals((Object)nodeArray2[n2])) continue;
                this.outline.getSelectionModel().addSelectionInterval(i, i);
                if (n4 != -1) continue;
                n4 = i;
                n = this.outline.convertColumnIndexToView(0);
                this.outline.getColumnModel().getSelectionModel().setSelectionInterval(n, n);
            }
        }
        this.outline.getSelectionModel().setValueIsAdjusting(false);
        if (bl && n4 >= 0 && (jViewport = this.getViewport()) != null) {
            object = this.outline.getCellRect(n4, 0, true);
            n2 = object.height;
            n = object.y;
            int n5 = jViewport.getExtentSize().height;
            int n6 = this.outline.getSize().height;
            if (n5 < 3 * n2) {
                if (n5 > n2) {
                    int n7 = (n5 - n2) / 2;
                    if ((n -= n7) < 0) {
                        n = 0;
                    }
                    if (n + n5 > n6) {
                        n5 = n6 - n;
                    }
                } else {
                    int n8 = (n2 - n5) / 2;
                    n += n8;
                }
                object.height = n5;
            } else {
                if (n > 0) {
                    if ((n -= n2) < 0) {
                        object.height += -n;
                        n = 0;
                    } else {
                        object.height += n2;
                    }
                }
                if (n6 > 0 && n + object.height < n6) {
                    object.height += n2;
                    if (n + object.height > n6) {
                        object.height = n6 - n;
                    }
                }
            }
            object.y = n;
            this.outline.scrollRectToVisible((Rectangle)object);
        }
    }

    private boolean needToSynchronize() {
        boolean bl = false;
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (this.outline.getSelectedRows().length != nodeArray.length) {
            bl = true;
        } else if (nodeArray.length > 0) {
            List<Node> list = Arrays.asList(nodeArray);
            for (int n : this.outline.getSelectedRows()) {
                Node node = this.getNodeFromRow(n);
                if (node != null && list.contains(node)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void expandSelection() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            TreeNode treeNode;
            if (nodeArray[i].getParentNode() == null && !this.outline.isRootVisible() || (treeNode = Visualizer.findVisualizer(nodeArray[i])) == null) continue;
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            while (treeNode != null) {
                arrayList.add(treeNode);
                treeNode = treeNode.getParent();
            }
            Collections.reverse(arrayList);
            TreePath treePath = new TreePath(arrayList.toArray());
            ArrayDeque<TreePath> arrayDeque = new ArrayDeque<TreePath>(arrayList.size());
            while (treePath != null && treePath.getPathCount() > 0) {
                if ((treePath = treePath.getParentPath()) == null) continue;
                arrayDeque.addFirst(treePath);
            }
            for (TreePath treePath2 : arrayDeque) {
                this.outline.expandPath(treePath2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        this.selection = new Selection(this.outline.getSelectionModel());
        this.outline.getSelectionModel().clearSelection();
        this.outline.getSelectionModel().removeListSelectionListener(this.managerListener);
        Object object = this.managerLock;
        synchronized (object) {
            if (this.manager != null) {
                this.manager.removePropertyChangeListener(this.wlpc);
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager = null;
            }
        }
    }

    void showPopup(int n, int n2, final JPopupMenu jPopupMenu) {
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0) {
            PopupMenuListener popupMenuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    jPopupMenu.removePopupMenuListener(this);
                    OutlineView.this.outline.requestFocus();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            };
            jPopupMenu.addPopupMenuListener(popupMenuListener);
            jPopupMenu.show(this, n, n2);
        }
    }

    private JPopupMenu createPopup(Point point) {
        Object object;
        int[] nArray = this.outline.getSelectedRows();
        ArrayList<Node> arrayList = new ArrayList<Node>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            object = this.getNodeFromRow(nArray[i]);
            if (object == null) continue;
            arrayList.add((Node)object);
        }
        Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        if (nodeArray.length == 0 && this.manager.getRootContext() != null && (object = this.manager.getRootContext().getContextMenu()) != null && ((JPopupMenu)object).getSubElements().length > 0) {
            this.popupFactory.addNoFilterItem((ETable)this.outline, (JPopupMenu)object);
            return object;
        }
        point = SwingUtilities.convertPoint(this, point, (Component)((Object)this.outline));
        int n = this.outline.columnAtPoint(point);
        int n2 = this.outline.rowAtPoint(point);
        return this.popupFactory.createPopupMenu(n2, n, nodeArray, (Component)((Object)this.outline));
    }

    Node getNodeFromRow(int n) {
        int n2 = this.outline.convertRowIndexToModel(n);
        TreePath treePath = this.outline.getLayoutCache().getPathForRow(n2);
        if (treePath == null) {
            return null;
        }
        return Visualizer.findNode(treePath.getLastPathComponent());
    }

    private Point getPositionForPopup() {
        Rectangle rectangle;
        int n = this.outline.getSelectionModel().getLeadSelectionIndex();
        if (n < 0) {
            return null;
        }
        int n2 = this.outline.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((rectangle = this.outline.getCellRect(n, n2, true)) == null) {
            return null;
        }
        Point point = new Point(rectangle.x + rectangle.width / 3, rectangle.y + rectangle.height / 2);
        point = SwingUtilities.convertPoint((Component)((Object)this.outline), point, this);
        return point;
    }

    private void callSelectionChanged(Node[] nodeArray) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            this.manager.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.synchronizeSelectedNodes(false, new Node[0]);
        }
        finally {
            this.manager.removePropertyChangeListener(this.wlpc);
            this.manager.removeVetoableChangeListener(this.wlvc);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
    }

    private boolean isSelectionModeBroken(Node[] nodeArray) {
        if (nodeArray.length <= 1 || this.outline.getSelectionModel().getSelectionMode() == 2) {
            return false;
        }
        return this.outline.getSelectionModel().getSelectionMode() == 0;
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean bl) {
        if (bl && this.dragSupport == null) {
            this.dragSupport = new OutlineViewDragSupport(this, (JComponent)this.getOutline());
        }
        this.dragActive = bl;
        if (this.dragSupport != null) {
            this.dragSupport.activate(this.dragActive);
        }
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean bl) {
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new OutlineViewDropSupport(this, (JTable)((Object)this.outline), this.dropTargetPopupAllowed);
        }
        this.dropActive = bl;
        if (this.dropSupport != null) {
            this.dropSupport.activate(this.dropActive);
        }
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int n) {
        this.allowedDragActions = n;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    protected int getAllowedDropActions(Transferable transferable) {
        return this.getAllowedDropActions();
    }

    public void setAllowedDropActions(int n) {
        this.allowedDropActions = n;
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        TreePathSupport treePathSupport = this.getOutline().getOutlineModel().getTreePathSupport();
        if (treePathSupport != null) {
            treePathSupport.addTreeExpansionListener(treeExpansionListener);
        }
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        TreePathSupport treePathSupport = this.getOutline().getOutlineModel().getTreePathSupport();
        if (treePathSupport != null) {
            treePathSupport.removeTreeExpansionListener(treeExpansionListener);
        }
    }

    public void collapseNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        this.getOutline().collapsePath(treePath);
    }

    public void expandNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.lookupExplorerManager();
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        this.getOutline().expandPath(treePath);
    }

    public boolean isExpanded(Node node) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        return this.getOutline().isExpanded(treePath);
    }

    @Override
    public Insets getInsets() {
        Insets insets = this.getInnerInsets();
        insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        if (null != this.searchPanel && this.searchPanel.isVisible()) {
            insets.bottom += this.searchPanel.getPreferredSize().height;
        }
        return insets;
    }

    private Insets getInnerInsets() {
        Insets insets = super.getInsets();
        if (null == insets) {
            insets = new Insets(0, 0, 0, 0);
        }
        return insets;
    }

    public final void setShowNodeIcons(boolean bl) {
        this.nodeRenderer.setShowIcons(bl);
    }

    public final boolean isShowNodeIcons() {
        return this.nodeRenderer.isShowIcons();
    }

    private boolean horizontalWheelScroll(MouseWheelEvent mouseWheelEvent) {
        JScrollBar jScrollBar = this.hScrollBar;
        if (null == jScrollBar || !jScrollBar.isVisible()) {
            return false;
        }
        if (mouseWheelEvent.getWheelRotation() == 0) {
            return false;
        }
        int n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
        JViewport jViewport = this.getViewport();
        if (jViewport == null) {
            return false;
        }
        int n2 = Math.abs(mouseWheelEvent.getUnitsToScroll());
        boolean bl = Math.abs(mouseWheelEvent.getWheelRotation()) == 1;
        int n3 = -1;
        JScrollBar jScrollBar2 = jScrollBar;
        if (bl) {
            n3 = n < 0 ? jScrollBar2.getValue() - jScrollBar2.getBlockIncrement(n) : jScrollBar2.getValue() + jScrollBar2.getBlockIncrement(n);
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = n > 0 ? jScrollBar2.getUnitIncrement(n) : -jScrollBar2.getUnitIncrement(n);
            int n5 = jScrollBar2.getValue();
            int n6 = n5 + n4;
            if (n4 > 0 && n6 < n5) {
                n6 = jScrollBar2.getMaximum();
            } else if (n4 < 0 && n6 > n5) {
                n6 = jScrollBar2.getMinimum();
            }
            if (n5 == n6) break;
            if (bl && i > 0) {
                assert (n3 != -1);
                if (n < 0 && n6 < n3 || n > 0 && n6 > n3) break;
            }
            jScrollBar2.setValue(n6);
        }
        return true;
    }

    private static class Selection {
        int selectionMode;
        int anchor;
        int lead;
        List<int[]> intervals = new ArrayList<int[]>();

        public Selection(ListSelectionModel listSelectionModel) {
            this.selectionMode = listSelectionModel.getSelectionMode();
            this.anchor = listSelectionModel.getAnchorSelectionIndex();
            this.lead = listSelectionModel.getLeadSelectionIndex();
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            int n3 = -1;
            for (int i = n; i <= n2; ++i) {
                if (listSelectionModel.isSelectedIndex(i)) {
                    if (n3 != -1) continue;
                    n3 = i;
                    continue;
                }
                if (n3 == -1) continue;
                this.intervals.add(new int[]{n3, i});
                n3 = -1;
            }
            if (n3 != -1) {
                this.intervals.add(new int[]{n3, n2});
            }
        }

        public void setTo(ListSelectionModel listSelectionModel) {
            listSelectionModel.clearSelection();
            listSelectionModel.setSelectionMode(this.selectionMode);
            for (int[] nArray : this.intervals) {
                listSelectionModel.addSelectionInterval(nArray[0], nArray[1]);
            }
            listSelectionModel.setAnchorSelectionIndex(this.anchor);
            listSelectionModel.setLeadSelectionIndex(this.lead);
        }
    }

    private static class OutlineScrollLayout
    extends ScrollPaneLayout.UIResource {
        private JScrollBar thsb;

        @Override
        public void addLayoutComponent(String string, Component component) {
            if (string.equals(OutlineView.TREE_HORIZONTAL_SCROLLBAR)) {
                this.thsb = (JScrollBar)this.addSingletonComponent(this.thsb, component);
            } else {
                super.addLayoutComponent(string, component);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = super.preferredLayoutSize(container);
            OutlineView outlineView = (OutlineView)container;
            int n = outlineView.treeHorizontalScrollBarPolicy;
            if (this.thsb != null && n != 31) {
                if (n == 32) {
                    dimension.height += this.thsb.getPreferredSize().height;
                } else {
                    Dimension dimension2 = null;
                    Dimension dimension3 = null;
                    Component component = null;
                    if (this.viewport != null) {
                        dimension2 = this.viewport.getPreferredSize();
                        dimension3 = this.viewport.getViewSize();
                        component = this.viewport.getView();
                    }
                    if (dimension3 != null && dimension2 != null) {
                        boolean bl = true;
                        if (component instanceof Scrollable) {
                            boolean bl2 = bl = !((Scrollable)((Object)component)).getScrollableTracksViewportWidth();
                        }
                        if (bl && dimension3.width > dimension2.width) {
                            dimension.height += this.thsb.getPreferredSize().height;
                        }
                    }
                }
            }
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return super.minimumLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            OutlineView outlineView = (OutlineView)container;
            if (outlineView.isTreeHScrollBar && outlineView.outline.getColumnModel().getColumnCount() > 0) {
                boolean bl;
                Serializable serializable;
                int n = outlineView.outline.convertColumnIndexToView(0);
                int n2 = outlineView.outline.getColumnModel().getColumn(n).getWidth();
                int n3 = outlineView.outline.getTreePreferredWidth();
                boolean bl2 = this.thsb.isVisible();
                boolean bl3 = n3 <= n2 && outlineView.treeHorizontalScrollBarPolicy != 32;
                JScrollBar jScrollBar = this.hsb;
                if (!bl3) {
                    Cloneable cloneable;
                    Border border;
                    Object object;
                    serializable = this.viewport != null ? this.viewport.getView() : null;
                    boolean bl4 = false;
                    if (serializable instanceof Scrollable) {
                        object = (Scrollable)((Object)serializable);
                        bl4 = object.getScrollableTracksViewportWidth();
                    }
                    object = serializable != null ? ((Component)serializable).getPreferredSize() : new Dimension(0, 0);
                    Rectangle rectangle = outlineView.getBounds();
                    Insets insets = container.getInsets();
                    rectangle.width -= insets.left + insets.right;
                    if (this.rowHead != null && this.rowHead.isVisible()) {
                        int n4 = Math.min(rectangle.width, this.rowHead.getPreferredSize().width);
                        rectangle.width -= n4;
                    }
                    if ((border = outlineView.getViewportBorder()) != null) {
                        cloneable = border.getBorderInsets(container);
                        rectangle.width -= cloneable.left + cloneable.right;
                    }
                    if (rectangle.width < 0) {
                        bl = false;
                    }
                    if (outlineView.getHorizontalScrollBarPolicy() == 32) {
                        bl = true;
                    } else if (outlineView.getHorizontalScrollBarPolicy() == 31) {
                        bl = false;
                    } else {
                        cloneable = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
                        boolean bl5 = bl = !bl4 && ((Dimension)object).width > ((Dimension)cloneable).width;
                    }
                    if (bl) {
                        this.hsb = this.createFakeHSB(jScrollBar);
                    } else {
                        outlineView.sayHorizontalScrollBarNeeded(true);
                    }
                } else {
                    bl = false;
                }
                super.layoutContainer(container);
                if (!bl3) {
                    if (bl) {
                        serializable = this.hsb;
                        ((JComponent)serializable).setVisible(false);
                        this.hsb = jScrollBar;
                        Rectangle rectangle = ((Component)serializable).getBounds();
                        rectangle.height /= 2;
                        rectangle.y += rectangle.height;
                        this.hsb.setBounds(rectangle);
                        this.hsb.setVisible(true);
                    } else {
                        outlineView.sayHorizontalScrollBarNeeded(false);
                        this.hsbPolicy = outlineView.getHorizontalScrollBarPolicy();
                        this.hsb.setVisible(false);
                    }
                }
                if (bl3) {
                    this.thsb.setVisible(false);
                    outlineView.hScrollBar.setValues(0, 0, 0, 0);
                } else {
                    serializable = this.viewport.getBounds();
                    Rectangle rectangle = new Rectangle(this.getColumnXPos(outlineView.outline, n), ((Rectangle)serializable).y + ((Rectangle)serializable).height, n2, this.thsb.getPreferredSize().height);
                    this.thsb.setBounds(rectangle);
                    if (!bl2) {
                        this.thsb.setVisible(true);
                        outlineView.listener.revalidateScrollBar();
                    }
                }
            } else {
                super.layoutContainer(container);
            }
            Component component = outlineView.searchPanel;
            if (null != component && component.isVisible()) {
                Insets insets = outlineView.getInnerInsets();
                Dimension dimension = component.getPreferredSize();
                component.setBounds(insets.left, container.getHeight() - insets.bottom - dimension.height, container.getWidth() - insets.left - insets.right, dimension.height);
            }
        }

        private JScrollBar createFakeHSB(final JScrollBar jScrollBar) {
            return new JScrollBar(0){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = jScrollBar.getPreferredSize();
                    return new Dimension(dimension.width, 2 * dimension.height);
                }
            };
        }

        private int getColumnXPos(OutlineViewOutline outlineViewOutline, int n) {
            if (n < 0) {
                if (!outlineViewOutline.getComponentOrientation().isLeftToRight()) {
                    return outlineViewOutline.getWidth();
                }
                return 0;
            }
            if (n >= outlineViewOutline.getColumnCount()) {
                if (outlineViewOutline.getComponentOrientation().isLeftToRight()) {
                    return outlineViewOutline.getWidth();
                }
                return 0;
            }
            TableColumnModel tableColumnModel = outlineViewOutline.getColumnModel();
            int n2 = 0;
            if (outlineViewOutline.getComponentOrientation().isLeftToRight()) {
                for (int i = 0; i < n; ++i) {
                    n2 += tableColumnModel.getColumn(i).getWidth();
                }
            } else {
                for (int i = tableColumnModel.getColumnCount() - 1; i > n; --i) {
                    n2 += tableColumnModel.getColumn(i).getWidth();
                }
            }
            return n2;
        }
    }

    private final class ScrollListener
    extends ComponentAdapter
    implements ChangeListener,
    TableColumnModelListener,
    AdjustmentListener {
        ScrollListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == OutlineView.this.hScrollBar.getModel()) {
                int n = OutlineView.this.hScrollBar.getModel().getValue();
                OutlineView.this.outline.setTreePositionX(n);
            }
        }

        private void revalidateScrollBar() {
            if (!OutlineView.this.isDisplayable()) {
                return;
            }
            if (!OutlineView.this.isTreeHScrollBar) {
                return;
            }
            if (OutlineView.this.outline.getColumnModel().getColumnCount() > 0) {
                int n = OutlineView.this.outline.convertColumnIndexToView(0);
                int n2 = OutlineView.this.outline.getColumnModel().getColumn(n).getWidth();
                int n3 = OutlineView.this.outline.getTreePreferredWidth();
                int n4 = OutlineView.this.outline.getTreePositionX();
                int n5 = Math.max(0, Math.min(n4, n3 - n2));
                OutlineView.this.hScrollBar.setValues(n5, n2, 0, n3);
                OutlineView.this.hScrollBar.setBlockIncrement(n2);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            OutlineView.this.revalidate();
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.revalidateScrollBar();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = OutlineView.this.hScrollBar.getModel().getValue();
            OutlineView.this.outline.setTreePositionX(n);
        }
    }

    static final class PrototypeProperty
    extends PropertySupport.ReadWrite<Object> {
        PrototypeProperty(String string, String string2) {
            this(string, string2, null);
        }

        PrototypeProperty(String string, String string2, String string3) {
            super(string, Object.class, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            throw new AssertionError();
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new AssertionError();
        }

        public boolean equals(Object object) {
            return object instanceof Node.Property && this.getName().equals(((Node.Property)object).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }

    private static class NodeOutlineModel
    extends DefaultOutlineModel {
        public NodeOutlineModel(NodeTreeModel nodeTreeModel, RowModel rowModel, boolean bl, String string) {
            super((TreeModel)nodeTreeModel, rowModel, bl, string);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                Node node = this.getNodeAt(n);
                return null != node && node.canRename();
            }
            return super.isCellEditable(n, n2);
        }

        protected void setTreeValueAt(Object object, int n) {
            Node node = this.getNodeAt(n);
            if (null != node) {
                ViewUtil.nodeRename(node, object == null ? "" : object.toString());
            }
        }

        protected final Node getNodeAt(int n) {
            Node node = null;
            TreePath treePath = this.getLayout().getPathForRow(n);
            if (treePath != null) {
                node = Visualizer.findNode(treePath.getLastPathComponent());
            }
            return node;
        }
    }

    private static class OutlinePopupFactory
    extends NodePopupFactory {
        @Override
        public JPopupMenu createPopupMenu(int n, int n2, Node[] nodeArray, Component component) {
            if (component instanceof ETable) {
                ETable eTable = (ETable)component;
                int n3 = eTable.convertColumnIndexToModel(n2);
                this.setShowQuickFilter(n3 != 0);
            }
            return super.createPopupMenu(n, n2, nodeArray, component);
        }
    }

    static class OutlineViewOutline
    extends Outline {
        private final PropertiesRowModel rowModel;
        private static final String COLUMNS_SELECTOR_HINT = "ColumnsSelectorHint";
        private static final String COPY_ACTION_DELEGATE = "Outline Copy Action Delegate ";
        private boolean treeSortable = true;
        private boolean isHScrollingEnabled;
        private JScrollBar hScrollBar;
        private TMScrollingListener tmScrollingListener;
        private int treePositionX = 0;
        private int[] rowWidths;
        private RequestProcessor.Task changeTask;
        private boolean defaultActionAllowed = true;
        private String nodesColumnDescription;
        private ExplorerManager manager;
        private TableQuickSearchSupport.QuickSearchSettings qss = new TableQuickSearchSupport.QuickSearchSettings();

        public OutlineViewOutline(OutlineModel outlineModel, PropertiesRowModel propertiesRowModel) {
            super(outlineModel);
            this.rowModel = propertiesRowModel;
            this.setSelectVisibleColumnsLabel(NbBundle.getMessage(OutlineView.class, (String)"CTL_ColumnsSelector"));
            this.removeDefaultCutCopyPaste(this.getInputMap(0));
            this.removeDefaultCutCopyPaste(this.getInputMap(1));
            KeyStroke keyStroke = Utilities.isMac() ? KeyStroke.getKeyStroke(32, 4, false) : KeyStroke.getKeyStroke(32, 128, false);
            Object object = this.getInputMap(1).get(keyStroke);
            if (object != null) {
                this.getInputMap(1).put(keyStroke, "invokeCustomEditor");
                InvokeCustomEditorAction invokeCustomEditorAction = new InvokeCustomEditorAction(object);
                this.getActionMap().put("invokeCustomEditor", invokeCustomEditorAction);
            }
        }

        private void removeDefaultCutCopyPaste(InputMap inputMap) {
            this.putActionDelegate(inputMap, KeyStroke.getKeyStroke("control C"));
            inputMap.put(KeyStroke.getKeyStroke("control V"), "none");
            inputMap.put(KeyStroke.getKeyStroke("control X"), "none");
            this.putActionDelegate(inputMap, KeyStroke.getKeyStroke("COPY"));
            inputMap.put(KeyStroke.getKeyStroke("PASTE"), "none");
            inputMap.put(KeyStroke.getKeyStroke("CUT"), "none");
            if (Utilities.isMac()) {
                this.putActionDelegate(inputMap, KeyStroke.getKeyStroke(67, 4));
                inputMap.put(KeyStroke.getKeyStroke(88, 4), "none");
                inputMap.put(KeyStroke.getKeyStroke(86, 4), "none");
            } else {
                this.putActionDelegate(inputMap, KeyStroke.getKeyStroke(67, 128));
                inputMap.put(KeyStroke.getKeyStroke(88, 128), "none");
                inputMap.put(KeyStroke.getKeyStroke(86, 128), "none");
            }
        }

        private void putActionDelegate(InputMap inputMap, KeyStroke keyStroke) {
            String string = COPY_ACTION_DELEGATE + keyStroke.toString();
            Action action = this.getCopyActionDelegate(inputMap, keyStroke);
            if (action != null) {
                this.getActionMap().put(string, action);
                inputMap.put(keyStroke, string);
            }
        }

        private Action getCopyActionDelegate(InputMap inputMap, KeyStroke keyStroke) {
            ActionMap actionMap = this.getActionMap();
            if (inputMap != null && actionMap != null && this.isEnabled()) {
                Action action;
                Object object = inputMap.get(keyStroke);
                Action action2 = action = object == null ? null : actionMap.get(object);
                if (action != null) {
                    return new CopyToClipboardAction(action);
                }
            }
            return null;
        }

        public void setColumnModel(TableColumnModel tableColumnModel) {
            int n;
            super.setColumnModel(tableColumnModel);
            if (this.rowModel == null) {
                return;
            }
            List<TableColumn> list = null;
            if (tableColumnModel instanceof ETableColumnModel) {
                list = OutlineViewOutline.getAllColumns((ETableColumnModel)tableColumnModel);
            }
            if (list == null) {
                list = Collections.list(tableColumnModel.getColumns());
            }
            if ((n = list.size()) > 0) {
                String string = this.getNodesColumnName();
                Node.Property[] propertyArray = this.rowModel.getProperties();
                Node.Property[] propertyArray2 = new Node.Property[n - 1];
                int n2 = 0;
                int n3 = 0;
                for (TableColumn tableColumn : list) {
                    String string2 = tableColumn.getHeaderValue().toString();
                    Node.Property property = this.findProperty(propertyArray, string2);
                    n2 += property == null ? 0 : 1;
                    if (string == null && n3 == 0 || string != null && string.equals(string2)) continue;
                    propertyArray2[n3++] = property == null ? new PrototypeProperty(string2, string2) : property;
                }
                if (n2 != n - 1) {
                    this.rowModel.setProperties(propertyArray2);
                }
            } else {
                this.rowModel.setProperties(new Node.Property[0]);
            }
        }

        private Node.Property findProperty(Node.Property[] propertyArray, String string) {
            if (propertyArray != null) {
                for (Node.Property property : propertyArray) {
                    if (property == null || property.getDisplayName() == null || !property.getDisplayName().equals(string)) continue;
                    return property;
                }
            }
            return null;
        }

        private String getNodesColumnName() {
            OutlineModel outlineModel = this.getOutlineModel();
            if (outlineModel != null && outlineModel.getColumnCount() > 0) {
                return outlineModel.getColumnName(0);
            }
            return null;
        }

        private static List<TableColumn> getAllColumns(ETableColumnModel eTableColumnModel) {
            try {
                Method method = ETableColumnModel.class.getDeclaredMethod("getAllColumns", new Class[0]);
                method.setAccessible(true);
                return (List)method.invoke((Object)eTableColumnModel, new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }

        public void readSettings(Properties properties, String string) {
            super.readSettings(properties, string);
            int n = this.getColumnModel().getColumnCount();
            for (int i = 0; i < n; ++i) {
                OutlineViewOutlineColumn outlineViewOutlineColumn = (OutlineViewOutlineColumn)((Object)this.getColumnModel().getColumn(i));
                outlineViewOutlineColumn.postReadSettings(properties, i, string);
            }
        }

        private TableQuickSearchSupport createDefaultTableQuickSearchSupport() {
            return new TableQuickSearchSupport((JTable)((Object)this), new DefaultQuickSearchTableFilter(), this.qss);
        }

        private TableQuickSearchSupport createTableQuickSearchSupport(QuickSearchTableFilter quickSearchTableFilter) {
            return new TableQuickSearchSupport((JTable)((Object)this), quickSearchTableFilter, this.qss);
        }

        private void setExplorerManager(ExplorerManager explorerManager) {
            this.manager = explorerManager;
        }

        PropertiesRowModel getRowModel() {
            return this.rowModel;
        }

        public Object transformValue(Object object) {
            if (object instanceof OutlineViewOutlineColumn) {
                String string;
                OutlineViewOutlineColumn outlineViewOutlineColumn = (OutlineViewOutlineColumn)((Object)object);
                String string2 = outlineViewOutlineColumn.getRawColumnName();
                if (string2 == null) {
                    string2 = outlineViewOutlineColumn.getHeaderValue().toString();
                }
                if ((string = outlineViewOutlineColumn.getShortDescription(null)) == null) {
                    return string2;
                }
                return NbBundle.getMessage(OutlineView.class, (String)"OutlineViewOutline_NameAndDesc", (Object)string2, (Object)string);
            }
            if (COLUMNS_SELECTOR_HINT.equals(object)) {
                return NbBundle.getMessage(OutlineView.class, (String)COLUMNS_SELECTOR_HINT);
            }
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)abstractButton.getText());
                return abstractButton;
            }
            if (object instanceof VisualizerNode) {
                return Visualizer.findNode(object);
            }
            return PropertiesRowModel.getValueFromProperty(object);
        }

        public String convertValueToString(Object object) {
            if (object instanceof VisualizerNode) {
                return ((VisualizerNode)object).getDisplayName();
            }
            if (object instanceof Node) {
                return ((Node)object).getDisplayName();
            }
            return super.convertValueToString(object);
        }

        void setTreeHScrollingEnabled(boolean bl, JScrollBar jScrollBar) {
            this.isHScrollingEnabled = bl;
            this.hScrollBar = jScrollBar;
            if (bl) {
                if (this.tmScrollingListener == null) {
                    this.tmScrollingListener = new TMScrollingListener();
                    this.rowWidths = new int[this.getOutlineModel().getRowCount()];
                    this.getOutlineModel().addTableModelListener((TableModelListener)this.tmScrollingListener);
                    this.getOutlineModel().addTreeModelListener((TreeModelListener)this.tmScrollingListener);
                }
            } else if (this.tmScrollingListener != null) {
                this.getOutlineModel().removeTableModelListener((TableModelListener)this.tmScrollingListener);
                this.getOutlineModel().removeTreeModelListener((TreeModelListener)this.tmScrollingListener);
                this.tmScrollingListener = null;
                this.rowWidths = null;
            }
        }

        void setTreeWidthChangeTask(RequestProcessor.Task task) {
            this.changeTask = task;
        }

        int getTreePositionX() {
            return this.treePositionX;
        }

        void setTreePositionX(int n) {
            if (n == this.treePositionX) {
                return;
            }
            this.treePositionX = n;
            this.tableChanged(new TableModelEvent(this.getModel(), 0, this.getRowCount(), 0));
        }

        private void setPreferredTreeWidth(int n, int n2) {
            if (this.isHScrollingEnabled) {
                if (n >= this.rowWidths.length) {
                    this.rowWidths = Arrays.copyOf(this.rowWidths, n + 1);
                }
                if (this.rowWidths[n] != n2) {
                    this.rowWidths[n] = n2;
                    this.changeTask.schedule(100);
                }
            }
        }

        int getTreePreferredWidth() {
            int n;
            Rectangle rectangle = this.getVisibleRect();
            int n2 = this.rowAtPoint(new Point(0, rectangle.y));
            if (n2 < 0) {
                return 0;
            }
            if (this.hScrollBar.isVisible()) {
                rectangle.height += this.hScrollBar.getSize().height;
            }
            if ((n = this.rowAtPoint(new Point(0, rectangle.y + rectangle.height))) < 0) {
                n = this.getRowCount() - 1;
            }
            if (n >= this.rowWidths.length) {
                n = this.rowWidths.length - 1;
            }
            int n3 = 0;
            for (int i = n2; i <= n; ++i) {
                if (this.rowWidths[i] <= n3) continue;
                n3 = this.rowWidths[i];
            }
            return n3 += 2 * this.getIntercellSpacing().width;
        }

        void setDefaultActionAllowed(boolean bl) {
            this.defaultActionAllowed = bl;
        }

        boolean isDefaultActionAllowed() {
            return this.defaultActionAllowed;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            int n3;
            TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
            if (this.isHScrollingEnabled && (n3 = this.convertColumnIndexToModel(n2)) == 0) {
                tableCellRenderer = new TranslatedTableCellRenderer(this, tableCellRenderer);
            }
            return tableCellRenderer;
        }

        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            MouseEvent mouseEvent;
            boolean bl;
            Node.Property property;
            Object object = this.getValueAt(n, n2);
            if (object instanceof Node.Property && ((property = (Node.Property)object).getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE)) {
                PropertiesRowModel.toggleBooleanProperty((Node.Property<Boolean>)property);
                Rectangle rectangle = this.getCellRect(n, n2, true);
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return false;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = bl = this.convertColumnIndexToModel(n2) == 0;
            if (bl && n != -1 && eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
                Action action;
                if (this.checkAt(n, n2, (MouseEvent)eventObject)) {
                    return false;
                }
                int n3 = ((MouseEvent)eventObject).getClickCount();
                if (n3 > 1 && (mouseEvent = Visualizer.findNode(object)) != null && this.defaultActionAllowed && (action = TreeView.takeAction(mouseEvent.getPreferredAction(), new Node[]{mouseEvent})) != null) {
                    if (action.isEnabled()) {
                        action.actionPerformed(new ActionEvent(mouseEvent, 1001, "", ((MouseEvent)eventObject).getModifiers()));
                        return false;
                    }
                    Logger.getLogger(OutlineView.class.getName()).info("Action " + action + " on node " + mouseEvent + " is disabled");
                }
            }
            if (eventObject instanceof MouseEvent) {
                Action action;
                PropertyPanel propertyPanel;
                PropertyEditor propertyEditor;
                Node.Property property2;
                final Rectangle rectangle = this.getCellRect(n, n2, true);
                mouseEvent = (MouseEvent)eventObject;
                mouseEvent.translatePoint(this.treePositionX, 0);
                int n4 = mouseEvent.getX();
                if (n4 > rectangle.x + rectangle.width - 24 && n4 < rectangle.x + rectangle.width && object instanceof Node.Property && !bl && !Boolean.TRUE.equals((property2 = (Node.Property)object).getValue("suppressCustomEditor")) && (propertyEditor = (propertyPanel = new PropertyPanel(property2)).getPropertyEditor()) != null && propertyEditor.supportsCustomEditor() && (action = propertyPanel.getActionMap().get("invokeCustomEditor")) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            rectangle.x = 0;
                            rectangle.width = this.getWidth();
                            this.repaint(rectangle);
                        }
                    });
                    action.actionPerformed(null);
                    return false;
                }
            }
            return super.editCellAt(n, n2, eventObject);
        }

        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            Component component = this.getEditorComponent();
            if (component != null && component.isFocusable()) {
                component.requestFocusInWindow();
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(keyEvent);
            } else {
                super.processComponentKeyEvent(keyEvent);
            }
        }

        protected TableColumn createColumn(int n) {
            return new OutlineViewOutlineColumn(n);
        }

        boolean isTreeSortable() {
            return this.treeSortable;
        }

        void setTreeSortable(boolean bl) {
            this.treeSortable = bl;
        }

        private void setNodesColumnDescription(String string) {
            this.nodesColumnDescription = string;
        }

        static /* synthetic */ int[] access$2502(OutlineViewOutline outlineViewOutline, int[] nArray) {
            outlineViewOutline.rowWidths = nArray;
            return nArray;
        }

        private class TMScrollingListener
        implements TableModelListener,
        TreeModelListener {
            private TMScrollingListener() {
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                this.updateRowWidths();
            }

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                this.updateRowWidths();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                this.updateRowWidths();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                this.updateRowWidths();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                this.updateRowWidths();
            }

            private void updateRowWidths() {
                int n = OutlineViewOutline.this.getOutlineModel().getRowCount();
                if (n != OutlineViewOutline.this.rowWidths.length) {
                    OutlineViewOutline.access$2502(OutlineViewOutline.this, Arrays.copyOf(OutlineViewOutline.this.rowWidths, n));
                }
            }
        }

        private class TranslatedTableCellRenderer
        extends JComponent
        implements TableCellRenderer {
            private OutlineViewOutline outline;
            private TableCellRenderer delegate;
            private Component component;

            public TranslatedTableCellRenderer(OutlineViewOutline outlineViewOutline2, TableCellRenderer tableCellRenderer) {
                this.outline = outlineViewOutline2;
                this.delegate = tableCellRenderer;
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.component = this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                OutlineViewOutline.this.setPreferredTreeWidth(n, this.component.getPreferredSize().width);
                return this;
            }

            @Override
            public void setBounds(int n, int n2, int n3, int n4) {
                this.component.setBounds(n, n2, Math.max(n3, this.outline.getTreePreferredWidth()), n4);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.component.getPreferredSize();
            }

            @Override
            public void paint(Graphics graphics) {
                if (!(this.component instanceof TranslatedTableCellRenderer)) {
                    graphics.translate(-this.outline.getTreePositionX(), 0);
                }
                try {
                    this.component.paint(graphics);
                }
                catch (NullPointerException nullPointerException) {
                    Border border = null;
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)nullPointerException, (String)("Failed painting of component " + this.component + " with border " + (this.component instanceof JComponent ? (border = ((JComponent)this.component).getBorder()) : null) + (border instanceof CompoundBorder ? ", with outsideBorder = " + ((CompoundBorder)border).getOutsideBorder() + " and insideBorder = " + ((CompoundBorder)border).getInsideBorder() : ""))));
                }
            }

            @Override
            public String getToolTipText() {
                if (this.component instanceof JComponent) {
                    return ((JComponent)this.component).getToolTipText();
                }
                return super.getToolTipText();
            }

            @Override
            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (this.component instanceof JComponent) {
                    return ((JComponent)this.component).getToolTipLocation(mouseEvent);
                }
                return super.getToolTipLocation(mouseEvent);
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                if (this.component instanceof JComponent) {
                    return ((JComponent)this.component).getToolTipText(mouseEvent);
                }
                return super.getToolTipText(mouseEvent);
            }

            @Override
            public JToolTip createToolTip() {
                if (this.component instanceof JComponent) {
                    return ((JComponent)this.component).createToolTip();
                }
                return super.createToolTip();
            }
        }

        class OutlineViewOutlineColumn
        extends Outline.OutlineColumn {
            private static final String PROP_PREFIX = "OutlineViewOutlineColumn-";
            private static final String PROP_SHORT_DESCRIPTION = "shortDescription";
            private String tooltip;
            private final Comparator originalNodeComparator;

            public OutlineViewOutlineColumn(int n) {
                super((Outline)OutlineViewOutline.this, n);
                this.originalNodeComparator = new NodeNestedComparator();
            }

            public boolean isSortingAllowed() {
                int n = this.getModelIndex();
                if (n <= 0) {
                    return OutlineViewOutline.this.isTreeSortable();
                }
                Object object = OutlineViewOutline.this.rowModel.getPropertyValue("SortableColumn", n - 1);
                if (object != null) {
                    return Boolean.TRUE.equals(object);
                }
                return super.isSortingAllowed();
            }

            public Comparator getNestedComparator() {
                if (this.getModelIndex() == 0 && super.getNestedComparator() == null) {
                    return this.originalNodeComparator;
                }
                return super.getNestedComparator();
            }

            protected TableCellRenderer createDefaultHeaderRenderer() {
                TableCellRenderer tableCellRenderer = super.createDefaultHeaderRenderer();
                OutlineViewOutlineHeaderRenderer outlineViewOutlineHeaderRenderer = new OutlineViewOutlineHeaderRenderer(tableCellRenderer);
                return outlineViewOutlineHeaderRenderer;
            }

            public String getShortDescription(String string) {
                TableModel tableModel = OutlineViewOutline.this.getModel();
                if (tableModel.getRowCount() <= 0) {
                    return null;
                }
                if (this.getModelIndex() == 0) {
                    if (OutlineViewOutline.this.nodesColumnDescription != null) {
                        return OutlineViewOutline.this.nodesColumnDescription;
                    }
                    return string;
                }
                return OutlineViewOutline.this.rowModel.getShortDescription(this.getModelIndex() - 1);
            }

            public String getRawColumnName() {
                TableModel tableModel = OutlineViewOutline.this.getModel();
                if (tableModel.getRowCount() <= 0) {
                    return null;
                }
                if (this.getModelIndex() == 0) {
                    return null;
                }
                return OutlineViewOutline.this.rowModel.getRawColumnName(this.getModelIndex() - 1);
            }

            void postReadSettings(Properties properties, int n, String string) {
                String string2;
                String string3;
                TableModel tableModel = OutlineViewOutline.this.getModel();
                if (tableModel.getRowCount() > 0 && this.getModelIndex() > 0 && (string3 = properties.getProperty((string2 = string + PROP_PREFIX + Integer.toString(n) + "-") + PROP_SHORT_DESCRIPTION, null)) != null) {
                    OutlineViewOutline.this.rowModel.setShortDescription(this.getModelIndex() - 1, string3);
                }
            }

            public void writeSettings(Properties properties, int n, String string) {
                super.writeSettings(properties, n, string);
                TableModel tableModel = OutlineViewOutline.this.getModel();
                if (tableModel.getRowCount() > 0 && this.getModelIndex() > 0) {
                    String string2 = OutlineViewOutline.this.rowModel.getShortDescription(this.getModelIndex() - 1);
                    String string3 = string + PROP_PREFIX + Integer.toString(n) + "-";
                    properties.setProperty(string3 + PROP_SHORT_DESCRIPTION, string2);
                }
            }

            private class NodeNestedComparator
            implements Comparator {
                private NodeNestedComparator() {
                }

                public int compare(Object object, Object object2) {
                    assert (object instanceof Node) : object + " is instanceof Node";
                    assert (object2 instanceof Node) : object2 + " is instanceof Node";
                    return ((Node)object).getDisplayName().compareTo(((Node)object2).getDisplayName());
                }
            }

            class OutlineViewOutlineHeaderRenderer
            implements TableCellRenderer {
                private TableCellRenderer orig;

                public OutlineViewOutlineHeaderRenderer(TableCellRenderer tableCellRenderer) {
                    this.orig = tableCellRenderer;
                }

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = this.orig.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (OutlineViewOutlineColumn.this.tooltip == null) {
                        OutlineViewOutlineColumn.this.tooltip = OutlineViewOutlineColumn.this.getShortDescription(object.toString());
                    }
                    if (OutlineViewOutlineColumn.this.tooltip != null && component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        jComponent.setToolTipText(OutlineViewOutlineColumn.this.tooltip);
                    }
                    return component;
                }
            }
        }

        private class InvokeCustomEditorAction
        implements Action {
            private Object delegateActionBind;

            InvokeCustomEditorAction(Object object) {
                this.delegateActionBind = object;
            }

            @Override
            public Object getValue(String string) {
                return null;
            }

            @Override
            public void putValue(String string, Object object) {
            }

            @Override
            public void setEnabled(boolean bl) {
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action;
                if (!this.openCustomEditor(actionEvent) && (action = OutlineViewOutline.this.getActionMap().get(this.delegateActionBind)) != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }

            private boolean openCustomEditor(ActionEvent actionEvent) {
                Action action;
                PropertyPanel propertyPanel;
                PropertyEditor propertyEditor;
                if (OutlineViewOutline.this.getSelectedRowCount() != 1 || OutlineViewOutline.this.getSelectedColumnCount() != 1) {
                    return false;
                }
                int n = OutlineViewOutline.this.getSelectedRow();
                if (n < 0) {
                    return false;
                }
                int n2 = OutlineViewOutline.this.getSelectedColumn();
                if (n2 < 0) {
                    return false;
                }
                Object object = OutlineViewOutline.this.getValueAt(n, n2);
                if (!(object instanceof Node.Property)) {
                    return false;
                }
                Node.Property property = (Node.Property)object;
                if (!Boolean.TRUE.equals(property.getValue("suppressCustomEditor")) && (propertyEditor = (propertyPanel = new PropertyPanel(property)).getPropertyEditor()) != null && propertyEditor.supportsCustomEditor() && (action = propertyPanel.getActionMap().get("invokeCustomEditor")) != null) {
                    action.actionPerformed(null);
                    return true;
                }
                return false;
            }
        }

        private static class TextAddedTransferable
        implements Transferable {
            private Transferable trans;
            private Transferable ss;
            private DataFlavor[] dataFlavors;

            public TextAddedTransferable(Transferable transferable, Transferable transferable2) {
                this.trans = transferable;
                this.ss = transferable2;
            }

            @Override
            public synchronized DataFlavor[] getTransferDataFlavors() {
                if (this.dataFlavors == null) {
                    DataFlavor[] dataFlavorArray = this.trans.getTransferDataFlavors();
                    DataFlavor[] dataFlavorArray2 = this.ss.getTransferDataFlavors();
                    ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(dataFlavorArray.length + dataFlavorArray2.length);
                    for (DataFlavor dataFlavor : dataFlavorArray) {
                        arrayList.add(dataFlavor);
                    }
                    for (DataFlavor dataFlavor : dataFlavorArray2) {
                        if (arrayList.contains(dataFlavor)) continue;
                        arrayList.add(dataFlavor);
                    }
                    this.dataFlavors = arrayList.toArray(new DataFlavor[0]);
                }
                return this.dataFlavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                if (this.trans.isDataFlavorSupported(dataFlavor)) {
                    return true;
                }
                return this.ss.isDataFlavorSupported(dataFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (this.trans.isDataFlavorSupported(dataFlavor)) {
                    return this.trans.getTransferData(dataFlavor);
                }
                return this.ss.getTransferData(dataFlavor);
            }
        }

        private class OutlineTransferHandler
        extends ETableTransferHandler {
            private OutlineTransferHandler() {
            }

            public Transferable createOutlineTransferable() {
                return super.createTransferable((JComponent)((Object)OutlineViewOutline.this));
            }
        }

        private class CopyToClipboardAction
        implements Action {
            private Action orig;

            CopyToClipboardAction(Action action) {
                this.orig = action;
            }

            private Action getDelegate() {
                ExplorerManager explorerManager = OutlineViewOutline.this.manager;
                if (explorerManager == null) {
                    return this.orig;
                }
                Action action = ExplorerUtils.actionCopy(explorerManager);
                if (action.isEnabled()) {
                    return action;
                }
                return this.orig;
            }

            @Override
            public Object getValue(String string) {
                return this.getDelegate().getValue(string);
            }

            @Override
            public void putValue(String string, Object object) {
                this.getDelegate().putValue(string, object);
            }

            @Override
            public void setEnabled(boolean bl) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean isEnabled() {
                return this.getDelegate().isEnabled();
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.getDelegate().addPropertyChangeListener(propertyChangeListener);
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.getDelegate().removePropertyChangeListener(propertyChangeListener);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action;
                ExplorerManager explorerManager = OutlineViewOutline.this.manager;
                if (explorerManager != null && (action = ExplorerUtils.actionCopy(explorerManager)).isEnabled()) {
                    this.doCopy(explorerManager);
                    return;
                }
                this.getDelegate().actionPerformed(actionEvent);
            }

            private void doCopy(ExplorerManager explorerManager) {
                Clipboard clipboard;
                Node[] nodeArray = explorerManager.getSelectedNodes();
                Transferable transferable = ExplorerActionsImpl.getTransferableOwner(nodeArray, true);
                Transferable transferable2 = new OutlineTransferHandler().createOutlineTransferable();
                if (transferable != null) {
                    if (transferable2 != null) {
                        transferable = new TextAddedTransferable(transferable, transferable2);
                    }
                } else {
                    transferable = transferable2;
                }
                if (transferable != null && (clipboard = ExplorerActionsImpl.getClipboard()) != null) {
                    clipboard.setContents(transferable, new StringSelection(""));
                }
            }
        }

        private final class DefaultQuickSearchTableFilter
        implements QuickSearchTableFilter {
            private DefaultQuickSearchTableFilter() {
            }

            @Override
            public String getStringValueAt(int n, int n2) {
                String string;
                Object object = OutlineViewOutline.this.transformValue(OutlineViewOutline.this.getValueAt(n, n2));
                if (object instanceof Node.Property) {
                    Node.Property property = (Node.Property)object;
                    Object object2 = null;
                    try {
                        object2 = property.getValue();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    string = object2 instanceof String ? (String)object2 : null;
                } else {
                    string = object instanceof VisualizerNode ? ((VisualizerNode)object).getDisplayName() : (object instanceof Node ? ((Node)object).getDisplayName() : (object instanceof String ? (String)object : null));
                }
                return string;
            }
        }
    }

    private class DefaultTreeAction
    implements ActionListener {
        private Outline outline;

        DefaultTreeAction(Outline outline) {
            this.outline = outline;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.outline.getSelectedColumn() != 0) {
                return;
            }
            Node[] nodeArray = OutlineView.this.manager.getSelectedNodes();
            TreeView.performPreferredActionOnNodes(nodeArray);
        }
    }

    private class TableSelectionListener
    implements VetoableChangeListener,
    ListSelectionListener,
    PropertyChangeListener {
        private TableSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = OutlineView.this.managerLock;
            synchronized (object) {
                if (OutlineView.this.manager == null) {
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("rootContext")) {
                    OutlineView.this.synchronizeRootContext();
                }
                if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                    OutlineView.this.synchronizeSelectedNodes(true, new Node[0]);
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int[] nArray = OutlineView.this.outline.getSelectedRows();
            ArrayList<Node> arrayList = new ArrayList<Node>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                Node node = OutlineView.this.getNodeFromRow(nArray[i]);
                if (node == null) continue;
                arrayList.add(node);
            }
            OutlineView.this.callSelectionChanged(arrayList.toArray(new Node[arrayList.size()]));
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes") && OutlineView.this.isSelectionModeBroken(nodeArray = (Node[])propertyChangeEvent.getNewValue())) {
                throw new PropertyVetoException("selection mode  broken by " + Arrays.asList(nodeArray), propertyChangeEvent);
            }
        }
    }

    private class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = OutlineView.this.outline.rowAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                if (!OutlineView.this.outline.getSelectionModel().isSelectedIndex(n)) {
                    OutlineView.this.outline.getSelectionModel().clearSelection();
                    OutlineView.this.outline.getSelectionModel().setSelectionInterval(n, n);
                }
            } else {
                OutlineView.this.outline.getSelectionModel().clearSelection();
            }
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), OutlineView.this);
            if (OutlineView.this.isPopupAllowed()) {
                JPopupMenu jPopupMenu = OutlineView.this.createPopup(point);
                OutlineView.this.showPopup(point.x, point.y, jPopupMenu);
                mouseEvent.consume();
            }
        }
    }

    private class PopupAction
    extends AbstractAction
    implements Runnable {
        private PopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            Point point = OutlineView.this.getPositionForPopup();
            if (point == null) {
                return;
            }
            if (OutlineView.this.isPopupAllowed()) {
                JPopupMenu jPopupMenu = OutlineView.this.createPopup(point);
                OutlineView.this.showPopup(point.x, point.y, jPopupMenu);
            }
        }
    }
}

