from typing import Any, Dict, List

#
# Bazaar documentation build configuration file, created by
# sphinx-quickstart on Tue Jul 21 17:04:52 2009.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# FIXME: better move the content of doc/en/conf.py here and cleanup the result
# -- vila 20100428

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
# sys.path.append(os.path.abspath('.'))


# -- General configuration -----------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    "sphinx.ext.ifconfig",
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx_epytext",
    # 'sphinxcontrib.napoleon', # TODO: for Google docstrings
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix of source filenames.
source_suffix = ".txt"

# The encoding of source files.
# source_encoding = 'utf-8'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "Breezy"
copyright = "2009-2011 Canonical Ltd, 2017-2018 Breezy Developers"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
import breezy

version = ".".join(str(p) for p in breezy.version_info[:2])
# The full version, including alpha/beta/rc tags.
release = breezy.version_string

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
# unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = ["_build"]

# The reST default role (used for this markup: `text`) to use for all documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  Major themes that come with
# Sphinx are currently 'default' and 'sphinxdoc'.
html_theme = "agogo"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options: Dict[str, Any] = {
    # Unfortunately, the right sidebar breaks under IE6 and maybe IE7.
    # So we stick with the default left placement to cater for users stuck
    # on those browsers.
    # 'rightsidebar': True,
    # Non-document areas: header (relbar), footer, sidebar, etc.
    # Some useful colours here:
    # * blue: darkblue, mediumblue, darkslateblue, cornflowerblue, royalblue,
    #   midnightblue
    # * gray: dimgray, slategray, lightslategray
    #'sidebarbgcolor': "cornflowerblue",
    #'sidebarlinkcolor': "midnightblue",
    #'relbarbgcolor': "darkblue",
    #'footerbgcolor': "lightslategray",
    # Text, heading and code colouring
    #'codebgcolor': "lightyellow",
    #'codetextcolor': "firebrick",
    #'linkcolor': "mediumblue",
}

# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
# TODO(jelmer): add a brz.ico
# html_favicon = "brz.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
html_use_modindex = False

# If false, no index is generated.
html_use_index = False

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = "brz-docs"


# -- Options for LaTeX output --------------------------------------------------

# The paper size ('letter' or 'a4').
# latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
# latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents: List[Any] = []

# The name of an image file (relative to this directory) to place at the top of
# the title page.
# latex_logo = '../Bazaar-Logo-For-Manuals.png'

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
# latex_use_parts = False

# Additional stuff for the LaTeX preamble.
# latex_preamble = ''

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
# latex_use_modindex = True


# -- Bazaar-specific configuration ---------------------------------------------

# Authors of the documents
brz_team = "Breezy Developers"

intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "testtools": ("https://testtools.readthedocs.io/en/latest", None),
    "configobj": ("https://configobj.readthedocs.io/en/latest", None),
    "dulwich": ("https://dulwich.readthedocs.io/en/latest", None),
}
