/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.SimpleScrollPaneLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class SimpleScrollPane
extends JScrollPane
implements ChangeListener,
MouseWheelListener {
    private AbstractButton _scrollUpButton;
    private AbstractButton _scrollDownButton;
    private AbstractButton _scrollLeftButton;
    private AbstractButton _scrollRightButton;
    private int _horizontalUnitIncrement = 10;
    private boolean _horizontalUnitIncrementSet = false;
    private int _verticalUnitIncrement = 10;
    private boolean _verticalUnitIncrementSet = false;
    private int _repeatDelay = 50;
    private boolean _scrollOnRollover = true;
    public static final String SCROLL_UP_BUTTON = "SCROLL_UP_BUTTON";
    public static final String SCROLL_DOWN_BUTTON = "SCROLL_DOWN_BUTTON";
    public static final String SCROLL_LEFT_BUTTON = "SCROLL_LEFT_BUTTON";
    public static final String SCROLL_RIGHT_BUTTON = "SCROLL_RIGHT_BUTTON";

    public SimpleScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        this.setLayout(new SimpleScrollPaneLayout.UIResource());
        this.setVerticalScrollBarPolicy(vsbPolicy);
        this.setHorizontalScrollBarPolicy(hsbPolicy);
        this.setViewport(this.createViewport());
        this.setScrollUpButton(this.createScrollButton(1));
        this.setScrollDownButton(this.createScrollButton(5));
        this.setScrollLeftButton(this.createScrollButton(7));
        this.setScrollRightButton(this.createScrollButton(3));
        if (null != view) {
            this.setViewportView(view);
        }
        this.updateButtonState();
        this.setOpaque(true);
        this.setFocusable(false);
        if (this.getHorizontalScrollBar() != null) {
            this.getHorizontalScrollBar().setVisible(false);
            this.getHorizontalScrollBar().setFocusable(false);
        }
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setVisible(false);
            this.getVerticalScrollBar().setFocusable(false);
        }
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
        if (this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
    }

    public SimpleScrollPane(Component view) {
        this(view, 20, 30);
    }

    public SimpleScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public SimpleScrollPane() {
        this(null, 20, 30);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setLayout(new SimpleScrollPaneLayout.UIResource());
        LookAndFeel.installBorder(this, "JideScrollPane.border");
        this.getViewport().addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.getViewport()) {
            this.updateButtonState();
        }
    }

    public AbstractButton getScrollUpButton() {
        return this._scrollUpButton;
    }

    public void setScrollUpButton(AbstractButton scrollUpButton) {
        AbstractButton old = this.getScrollUpButton();
        this._scrollUpButton = scrollUpButton;
        this.add((Component)this._scrollUpButton, SCROLL_UP_BUTTON);
        this.firePropertyChange("scrollUpButton", old, this._scrollUpButton);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollDownButton() {
        return this._scrollDownButton;
    }

    public void setScrollDownButton(AbstractButton scrollDownButton) {
        AbstractButton old = this.getScrollDownButton();
        this._scrollDownButton = scrollDownButton;
        this.add((Component)this._scrollDownButton, SCROLL_DOWN_BUTTON);
        this.firePropertyChange("scrollDownButton", old, this._scrollDownButton);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollLeftButton() {
        return this._scrollLeftButton;
    }

    public void setScrollLeftButton(AbstractButton scrollLeftButton) {
        AbstractButton old = this.getScrollLeftButton();
        this._scrollLeftButton = scrollLeftButton;
        this.add((Component)this._scrollLeftButton, SCROLL_LEFT_BUTTON);
        this.firePropertyChange("scrollLeftButton", old, this._scrollLeftButton);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollRightButton() {
        return this._scrollRightButton;
    }

    public void setScrollRightButton(AbstractButton scrollRightButton) {
        AbstractButton old = this.getScrollRightButton();
        this._scrollRightButton = scrollRightButton;
        this.add((Component)this._scrollRightButton, SCROLL_RIGHT_BUTTON);
        this.firePropertyChange("scrollRightButton", old, this._scrollRightButton);
        this.revalidate();
        this.repaint();
    }

    protected AbstractButton createScrollButton(int type) {
        return new ScrollButton(type);
    }

    protected void updateButtonState() {
        Point p = this.viewport.getViewPosition();
        this._scrollUpButton.setEnabled(p.y != 0);
        this._scrollDownButton.setEnabled(p.y != this.viewport.getViewSize().height - this.viewport.getViewRect().height);
        this._scrollLeftButton.setEnabled(p.x != 0);
        this._scrollRightButton.setEnabled(p.x != this.viewport.getViewSize().width - this.viewport.getViewRect().width);
        this.revalidate();
        this.repaint();
    }

    public void scroll(JViewport viewport, int type) {
        Point p = viewport.getViewPosition();
        JViewport vp = this.getViewport();
        switch (type) {
            case 1: {
                if (!this._verticalUnitIncrementSet && vp != null && vp.getView() instanceof Scrollable) {
                    Scrollable view = (Scrollable)((Object)vp.getView());
                    Rectangle vr = vp.getViewRect();
                    p.y -= view.getScrollableUnitIncrement(vr, 1, -1);
                } else {
                    p.y -= this.getVerticalUnitIncrement();
                }
                if (p.y >= 0) break;
                p.y = 0;
                break;
            }
            case 5: {
                if (!this._verticalUnitIncrementSet && vp != null && vp.getView() instanceof Scrollable) {
                    Scrollable view = (Scrollable)((Object)vp.getView());
                    Rectangle vr = vp.getViewRect();
                    p.y += view.getScrollableUnitIncrement(vr, 1, 1);
                } else {
                    p.y += this.getVerticalUnitIncrement();
                }
                if (p.y + viewport.getViewRect().height <= viewport.getViewSize().height) break;
                p.y = viewport.getViewSize().height - viewport.getViewRect().height;
                break;
            }
            case 7: {
                if (!this._horizontalUnitIncrementSet && vp != null && vp.getView() instanceof Scrollable) {
                    Scrollable view = (Scrollable)((Object)vp.getView());
                    Rectangle vr = vp.getViewRect();
                    p.x -= view.getScrollableUnitIncrement(vr, 0, -1);
                } else {
                    p.x -= this.getHorizontalUnitIncrement();
                }
                if (p.x >= 0) break;
                p.x = 0;
                break;
            }
            case 3: {
                if (!this._horizontalUnitIncrementSet && vp != null && vp.getView() instanceof Scrollable) {
                    Scrollable view = (Scrollable)((Object)vp.getView());
                    Rectangle vr = vp.getViewRect();
                    p.x += view.getScrollableUnitIncrement(vr, 0, 1);
                } else {
                    p.x += this.getHorizontalUnitIncrement();
                }
                if (p.x + viewport.getViewRect().width <= viewport.getViewSize().width) break;
                p.x = viewport.getViewSize().width - viewport.getViewRect().width;
            }
        }
        viewport.setViewPosition(p);
    }

    @Override
    public Rectangle getViewportBorderBounds() {
        Rectangle borderR = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        borderR.x = insets.left;
        borderR.y = insets.top;
        borderR.width -= insets.left + insets.right;
        borderR.height -= insets.top + insets.bottom;
        if (this._scrollUpButton != null && this._scrollUpButton.isVisible()) {
            borderR.y += this._scrollUpButton.getHeight();
            borderR.height -= this._scrollUpButton.getHeight();
        }
        if (this._scrollLeftButton != null && this._scrollLeftButton.isVisible()) {
            borderR.x += this._scrollLeftButton.getWidth();
            borderR.width -= this._scrollLeftButton.getWidth();
        }
        if (this._scrollDownButton != null && this._scrollDownButton.isVisible()) {
            borderR.height -= this._scrollDownButton.getHeight();
        }
        if (this._scrollRightButton != null && this._scrollRightButton.isVisible()) {
            borderR.width -= this._scrollRightButton.getWidth();
        }
        return borderR;
    }

    public int getHorizontalUnitIncrement() {
        return this._horizontalUnitIncrement;
    }

    public void setHorizontalUnitIncrement(int horizontalUnitIncrement) {
        this._horizontalUnitIncrementSet = true;
        if (horizontalUnitIncrement != this._horizontalUnitIncrement) {
            int old = this._horizontalUnitIncrement;
            this._horizontalUnitIncrement = horizontalUnitIncrement;
            this.firePropertyChange("horizontalUnitIncrement", old, this._horizontalUnitIncrement);
        }
    }

    public int getVerticalUnitIncrement() {
        return this._verticalUnitIncrement;
    }

    public void setVerticalUnitIncrement(int verticalUnitIncrement) {
        this._verticalUnitIncrementSet = true;
        if (verticalUnitIncrement != this._verticalUnitIncrement) {
            int old = this._verticalUnitIncrement;
            this._verticalUnitIncrement = verticalUnitIncrement;
            this.firePropertyChange("verticalUnitIncrement", old, this._verticalUnitIncrement);
        }
    }

    public boolean isScrollOnRollover() {
        return this._scrollOnRollover;
    }

    public void setScrollOnRollover(boolean scrollOnRollover) {
        if (this._scrollOnRollover != scrollOnRollover) {
            boolean old = this._scrollOnRollover;
            this._scrollOnRollover = scrollOnRollover;
            this.firePropertyChange("scrollOnRollover", old, this._scrollOnRollover);
        }
    }

    public int getRepeatDelay() {
        return this._repeatDelay;
    }

    public void setRepeatDelay(int repeatDelay) {
        if (repeatDelay != this._repeatDelay) {
            int old = this._repeatDelay;
            this._repeatDelay = repeatDelay;
            this.firePropertyChange("repeatDelay", old, this._repeatDelay);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
            boolean scrollingUp = e.getWheelRotation() >= 0;
            int direction = 0;
            if (!this.isButtonVisible(scrollingUp)) {
                return;
            }
            direction = this.getScrollDirection(scrollingUp);
            if (direction != 0) {
                this.scroll(this.getViewport(), direction);
            }
        }
    }

    private boolean isButtonVisible(boolean scrollingUp) {
        if (scrollingUp) {
            return this._scrollUpButton != null && this._scrollUpButton.isVisible() || this._scrollLeftButton != null && this._scrollLeftButton.isVisible();
        }
        return this._scrollDownButton != null && this._scrollDownButton.isVisible() || this._scrollRightButton != null && this._scrollRightButton.isVisible();
    }

    private int getScrollDirection(boolean scrollingUp) {
        if (scrollingUp) {
            if (this._scrollUpButton != null && this._scrollUpButton.isVisible()) {
                return 5;
            }
            if (this._scrollLeftButton != null && this._scrollLeftButton.isVisible()) {
                return 3;
            }
        } else {
            if (this._scrollDownButton != null && this._scrollDownButton.isVisible()) {
                return 1;
            }
            if (this._scrollRightButton != null && this._scrollRightButton.isVisible()) {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public void setWheelScrollingEnabled(boolean handleWheel) {
        if (handleWheel && !this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
        if (!handleWheel && this.isWheelScrollingEnabled()) {
            this.removeMouseWheelListener(this);
        }
        super.setWheelScrollingEnabled(handleWheel);
    }

    public class ScrollButton
    extends JideButton
    implements MouseListener,
    ActionListener,
    UIResource {
        private int _type;
        private Timer _timer;

        public ScrollButton(int type) {
            this._type = type;
            switch (type) {
                case 1: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_up.gif"));
                    break;
                }
                case 5: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_down.gif"));
                    break;
                }
                case 7: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_left.gif"));
                    break;
                }
                case 3: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
                }
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(10, 10));
            this.setMinimumSize(new Dimension(10, 10));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleScrollPane.this.scroll(SimpleScrollPane.this.getViewport(), this._type);
            SimpleScrollPane.this.updateButtonState();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SimpleScrollPane.this.isScrollOnRollover()) {
                this.startTimer(e, 500);
            } else {
                this.updateTimer(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!SimpleScrollPane.this.isScrollOnRollover()) {
                this.stopTimer();
            } else {
                this.updateTimer(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                this.startTimer(e, 500);
            }
        }

        private void updateTimer(MouseEvent e) {
            if (this._timer != null) {
                this._timer.setDelay(this.getDelay(e));
            }
        }

        private void startTimer(MouseEvent e, int initDelay) {
            this.stopTimer();
            this._timer = new Timer(this.getDelay(e), this);
            this._timer.setInitialDelay(initDelay);
            this._timer.start();
        }

        private void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
        }

        private int getDelay(MouseEvent e) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                return SwingUtilities.isLeftMouseButton(e) ? SimpleScrollPane.this.getRepeatDelay() : SimpleScrollPane.this.getRepeatDelay() * 2;
            }
            return SimpleScrollPane.this.getRepeatDelay();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                this.stopTimer();
            }
        }
    }
}

