/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus.actions;

import java.util.ArrayList;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.gui.menus.actions.MenuAction;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.SetOffsetTask;
import org.fibs.geotag.tasks.TaskExecutor;

public class CopyOffsetToSelectedAction
implements MenuAction,
MenuConstants {
    private ImageInfo fromImage;
    private ImagesTable imagesTable;

    public CopyOffsetToSelectedAction(ImageInfo currentImage, ImagesTable imagesTable) {
        this.fromImage = currentImage;
        this.imagesTable = imagesTable;
    }

    @Override
    public void perform() {
        int offset = this.fromImage.getOffset();
        int[] selectedRows = this.imagesTable.getSelectedRows();
        ImagesTableModel tableModel = (ImagesTableModel)this.imagesTable.getModel();
        ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < selectedRows.length) {
            ImageInfo image = tableModel.getImageInfo(selectedRows[index]);
            imageList.add(image);
            ++index;
        }
        TaskExecutor.execute(new SetOffsetTask(COPY_TIME_OFFSET, COPY_TIME_OFFSET_SELECTED, tableModel, offset, imageList));
    }
}

