/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import com.yahoo.sketches.theta.DirectCompactUnorderedSketch;
import com.yahoo.sketches.theta.DirectQuickSelectSketch;
import com.yahoo.sketches.theta.HeapAlphaSketch;
import com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import com.yahoo.sketches.theta.HeapCompactUnorderedSketch;
import com.yahoo.sketches.theta.HeapQuickSelectSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.UpdateReturnState;
import com.yahoo.sketches.theta.UpdateSketchBuilder;
import java.nio.charset.StandardCharsets;

public abstract class UpdateSketch
extends Sketch {
    UpdateSketch() {
    }

    public static UpdateSketch wrap(WritableMemory srcMem) {
        return UpdateSketch.wrap(srcMem, 9001L);
    }

    public static UpdateSketch wrap(WritableMemory srcMem, long seed) {
        int preLongs = srcMem.getByte(0L) & 0x3F;
        int serVer = srcMem.getByte(1L) & 0xFF;
        int familyID = srcMem.getByte(2L) & 0xFF;
        Family family = Family.idToFamily(familyID);
        if (family != Family.QUICKSELECT) {
            throw new SketchesArgumentException("A " + (Object)((Object)family) + " sketch cannot be wrapped as an UpdateSketch.");
        }
        if (serVer == 3 && preLongs == 3) {
            return DirectQuickSelectSketch.writableWrap(srcMem, seed);
        }
        throw new SketchesArgumentException("Corrupted: An UpdateSketch image: must have SerVer = 3 and preLongs = 3");
    }

    public static UpdateSketch heapify(Memory srcMem) {
        return UpdateSketch.heapify(srcMem, 9001L);
    }

    public static UpdateSketch heapify(Memory srcMem, long seed) {
        Family family = Family.idToFamily(srcMem.getByte(2L));
        if (family.equals((Object)Family.ALPHA)) {
            return HeapAlphaSketch.heapifyInstance(srcMem, seed);
        }
        return HeapQuickSelectSketch.heapifyInstance(srcMem, seed);
    }

    @Override
    public CompactSketch compact() {
        return this.compact(true, null);
    }

    @Override
    public CompactSketch compact(boolean dstOrdered, WritableMemory dstMem) {
        CompactSketch sketchOut = null;
        int sw = (dstOrdered ? 2 : 0) | (dstMem != null ? 1 : 0);
        switch (sw) {
            case 0: {
                sketchOut = HeapCompactUnorderedSketch.compact(this);
                break;
            }
            case 1: {
                sketchOut = DirectCompactUnorderedSketch.compact(this, dstMem);
                break;
            }
            case 2: {
                sketchOut = HeapCompactOrderedSketch.compact(this);
                break;
            }
            case 3: {
                sketchOut = DirectCompactOrderedSketch.compact(this, dstMem);
            }
        }
        return sketchOut;
    }

    @Override
    public boolean isCompact() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    public static final UpdateSketchBuilder builder() {
        return new UpdateSketchBuilder();
    }

    public abstract void reset();

    public abstract UpdateSketch rebuild();

    public abstract ResizeFactor getResizeFactor();

    public UpdateReturnState update(long datum) {
        long[] data = new long[]{datum};
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(String datum) {
        if (datum == null || datum.isEmpty()) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(byte[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(char[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(int[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(long[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    abstract UpdateReturnState hashUpdate(long var1);

    abstract int getLgArrLongs();

    public abstract int getLgNomLongs();

    abstract float getP();

    abstract long getSeed();

    abstract boolean isDirty();

    abstract boolean isOutOfSpace(int var1);

    static void checkUnionQuickSelectFamily(Memory mem, int preambleLongs, int lgNomLongs) {
        int familyID = PreambleUtil.extractFamilyID(mem);
        Family family = Family.idToFamily(familyID);
        if (family.equals((Object)Family.UNION)) {
            if (preambleLongs != Family.UNION.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for UNION: " + preambleLongs);
            }
        } else if (family.equals((Object)Family.QUICKSELECT)) {
            if (preambleLongs != Family.QUICKSELECT.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for QUICKSELECT: " + preambleLongs);
            }
        } else {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
        if (lgNomLongs < 4) {
            throw new SketchesArgumentException("Possible corruption: Current Memory lgNomLongs < min required size: " + lgNomLongs + " < " + 4);
        }
    }

    static void checkMemIntegrity(Memory srcMem, long seed, int preambleLongs, int lgNomLongs, int lgArrLongs) {
        int serVer = PreambleUtil.extractSerVer(srcMem);
        if (serVer != 3) {
            throw new SketchesArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
        }
        int flags = PreambleUtil.extractFlags(srcMem);
        int flagsMask = 27;
        if ((flags & 0x1B) > 0) {
            throw new SketchesArgumentException("Possible corruption: Input srcMem cannot be: big-endian, compact, ordered, or read-only");
        }
        short seedHash = (short)PreambleUtil.extractSeedHash(srcMem);
        Util.checkSeedHashes(seedHash, Util.computeSeedHash(seed));
        long curCapBytes = srcMem.getCapacity();
        int minReqBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        if (curCapBytes < (long)minReqBytes) {
            throw new SketchesArgumentException("Possible corruption: Current Memory size < min required size: " + curCapBytes + " < " + minReqBytes);
        }
        float p = PreambleUtil.extractP(srcMem);
        long thetaLong = PreambleUtil.extractThetaLong(srcMem);
        double theta = (double)thetaLong / 9.223372036854776E18;
        if (lgArrLongs <= lgNomLongs && theta < (double)p) {
            throw new SketchesArgumentException("Possible corruption: Theta cannot be < p and lgArrLongs <= lgNomLongs. " + lgArrLongs + " <= " + lgNomLongs + ", Theta: " + theta + ", p: " + p);
        }
    }
}

