/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.common.exception;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.core.common.io.stream.NotSerializableExceptionWrapper;
import org.opensearch.timeseries.common.exception.ClientException;
import org.opensearch.timeseries.common.exception.DuplicateTaskException;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.InternalFailure;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.common.exception.ResourceNotFoundException;
import org.opensearch.timeseries.common.exception.TaskCancelledException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.common.exception.VersionException;

public enum NotSerializedExceptionName {
    RESOURCE_NOT_FOUND_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new ResourceNotFoundException("", ""))),
    LIMIT_EXCEEDED_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new LimitExceededException("", "", false))),
    END_RUN_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new EndRunException("", "", false))),
    TIME_SERIES_DETECTION_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new TimeSeriesException("", ""))),
    INTERNAL_FAILURE_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new InternalFailure("", ""))),
    CLIENT_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new ClientException("", ""))),
    CANCELLATION_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new TaskCancelledException("", ""))),
    DUPLICATE_TASK_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new DuplicateTaskException(""))),
    VERSION_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new VersionException(""))),
    VALIDATION_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new ValidationException("", null, null)));

    private static final Logger LOG;
    private final String name;

    private NotSerializedExceptionName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<TimeSeriesException> convertWrappedTimeSeriesException(NotSerializableExceptionWrapper exception, String configID) {
        String exceptionMsg = exception.getMessage().trim();
        TimeSeriesException convertedException = null;
        block12: for (NotSerializedExceptionName timeseriesException : NotSerializedExceptionName.values()) {
            if (!exceptionMsg.startsWith(timeseriesException.getName())) continue;
            switch (timeseriesException) {
                case RESOURCE_NOT_FOUND_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new ResourceNotFoundException(configID, exceptionMsg);
                    continue block12;
                }
                case LIMIT_EXCEEDED_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new LimitExceededException(configID, exceptionMsg, false);
                    continue block12;
                }
                case END_RUN_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new EndRunException(configID, exceptionMsg, false);
                    continue block12;
                }
                case TIME_SERIES_DETECTION_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new TimeSeriesException(configID, exceptionMsg);
                    continue block12;
                }
                case INTERNAL_FAILURE_NAME_UNDERSCORE: {
                    convertedException = new InternalFailure(configID, exceptionMsg);
                    continue block12;
                }
                case CLIENT_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new ClientException(configID, exceptionMsg);
                    continue block12;
                }
                case CANCELLATION_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new TaskCancelledException(exceptionMsg, "");
                    continue block12;
                }
                case DUPLICATE_TASK_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new DuplicateTaskException(exceptionMsg);
                    continue block12;
                }
                case VERSION_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new VersionException(exceptionMsg);
                    continue block12;
                }
                case VALIDATION_EXCEPTION_NAME_UNDERSCORE: {
                    convertedException = new ValidationException(exceptionMsg, null, null);
                    continue block12;
                }
                default: {
                    LOG.warn((Message)new ParameterizedMessage("Unexpected exception {}", (Object)timeseriesException));
                }
            }
        }
        return Optional.ofNullable(convertedException);
    }

    static {
        LOG = LogManager.getLogger(NotSerializedExceptionName.class);
    }
}

