/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export var OUI_THUMB_SIZE = 16;
export var calculateThumbPosition = function calculateThumbPosition(value, min, max, width) {
  var thumbSize = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : OUI_THUMB_SIZE;
  // Calculate the left position based on value
  var decimal = (value - min) / (max - min); // Must be between 0-100%

  var valuePosition = decimal <= 1 ? decimal : 1;
  valuePosition = valuePosition >= 0 ? valuePosition : 0;
  var trackWidth = width !== null && width !== void 0 ? width : 0;
  var thumbToTrackRatio = thumbSize / trackWidth;
  var trackPositionScale = (1 - thumbToTrackRatio) * 100;
  return valuePosition * trackPositionScale;
};
/* OUI -> EUI Aliases: Build-Time */

export { EUI_THUMB_SIZE } from '../../../eui_components/form/range/utils';