/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.GetSnapshotsResult;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.SnapshotManagementException;
import org.opensearch.indexmanagement.snapshotmanagement.UpdateNextExecutionTimeResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMMetadata;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotMissingException;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a.\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\n\u001a\u00020\u0007\u001a\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u0010\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007\u001a\u000e\u0010$\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007\u001a\u000e\u0010%\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u001a\u000e\u0010&\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u001a&\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003\u001a.\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020*2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u00102\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0007\u001a\u000e\u00103\u001a\u0002042\u0006\u0010\n\u001a\u00020\u0007\u001a\u001e\u00105\u001a\b\u0012\u0004\u0012\u00020706*\b\u0012\u0004\u0012\u000207062\u0006\u0010\n\u001a\u00020\u0007\u001a\u001f\u00108\u001a\u0004\u0018\u00010\u001a*\u0002092\u0006\u0010:\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;\u001a\u001d\u0010<\u001a\u00020\u0011*\u0002092\u0006\u0010=\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;\u001a+\u0010>\u001a\b\u0012\u0004\u0012\u00020706*\u0002092\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010A\u001aG\u0010>\u001a\u00020B*\u0002092\u0006\u0010C\u001a\u00020\u00112\u0006\u0010?\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010D\u001a\u0004\u0018\u00010\u00072\u0006\u0010E\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010F\u001a?\u0010G\u001a\u00020H*\u0002092\u0006\u0010I\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020L2\b\b\u0002\u0010N\u001a\u00020OH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010P\u001a\u0014\u0010Q\u001a\u00020O*\u00020\u00162\b\u0010R\u001a\u0004\u0018\u00010.\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006S"}, d2={"RANDOM_STRING_LENGTH", "", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "addSMPolicyInSnapshotMetadata", "", "", "", "snapshotConfig", "policyName", "generateFormatDate", "dateFormat", "timezone", "Ljava/time/ZoneId;", "generateSnapshotName", "policy", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;", "getRandomString", "length", "getTimeLimitExceededMessage", "timeLimit", "Lorg/opensearch/common/unit/TimeValue;", "workflow", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/WorkflowType;", "parseSMMetadata", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;", "response", "Lorg/opensearch/action/get/GetResponse;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "parseSMPolicy", "preFixTimeStamp", "msg", "smDocIdToPolicyName", "docId", "smMetadataDocIdToPolicyName", "smPolicyNameToDocId", "smPolicyNameToMetadataDocId", "timeLimitExceeded", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMResult;", "metadataBuilder", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder;", "tryUpdatingNextExecutionTime", "Lorg/opensearch/indexmanagement/snapshotmanagement/UpdateNextExecutionTimeResult;", "nextTime", "Ljava/time/Instant;", "schedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "workflowType", "validateDateFormat", "validateSMPolicyName", "", "filterBySMPolicyInSnapshotMetadata", "", "Lorg/opensearch/snapshots/SnapshotInfo;", "getSMMetadata", "Lorg/opensearch/client/Client;", "jobID", "(Lorg/opensearch/client/Client;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSMPolicy", "policyID", "getSnapshots", "name", "repo", "(Lorg/opensearch/client/Client;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/opensearch/indexmanagement/snapshotmanagement/GetSnapshotsResult;", "job", "snapshotMissingMsg", "exceptionMsg", "(Lorg/opensearch/client/Client;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;Ljava/lang/String;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder;Lorg/apache/logging/log4j/Logger;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexMetadata", "Lorg/opensearch/action/index/IndexResponse;", "metadata", "id", "seqNo", "", "primaryTerm", "create", "", "(Lorg/opensearch/client/Client;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;Ljava/lang/String;JJZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isExceed", "startTime", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nSMUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMUtils.kt\norg/opensearch/indexmanagement/snapshotmanagement/SMUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n1#2:367\n766#3:368\n857#3,2:369\n*S KotlinDebug\n*F\n+ 1 SMUtils.kt\norg/opensearch/indexmanagement/snapshotmanagement/SMUtilsKt\n*L\n207#1:368\n207#1:369,2\n*E\n"})
public final class SMUtilsKt {
    private static final Logger log = LogManager.getLogger((String)"o.i.s.SnapshotManagementHelper");
    public static final int RANDOM_STRING_LENGTH = 8;

    @NotNull
    public static final String smPolicyNameToDocId(@NotNull String policyName) {
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        return policyName + "-sm-policy";
    }

    @NotNull
    public static final String smDocIdToPolicyName(@NotNull String docId2) {
        Intrinsics.checkNotNullParameter((Object)docId2, (String)"docId");
        return StringsKt.substringBeforeLast$default((String)docId2, (String)"-sm-policy", null, (int)2, null);
    }

    @NotNull
    public static final String smPolicyNameToMetadataDocId(@NotNull String policyName) {
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        return policyName + "-sm-metadata";
    }

    @NotNull
    public static final String smMetadataDocIdToPolicyName(@NotNull String docId2) {
        Intrinsics.checkNotNullParameter((Object)docId2, (String)"docId");
        return StringsKt.substringBeforeLast$default((String)docId2, (String)"-sm-metadata", null, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSMPolicy(@NotNull Client var0, @NotNull String var1_1, @NotNull Continuation<? super SMPolicy> var2_2) {
        if (!(var2_2 instanceof getSMPolicy.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMUtilsKt.getSMPolicy(null, null, (Continuation<? super SMPolicy>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                getRequest = new GetRequest(".opendistro-ism-config", policyID);
                $continuation.L$0 = policyID;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$getSMPolicy, (Function2)new Function2<Client, ActionListener<GetResponse>, Unit>(getRequest){
                    final /* synthetic */ GetRequest $getRequest;
                    {
                        this.$getRequest = $getRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<GetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.get(this.$getRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var7_5) goto lbl20
lbl19:
                // 1 sources

                return var7_5;
lbl20:
                // 1 sources

                ** GOTO lbl27
            }
            case 1: {
                policyID = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    if (!(getResponse = (GetResponse)v0).isExists() || getResponse.isSourceEmpty()) {
                        throw new OpenSearchStatusException("Snapshot management policy not found", RestStatus.NOT_FOUND, new Object[0]);
                    }
                    return SMUtilsKt.parseSMPolicy$default(getResponse, null, 2, null);
                }
                catch (OpenSearchStatusException e) {
                    throw e;
                }
                catch (IndexNotFoundException e) {
                    throw new OpenSearchStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management policy [" + policyID + "]", (Throwable)e);
                    throw new OpenSearchStatusException("Snapshot management policy could not be parsed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                catch (Exception e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management policy [" + policyID + "]", (Throwable)e);
                    throw new OpenSearchStatusException("Failed to retrieve Snapshot management policy.", RestStatus.NOT_FOUND, new Object[0]);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSMMetadata(@NotNull Client var0, @NotNull String var1_1, @NotNull Continuation<? super SMMetadata> var2_2) {
        if (!(var2_2 instanceof getSMMetadata.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMUtilsKt.getSMMetadata(null, null, (Continuation<? super SMMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                metadataID = SMUtilsKt.smPolicyNameToMetadataDocId(SMUtilsKt.smDocIdToPolicyName((String)jobID));
                getRequest = new GetRequest(".opendistro-ism-config", metadataID).routing((String)jobID);
                $continuation.L$0 = metadataID;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$getSMMetadata, (Function2)new Function2<Client, ActionListener<GetResponse>, Unit>(getRequest){
                    final /* synthetic */ GetRequest $getRequest;
                    {
                        this.$getRequest = $getRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<GetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.get(this.$getRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var8_5) goto lbl21
lbl20:
                // 1 sources

                return var8_5;
lbl21:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                metadataID = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    if (!(getResponse = (GetResponse)v0).isExists() || getResponse.isSourceEmpty()) {
                        return null;
                    }
                    return SMUtilsKt.parseSMMetadata$default(getResponse, null, 2, null);
                }
                catch (OpenSearchStatusException e) {
                    throw e;
                }
                catch (IndexNotFoundException e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management metadata [" + metadataID + "] because config index did not exist", (Throwable)e);
                    throw new OpenSearchStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management metadata [" + metadataID + "]", (Throwable)e);
                    throw new OpenSearchStatusException("Snapshot management metadata could not be parsed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                catch (Exception e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management metadata [" + metadataID + "]", (Throwable)e);
                    throw new OpenSearchStatusException("Failed to retrieve Snapshot management metadata.", RestStatus.NOT_FOUND, new Object[0]);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final SMPolicy parseSMPolicy(@NotNull GetResponse response2, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
        String string = response2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
        return (SMPolicy)OpenSearchExtensionsKt.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, SMPolicy>((Object)SMPolicy.Companion){

            @NotNull
            public final SMPolicy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((SMPolicy.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        });
    }

    public static /* synthetic */ SMPolicy parseSMPolicy$default(GetResponse getResponse2, NamedXContentRegistry namedXContentRegistry, int n, Object object) {
        if ((n & 2) != 0) {
            NamedXContentRegistry namedXContentRegistry2 = NamedXContentRegistry.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)namedXContentRegistry2, (String)"EMPTY");
            namedXContentRegistry = namedXContentRegistry2;
        }
        return SMUtilsKt.parseSMPolicy(getResponse2, namedXContentRegistry);
    }

    @NotNull
    public static final SMMetadata parseSMMetadata(@NotNull GetResponse response2, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
        String string = response2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
        return (SMMetadata)OpenSearchExtensionsKt.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, SMMetadata>((Object)SMMetadata.Companion){

            @NotNull
            public final SMMetadata invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((SMMetadata.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        });
    }

    public static /* synthetic */ SMMetadata parseSMMetadata$default(GetResponse getResponse2, NamedXContentRegistry namedXContentRegistry, int n, Object object) {
        if ((n & 2) != 0) {
            NamedXContentRegistry namedXContentRegistry2 = NamedXContentRegistry.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)namedXContentRegistry2, (String)"EMPTY");
            namedXContentRegistry = namedXContentRegistry2;
        }
        return SMUtilsKt.parseSMMetadata(getResponse2, namedXContentRegistry);
    }

    @Nullable
    public static final Object indexMetadata(@NotNull Client $this$indexMetadata, @NotNull SMMetadata metadata2, @NotNull String id2, long seqNo, long primaryTerm, boolean create, @NotNull Continuation<? super IndexResponse> $completion) {
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").create(create).id(SMUtilsKt.smPolicyNameToMetadataDocId(SMUtilsKt.smDocIdToPolicyName(id2)));
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        IndexRequest indexReq = indexRequest.source(metadata2.toXContent(xContentBuilder, params)).setIfSeqNo(seqNo).setIfPrimaryTerm(primaryTerm).routing(id2);
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$indexMetadata, (Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(indexReq){
            final /* synthetic */ IndexRequest $indexReq;
            {
                this.$indexReq = $indexReq;
                super(2);
            }

            public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexResponse> it) {
                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                $this$suspendUntil.index(this.$indexReq, it);
            }
        }, $completion);
    }

    public static /* synthetic */ Object indexMetadata$default(Client client, SMMetadata sMMetadata, String string, long l, long l2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return SMUtilsKt.indexMetadata(client, sMMetadata, string, l, l2, bl, (Continuation<? super IndexResponse>)continuation);
    }

    @NotNull
    public static final String generateSnapshotName(@NotNull SMPolicy policy2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)policy2, (String)"policy");
        Object result2 = policy2.getPolicyName();
        String dateFormat = (String)policy2.getSnapshotConfig().get("date_format");
        if (dateFormat == null) {
            dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
        }
        if (policy2.getSnapshotConfig().get("date_format_timezone") != null) {
            Object object = policy2.getSnapshotConfig().get("date_format_timezone");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            ZoneId zoneId = ZoneId.of((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(policy.snapshotConfig\u2026IMEZONE_FIELD] as String)");
            string = SMUtilsKt.generateFormatDate(dateFormat, zoneId);
        } else {
            string = SMUtilsKt.generateFormatDate$default(dateFormat, null, 2, null);
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String dateValue = string2;
        result2 = (String)result2 + "-" + dateValue;
        return (String)result2 + "-" + SMUtilsKt.getRandomString(8);
    }

    @NotNull
    public static final String getRandomString(int length) {
        List allowedChars = CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9')));
        ArrayList<Character> arrayList = new ArrayList<Character>(length);
        int n = 0;
        while (n < length) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Character> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(Character.valueOf(((Character)CollectionsKt.random((Collection)allowedChars, (Random)((Random)Random.Default))).charValue()));
        }
        return CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String generateFormatDate(@NotNull String dateFormat, @NotNull ZoneId timezone) {
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        DateFormatter dateFormatter = DateFormatter.forPattern((String)dateFormat).withZone(timezone);
        String string = dateFormatter.format((TemporalAccessor)Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormatter.format(now())");
        return string;
    }

    public static /* synthetic */ String generateFormatDate$default(String string, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.of("UTC");
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"of(\"UTC\")");
            zoneId = zoneId2;
        }
        return SMUtilsKt.generateFormatDate(string, zoneId);
    }

    @Nullable
    public static final String validateDateFormat(@NotNull String dateFormat) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        try {
            ZoneId timeZone = ZoneId.systemDefault();
            DateFormatter dateFormatter = DateFormatter.forPattern((String)dateFormat).withZone(timeZone);
            Instant instant = dateFormatter.toDateMathParser().parse("now/s", System::currentTimeMillis, false, timeZone);
            dateFormatter.format((TemporalAccessor)instant);
            string = null;
        }
        catch (Exception e) {
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "Invalid date format.";
            }
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String preFixTimeStamp(@Nullable String msg) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT;
        return "[" + formatter.format(Instant.now().truncatedTo(ChronoUnit.SECONDS)) + "]: " + msg;
    }

    @NotNull
    public static final Map<String, Object> addSMPolicyInSnapshotMetadata(@NotNull Map<String, ? extends Object> snapshotConfig, @NotNull String policyName) {
        Intrinsics.checkNotNullParameter(snapshotConfig, (String)"snapshotConfig");
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        Map snapshotMetadata = TypeIntrinsics.asMutableMap((Object)snapshotConfig.get("metadata"));
        if (snapshotMetadata != null) {
            snapshotMetadata.put("sm_policy", policyName);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"sm_policy", (Object)policyName)};
            snapshotMetadata = MapsKt.mutableMapOf((Pair[])pairArray);
        }
        Map snapshotConfigWithSMPolicyMetadata = MapsKt.toMutableMap(snapshotConfig);
        snapshotConfigWithSMPolicyMetadata.put("metadata", snapshotMetadata);
        return snapshotConfigWithSMPolicyMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SnapshotInfo> filterBySMPolicyInSnapshotMetadata(@NotNull List<SnapshotInfo> $this$filterBySMPolicyInSnapshotMetadata, @NotNull String policyName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterBySMPolicyInSnapshotMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        Iterable $this$filter$iv = $this$filterBySMPolicyInSnapshotMetadata;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SnapshotInfo it = (SnapshotInfo)element$iv$iv;
            boolean bl = false;
            Map map = it.userMetadata();
            if (!Intrinsics.areEqual(map != null ? map.get("sm_policy") : null, (Object)policyName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSnapshots(@NotNull Client var0, @NotNull String var1_1, @NotNull String var2_2, @NotNull Continuation<? super List<SnapshotInfo>> var3_3) {
        if (!(var3_3 instanceof getSnapshots.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMUtilsKt.getSnapshots(null, null, null, (Continuation<? super List<SnapshotInfo>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new String[]{name};
                req = new GetSnapshotsRequest().snapshots(var5_7).repository((String)repo);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$getSnapshots.admin().cluster(), (Function2)new Function2<ClusterAdminClient, ActionListener<GetSnapshotsResponse>, Unit>(req){
                    final /* synthetic */ GetSnapshotsRequest $req;
                    {
                        this.$req = $req;
                        super(2);
                    }

                    public final void invoke(ClusterAdminClient $this$suspendUntil, @NotNull ActionListener<GetSnapshotsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.getSnapshots(this.$req, it);
                    }
                }, $continuation);
                ** if (v0 != var8_6) goto lbl20
lbl19:
                // 1 sources

                return var8_6;
lbl20:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    res = (GetSnapshotsResponse)v0;
                    v1 = res.getSnapshots();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"res.snapshots");
                    return v1;
                }
                catch (RemoteTransportException ex) {
                    v2 = ExceptionsHelper.unwrapCause((Throwable)ex);
                    Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    unwrappedException = (Exception)v2;
                    throw unwrappedException;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSnapshots(@NotNull Client var0, @NotNull SMPolicy var1_1, @NotNull String var2_2, @NotNull SMMetadata.Builder var3_3, @NotNull Logger var4_4, @Nullable String var5_5, @NotNull String var6_6, @NotNull Continuation<? super GetSnapshotsResult> var7_7) {
        if (!(var7_7 instanceof getSnapshots.2)) ** GOTO lbl-1000
        var13_8 = var7_7;
        if ((var13_8.label & -2147483648) != 0) {
            var13_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var7_7){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMUtilsKt.getSnapshots(null, null, null, null, null, null, null, (Continuation<? super GetSnapshotsResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = job.getSnapshotConfig().get("repository");
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type kotlin.String");
                $continuation.L$0 = job;
                $continuation.L$1 = metadataBuilder;
                $continuation.L$2 = log;
                $continuation.L$3 = snapshotMissingMsg;
                $continuation.L$4 = exceptionMsg;
                $continuation.label = 1;
                v1 = SMUtilsKt.getSnapshots(var0, var2_2, (String)v0, (Continuation<? super List<SnapshotInfo>>)$continuation);
                ** if (v1 != var14_10) goto lbl25
lbl24:
                // 1 sources

                return var14_10;
lbl25:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                exceptionMsg = (String)$continuation.L$4;
                snapshotMissingMsg = (String)$continuation.L$3;
                log = (Logger)$continuation.L$2;
                metadataBuilder = (SMMetadata.Builder)$continuation.L$1;
                job = (SMPolicy)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl36:
                    // 2 sources

                    var9_11 = (List)v1;
                }
                catch (SnapshotMissingException var10_12) {
                    if (snapshotMissingMsg != null) {
                        $i$a$-let-SMUtilsKt$getSnapshots$snapshots$1 = false;
                        log.warn(snapshotMissingMsg);
                    }
                    return new GetSnapshotsResult(false, CollectionsKt.emptyList(), metadataBuilder);
                }
                catch (Exception ex) {
                    log.error(exceptionMsg, (Throwable)ex);
                    SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.RETRYING, false, exceptionMsg, false, ex, null, 42, null);
                    return new GetSnapshotsResult(true, CollectionsKt.emptyList(), metadataBuilder);
                }
                snapshots = SMUtilsKt.filterBySMPolicyInSnapshotMetadata(var9_11, job.getPolicyName());
                return new GetSnapshotsResult(false, snapshots, metadataBuilder);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final UpdateNextExecutionTimeResult tryUpdatingNextExecutionTime(@NotNull SMMetadata.Builder metadataBuilder, @NotNull Instant nextTime, @NotNull Schedule schedule, @NotNull WorkflowType workflowType, @NotNull Logger log) {
        UpdateNextExecutionTimeResult updateNextExecutionTimeResult;
        Intrinsics.checkNotNullParameter((Object)metadataBuilder, (String)"metadataBuilder");
        Intrinsics.checkNotNullParameter((Object)nextTime, (String)"nextTime");
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        Intrinsics.checkNotNullParameter((Object)((Object)workflowType), (String)"workflowType");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Instant now = Instant.now();
        if (!now.isBefore(nextTime)) {
            log.info("Current time [" + Instant.now() + "] has passed nextExecutionTime [" + nextTime + "].");
            Instant newNextTime = schedule.getNextExecutionTime(now);
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNullExpressionValue((Object)newNextTime, (String)"newNextTime");
                    metadataBuilder.setNextCreationTime(newNextTime);
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)newNextTime, (String)"newNextTime");
                    metadataBuilder.setNextDeletionTime(newNextTime);
                }
            }
            updateNextExecutionTimeResult = new UpdateNextExecutionTimeResult(true, metadataBuilder);
        } else {
            log.debug("Current time [" + Instant.now() + "] has not passed nextExecutionTime [" + nextTime + "]");
            updateNextExecutionTimeResult = new UpdateNextExecutionTimeResult(false, metadataBuilder);
        }
        return updateNextExecutionTimeResult;
    }

    public static final void validateSMPolicyName(@NotNull String policyName) {
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        List errorMessages = new ArrayList();
        if (((CharSequence)policyName).length() == 0) {
            errorMessages.add("Policy name cannot be empty.");
        }
        if (StringsKt.contains$default((CharSequence)policyName, (CharSequence)" ", (boolean)false, (int)2, null)) {
            errorMessages.add("Policy name must not contain whitespace.");
        }
        if (StringsKt.contains$default((CharSequence)policyName, (CharSequence)",", (boolean)false, (int)2, null)) {
            errorMessages.add("Policy name must not contain ','.");
        }
        if (StringsKt.contains$default((CharSequence)policyName, (CharSequence)"#", (boolean)false, (int)2, null)) {
            errorMessages.add("Policy name must not contain '#'.");
        }
        if (StringsKt.startsWith$default((String)policyName, (String)"_", (boolean)false, (int)2, null)) {
            errorMessages.add("Policy name must not start with '_'.");
        }
        String string = policyName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        if (!Intrinsics.areEqual((Object)string2, (Object)policyName)) {
            errorMessages.add("Policy name must be lowercase.");
        }
        if (!Strings.validFileName((String)policyName)) {
            errorMessages.add("Policy name must not contain the following characters " + Strings.INVALID_FILENAME_CHARS + ".");
        }
        if (!((Collection)errorMessages).isEmpty()) {
            throw new IllegalArgumentException(CollectionsKt.joinToString$default((Iterable)errorMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
    }

    public static final boolean isExceed(@NotNull TimeValue $this$isExceed, @Nullable Instant startTime) {
        Intrinsics.checkNotNullParameter((Object)$this$isExceed, (String)"<this>");
        if (startTime == null) {
            return false;
        }
        return Instant.now().toEpochMilli() - startTime.toEpochMilli() > $this$isExceed.getMillis();
    }

    @NotNull
    public static final SMResult timeLimitExceeded(@NotNull TimeValue timeLimit, @NotNull SMMetadata.Builder metadataBuilder, @NotNull WorkflowType workflow, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
        Intrinsics.checkNotNullParameter((Object)metadataBuilder, (String)"metadataBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)workflow), (String)"workflow");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        String message = SMUtilsKt.getTimeLimitExceededMessage(timeLimit, workflow);
        log.warn(message);
        SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.TIME_LIMIT_EXCEEDED, false, null, false, (Exception)((Object)new SnapshotManagementException(null, null, message, 3, null)), Instant.now(), 14, null);
        return new SMResult.Fail(metadataBuilder, workflow, true);
    }

    @NotNull
    public static final String getTimeLimitExceededMessage(@NotNull TimeValue timeLimit, @NotNull WorkflowType workflow) {
        String string;
        Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
        Intrinsics.checkNotNullParameter((Object)((Object)workflow), (String)"workflow");
        switch (WhenMappings.$EnumSwitchMapping$0[workflow.ordinal()]) {
            case 1: {
                string = "creation";
                break;
            }
            case 2: {
                string = "deletion";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String workflowStr = string;
        return "Time limit " + timeLimit + " exceeded during snapshot " + workflowStr + " step";
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorkflowType.values().length];
            try {
                nArray[WorkflowType.CREATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkflowType.DELETION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

