/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.exception.MLException;

public class FileUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(FileUtils.class);

    public static List<String> splitFileIntoChunks(File file, Path outputPath, int chunkSize) throws IOException {
        int fileSize = (int)file.length();
        ArrayList<String> nameList = new ArrayList<String>();
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));){
            int numberOfChunk = 0;
            int totalBytesRead = 0;
            while (totalBytesRead < fileSize) {
                byte[] temporary;
                int bytesRead;
                String partName = "" + numberOfChunk;
                int bytesRemaining = fileSize - totalBytesRead;
                if (bytesRemaining < chunkSize) {
                    chunkSize = bytesRemaining;
                }
                if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[chunkSize], 0, chunkSize)) > 0) {
                    totalBytesRead += bytesRead;
                    ++numberOfChunk;
                }
                Path partFileName = outputPath.resolve(partName);
                FileUtils.write(temporary, partFileName.toString());
                nameList.add(partFileName.toString());
            }
        }
        return nameList;
    }

    public static void write(byte[] data, String destinationFile) throws IOException {
        File file = new File(destinationFile);
        FileUtils.write(data, file, false);
    }

    public static void write(byte[] data, File destinationFile, boolean append) throws IOException {
        org.apache.commons.io.FileUtils.forceMkdir((File)destinationFile.getParentFile());
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile, append);
             BufferedOutputStream output = new BufferedOutputStream(fileOutputStream);){
            ((OutputStream)output).write(data);
            ((OutputStream)output).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(Queue<File> files, File mergedFile) {
        log.debug("merge {} files into {}", (Object)files.size(), (Object)mergedFile);
        boolean failed = false;
        while (!files.isEmpty()) {
            File f = files.poll();
            try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(f));){
                if (failed) continue;
                int fileLength = (int)f.length();
                byte[] fileContent = new byte[fileLength];
                ((InputStream)inStream).read(fileContent, 0, fileLength);
                FileUtils.write(fileContent, mergedFile, true);
            }
            catch (IOException e) {
                log.error("Failed to merge file from " + f.getAbsolutePath() + " to " + mergedFile.getAbsolutePath(), (Throwable)e);
                failed = true;
            }
            finally {
                org.apache.commons.io.FileUtils.deleteQuietly((File)f);
                if (!files.isEmpty()) continue;
                org.apache.commons.io.FileUtils.deleteQuietly((File)f.getParentFile());
            }
        }
        if (failed) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)mergedFile);
            throw new MLException("Failed to merge model chunks");
        }
    }

    public static String calculateFileHash(File file) throws IOException {
        ByteSource byteSource = Files.asByteSource((File)file);
        HashCode hc = byteSource.hash(Hashing.sha256());
        return hc.toString();
    }

    public static void deleteFileQuietly(Path path) {
        FileUtils.deleteFileQuietly(new File(path.toUri()));
    }

    public static void deleteFileQuietly(File file) {
        if (file.exists()) {
            AccessController.doPrivileged(() -> {
                org.apache.commons.io.FileUtils.deleteQuietly((File)file);
                return null;
            });
        }
    }

    public static Set<String> getFileNames(Path ... paths) {
        HashSet<String> allFileNames = new HashSet<String>();
        for (Path path : paths) {
            String[] fileNames;
            File f = new File(path.toUri());
            if (!f.exists() || (fileNames = f.list()) == null || fileNames.length <= 0) continue;
            for (String name : fileNames) {
                allFileNames.add(name);
            }
        }
        return allFileNames;
    }
}

